/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.looks.HeaderStyle;
import interfaces.Observable;
import interfaces.Observer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSimpleViewer;
import org.jmol.api.JmolViewer;
import util.Alignment;
import util.SelectionManager;
import view.AlignPanel;
import view.MyCallbackListener;
import view.NamePainter;
import view.SequencePainter;
import view.StructureWindowListener;

public class Structure3DFrame
extends JFrame
implements Observer {
    private static final long serialVersionUID = 1L;
    private JmolPanel jmolPanel;
    private JFrame frame;
    private JMenuItem ribbonMenuItem;
    private JMenuItem cartoonMenuItem;
    private JMenuItem spacefillMenuItem;
    private String selectedChain;
    private JMenuItem zoomOutMenuItem;
    private JMenuItem zoomInMenuItem;
    private Alignment alignment;
    private JPanel commandsPanel;
    private JTextField commandsBox;
    private JButton execCommand;

    public Structure3DFrame(String pdbFile, SequencePainter seqPainter, String selectedChain, Alignment alignment, NamePainter namePainter, AlignPanel alignPanel) {
        this.selectedChain = selectedChain;
        this.alignment = alignment;
        this.addWindowListener(new StructureWindowListener(this, namePainter, seqPainter, alignPanel.getMethodPanel(), alignPanel.getIndexPanel()));
        alignPanel.setScrollValues(0, 0);
        this.frame = this;
        this.frame.setTitle("Structure 3D View");
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setPreferredSize(new Dimension(600, 630));
        this.jmolPanel = new JmolPanel();
        this.jmolPanel.setPreferredSize(new Dimension(600, 600));
        this.jmolPanel.readPDBFile(pdbFile);
        String selectChain = "select *" + selectedChain + " and not hetero and not solvent and not hoh; wireframe off; cartoon on; ribbon off; spacefill off; select hetero and not solvent and not hoh and *" + selectedChain + "; spacefill; color yellow; select not all";
        String deselectChain = "select not *" + selectedChain + " or solvent; wireframe off; spacefill off; backbone 20;";
        this.jmolPanel.eval(selectChain);
        this.jmolPanel.eval(deselectChain);
        this.jmolPanel.eval("set disablePopupMenu on");
        this.constructMenu();
        contentPane.add(this.jmolPanel);
        this.highlightSelection();
        this.commandsBox = new JTextField();
        this.commandsBox.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    Structure3DFrame.this.executeCommand();
                }
            }
        });
        this.execCommand = new JButton("Execute");
        this.execCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Structure3DFrame.this.executeCommand();
            }
        });
        this.commandsBox.setMinimumSize(new Dimension(100, 30));
        this.commandsBox.setPreferredSize(new Dimension(500, 30));
        this.commandsBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.commandsPanel = new JPanel();
        this.commandsPanel.setSize(new Dimension(600, 30));
        this.commandsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.commandsPanel.setLayout(new BorderLayout());
        this.commandsPanel.add((Component)this.commandsBox, "Center");
        this.commandsPanel.add((Component)this.execCommand, "East");
        contentPane.add(this.commandsPanel);
        seqPainter.notifyObservers();
        seqPainter.register(this);
        seqPainter.setJmolPanel(this.jmolPanel);
        SelectionManager.setEnabled(true);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void constructMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        JMenu optionMenu = new JMenu("Options");
        optionMenu.setMnemonic('O');
        menuBar.add(optionMenu);
        JMenu zoomMenu = new JMenu("Zoom");
        optionMenu.setMnemonic('Z');
        menuBar.add(zoomMenu);
        this.ribbonMenuItem = new JMenuItem();
        this.cartoonMenuItem = new JMenuItem();
        this.spacefillMenuItem = new JMenuItem();
        this.ribbonMenuItem.setMnemonic('R');
        this.ribbonMenuItem.setText("Ribbon");
        this.ribbonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String ribbon = "select *" + Structure3DFrame.this.selectedChain + " and not hetero; cartoon off; ribbon on; spacefill off;";
                Structure3DFrame.this.jmolPanel.eval(ribbon);
                Structure3DFrame.this.jmolPanel.repaint();
            }
        });
        optionMenu.add(this.ribbonMenuItem);
        this.cartoonMenuItem.setMnemonic('C');
        this.cartoonMenuItem.setText("Cartoon");
        this.cartoonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String cartoon = "select *" + Structure3DFrame.this.selectedChain + " and not hetero; cartoon on; ribbon off; spacefill off;";
                Structure3DFrame.this.jmolPanel.eval(cartoon);
                Structure3DFrame.this.jmolPanel.repaint();
            }
        });
        optionMenu.add(this.cartoonMenuItem);
        this.spacefillMenuItem.setMnemonic('S');
        this.spacefillMenuItem.setText("Spacefill");
        this.spacefillMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String spacefill = "select *" + Structure3DFrame.this.selectedChain + " and not hetero; cartoon off; ribbon off; spacefill on; select hetero and not solvent; wireframe off;";
                Structure3DFrame.this.jmolPanel.eval(spacefill);
                Structure3DFrame.this.jmolPanel.repaint();
            }
        });
        optionMenu.add(this.spacefillMenuItem);
        this.zoomOutMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomInMenuItem.setMnemonic('i');
        this.zoomInMenuItem.setText("Zoom in +");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Structure3DFrame.this.jmolPanel.eval("zoomto *1.2");
            }
        });
        zoomMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setMnemonic('o');
        this.zoomOutMenuItem.setText("Zoom out -");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Structure3DFrame.this.jmolPanel.eval("zoomto /1.2");
            }
        });
        zoomMenu.add(this.zoomOutMenuItem);
        this.frame.setJMenuBar(menuBar);
    }

    public JmolSimpleViewer getViewer() {
        return this.jmolPanel.getViewer();
    }

    @Override
    public void update(Observable object) {
        if (object instanceof SequencePainter) {
            this.highlightSelection();
        }
    }

    private void highlightSelection() {
        this.jmolPanel.eval("select all and not hetero; color cpk; wireframe off; ");
        Vector<Integer> currentSelection = SelectionManager.getFullSelection();
        StringBuffer selection = new StringBuffer();
        for (int i = 0; i < currentSelection.size(); ++i) {
            int pos = currentSelection.get(i);
            int currentPDBPos = this.alignment.getPDBPos(pos);
            if (currentPDBPos <= 0) continue;
            selection.append(currentPDBPos + ":" + this.selectedChain + ",");
        }
        if (selection.length() > 0) {
            this.jmolPanel.eval("select " + selection.substring(0, selection.length() - 1) + " and not hetero; color green; wireframe 60; ");
        }
    }

    private void executeCommand() {
        this.jmolPanel.eval(this.commandsBox.getText());
        this.commandsBox.setText("");
        this.jmolPanel.repaint();
    }

    class JmolPanel
    extends JPanel
    implements Observable {
        private static final long serialVersionUID = 1L;
        JmolViewer viewer;
        JmolAdapter adapter;
        private Vector<Observer> observersList;
        private Object[] selection;
        final Dimension currentSize = new Dimension();
        final Rectangle rectClip = new Rectangle();

        public JmolPanel() {
            this.adapter = new SmarterJmolAdapter();
            this.observersList = new Vector();
            this.viewer = (JmolViewer)JmolViewer.allocateSimpleViewer(this, this.adapter);
            this.viewer.setJmolCallbackListener(new MyCallbackListener(this));
        }

        @Override
        public void notifyObservers() {
            for (int i = 0; i < this.observersList.size(); ++i) {
                Observer observer = this.observersList.elementAt(i);
                observer.update(this);
            }
        }

        @Override
        public void register(Observer obs) {
            this.observersList.addElement(obs);
        }

        @Override
        public void deregister(Observer obs) {
            this.observersList.removeElement(obs);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        public void readPDBFile(String file) {
            this.viewer.openFile(file);
        }

        public void eval(String attributes) {
            this.viewer.evalString(attributes);
        }

        @Override
        public void paint(Graphics g) {
            this.getSize(this.currentSize);
            g.getClipBounds(this.rectClip);
            this.viewer.renderScreenImage(g, this.currentSize, this.rectClip);
        }

        public Object[] getSelection() {
            return this.selection;
        }

        public void addSelection(Object[] selection) {
            String select = selection[1].toString();
            int pos = new Integer(select.substring(select.indexOf(93) + 1, select.indexOf(58)));
            String chain = select.substring(select.indexOf(58) + 1, select.indexOf(46));
            int alignPos = Structure3DFrame.this.alignment.getAlignPos(pos);
            if (alignPos != -1 && chain.equals(Structure3DFrame.this.selectedChain)) {
                SelectionManager.toggleSelection(alignPos, true);
            }
        }

        public void setSelection(Object[] selection) {
            this.selection = selection;
        }
    }
}

