/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;
import model.AlignObject;
import util.ColorScheme;
import view.AlignViewProps;
import view.ColorSchemeInfo;
import view.SeparatorPanel;

public class StatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AlignObject alObj;
    private JLabel seqNumberLabel;
    private JLabel alignLengthLabel;
    private JLabel filenameLabel;
    private JLabel filenameLabel2;
    private JLabel alignLengthLabel2;
    private JLabel seqNumberLabel2;
    private JPanel contentPanel;
    private JLabel colorLabel;
    private ColorSchemeInfo colorPalette;

    public StatusPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this.getWidth(), 30));
        this.setBackground(new Color(236, 233, 216));
        this.init();
    }

    public StatusPanel(AlignViewProps viewProps) {
        this.alObj = viewProps.getAlObj();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(this.getWidth(), 30));
        this.setBackground(new Color(236, 233, 216));
        this.init();
    }

    private void init() {
        this.contentPanel = new JPanel();
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout(new FormLayout("5dlu, p , 5dlu, 200px, 5dlu, 25dlu, p, 5dlu, p, 25dlu, p, 25dlu, p, 5dlu, p, 25dlu, p, 25dlu, p, 5dlu, p, 5dlu", "4dlu, fill:10dlu, 2dlu"));
        this.colorLabel = new JLabel();
        this.colorLabel.setText("Schema:");
        this.colorPalette = ColorScheme.getPaletteImage();
        this.seqNumberLabel = new JLabel();
        this.seqNumberLabel2 = new JLabel();
        this.seqNumberLabel.setText("Number of sequences:");
        if (this.alObj != null) {
            this.seqNumberLabel2.setText(new Integer(this.alObj.getProteinNumber()).toString());
            Font f = this.seqNumberLabel2.getFont();
            this.seqNumberLabel2.setFont(f.deriveFont(f.getStyle() ^ 1));
        } else {
            this.seqNumberLabel2.setText("0");
        }
        this.alignLengthLabel = new JLabel();
        this.alignLengthLabel2 = new JLabel();
        this.alignLengthLabel.setText("Alignment length:");
        if (this.alObj != null) {
            this.alignLengthLabel2.setText(new Integer(this.alObj.getWidth()).toString());
            Font f2 = this.alignLengthLabel2.getFont();
            this.alignLengthLabel2.setFont(f2.deriveFont(f2.getStyle() ^ 1));
        } else {
            this.alignLengthLabel2.setText("0");
        }
        this.filenameLabel = new JLabel();
        this.filenameLabel2 = new JLabel();
        this.filenameLabel.setText("Filename:");
        if (this.alObj != null) {
            this.filenameLabel2.setText(this.alObj.getFilename());
            Font f3 = this.filenameLabel2.getFont();
            this.filenameLabel2.setFont(f3.deriveFont(f3.getStyle() ^ 1));
        } else {
            this.filenameLabel2.setText("(No file loaded)");
        }
        CellConstraints cc = new CellConstraints();
        this.contentPanel.add((Component)this.colorLabel, cc.xy(2, 2));
        this.contentPanel.add((Component)this.colorPalette, cc.xy(4, 2));
        this.contentPanel.add((Component)new SeparatorPanel(Color.GRAY, Color.WHITE), cc.xy(5, 2));
        this.contentPanel.add((Component)this.seqNumberLabel, cc.xy(7, 2));
        this.contentPanel.add((Component)this.seqNumberLabel2, cc.xy(9, 2));
        this.contentPanel.add((Component)new SeparatorPanel(Color.GRAY, Color.WHITE), cc.xy(11, 2));
        this.contentPanel.add((Component)this.alignLengthLabel, cc.xy(13, 2));
        this.contentPanel.add((Component)this.alignLengthLabel2, cc.xy(15, 2));
        this.contentPanel.add((Component)new SeparatorPanel(Color.GRAY, Color.WHITE), cc.xy(17, 2));
        this.contentPanel.add((Component)this.filenameLabel, cc.xy(19, 2));
        this.contentPanel.add((Component)this.filenameLabel2, cc.xy(21, 2));
        this.add((Component)this.contentPanel, "Center");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int y = 0;
        g.setColor(new Color(156, 154, 140));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(196, 194, 183));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(218, 215, 201));
        g.drawLine(0, ++y, this.getWidth(), y);
        g.setColor(new Color(233, 231, 217));
        g.drawLine(0, ++y, this.getWidth(), y);
        y = this.getHeight() - 3;
        g.setColor(new Color(233, 232, 218));
        g.drawLine(0, y, this.getWidth(), y);
        g.setColor(new Color(233, 231, 216));
        g.drawLine(0, ++y, this.getWidth(), y);
        y = this.getHeight() - 1;
        g.setColor(new Color(221, 221, 220));
        g.drawLine(0, y, this.getWidth(), y);
    }

    public ColorSchemeInfo getColorPalette() {
        return this.colorPalette;
    }

    public void setColorPalette(ColorSchemeInfo colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void updateWidth() {
        this.alignLengthLabel2.setText(this.alObj.getWidth() + "");
    }
}

