/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.Methods;
import util.Constants;
import view.AlignFrame;
import view.SliderChangeListener;
import view.SliderKeyAdapter;

public class SliderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AlignFrame alignFrame;
    private JSlider xDetSlider;
    private JTextField xDetTtf;
    private JSlider entropySlider;
    private JTextField entropyTtf;
    private JTextField s3DetTtf;
    private JSlider s3DetSlider;
    private JTextField[] otherTtf;
    private JSlider[] otherSlider;
    private Methods methods;
    private JLabel xDetLbl;
    private JLabel entropyLbl;
    private JLabel s3DetLbl;
    private JLabel[] otherLbl;
    private int udmNumber;
    private int index;
    private int xDetCutoff;
    private int entropyCutoff;
    private int s3DetCutoff;
    private int scoreCutoff;
    private JButton xDetSelectOr;
    private JButton entropySelectOr;
    private JButton s3DetSelectOr;
    private JButton[] otherSelectOr;
    private JButton xDetSelectAnd;
    private JButton entropySelectAnd;
    private JButton s3DetSelectAnd;
    private JButton[] otherSelectAnd;

    public SliderPanel() {
        this.setBackground(Constants.METHODDESCPNL_BGCOLOR);
        this.setMinimumSize(new Dimension(270, Constants.METHODDESCPNL_HEIGHT));
        this.setPreferredSize(new Dimension(270, Constants.METHODDESCPNL_HEIGHT));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public SliderPanel(AlignFrame alignFrame) {
        this.alignFrame = alignFrame;
        this.methods = alignFrame.getMethods();
        this.udmNumber = this.methods.getUdmNumber();
        this.setBackground(Constants.METHODDESCPNL_BGCOLOR);
        this.calculateHeight();
        this.setMinimumSize(new Dimension(270, Constants.METHODDESCPNL_HEIGHT));
        this.setPreferredSize(new Dimension(270, Constants.METHODDESCPNL_HEIGHT));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.buildThresholdPanels();
    }

    private void calculateHeight() {
        int height = 20;
        Constants.METHODDESCPNL_HEIGHT = height += Constants.METHOD_OFFSET * this.methods.getMethodNumber();
    }

    private void buildThresholdPanels() {
        this.setLayout(new FormLayout("5px, 70px, 5px, 45px, 100px, 10px, 10px", "5dlu, p, p, p, p, p, p, p, p, 10dlu"));
        CellConstraints cc = new CellConstraints();
        this.xDetLbl = new JLabel("XDet");
        this.xDetLbl.setFont(new Font("monospaced", 0, 12));
        this.xDetTtf = new JTextField(3);
        this.xDetTtf.setMinimumSize(new Dimension(100, 18));
        this.xDetTtf.setPreferredSize(new Dimension(100, 18));
        this.xDetCutoff = new Double(this.methods.getxDetCutoff() * 100.0).intValue();
        this.xDetSlider = new JSlider(0, this.xDetCutoff * 2, this.xDetCutoff);
        this.xDetSlider.setMinimumSize(new Dimension(120, 18));
        this.xDetSlider.setPreferredSize(new Dimension(120, 18));
        this.xDetSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.xDetTtf.setText(String.valueOf(new Double(this.xDetCutoff) / 100.0));
        this.xDetTtf.setToolTipText("Please hit ENTER...");
        this.xDetSlider.setPaintLabels(false);
        this.xDetSlider.setFocusable(false);
        this.xDetSlider.setOpaque(false);
        this.xDetSlider.setToolTipText("Change the correlation threshold.");
        this.xDetSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double corrThreshold = new Double(SliderPanel.this.xDetSlider.getValue()) / 100.0;
                SliderPanel.this.xDetTtf.setText(String.valueOf(corrThreshold));
                SliderPanel.this.alignFrame.getAlignPanel().getMethodPanel().updatePanelWithXdetThreshold(corrThreshold);
            }
        });
        this.xDetTtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    try {
                        String text = SliderPanel.this.xDetTtf.getText();
                        if (text.length() > 4) {
                            throw new NumberFormatException();
                        }
                        int value = new Double(Double.parseDouble(text) * 100.0).intValue();
                        SliderPanel.this.xDetSlider.setValue(value);
                    }
                    catch (NumberFormatException e1) {
                        SliderPanel.this.xDetSlider.setValue(SliderPanel.this.xDetCutoff);
                        SliderPanel.this.xDetTtf.setText(String.valueOf(new Double(SliderPanel.this.xDetSlider.getValue()) / 100.0));
                    }
                }
            }
        });
        ImageIcon addIcon = AlignFrame.getImageIcon("img/add.png");
        ImageIcon orIcon = AlignFrame.getImageIcon("img/or.png");
        Dimension buttonSize = this.getPreferredSize();
        buttonSize.height = 10;
        buttonSize.width = 10;
        this.xDetSelectOr = new JButton(addIcon);
        this.xDetSelectOr.setPreferredSize(buttonSize);
        this.xDetSelectOr.setToolTipText("Add to selection residues from XDet");
        this.xDetSelectOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectXDetItems(2);
            }
        });
        this.xDetSelectAnd = new JButton(orIcon);
        this.xDetSelectAnd.setPreferredSize(buttonSize);
        this.xDetSelectAnd.setToolTipText("Combine selection with residues from XDet");
        this.xDetSelectAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectXDetItems(1);
            }
        });
        this.entropyLbl = new JLabel("Entropy");
        this.entropyLbl.setFont(new Font("monospaced", 0, 12));
        this.entropyTtf = new JTextField(3);
        this.entropyTtf.setMinimumSize(new Dimension(100, 18));
        this.entropyTtf.setPreferredSize(new Dimension(100, 18));
        this.entropyCutoff = new Double(this.methods.getEntropyCutoff() * 10.0).intValue();
        this.entropySlider = new JSlider(0, this.entropyCutoff * 2, this.entropyCutoff);
        this.entropySlider.setMinimumSize(new Dimension(120, 18));
        this.entropySlider.setPreferredSize(new Dimension(120, 18));
        this.entropySlider.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.entropyTtf.setText(String.valueOf(new Double(this.entropyCutoff) / 10.0));
        this.entropyTtf.setToolTipText("Please hit ENTER...");
        this.entropySlider.setPaintLabels(false);
        this.entropySlider.setFocusable(false);
        this.entropySlider.setOpaque(false);
        this.entropySlider.setToolTipText("Change the entropy threshold.");
        this.entropySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double entropyThreshold = new Double(SliderPanel.this.entropySlider.getValue()) / 10.0;
                SliderPanel.this.entropyTtf.setText(String.valueOf(entropyThreshold));
                SliderPanel.this.alignFrame.getAlignPanel().getMethodPanel().updatePanelWithEntropyThreshold(entropyThreshold);
            }
        });
        this.entropyTtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    try {
                        String text = SliderPanel.this.entropyTtf.getText();
                        if (text.length() > 4) {
                            SliderPanel.this.entropyTtf.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyReleased(KeyEvent ke) {
                                    if (ke.getKeyCode() == 10) {
                                        try {
                                            String text = SliderPanel.this.entropyTtf.getText();
                                            if (text.length() > 4) {
                                                throw new NumberFormatException();
                                            }
                                            int value = new Double(Double.parseDouble(text) * 100.0).intValue();
                                            SliderPanel.this.entropySlider.setValue(value);
                                        }
                                        catch (NumberFormatException e1) {
                                            SliderPanel.this.entropySlider.setValue(SliderPanel.this.entropyCutoff);
                                            SliderPanel.this.entropyTtf.setText(String.valueOf(new Double(SliderPanel.this.entropySlider.getValue()) / 100.0));
                                        }
                                    }
                                }
                            });
                            throw new NumberFormatException();
                        }
                        int value = new Double(Double.parseDouble(text) * 10.0).intValue();
                        SliderPanel.this.entropySlider.setValue(value);
                    }
                    catch (NumberFormatException e1) {
                        SliderPanel.this.entropySlider.setValue(SliderPanel.this.entropyCutoff);
                        SliderPanel.this.entropyTtf.setText(String.valueOf(new Double(SliderPanel.this.entropySlider.getValue()) / 10.0));
                    }
                }
            }
        });
        this.entropySelectOr = new JButton(addIcon);
        this.entropySelectOr.setPreferredSize(buttonSize);
        this.entropySelectOr.setToolTipText("Add to selection residues from Entropy");
        this.entropySelectOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectEntropyItems(2);
            }
        });
        this.entropySelectAnd = new JButton(orIcon);
        this.entropySelectAnd.setPreferredSize(buttonSize);
        this.entropySelectAnd.setToolTipText("Combine selection with residues from Entropy");
        this.entropySelectAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectEntropyItems(1);
            }
        });
        if (!this.methods.isEntropyUsed()) {
            this.entropySlider.setEnabled(false);
            this.entropyTtf.setEnabled(false);
        }
        this.s3DetLbl = new JLabel("S3Det");
        this.s3DetLbl.setFont(new Font("monospaced", 0, 12));
        this.s3DetTtf = new JTextField(3);
        this.s3DetTtf.setMinimumSize(new Dimension(100, 18));
        this.s3DetTtf.setPreferredSize(new Dimension(100, 18));
        this.s3DetTtf.setToolTipText("Please hit ENTER...");
        this.s3DetCutoff = new Double(this.methods.getS3DetCutoff()).intValue();
        this.s3DetSlider = new JSlider(0, this.s3DetCutoff * 2, this.s3DetCutoff);
        this.s3DetSlider.setMinimumSize(new Dimension(120, 18));
        this.s3DetSlider.setPreferredSize(new Dimension(120, 18));
        this.s3DetSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.s3DetTtf.setText(String.valueOf(new Double(this.s3DetCutoff)));
        this.s3DetSlider.setPaintLabels(false);
        this.s3DetSlider.setFocusable(false);
        this.s3DetSlider.setOpaque(false);
        this.s3DetSlider.setToolTipText("Change the S3Det threshold.");
        this.s3DetSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double rankThreshold = new Double(SliderPanel.this.s3DetSlider.getValue());
                SliderPanel.this.s3DetTtf.setText(String.valueOf(rankThreshold));
                SliderPanel.this.alignFrame.getAlignPanel().getMethodPanel().updatePanelWithS3detThreshold(rankThreshold);
            }
        });
        this.s3DetTtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    try {
                        String text = SliderPanel.this.s3DetTtf.getText();
                        if (text.length() > 4) {
                            SliderPanel.this.s3DetTtf.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyReleased(KeyEvent ke) {
                                    if (ke.getKeyCode() == 10) {
                                        try {
                                            String text = SliderPanel.this.s3DetTtf.getText();
                                            if (text.length() > 4) {
                                                throw new NumberFormatException();
                                            }
                                            int value = new Double(Double.parseDouble(text)).intValue();
                                            SliderPanel.this.s3DetSlider.setValue(value);
                                        }
                                        catch (NumberFormatException e1) {
                                            SliderPanel.this.xDetSlider.setValue(SliderPanel.this.s3DetCutoff);
                                            SliderPanel.this.s3DetTtf.setText(String.valueOf(new Double(SliderPanel.this.s3DetSlider.getValue()) / 100.0));
                                        }
                                    }
                                }
                            });
                            throw new NumberFormatException();
                        }
                        int value = new Double(Double.parseDouble(text)).intValue();
                        SliderPanel.this.s3DetSlider.setValue(value);
                    }
                    catch (NumberFormatException e1) {
                        SliderPanel.this.s3DetSlider.setValue(SliderPanel.this.s3DetCutoff);
                        SliderPanel.this.s3DetTtf.setText(String.valueOf(new Double(SliderPanel.this.s3DetSlider.getValue())));
                    }
                }
            }
        });
        this.s3DetSelectOr = new JButton(addIcon);
        this.s3DetSelectOr.setPreferredSize(buttonSize);
        this.s3DetSelectOr.setToolTipText("Add to selection residues from S3Det");
        this.s3DetSelectOr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectS3DetItems(2);
            }
        });
        this.s3DetSelectAnd = new JButton(orIcon);
        this.s3DetSelectAnd.setPreferredSize(buttonSize);
        this.s3DetSelectAnd.setToolTipText("Combine selection with residues from from S3Det");
        this.s3DetSelectAnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SliderPanel.this.alignFrame.selectS3DetItems(1);
            }
        });
        if (!this.methods.isS3DetUsed()) {
            this.s3DetSlider.setEnabled(false);
            this.s3DetTtf.setEnabled(false);
        }
        if (this.udmNumber > 0) {
            this.otherLbl = new JLabel[this.udmNumber];
            this.otherTtf = new JTextField[this.udmNumber];
            this.otherSlider = new JSlider[this.udmNumber];
            this.otherSelectOr = new JButton[this.udmNumber];
            this.otherSelectAnd = new JButton[this.udmNumber];
            this.index = 0;
            while (this.index < this.udmNumber) {
                String label = this.methods.getUdmObjects()[this.index].getMethodName();
                if (label.length() > 10) {
                    label = label.substring(0, 10);
                }
                this.otherLbl[this.index] = new JLabel(label);
                this.otherLbl[this.index].setFont(new Font("monospaced", 0, 12));
                this.otherTtf[this.index] = new JTextField(3);
                this.otherTtf[this.index].setMinimumSize(new Dimension(100, 18));
                this.otherTtf[this.index].setPreferredSize(new Dimension(100, 18));
                this.otherTtf[this.index].setToolTipText("Please hit ENTER...");
                this.scoreCutoff = new Double(this.methods.getScoreCutoffs()[this.index] * 10.0).intValue();
                this.otherSlider[this.index] = new JSlider(new Double(this.methods.getUdmObjects()[this.index].getMinValue()).intValue(), new Double(this.methods.getUdmObjects()[this.index].getMaxValue()).intValue() * 10, this.scoreCutoff);
                this.otherTtf[this.index].setText(String.valueOf(String.valueOf(new Double(this.scoreCutoff) / 10.0)));
                this.otherSlider[this.index].setMinimumSize(new Dimension(120, 18));
                this.otherSlider[this.index].setPreferredSize(new Dimension(120, 18));
                this.otherSlider[this.index].setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
                this.otherSlider[this.index].setPaintLabels(false);
                this.otherSlider[this.index].setFocusable(false);
                this.otherSlider[this.index].setOpaque(false);
                this.otherSlider[this.index].setToolTipText("Change the score threshold.");
                this.otherSlider[this.index].addChangeListener(new SliderChangeListener(this.alignFrame, this.otherSlider[this.index], this.otherTtf[this.index], this.index));
                this.otherTtf[this.index].addKeyListener(new SliderKeyAdapter(this.otherSlider[this.index], this.otherTtf[this.index], this.index));
                this.otherSelectOr[this.index] = new JButton(addIcon);
                this.otherSelectOr[this.index].setPreferredSize(buttonSize);
                this.otherSelectOr[this.index].setToolTipText("Add to selection residues from " + this.methods.getUdmObjects()[this.index].getMethodName());
                this.otherSelectOr[this.index].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JButton source = (JButton)evt.getSource();
                        String methodName = source.getToolTipText().substring(source.getToolTipText().lastIndexOf(" ") + 1);
                        SliderPanel.this.alignFrame.selectUserDefItems(methodName, 2);
                    }
                });
                this.otherSelectAnd[this.index] = new JButton(orIcon);
                this.otherSelectAnd[this.index].setPreferredSize(buttonSize);
                this.otherSelectAnd[this.index].setToolTipText("Combine selection with residues from " + this.methods.getUdmObjects()[this.index].getMethodName());
                this.otherSelectAnd[this.index].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JButton source = (JButton)evt.getSource();
                        String methodName = source.getToolTipText().substring(source.getToolTipText().lastIndexOf(" ") + 1);
                        SliderPanel.this.alignFrame.selectUserDefItems(methodName, 1);
                    }
                });
                ++this.index;
            }
        }
        int yCC = 2;
        if (this.methods.isxDetUsed()) {
            this.add((Component)this.xDetLbl, cc.xy(2, yCC));
            this.add((Component)this.xDetTtf, cc.xy(4, yCC));
            this.add((Component)this.xDetSlider, cc.xy(5, yCC));
            this.add((Component)this.xDetSelectOr, cc.xy(6, yCC));
            this.add((Component)this.xDetSelectAnd, cc.xy(7, yCC));
            ++yCC;
        }
        if (this.methods.isEntropyUsed()) {
            this.add((Component)this.entropyLbl, cc.xy(2, yCC));
            this.add((Component)this.entropySlider, cc.xy(5, yCC));
            this.add((Component)this.entropyTtf, cc.xy(4, yCC));
            this.add((Component)this.entropySelectOr, cc.xy(6, yCC));
            this.add((Component)this.entropySelectAnd, cc.xy(7, yCC));
            ++yCC;
        }
        if (this.methods.isS3DetUsed()) {
            this.add((Component)this.s3DetLbl, cc.xy(2, yCC));
            this.add((Component)this.s3DetSlider, cc.xy(5, yCC));
            this.add((Component)this.s3DetTtf, cc.xy(4, yCC));
            this.add((Component)this.s3DetSelectOr, cc.xy(6, yCC));
            this.add((Component)this.s3DetSelectAnd, cc.xy(7, yCC));
            ++yCC;
        }
        if (this.udmNumber > 0) {
            this.index = 0;
            while (this.index < this.udmNumber) {
                this.add((Component)this.otherLbl[this.index], cc.xy(2, yCC));
                this.add((Component)this.otherSlider[this.index], cc.xy(5, yCC));
                this.add((Component)this.otherTtf[this.index], cc.xy(4, yCC));
                this.add((Component)this.otherSelectOr[this.index], cc.xy(6, yCC));
                this.add((Component)this.otherSelectAnd[this.index], cc.xy(7, yCC));
                ++yCC;
                ++this.index;
            }
        }
    }

    public void drawPanel(Graphics g, int startx, int endx, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Constants.METHODDESCPNL_BGCOLOR);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.black);
        g2d.setFont(new Font("SansSerif", 1, 12));
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        int margin = Constants.METHOD_OFFSET;
        int y_index = fm.getHeight() - fm.getDescent() + Constants.METHOD_OFFSET / 2 + 2;
        if (this.methods.isxDetUsed()) {
            g2d.drawString("XDet: " + this.methods.getxDetCutoff(), margin, y_index);
            y_index += Constants.METHOD_OFFSET;
        }
        if (this.methods.isEntropyUsed()) {
            g2d.drawString("Entropy: " + this.methods.getEntropyCutoff(), margin, y_index);
            y_index += Constants.METHOD_OFFSET;
        }
        if (this.methods.isS3DetUsed()) {
            g2d.drawString("S3: " + this.methods.getS3DetCutoff(), margin, y_index);
            y_index += Constants.METHOD_OFFSET;
        }
        for (int i = 0; i < this.methods.getUdmNumber(); ++i) {
            g2d.drawString(this.methods.getUdmObjects()[i].getMethodName() + ": " + this.methods.getUdmObjects()[i].getScoreCutoff(), margin, y_index);
            y_index += Constants.METHOD_OFFSET;
        }
    }
}

