/*
 * Decompiled with CFR 0.152.
 */
package view;

import interfaces.Observable;
import interfaces.Observer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import model.FuncResidueImpl;
import model.S3DetObject;
import model.SequenceImpl;
import util.ColorScheme;
import util.ResidueSelectionManager;
import util.SelectionManager;
import util.SequenceManager;
import util.SequenceOrderer;
import view.AlignPanel;
import view.AlignViewProps;
import view.Cluster3DFrame;
import view.Structure3DFrame;

public class SequencePainter
extends JComponent
implements Observable,
Observer {
    private static final long serialVersionUID = 1L;
    private Graphics2D graphics2d;
    private Graphics graphics;
    private AlignViewProps viewProps;
    private FontMetrics fontMetrics;
    private AlignPanel alignPanel;
    private HashMap<Integer, Color> colColorMap;
    private int iWidth;
    private int iHeight;
    private S3DetObject s3detobj;
    private Vector<Observer> observersList;
    private int currentPosition;
    private SequenceImpl selectedSequence;
    private int sumScrollX;
    private Structure3DFrame.JmolPanel jmolPanel;
    private boolean isExport;
    private boolean isInteractive = true;

    public SequencePainter(AlignViewProps viewProps, AlignPanel alignPanel, S3DetObject s3detobj) {
        this.viewProps = viewProps;
        this.alignPanel = alignPanel;
        this.s3detobj = s3detobj;
        this.setLayout(new BorderLayout());
        this.observersList = new Vector();
        SelectionManager.setEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectionManager.isEnabled()) {
                    SequencePainter.this.toggleResidue(e);
                    SequencePainter.this.notifyOnMouseClick(e);
                }
            }
        });
        SelectionManager.setSeqPainter(this);
        ResidueSelectionManager.setSeqPainter(this);
    }

    public SequencePainter(AlignViewProps viewProps, S3DetObject s3detobj) {
        this.viewProps = viewProps;
        this.s3detobj = s3detobj;
        this.setLayout(new BorderLayout());
        this.isInteractive = false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphics2d = (Graphics2D)g.create();
        this.graphics2d.setFont(this.viewProps.getFont());
        this.graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        int yEnd = this.viewProps.getYEnd() * this.viewProps.getCharHeight();
        g.fillRect(0, 0, this.getWidth(), yEnd);
        this.iWidth = this.getWidth();
        this.iHeight = this.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0, yEnd, this.getWidth(), this.getHeight() - yEnd);
        this.drawPanel(this.graphics2d, this.viewProps.getXStart(), this.viewProps.getXEnd(), this.viewProps.getYStart(), this.viewProps.getYEnd(), 0);
        if (this.isInteractive) {
            int i;
            for (i = 0; i < SelectionManager.getCurrentSelection().size(); ++i) {
                this.highlightResidue(g, SelectionManager.getCurrentSelection().get(i) - 1);
            }
            for (i = 0; i < ResidueSelectionManager.getCurrentSelection().size(); ++i) {
                this.highlightAa(g, ResidueSelectionManager.getCurrentSelection().get(i).getPosition() - 1, ResidueSelectionManager.getCurrentSelection().get(i).getAa());
            }
        }
        g.setColor(Color.WHITE);
    }

    public void drawPanel(Graphics g1, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        this.draw(g1, startRes, endRes, startSeq, endSeq, offset);
    }

    private void draw(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        block17: {
            SequenceImpl nextSequence;
            int i;
            int seqPos;
            block16: {
                g.setFont(this.viewProps.getFont());
                this.init(g);
                seqPos = startSeq;
                if (this.s3detobj != null) break block16;
                if (this.isInteractive) {
                    for (int i2 = startSeq; i2 < endSeq; ++i2) {
                        SequenceImpl nextSequence2 = this.viewProps.getAlObj().getSequenceAt(i2);
                        this.drawSeq(nextSequence2, startRes, endRes, offset + (i2 - startSeq) * this.viewProps.getCharHeight());
                    }
                } else {
                    for (int i3 = 0; i3 < this.viewProps.getAlObj().getWidth(); ++i3) {
                        if (seqPos < startSeq || seqPos >= endSeq) continue;
                        SequenceImpl nextSequence3 = this.viewProps.getAlObj().getSequenceAt(i3);
                        if (!SequenceManager.isEmpty() && !SequenceManager.contains(nextSequence3.getName())) continue;
                        this.drawSelectionSeq(nextSequence3, startRes, endRes, offset + (seqPos - startSeq) * this.viewProps.getCharHeight());
                        ++seqPos;
                    }
                }
                break block17;
            }
            SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
            SequenceImpl[] sequences = seqOrderer.getClusterSequences();
            int startBox = 0;
            int endBox = 0;
            if (this.isInteractive) {
                for (i = startSeq; i < endSeq; ++i) {
                    nextSequence = sequences[i];
                    this.drawSeq(nextSequence, startRes, endRes, offset + (i - startSeq) * this.viewProps.getCharHeight());
                    if (nextSequence.isClusterStart()) {
                        startBox = i - startSeq;
                        if (this.isExport) {
                            this.drawHorizontal(nextSequence, 0, this.viewProps.getCharWidth() * nextSequence.getLength(), offset + startBox * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                        } else {
                            this.drawHorizontal(nextSequence, 0, (endRes - startRes + 1) * this.viewProps.getCharWidth(), offset + startBox * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                        }
                    }
                    if (nextSequence.isClusterEnd()) {
                        endBox = i + 1 - startSeq;
                        if (this.isExport) {
                            this.drawHorizontal(nextSequence, 0, this.viewProps.getCharWidth() * nextSequence.getLength() - 1, offset + (endBox * this.viewProps.getCharHeight() - 2), nextSequence.getClusterColor());
                        } else {
                            this.drawHorizontal(nextSequence, 0, (endRes - startRes + 1) * this.viewProps.getCharWidth(), offset + (endBox * this.viewProps.getCharHeight() - 2), nextSequence.getClusterColor());
                        }
                    }
                    if (!this.isExport) continue;
                    this.drawVertical(nextSequence, 0, startBox * this.viewProps.getCharHeight() + 1, endBox * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                    this.drawVertical(nextSequence, this.viewProps.getCharWidth() * nextSequence.getLength() - 1, startBox * this.viewProps.getCharHeight() + 1, endBox * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                }
            } else {
                for (i = 0; i < sequences.length; ++i) {
                    if (seqPos < startSeq || seqPos >= endSeq) continue;
                    nextSequence = sequences[i];
                    nextSequence = sequences[i];
                    if (!SequenceManager.isEmpty() && !SequenceManager.contains(nextSequence.getName())) continue;
                    this.drawSelectionSeq(nextSequence, startRes, endRes, offset + (seqPos - startSeq) * this.viewProps.getCharHeight());
                    ++seqPos;
                }
            }
            if (!this.isInteractive) break block17;
            for (i = 0; i < SelectionManager.getCurrentSelection().size(); ++i) {
                this.highlightResidue(g, SelectionManager.getCurrentSelection().get(i) - 1);
            }
            for (i = 0; i < ResidueSelectionManager.getCurrentSelection().size(); ++i) {
                this.highlightAa(g, ResidueSelectionManager.getCurrentSelection().get(i).getPosition() - 1, ResidueSelectionManager.getCurrentSelection().get(i).getAa());
            }
        }
    }

    public void init(Graphics g) {
        this.graphics = g;
        this.fontMetrics = g.getFontMetrics();
    }

    public void colorColumn(Color currentColor, int xPos, int yPos) {
        int width = this.viewProps.getCharWidth();
        Color standardColor = Color.WHITE;
        if (standardColor != currentColor) {
            if (currentColor != null) {
                this.graphics.setColor(currentColor);
                this.graphics.fillRect(this.viewProps.getCharWidth() * (xPos - this.viewProps.getXStart()), yPos, width, this.viewProps.getCharHeight());
            }
            width += this.viewProps.getCharWidth();
        }
    }

    public void drawBackground(int start, int end, int yPos) {
        for (int i = start; i < end && this.colColorMap != null; ++i) {
            if (!this.colColorMap.containsKey(i)) continue;
            Color columnColor = this.colColorMap.get(i);
            this.colorColumn(columnColor, i - 1, yPos);
        }
    }

    public void drawHorizontal(SequenceImpl seq, int xStart, int xEnd, int yPos, Color linecolor) {
        Graphics2D g2d = (Graphics2D)this.graphics;
        g2d.setColor(linecolor);
        g2d.setStroke(new BasicStroke(2.0f));
        double startX = new Integer(xStart).doubleValue();
        double endX = new Integer(xEnd).doubleValue();
        double startY = new Integer(yPos).doubleValue();
        double endY = new Integer(yPos).doubleValue();
        g2d.clearRect(xStart, yPos, xEnd - xStart, 2);
        Line2D.Double line2d = new Line2D.Double(startX, startY, endX, endY);
        g2d.draw(line2d);
    }

    public void drawVertical(SequenceImpl seq, int xPos, int yStart, int yEnd, Color linecolor) {
        Graphics2D g2d = (Graphics2D)this.graphics;
        g2d.setColor(linecolor);
        g2d.setStroke(new BasicStroke(1.5f));
        double startX = new Integer(xPos).doubleValue();
        double endX = new Integer(xPos).doubleValue();
        double startY = new Integer(yStart).doubleValue();
        double endY = new Integer(yEnd).doubleValue();
        Line2D.Double line2d = new Line2D.Double(startX, startY, endX, endY);
        g2d.draw(line2d);
    }

    public void drawSeq(SequenceImpl seq, int start, int end, int yPos) {
        int yStart = yPos;
        yPos += this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5;
        int charOffset = 0;
        if (end + 1 >= seq.getLength()) {
            end = seq.getLength() - 1;
        }
        for (int i = start; i <= end; ++i) {
            char letter = seq.getLetterAt(i);
            if (ColorScheme.containsKey(Character.valueOf(letter))) {
                this.graphics.setColor(ColorScheme.getColor(Character.valueOf(letter)));
                this.graphics.fillRect(this.viewProps.getCharWidth() * (i - this.viewProps.getXStart()), yStart, this.viewProps.getCharWidth(), this.viewProps.getCharHeight());
            }
            this.graphics.setColor(Color.BLACK);
            Font font = new Font("Sans Serif", 0, 12);
            this.graphics.setFont(font);
            charOffset = (this.viewProps.getCharWidth() - this.fontMetrics.charWidth(letter)) / 2;
            this.graphics.drawString(String.valueOf(letter), charOffset + this.viewProps.getCharWidth() * (i - start), yPos);
        }
    }

    public void drawSelectionSeq(SequenceImpl seq, int start, int end, int yPos) {
        if (SelectionManager.getCurrentSelection().isEmpty() && ResidueSelectionManager.isEmpty()) {
            this.drawSeq(seq, start, end, yPos);
        } else {
            int yStart = yPos;
            yPos += this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5;
            int charOffset = 0;
            if (end + 1 >= seq.getLength()) {
                end = seq.getLength() - 1;
            }
            Vector<Integer> currentSelection = SelectionManager.getFullSelection();
            for (int i = start; i < currentSelection.size() && i < end; ++i) {
                int j = currentSelection.get(i) - 1;
                char letter = seq.getLetterAt(j);
                if (ColorScheme.containsKey(Character.valueOf(letter))) {
                    this.graphics.setColor(ColorScheme.getColor(Character.valueOf(letter)));
                    this.graphics.fillRect(this.viewProps.getCharWidth() * (i - this.viewProps.getXStart()), yStart, this.viewProps.getCharWidth(), this.viewProps.getCharHeight());
                }
                this.graphics.setColor(Color.BLACK);
                Font font = new Font("Sans Serif", 0, 12);
                this.graphics.setFont(font);
                charOffset = (this.viewProps.getCharWidth() - this.fontMetrics.charWidth(letter)) / 2;
                this.graphics.drawString(String.valueOf(letter), charOffset + this.viewProps.getCharWidth() * (i - start), yPos);
            }
        }
    }

    public void scrollPainting(int xValue, int yValue) {
        this.graphics2d.copyArea(xValue * this.viewProps.getCharWidth(), yValue * this.viewProps.getCharHeight(), this.iWidth, this.iHeight, -xValue * this.viewProps.getCharWidth(), -yValue * this.viewProps.getCharHeight());
        int xStart = this.viewProps.getXStart();
        int xEnd = this.viewProps.getXEnd();
        int yStart = this.viewProps.getYStart();
        int yEnd = this.viewProps.getYEnd();
        int transX = 0;
        int transY = 0;
        if (xValue > 0) {
            transX = (++xEnd - xStart - xValue) * this.viewProps.getCharWidth();
            xStart = xEnd - xValue;
            this.sumScrollX += xValue;
        } else if (xValue < 0) {
            xEnd = xStart - xValue - 1;
            this.sumScrollX += xValue;
        } else if (yValue > 0) {
            yStart = yEnd - yValue;
            if (yStart < this.viewProps.getYStart()) {
                yStart = this.viewProps.getYStart();
            } else {
                transY = this.iHeight - yValue * this.viewProps.getCharHeight();
            }
        } else if (yValue < 0 && (yEnd = yStart - yValue) > this.viewProps.getYEnd()) {
            yEnd = this.viewProps.getYEnd();
        }
        this.graphics2d.translate(transX, transY);
        this.drawPanel(this.graphics2d, xStart, xEnd, yStart, yEnd, 0);
        this.graphics2d.translate(-transX, -transY);
        this.repaint();
    }

    public void notifyOnMouseClick(MouseEvent ev) {
        this.repaint();
        this.notifyObservers();
    }

    public void toggleResidue(MouseEvent ev) {
        if (this.getSequence(ev) >= 0) {
            SequenceImpl selectedSeq;
            if (this.s3detobj == null) {
                selectedSeq = this.viewProps.getAlObj().getSequenceAt(this.getSequence(ev));
            } else {
                SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
                SequenceImpl[] sequences = seqOrderer.getClusterSequences();
                selectedSeq = sequences[this.getSequence(ev)];
            }
            int currentPos = selectedSeq.findPosition(this.getAAPosition(ev));
            char aa = selectedSeq.getLetterAt(currentPos - 1);
            ResidueSelectionManager.toggleSelection(new FuncResidueImpl(currentPos, aa));
        }
    }

    private void highlightResidue(Graphics g, int x) {
        if (SelectionManager.isEnabled()) {
            Graphics2D g2d = (Graphics2D)this.graphics;
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(2.0f));
            int xPos = (x - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
            double startX = new Integer(xPos).doubleValue();
            double endX = new Integer(xPos + this.viewProps.getCharWidth()).doubleValue();
            double startY = new Integer(0).doubleValue();
            double endY = new Integer(this.viewProps.getCharHeight() * this.viewProps.getYEnd()).doubleValue();
            Line2D.Double leftLine = new Line2D.Double(startX, startY, startX, endY);
            Line2D.Double rightLine = new Line2D.Double(endX, startY, endX, endY);
            Line2D.Double bottomLine = new Line2D.Double(startX, endY, endX, endY);
            g2d.draw(leftLine);
            g2d.draw(rightLine);
            g2d.draw(bottomLine);
        }
    }

    private void highlightAa(Graphics g, int x, char aa) {
        Graphics2D g2d = (Graphics2D)this.graphics;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f));
        int xPos = (x - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
        double startX = new Integer(xPos).doubleValue();
        if (this.s3detobj == null) {
            SequenceImpl[] sequences = this.viewProps.getAlObj().getSequences();
            for (int i = 0; i < sequences.length; ++i) {
                if (sequences[i].getLetterAt(x) != aa) continue;
                double startY = (i - this.viewProps.getYStart()) * this.viewProps.getCharHeight();
                Rectangle2D.Double rectangle = new Rectangle2D.Double(startX, startY, this.viewProps.getCharWidth(), this.viewProps.getCharHeight());
                g2d.draw(rectangle);
            }
        } else {
            SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
            SequenceImpl[] sequences = seqOrderer.getClusterSequences();
            for (int i = 0; i < sequences.length; ++i) {
                if (sequences[i].getLetterAt(x) != aa) continue;
                double startY = (i - this.viewProps.getYStart()) * this.viewProps.getCharHeight();
                Rectangle2D.Double rectangle = new Rectangle2D.Double(startX, startY, this.viewProps.getCharWidth(), this.viewProps.getCharHeight());
                g2d.draw(rectangle);
            }
        }
    }

    public int getAAPosition(MouseEvent evt) {
        int pos = 0;
        int x = evt.getX();
        pos = x / this.viewProps.getCharWidth() + this.viewProps.getXStart();
        return pos;
    }

    public int getSequence(MouseEvent evt) {
        int seq = -1;
        int y = evt.getY();
        if (y / this.viewProps.getCharHeight() + this.viewProps.getYStart() < this.viewProps.getAlObj().getHeight()) {
            seq = y / this.viewProps.getCharHeight() + this.viewProps.getYStart();
        }
        return seq;
    }

    public AlignPanel getAlignPanel() {
        return this.alignPanel;
    }

    @Override
    public void notifyObservers() {
        for (int i = 0; i < this.observersList.size(); ++i) {
            Observer observer = this.observersList.elementAt(i);
            observer.update(this);
        }
    }

    public void notifyUpperPanels() {
        for (int i = 0; i < 2; ++i) {
            Observer observer = this.observersList.elementAt(i);
            observer.update(this);
        }
    }

    @Override
    public void register(Observer obs) {
        this.observersList.addElement(obs);
    }

    @Override
    public void deregister(Observer obs) {
        this.observersList.removeElement(obs);
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public SequenceImpl getSelectedSequence() {
        return this.selectedSequence;
    }

    @Override
    public void update(Observable object) {
        if (object instanceof Structure3DFrame.JmolPanel) {
            this.notifyObservers();
            this.repaint();
        }
    }

    public void setJmolPanel(Structure3DFrame.JmolPanel jmolPanel) {
        this.jmolPanel = jmolPanel;
        this.jmolPanel.register(this);
    }

    public void unsetJmolPanel() {
        this.jmolPanel.deregister(this);
    }

    public void setExport(boolean isExport) {
        this.isExport = isExport;
    }

    public void setSumScrollX(int sumScrollX) {
        this.sumScrollX = sumScrollX;
    }

    public int getSumScrollX() {
        return this.sumScrollX;
    }

    public void closeRegisteredWindows(String type) {
        for (int i = 0; i < this.observersList.size(); ++i) {
            Observer observer = this.observersList.elementAt(i);
            if (observer instanceof Structure3DFrame && (type.equals("Structures") || type.equals("All"))) {
                SequenceManager.setMarkedSequenceName(null);
                this.deregister(observer);
                ((Structure3DFrame)observer).dispose();
                --i;
                continue;
            }
            if (!(observer instanceof Cluster3DFrame) || !type.equals("Spaces") && !type.equals("All")) continue;
            this.deregister(observer);
            ((Cluster3DFrame)observer).dispose();
            --i;
        }
    }

    public AlignViewProps getViewProps() {
        return this.viewProps;
    }

    public void setViewProps(AlignViewProps viewProps) {
        this.viewProps = viewProps;
    }
}

