/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import model.S3DetObject;
import util.Constants;
import util.ResidueSelectionManager;
import util.ScreenConfig;
import util.SelectionManager;
import util.SequenceManager;
import view.AlignViewProps;
import view.IndexPanel;
import view.NamePanel;
import view.SequencePanel;

public class SelectionFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private AlignViewProps viewProps;
    private SequencePanel seqPanel;
    private S3DetObject s3detobj;
    private IndexPanel indexPanel;
    private NamePanel namePanel;
    private JPanel wholeSequencePnl = new JPanel();
    private JPanel descriptionPnl;
    private JLabel textLabel;
    private JPanel descBoxPanel;
    private JPanel upperPanel;
    private JPanel upperDescPnl;
    private JScrollBar horizontalScrollbar;
    private JScrollBar verticalScrollbar;
    private int horizontalChange = 0;
    private int verticalChange = 0;

    public SelectionFrame(AlignViewProps viewProps, S3DetObject s3detobj) {
        this.viewProps = viewProps;
        this.viewProps.init();
        this.s3detobj = s3detobj;
        this.init();
        this.pack();
        ScreenConfig.centerInScreen(this);
        this.validate();
        this.repaint();
        this.setVisible(true);
    }

    private void init() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().setPreferredSize(new Dimension(1100, 510));
        this.textLabel = new JLabel("Protein ID");
        this.textLabel.setPreferredSize(new Dimension(265, 30));
        this.textLabel.setMinimumSize(new Dimension(265, 30));
        this.textLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.descBoxPanel = new JPanel();
        this.descBoxPanel.setLayout(new BoxLayout(this.descBoxPanel, 0));
        this.descBoxPanel.setBackground(Constants.DESCBOXPNL_BGCOLOR);
        this.descBoxPanel.add(Box.createRigidArea(new Dimension(5, 30)));
        this.descBoxPanel.add(this.textLabel);
        this.upperDescPnl = new JPanel(new BorderLayout());
        this.upperPanel = new JPanel(new BorderLayout());
        if (this.viewProps == null) {
            this.indexPanel = new IndexPanel();
            this.namePanel = new NamePanel();
            this.seqPanel = new SequencePanel();
            this.descriptionPnl = new JPanel(new BorderLayout());
            this.descriptionPnl.setBackground(Color.WHITE);
            this.upperDescPnl.add((Component)this.descBoxPanel, "Center");
            this.upperPanel.add((Component)this.indexPanel, "Center");
            this.descriptionPnl.add((Component)this.upperDescPnl, "North");
            this.descriptionPnl.add((Component)this.namePanel, "Center");
            this.wholeSequencePnl = new JPanel(new BorderLayout());
            this.wholeSequencePnl.add((Component)this.upperPanel, "North");
            this.wholeSequencePnl.add((Component)this.seqPanel, "Center");
            this.getContentPane().add(this.descriptionPnl);
            this.getContentPane().add(this.wholeSequencePnl);
        } else {
            this.seqPanel = new SequencePanel(this.viewProps, this.s3detobj);
            this.namePanel = new NamePanel(this.viewProps, this.s3detobj);
            this.indexPanel = new IndexPanel(this.viewProps);
            this.upperPanel.add((Component)this.indexPanel, "Center");
            this.descriptionPnl = new JPanel(new BorderLayout());
            this.descriptionPnl.setBackground(Color.WHITE);
            this.upperDescPnl.add((Component)this.descBoxPanel, "Center");
            this.descriptionPnl.add((Component)this.upperDescPnl, "North");
            this.descriptionPnl.add((Component)this.namePanel, "Center");
            this.descriptionPnl.setPreferredSize(new Dimension(250, 450));
            this.descriptionPnl.setMinimumSize(new Dimension(250, 450));
            this.descriptionPnl.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.wholeSequencePnl = new JPanel(new BorderLayout());
            this.wholeSequencePnl.add((Component)this.upperPanel, "North");
            this.wholeSequencePnl.add((Component)this.seqPanel, "Center");
            this.horizontalScrollbar = new JScrollBar(0);
            this.horizontalScrollbar.addAdjustmentListener(new SelectionScrollAdjuster());
            this.wholeSequencePnl.add((Component)this.horizontalScrollbar, "South");
            this.verticalScrollbar = new JScrollBar(1);
            this.verticalScrollbar.addAdjustmentListener(new SelectionScrollAdjuster());
            this.getContentPane().add(this.descriptionPnl);
            this.getContentPane().add(this.wholeSequencePnl);
            this.getContentPane().add((Component)this.verticalScrollbar, "East");
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.viewProps != null) {
            this.setScrollValues(this.viewProps.getXStart(), this.viewProps.getYStart());
        }
    }

    public void setScrollValues(int x, int y) {
        int width = this.viewProps.getAlObj().getWidth();
        if (!SelectionManager.isEmpty() || !ResidueSelectionManager.isEmpty()) {
            width = SelectionManager.getFullSelection().size();
        }
        int height = this.viewProps.getAlObj().getHeight();
        if (!SequenceManager.isEmpty()) {
            height = SequenceManager.getSelectedSequences().size();
        }
        this.horizontalChange = this.seqPanel.getWidth() / this.viewProps.getCharWidth();
        this.verticalChange = this.seqPanel.getHeight() / this.viewProps.getCharHeight();
        if (this.horizontalChange > width) {
            this.horizontalChange = width;
        }
        if (this.verticalChange > height) {
            this.verticalChange = height;
        }
        if (this.horizontalChange + x > width) {
            x = width - this.horizontalChange;
        }
        if (this.verticalChange + y > height) {
            y = height - this.verticalChange;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        this.horizontalScrollbar.setValues(x, this.horizontalChange, 0, width);
        this.verticalScrollbar.setValues(y, this.verticalChange, 0, height);
    }

    public class SelectionScrollAdjuster
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            int oldX = SelectionFrame.this.viewProps.getXStart();
            int oldY = SelectionFrame.this.viewProps.getYStart();
            if (evt.getSource() == SelectionFrame.this.verticalScrollbar) {
                int y = SelectionFrame.this.verticalScrollbar.getValue();
                SelectionFrame.this.viewProps.setYStart(y);
                int yQuot = SelectionFrame.this.seqPanel.getSeqPainter().getHeight() / SelectionFrame.this.viewProps.getCharHeight();
                if (y + yQuot <= SelectionFrame.this.viewProps.getAlObj().getHeight()) {
                    SelectionFrame.this.viewProps.setYEnd(y + yQuot);
                }
            }
            if (evt.getSource() == SelectionFrame.this.horizontalScrollbar) {
                int x = SelectionFrame.this.horizontalScrollbar.getValue();
                SelectionFrame.this.viewProps.setXStart(x);
                SelectionFrame.this.viewProps.setXEnd(x + SelectionFrame.this.seqPanel.getSeqPainter().getWidth() / SelectionFrame.this.viewProps.getCharWidth());
            }
            int scrollX = SelectionFrame.this.viewProps.getXStart() - oldX;
            int scrollY = SelectionFrame.this.viewProps.getYStart() - oldY;
            if (scrollX > SelectionFrame.this.viewProps.getXEnd() - SelectionFrame.this.viewProps.getXStart()) {
                scrollX = SelectionFrame.this.viewProps.getXEnd() - SelectionFrame.this.viewProps.getXStart();
            } else if (scrollX < SelectionFrame.this.viewProps.getXStart() - SelectionFrame.this.viewProps.getXEnd()) {
                scrollX = SelectionFrame.this.viewProps.getXStart() - SelectionFrame.this.viewProps.getXEnd();
            }
            if (scrollY > SelectionFrame.this.viewProps.getYEnd() - SelectionFrame.this.viewProps.getYStart()) {
                scrollY = SelectionFrame.this.viewProps.getYEnd() - SelectionFrame.this.viewProps.getYStart();
            } else if (scrollY < SelectionFrame.this.viewProps.getYStart() - SelectionFrame.this.viewProps.getYEnd()) {
                scrollY = SelectionFrame.this.viewProps.getYStart() - SelectionFrame.this.viewProps.getYEnd();
            }
            if (scrollX != 0 || scrollY != 0) {
                SelectionFrame.this.seqPanel.getSeqPainter().scrollPainting(scrollX, scrollY);
                SelectionFrame.this.namePanel.getNameRenderer().scrollPainting(scrollX, scrollY);
                SelectionFrame.this.indexPanel.repaint();
            }
        }
    }
}

