/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import util.Constants;
import util.ResidueSelectionManager;
import util.SelectionManager;
import util.SequenceManager;

public class PickPointsBehavior
extends Behavior {
    private Canvas3D canvas;
    private BranchGroup objRoot;
    private BranchGroup quadBranch;
    private WakeupCriterion[] mouseEvents;
    private WakeupOr mouseCriterion;
    private Point3d initialPoint;
    private Point3d finalPoint;
    private Point2d initialPoint2d;
    private Point2d finalPoint2d;
    private boolean mousePressed = false;
    private boolean mouseDragged = false;
    private PickCanvas pickCanvas;
    private int x;
    private int y;

    public PickPointsBehavior(Canvas3D canvas, BranchGroup objRoot) {
        this.canvas = canvas;
        this.objRoot = objRoot;
        this.pickCanvas = new PickCanvas(canvas, objRoot);
        this.pickCanvas.setMode(1024);
        this.pickCanvas.setTolerance(0.5f);
    }

    @Override
    public void initialize() {
        this.initialPoint = new Point3d();
        this.finalPoint = new Point3d();
        this.initialPoint2d = new Point2d();
        this.finalPoint2d = new Point2d();
        this.mouseEvents = new WakeupCriterion[4];
        this.mouseEvents[0] = new WakeupOnAWTEvent(500);
        this.mouseEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseEvents[2] = new WakeupOnAWTEvent(502);
        this.mouseEvents[3] = new WakeupOnAWTEvent(506);
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn(this.mouseCriterion);
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        int isShiftPressed = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                if (event[i] instanceof MouseEvent) {
                    isShiftPressed = ((MouseEvent)event[i]).getModifiers() & 1;
                }
                if (isShiftPressed == 0) {
                    if (this.quadBranch != null) {
                        this.objRoot.removeChild(this.quadBranch);
                        this.quadBranch = null;
                    }
                    this.setRotation(true);
                } else {
                    this.setRotation(false);
                }
                int id = event[i].getID();
                if (isShiftPressed != 0 && id == 500) {
                    this.mousePressed = true;
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    this.initialPoint2d.set(this.x, this.y);
                    this.mousePressed = false;
                    this.mouseDragged = false;
                    this.performPointPicking();
                    SelectionManager.updateSeqPainter();
                    continue;
                }
                if (isShiftPressed != 0 && id == 506) {
                    if (!this.mousePressed) continue;
                    this.mouseDragged = true;
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    this.finalPoint2d.set(this.x, this.y);
                    this.drawPickingArea();
                    continue;
                }
                if (isShiftPressed != 0 && id == 501) {
                    this.setRotation(false);
                    this.mousePressed = true;
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    this.initialPoint2d.set(this.x, this.y);
                    continue;
                }
                if (id != 502 || isShiftPressed == 0) continue;
                if (!this.mouseDragged) {
                    this.mousePressed = false;
                    this.mouseDragged = false;
                    continue;
                }
                this.mousePressed = false;
                this.mouseDragged = false;
                this.x = ((MouseEvent)event[i]).getX();
                this.y = ((MouseEvent)event[i]).getY();
                this.finalPoint2d.set(this.x, this.y);
                this.performBoundsPicking();
                if (this.quadBranch != null) {
                    this.objRoot.removeChild(this.quadBranch);
                    this.quadBranch = null;
                }
                SelectionManager.updateSeqPainter();
            }
        }
        this.wakeupOn(this.mouseCriterion);
    }

    private void performPointPicking() {
        if (this.quadBranch != null) {
            this.objRoot.removeChild(this.quadBranch);
            this.quadBranch = null;
        }
        this.canvas.getPixelLocationInImagePlate(this.x, this.y, this.initialPoint);
        Transform3D transform3D = new Transform3D();
        this.canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(this.initialPoint);
        Vector3d direction = new Vector3d(0.0, 0.0, -1.0);
        PickCylinderRay pickRay = new PickCylinderRay(this.initialPoint, direction, 0.008f);
        SceneGraphPath[] sgp = this.objRoot.pickAll(pickRay);
        if (sgp != null) {
            for (int l = 0; l < sgp.length; ++l) {
                Shape3D shape;
                PickResult pickResult = new PickResult(sgp[l], pickRay);
                if (pickResult == null || (shape = (Shape3D)pickResult.getNode(1)).getUserData() == null || !shape.getUserData().equals("Sequences") && !shape.getUserData().equals("Residues")) continue;
                int numIntersections = pickResult.numIntersections();
                for (int i = 0; i < numIntersections; ++i) {
                    PickIntersection intersection = pickResult.getIntersection(i);
                    GeometryArray ga = intersection.getGeometryArray();
                    int[] primitiveVertexIndices = intersection.getPrimitiveVertexIndices();
                    if (primitiveVertexIndices == null) continue;
                    for (int j = 0; j < primitiveVertexIndices.length; ++j) {
                        Point3f point = new Point3f();
                        ga.getCoordinate(primitiveVertexIndices[j], point);
                        if (shape.getUserData() != null && shape.getUserData().equals("Sequences")) {
                            SequenceManager.addSequenceByPosition(primitiveVertexIndices[j]);
                            continue;
                        }
                        ResidueSelectionManager.addResidueByPosition(primitiveVertexIndices[j]);
                    }
                }
            }
        }
    }

    private void drawPickingArea() {
        if (this.quadBranch != null) {
            this.objRoot.removeChild(this.quadBranch);
            this.quadBranch = null;
        }
        Point2d drawInitialPoint = new Point2d(Math.min(this.initialPoint2d.x, this.finalPoint2d.x), Math.min(this.initialPoint2d.y, this.finalPoint2d.y));
        Point2d drawFinalPoint = new Point2d(Math.max(this.initialPoint2d.x, this.finalPoint2d.x), Math.max(this.initialPoint2d.y, this.finalPoint2d.y));
        Point3d markedPoint = new Point3d();
        Transform3D transform3D = new Transform3D();
        this.canvas.getImagePlateToVworld(transform3D);
        QuadArray qa = new QuadArray(4, 1);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawInitialPoint.x).intValue(), Double.valueOf(drawInitialPoint.y).intValue(), markedPoint);
        transform3D.transform(markedPoint);
        qa.setCoordinate(0, markedPoint);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawInitialPoint.x).intValue(), Double.valueOf(drawFinalPoint.y).intValue(), markedPoint);
        transform3D.transform(markedPoint);
        qa.setCoordinate(1, markedPoint);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawFinalPoint.x).intValue(), Double.valueOf(drawFinalPoint.y).intValue(), markedPoint);
        transform3D.transform(markedPoint);
        markedPoint = new Point3d(markedPoint);
        qa.setCoordinate(2, markedPoint);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawFinalPoint.x).intValue(), Double.valueOf(drawInitialPoint.y).intValue(), markedPoint);
        transform3D.transform(markedPoint);
        qa.setCoordinate(3, markedPoint);
        Appearance appearance = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(1);
        appearance.setPolygonAttributes(pa);
        LineAttributes la = new LineAttributes();
        la.setLinePattern(1);
        la.setLineAntialiasingEnable(true);
        appearance.setLineAttributes(la);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(new Color3f(Constants.PICK_AREA_COLOR));
        appearance.setColoringAttributes(ca);
        Shape3D s = new Shape3D(qa, appearance);
        this.quadBranch = new BranchGroup();
        this.quadBranch.setCapability(17);
        this.quadBranch.addChild(s);
        this.objRoot.addChild(this.quadBranch);
    }

    private void performBoundsPicking() {
        Point2d drawInitialPoint = new Point2d(Math.min(this.initialPoint2d.x, this.finalPoint2d.x), Math.min(this.initialPoint2d.y, this.finalPoint2d.y));
        Point2d drawFinalPoint = new Point2d(Math.max(this.initialPoint2d.x, this.finalPoint2d.x), Math.max(this.initialPoint2d.y, this.finalPoint2d.y));
        Transform3D transform3D = new Transform3D();
        this.canvas.getImagePlateToVworld(transform3D);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawInitialPoint.x).intValue(), Double.valueOf(drawInitialPoint.y).intValue(), this.initialPoint);
        transform3D.transform(this.initialPoint);
        this.canvas.getPixelLocationInImagePlate(Double.valueOf(drawFinalPoint.x).intValue(), Double.valueOf(drawFinalPoint.y).intValue(), this.finalPoint);
        transform3D.transform(this.finalPoint);
        Point3d upperFrontLeft = new Point3d(this.initialPoint.x, this.initialPoint.y, this.initialPoint.z);
        Point3d lowerBackRight = new Point3d(this.finalPoint.x, this.finalPoint.y, -this.initialPoint.z);
        Point3d upperFrontRight = new Point3d(lowerBackRight.x, upperFrontLeft.y, upperFrontLeft.z);
        Point3d lowerFrontRight = new Point3d(lowerBackRight.x, lowerBackRight.y, upperFrontLeft.z);
        Point3d upperBackRight = new Point3d(lowerBackRight.x, upperFrontLeft.y, lowerBackRight.z);
        Point3d lowerFrontLeft = new Point3d(upperFrontLeft.x, lowerBackRight.y, upperFrontLeft.z);
        Point3d lowerBackLeft = new Point3d(upperFrontLeft.x, lowerBackRight.y, lowerBackRight.z);
        Point3d upperBackLeft = new Point3d(upperFrontLeft.x, upperFrontLeft.y, lowerBackRight.z);
        Vector4d[] planes = new Vector4d[]{this.planeFromPoints(upperFrontRight, upperBackRight, lowerFrontRight), this.planeFromPoints(lowerFrontLeft, lowerBackLeft, upperFrontLeft), this.planeFromPoints(upperFrontLeft, upperBackLeft, upperFrontRight), this.planeFromPoints(lowerFrontLeft, lowerFrontRight, lowerBackLeft), this.planeFromPoints(lowerFrontLeft, upperFrontLeft, lowerFrontRight), this.planeFromPoints(lowerBackLeft, lowerBackRight, upperBackLeft)};
        BoundingPolytope selectedArea = new BoundingPolytope(planes);
        PickBounds pickBounds = new PickBounds(selectedArea);
        SceneGraphPath[] sgp = this.objRoot.pickAll(pickBounds);
        if (sgp != null) {
            for (int l = 0; l < sgp.length; ++l) {
                Shape3D shape;
                PickResult pickResult = new PickResult(sgp[l], pickBounds);
                if (pickResult == null || (shape = (Shape3D)pickResult.getNode(1)).getUserData() == null || !shape.getUserData().equals("Sequences") && !shape.getUserData().equals("Residues")) continue;
                int numIntersections = pickResult.numIntersections();
                for (int i = 0; i < numIntersections; ++i) {
                    PickIntersection intersection = pickResult.getIntersection(i);
                    GeometryArray ga = intersection.getGeometryArray();
                    int[] primitiveVertexIndices = intersection.getPrimitiveVertexIndices();
                    if (primitiveVertexIndices == null) continue;
                    for (int j = 0; j < primitiveVertexIndices.length; ++j) {
                        Point3f point = new Point3f();
                        ga.getCoordinate(primitiveVertexIndices[j], point);
                        if (shape.getUserData() != null && shape.getUserData().equals("Sequences")) {
                            SequenceManager.addSequenceByPosition(primitiveVertexIndices[j]);
                            continue;
                        }
                        ResidueSelectionManager.addResidueByPosition(primitiveVertexIndices[j]);
                    }
                }
            }
        }
    }

    private void setRotation(boolean value) {
        Enumeration rootChildren = this.objRoot.getAllChildren();
        while (rootChildren.hasMoreElements()) {
            Object childRoot = rootChildren.nextElement();
            if (!(childRoot instanceof MouseRotate)) continue;
            ((MouseRotate)childRoot).setEnable(value);
        }
    }

    private Vector4d planeFromPoints(Point3d base, Point3d rightPt, Point3d leftPt) {
        Vector3d rightVec = new Vector3d();
        rightVec.sub(rightPt, base);
        Vector3d leftVec = new Vector3d();
        leftVec.sub(leftPt, base);
        Vector3d normal = new Vector3d();
        normal.cross(leftVec, rightVec);
        normal.normalize();
        Vector4d plane = new Vector4d(normal.x, normal.y, normal.z, -(normal.x * base.x + normal.y * base.y + normal.z * base.z));
        return plane;
    }
}

