/*
 * Decompiled with CFR 0.152.
 */
package view;

import interfaces.Observable;
import interfaces.Observer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import model.S3DetObject;
import model.SequenceImpl;
import util.Constants;
import util.ResidueSelectionManager;
import util.SelectionManager;
import util.SequenceManager;
import util.SequenceOrderer;
import view.AlignPanel;
import view.AlignViewProps;
import view.SequencePainter;

public class NamePainter
extends JComponent
implements Observer {
    private static final long serialVersionUID = 1L;
    private AlignViewProps viewProps;
    private Graphics2D graphics2d;
    private S3DetObject s3detobj;
    private SequencePainter seqPainter;
    private int iWidth;
    private int iHeight;
    private boolean isInteractive = true;
    private int startSelection = -1;

    public NamePainter(AlignViewProps viewProps, AlignPanel alignPanel, S3DetObject s3detobj, SequencePainter seqPainter) {
        this.viewProps = viewProps;
        this.s3detobj = s3detobj;
        this.setLayout(new BorderLayout());
        SequenceManager.setS3detobj(s3detobj);
        SelectionManager.setS3detobj(s3detobj);
        ResidueSelectionManager.setS3detobj(s3detobj);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectionManager.isEnabled()) {
                    NamePainter.this.sequenceClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                NamePainter.this.sequencePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                NamePainter.this.sequenceReleased(e);
            }
        });
        this.seqPainter = seqPainter;
        seqPainter.register(this);
        this.repaint();
    }

    public NamePainter(AlignViewProps viewProps, S3DetObject s3detobj) {
        this.viewProps = viewProps;
        this.s3detobj = s3detobj;
        this.setLayout(new BorderLayout());
        this.isInteractive = false;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphics2d = (Graphics2D)g.create();
        this.iWidth = this.getWidth();
        this.iHeight = this.getHeight();
        this.drawComponent(this.graphics2d, this.viewProps.getXStart(), this.viewProps.getXEnd(), this.viewProps.getYStart(), this.viewProps.getYEnd());
    }

    public void drawComponent(Graphics2D g, int startRes, int endRes, int yStart, int yEnd) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), yEnd);
        g.setColor(Color.WHITE);
        g.fillRect(0, yEnd, this.getWidth(), this.getHeight() - yEnd);
        Font font = new Font("Verdana", 1, 12);
        g.setFont(font);
        int start = yStart;
        int end = yEnd;
        int seqPos = start;
        if (this.s3detobj == null) {
            if (this.isInteractive) {
                for (int i = start; i < end; ++i) {
                    SequenceImpl nextSequence = this.viewProps.getAlObj().getSequenceAt(i);
                    if (nextSequence.getName().equals(SequenceManager.getMarkedSequenceName())) {
                        this.drawBlackName(g, nextSequence, (i - start) * this.viewProps.getCharHeight());
                        continue;
                    }
                    if (SequenceManager.isSelected(nextSequence.getName())) {
                        this.drawSelectedName(g, nextSequence, (i - start) * this.viewProps.getCharHeight());
                        continue;
                    }
                    this.drawName(g, nextSequence, 0, (i - start) * this.viewProps.getCharHeight(), Color.WHITE);
                }
            } else {
                for (int i = 0; i < this.viewProps.getAlObj().getHeight(); ++i) {
                    if (seqPos < start || seqPos >= end) continue;
                    SequenceImpl nextSequence = this.viewProps.getAlObj().getSequenceAt(i);
                    if (!SequenceManager.isEmpty() && !SequenceManager.contains(nextSequence.getName())) continue;
                    this.drawName(g, nextSequence, 0, (seqPos - start) * this.viewProps.getCharHeight(), Color.WHITE);
                    ++seqPos;
                }
            }
        } else {
            SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
            SequenceImpl[] sequences = seqOrderer.getClusterSequences();
            if (this.isInteractive) {
                for (int i = start; i < end; ++i) {
                    SequenceImpl nextSequence = sequences[i];
                    if (nextSequence.getName().equals(SequenceManager.getMarkedSequenceName())) {
                        this.drawBlackName(g, nextSequence, (i - start) * this.viewProps.getCharHeight());
                        continue;
                    }
                    if (SequenceManager.isSelected(nextSequence.getName())) {
                        this.drawSelectedName(g, nextSequence, (i - start) * this.viewProps.getCharHeight());
                        continue;
                    }
                    this.drawName(g, nextSequence, 0, (i - start) * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                }
            } else {
                for (int i = 0; i < sequences.length; ++i) {
                    if (seqPos < start || seqPos >= end) continue;
                    SequenceImpl nextSequence = sequences[i];
                    if (!SequenceManager.isEmpty() && !SequenceManager.contains(nextSequence.getName())) continue;
                    this.drawName(g, nextSequence, 0, (seqPos - start) * this.viewProps.getCharHeight(), nextSequence.getClusterColor());
                    ++seqPos;
                }
            }
        }
    }

    public void drawName(Graphics2D g, SequenceImpl seq, int start, int y1, Color box) {
        g.setColor(box);
        g.fillRect(start, (y1 += this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5) - this.viewProps.getCharHeight() + 2, this.getWidth(), this.viewProps.getCharHeight() + 2);
        g.setColor(Color.BLACK);
        String name = seq.getName();
        g.drawString(name, 5, y1);
    }

    public void drawBlackName(Graphics2D g, SequenceImpl seq, int y1) {
        g.setColor(Color.BLACK);
        g.fillRect(0, (y1 += this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5) - this.viewProps.getCharHeight() + 2, this.getWidth(), this.viewProps.getCharHeight() + 2);
        g.setColor(Color.WHITE);
        String name = seq.getName();
        g.drawString(name, 5, y1);
    }

    public void drawSelectedName(Graphics2D g, SequenceImpl seq, int y1) {
        g.setColor(Constants.NAMEPANEL_SELECTED_BGSEQUENCE);
        g.fillRect(0, (y1 += this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5) - this.viewProps.getCharHeight() + 2, this.getWidth(), this.viewProps.getCharHeight() + 2);
        g.setColor(Constants.NAMEPANEL_SELECTED_FGSEQUENCE);
        String name = seq.getName();
        g.drawString(name, 5, y1);
    }

    public void scrollPainting(int xValue, int yValue) {
        this.graphics2d.copyArea(xValue * this.viewProps.getCharWidth(), yValue * this.viewProps.getCharHeight(), this.iWidth, this.iHeight, -xValue * this.viewProps.getCharWidth(), -yValue * this.viewProps.getCharHeight());
        int xStart = this.viewProps.getXStart();
        int xEnd = this.viewProps.getXEnd();
        int yStart = this.viewProps.getYStart();
        int yEnd = this.viewProps.getYEnd();
        int transX = 0;
        int transY = 0;
        if (xValue > 0) {
            transX = (++xEnd - xStart - xValue) * this.viewProps.getCharWidth();
            xStart = xEnd - xValue;
        } else if (xValue < 0) {
            xEnd = xStart - xValue - 1;
        } else if (yValue > 0) {
            yStart = yEnd - yValue;
            if (yStart < this.viewProps.getYStart()) {
                yStart = this.viewProps.getYStart();
            } else {
                transY = this.iHeight - yValue * this.viewProps.getCharHeight();
            }
        } else if (yValue < 0 && (yEnd = yStart - yValue) > this.viewProps.getYEnd()) {
            yEnd = this.viewProps.getYEnd();
        }
        this.graphics2d.translate(transX, transY);
        this.drawComponent(this.graphics2d, xStart, xEnd, yStart, yEnd);
        this.graphics2d.translate(-transX, -transY);
        this.repaint();
    }

    public void sequenceClicked(MouseEvent ev) {
    }

    public void sequencePressed(MouseEvent ev) {
        int pos = this.viewProps.getYStart() + ev.getY() / this.viewProps.getCharHeight();
        if (pos < 0) {
            pos = 0;
        }
        if (pos > this.viewProps.getAlObj().getHeight() - 1) {
            pos = this.viewProps.getAlObj().getHeight() - 1;
        }
        this.startSelection = pos;
    }

    public void sequenceReleased(MouseEvent ev) {
        if (this.startSelection != -1) {
            int end;
            int pos = this.viewProps.getYStart() + ev.getY() / this.viewProps.getCharHeight();
            if (pos < 0) {
                pos = 0;
            }
            if (pos > this.viewProps.getAlObj().getHeight() - 1) {
                pos = this.viewProps.getAlObj().getHeight() - 1;
            }
            int start = this.startSelection < pos ? this.startSelection : pos;
            int n = end = this.startSelection > pos ? this.startSelection : pos;
            if (this.s3detobj == null) {
                for (int i = start; i <= end; ++i) {
                    String seqName = this.viewProps.getAlObj().getSequenceAt(i).getName();
                    SequenceManager.toggleSequence(seqName);
                }
            } else {
                SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
                SequenceImpl[] sequences = seqOrderer.getClusterSequences();
                for (int i = start; i <= end; ++i) {
                    String seqName = sequences[i].getName();
                    SequenceManager.toggleSequence(seqName);
                }
            }
            this.seqPainter.notifyObservers();
            this.startSelection = -1;
        }
    }

    @Override
    public void update(Observable object) {
        if (object instanceof SequencePainter) {
            this.repaint();
        }
    }
}

