/*
 * Decompiled with CFR 0.152.
 */
package view;

import interfaces.Observable;
import interfaces.Observer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.JPanel;
import model.FuncResidueImpl;
import model.Methods;
import model.PredictedPosition;
import model.ResidueImpl;
import model.S3DetObject;
import model.UDMObject;
import model.XDetObject;
import util.Constants;
import util.ResidueSelectionManager;
import util.SelectionManager;
import view.AlignPanel;
import view.AlignViewProps;
import view.SequencePainter;

public class MethodPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private XDetObject xdetObj;
    private S3DetObject s3detObj;
    private UDMObject[] udmObjs;
    private AlignViewProps viewProps;
    private HashMap<Integer, FuncResidueImpl> pos2funcRes;
    private HashMap<Integer, PredictedPosition> pos2predPos;
    private HashMap<Integer, ResidueImpl> pos2res;
    private double xdetThreshold;
    private double entropyThreshold;
    private double s3detThreshold;
    private double[] scoreThreshold;
    private Methods methods;
    private int YINDEX_XDET;
    private int YINDEX_ENTROPY;
    private int YINDEX_S3DET;
    private int[] YINDEX_UDM;
    private String firstSequence;
    private SequencePainter seqPainter;
    private int height;

    public MethodPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(830, Constants.METHODPANEL_HEIGHT));
        this.setPreferredSize(new Dimension(830, Constants.METHODPANEL_HEIGHT));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel panel = new JPanel();
        panel.setBackground(Constants.METHODPANEL_BGCOLOR);
        this.add((Component)panel, "Center");
    }

    public MethodPanel(AlignViewProps viewProps, AlignPanel alignPanel, SequencePainter seqPainter) {
        this.xdetObj = alignPanel.getAlignFrame().getMethods().getxDetObject();
        this.s3detObj = alignPanel.getAlignFrame().getMethods().getS3DetObject();
        this.udmObjs = alignPanel.getAlignFrame().getMethods().getUdmObjects();
        this.viewProps = viewProps;
        this.methods = alignPanel.getAlignFrame().getMethods();
        this.xdetThreshold = this.methods.getxDetCutoff();
        this.methods.setCurrentXDetCutoff(this.methods.getxDetCutoff());
        this.entropyThreshold = this.methods.getEntropyCutoff();
        this.methods.setCurrentEntropyCutoff(this.methods.getEntropyCutoff());
        this.s3detThreshold = this.methods.getS3DetCutoff();
        this.methods.setCurrentS3DetCutoff(this.methods.getS3DetCutoff());
        this.seqPainter = seqPainter;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectionManager.isEnabled()) {
                    MethodPanel.this.notifyOnMouseClick(e);
                }
            }
        });
        if (this.udmObjs != null) {
            this.scoreThreshold = this.methods.getScoreCutoffs();
            for (int i = 0; i < this.methods.getUdmNumber(); ++i) {
                this.methods.getUdmObjects()[i].setCurrentScoreCutoff(this.methods.getUdmObjects()[i].getScoreCutoff());
            }
        }
        if (this.xdetObj != null) {
            this.pos2funcRes = this.xdetObj.getPos2ResMap();
        }
        if (this.s3detObj != null) {
            this.pos2predPos = this.s3detObj.getPos2PredPosition();
        }
        this.firstSequence = viewProps.getAlObj().getSequenceAt(0).getSequenceAsString();
        this.setupYIndices();
        seqPainter.register(this);
        this.setLayout(new BorderLayout());
        this.calculateHeight();
        this.setMinimumSize(new Dimension(830, Constants.METHODPANEL_HEIGHT));
        this.setPreferredSize(new Dimension(830, Constants.METHODPANEL_HEIGHT));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    private void setupYIndices() {
        int yIndex = 2;
        if (this.xdetObj != null) {
            this.YINDEX_XDET = yIndex;
            this.YINDEX_ENTROPY = yIndex += Constants.METHOD_OFFSET;
            yIndex += Constants.METHOD_OFFSET;
        }
        if (this.s3detObj != null) {
            this.YINDEX_S3DET = yIndex;
            yIndex += Constants.METHOD_OFFSET;
        }
        if (this.udmObjs != null) {
            this.YINDEX_UDM = new int[this.udmObjs.length];
            for (int i = 0; i < this.udmObjs.length; ++i) {
                this.YINDEX_UDM[i] = yIndex;
                yIndex += Constants.METHOD_OFFSET;
            }
        }
        this.height = yIndex;
    }

    private void calculateHeight() {
        int height = 20;
        Constants.METHODPANEL_HEIGHT = height += Constants.METHOD_OFFSET * this.methods.getMethodNumber();
    }

    public void updatePanelWithXdetThreshold(double xdetThreshold) {
        this.xdetThreshold = xdetThreshold;
        this.methods.setCurrentXDetCutoff(xdetThreshold);
        this.repaint();
    }

    public void updatePanelWithEntropyThreshold(double entropyThreshold) {
        this.entropyThreshold = entropyThreshold;
        this.methods.setCurrentEntropyCutoff(entropyThreshold);
        this.repaint();
    }

    public void updatePanelWithS3detThreshold(double s3detThreshold) {
        this.s3detThreshold = s3detThreshold;
        this.methods.setCurrentS3DetCutoff(s3detThreshold);
        this.repaint();
    }

    public void updatePanelWithScoreThreshold(double scoreThreshold, int index) {
        this.scoreThreshold[index] = scoreThreshold;
        this.methods.getUdmObjects()[index].setCurrentScoreCutoff(scoreThreshold);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawSquares(g, this.viewProps.getXStart(), this.viewProps.getXEnd(), this.getWidth(), this.getHeight());
        if (SelectionManager.isEnabled()) {
            for (int i = 0; i < SelectionManager.getCurrentSelection().size(); ++i) {
                this.highLightPosition(g, SelectionManager.getCurrentSelection().get(i) - 1);
            }
        }
    }

    public void drawSquares(Graphics g, int startx, int endx, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.viewProps.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Constants.METHODPANEL_BGCOLOR);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.black);
        FontMetrics fm = g2d.getFontMetrics(this.viewProps.getFont());
        g2d.setColor(Constants.INDEXPANEL_BGCOLOR);
        for (int i = 0; i < SelectionManager.getFullSelection().size(); ++i) {
            int pos = SelectionManager.getFullSelection().get(i) - 1;
            int xPos = (pos - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
            double startX = new Integer(xPos).doubleValue();
            double endX = new Integer(xPos + this.viewProps.getCharWidth()).doubleValue();
            double startY = new Integer(0).doubleValue();
            double endY = height;
            g2d.fill(new Rectangle2D.Double(new Double(startX).intValue(), new Double(startY).intValue(), new Double(endX - startX).intValue(), new Double(endY - startY).intValue()));
        }
        g2d.setColor(Color.BLACK);
        int x_index = startx / 10 * 10;
        int y_index = this.viewProps.getCharHeight() - fm.getDescent();
        for (int i = x_index; i < endx; ++i) {
            int charOffset;
            int x;
            char letter;
            if (this.pos2funcRes != null && this.pos2funcRes.containsKey(i)) {
                if (this.pos2funcRes.get(i).getCorrelation().doubleValue() >= this.xdetThreshold) {
                    letter = this.firstSequence.charAt(i - 1);
                    x = this.viewProps.getCharWidth() * (i - startx) - 10;
                    charOffset = (this.viewProps.getCharWidth() - fm.charWidth(letter)) / 2;
                    g2d.drawString(String.valueOf(letter), charOffset + x, y_index);
                    if (SelectionManager.contains(i) || ResidueSelectionManager.contains(i)) {
                        g2d.setColor(Color.RED);
                    } else {
                        g2d.setColor(Color.GREEN);
                    }
                    g2d.fillOval(x + 1, y_index + this.YINDEX_XDET, 9, 11);
                    g2d.setColor(Color.BLACK);
                    g2d.drawOval(x, y_index + this.YINDEX_XDET - 1, 10, 12);
                }
                if (this.pos2funcRes.get(i).getEntropy().doubleValue() <= this.entropyThreshold && this.pos2funcRes.get(i).getEntropy().doubleValue() >= 0.0) {
                    letter = this.firstSequence.charAt(i - 1);
                    x = this.viewProps.getCharWidth() * (i - startx) - 10;
                    charOffset = (this.viewProps.getCharWidth() - fm.charWidth(letter)) / 2;
                    g2d.drawString(String.valueOf(letter), charOffset + x, y_index);
                    if (SelectionManager.contains(i) || ResidueSelectionManager.contains(i)) {
                        g2d.setColor(Color.RED);
                    } else {
                        g2d.setColor(Color.GREEN);
                    }
                    g2d.fillOval(x + 1, y_index + this.YINDEX_ENTROPY, 9, 11);
                    g2d.setColor(Color.BLACK);
                    g2d.drawOval(x, y_index + this.YINDEX_ENTROPY - 1, 10, 12);
                }
            }
            if (this.pos2predPos != null && this.pos2predPos.containsKey(i) && this.pos2predPos.get(i).getAverageRank().doubleValue() <= this.s3detThreshold) {
                letter = this.firstSequence.charAt(i - 1);
                x = this.viewProps.getCharWidth() * (i - startx) - 10;
                charOffset = (this.viewProps.getCharWidth() - fm.charWidth(letter)) / 2;
                g2d.drawString(String.valueOf(letter), charOffset + x, y_index);
                if (SelectionManager.contains(i) || ResidueSelectionManager.contains(i)) {
                    g2d.setColor(Color.RED);
                } else {
                    g2d.setColor(Color.GREEN);
                }
                g2d.fillOval(x + 1, y_index + this.YINDEX_S3DET, 9, 11);
                g2d.setColor(Color.BLACK);
                g2d.drawOval(x, y_index + this.YINDEX_S3DET - 1, 10, 12);
            }
            if (this.udmObjs == null) continue;
            for (int k = 0; k < this.udmObjs.length; ++k) {
                this.pos2res = this.udmObjs[k].getPos2ResMap();
                if (!this.pos2res.containsKey(i) || !(this.udmObjs[k].isIncreasingScore() && this.pos2res.get(i).getScore().doubleValue() >= this.scoreThreshold[k]) && (this.udmObjs[k].isIncreasingScore() || !(this.pos2res.get(i).getScore().doubleValue() <= this.scoreThreshold[k]))) continue;
                letter = this.firstSequence.charAt(i - 1);
                x = this.viewProps.getCharWidth() * (i - startx) - 10;
                charOffset = (this.viewProps.getCharWidth() - fm.charWidth(letter)) / 2;
                g2d.drawString(String.valueOf(letter), charOffset + x, y_index);
                if (SelectionManager.contains(i) || ResidueSelectionManager.contains(i)) {
                    g2d.setColor(Color.RED);
                } else {
                    g2d.setColor(Color.GREEN);
                }
                g2d.fillOval(x + 1, y_index + this.YINDEX_UDM[k], 9, 11);
                g2d.setColor(Color.BLACK);
                g2d.drawOval(x, y_index + this.YINDEX_UDM[k] - 1, 10, 12);
            }
        }
    }

    private void highLightPosition(Graphics g, int pos) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f));
        int xPos = (pos - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
        double startX = new Integer(xPos).doubleValue();
        double endX = new Integer(xPos + this.viewProps.getCharWidth()).doubleValue();
        double startY = new Integer(0).doubleValue();
        double endY = new Integer(this.height + this.viewProps.getCharHeight()).doubleValue() + 2.0;
        Line2D.Double topLine = new Line2D.Double(startX, startY, endX, 0.0);
        Line2D.Double leftLine = new Line2D.Double(startX, startY, startX, endY);
        Line2D.Double rightLine = new Line2D.Double(endX, startY, endX, endY);
        g2d.draw(topLine);
        g2d.draw(leftLine);
        g2d.draw(rightLine);
    }

    @Override
    public void update(Observable object) {
        if (object instanceof SequencePainter) {
            this.seqPainter = (SequencePainter)object;
            this.repaint();
        }
    }

    public void notifyOnMouseClick(MouseEvent ev) {
        SelectionManager.toggleSelection(this.viewProps.getAlObj().getSequenceAt(0).findPosition(this.seqPainter.getAAPosition(ev)), false);
        this.seqPainter.notifyOnMouseClick(ev);
        this.seqPainter.repaint();
    }
}

