/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import model.AlignObject;
import model.Methods;
import model.XDetObject;
import org.jdesktop.swingx.JXButton;
import parser.XDetParser;
import util.ScreenConfig;
import view.AlignFrame;

public class LoadXDetFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String filename = null;
    private JTextField xDetTtf;
    private JXButton browseXDetFileBtn;
    private JXButton loadBtn;
    private JXButton closeBtn;
    private AlignFrame parent;
    private LoadXDetFrame frame;
    private Methods methods;
    private AlignObject alignObject;
    private JPanel correlationPnl;
    private JPanel entropyPnl;
    private JLabel entropyCutoffLbl;
    private JLabel corrCutoffLbl;
    private JTextField corrCutoffTtf;
    private JTextField entropyCutoffTtf;

    public LoadXDetFrame(AlignFrame parent) {
        super(parent, "Load XDet", true);
        this.parent = parent;
        this.methods = parent.getMethods();
        this.alignObject = parent.getAlObj();
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoadXDetFrame.this.cancelTriggered();
            }
        });
        this.frame = this;
        this.setDefaultCloseOperation(2);
        this.constructScreen();
    }

    private void constructScreen() {
        JPanel panelNorth = null;
        JPanel panelSouth = null;
        this.frame.setSize(800, 500);
        Container tContentPane = this.frame.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        panelNorth = new JPanel(new FormLayout("10dlu, p, 5dlu, p, 10dlu", "p, 5dlu"));
        panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel xDetPanel = new JPanel(new FormLayout("3dlu, p, 3dlu, p", "p, 3dlu, p, 3dlu p"));
        xDetPanel.setBorder(BorderFactory.createTitledBorder("XDet File"));
        this.correlationPnl = new JPanel(new FormLayout("p, 5dlu, p", "p"));
        this.entropyPnl = new JPanel(new FormLayout("p, 5dlu, p", "p"));
        this.corrCutoffLbl = new JLabel("Correlation Cutoff:");
        this.entropyCutoffLbl = new JLabel("Entropy Cutoff:");
        this.corrCutoffTtf = new JTextField(3);
        this.entropyCutoffTtf = new JTextField(3);
        this.corrCutoffTtf.setText(new Double(0.6).toString());
        this.entropyCutoffTtf.setText(new Double(2.5).toString());
        this.correlationPnl.add((Component)this.corrCutoffLbl, cc.xy(1, 1));
        this.correlationPnl.add((Component)this.corrCutoffTtf, cc.xy(3, 1));
        this.entropyPnl.add((Component)this.entropyCutoffLbl, cc.xy(1, 1));
        this.entropyPnl.add((Component)this.entropyCutoffTtf, cc.xy(3, 1));
        this.xDetTtf = new JTextField(20);
        this.xDetTtf.setEditable(false);
        this.xDetTtf.setEnabled(false);
        xDetPanel.add((Component)this.correlationPnl, cc.xy(2, 1));
        xDetPanel.add((Component)this.entropyPnl, cc.xy(2, 3));
        xDetPanel.add((Component)this.xDetTtf, cc.xy(2, 5));
        this.browseXDetFileBtn = new JXButton(this.openFileAction("xdet"));
        xDetPanel.add((Component)this.browseXDetFileBtn, cc.xy(4, 5));
        JPanel loadPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu"));
        loadPanel.add((Component)xDetPanel, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        this.loadBtn = new JXButton("Load");
        this.loadBtn.setEnabled(false);
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AlignFrame alignFrame = LoadXDetFrame.this.loadAlignFrame();
                    if (LoadXDetFrame.this.parent != null) {
                        LoadXDetFrame.this.parent.closeOtherWindows();
                        LoadXDetFrame.this.parent.dispose();
                    }
                    LoadXDetFrame.this.frame.dispose();
                    alignFrame.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.closeBtn = new JXButton("Close");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadXDetFrame.this.frame.dispose();
            }
        });
        actionPanel.add((Component)this.closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)this.loadBtn, cc.xy(4, 2));
        panelNorth.add((Component)loadPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelSouth, "South");
        this.frame.setResizable(false);
        this.frame.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.frame.setVisible(true);
    }

    private AlignFrame loadAlignFrame() throws Exception {
        AlignFrame alignFrame = null;
        XDetParser xdetparser = new XDetParser();
        XDetObject xdetObject = null;
        try {
            if (this.xDetTtf.getText().length() > 0) {
                xdetObject = xdetparser.read(this.xDetTtf.getText(), this.parent.getAlObj());
                this.methods.setxDetUsed(true);
                this.methods.setxDetObject(xdetObject);
                this.methods.setxDetCutoff(new Double(this.corrCutoffTtf.getText()));
                this.methods.setEntropyUsed(true);
                this.methods.setEntropyCutoff(new Double(this.entropyCutoffTtf.getText()));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "The XDet file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
            throw new Exception();
        }
        alignFrame = new AlignFrame(this.alignObject, this.methods, 1100, 650, false);
        alignFrame.pack();
        return alignFrame;
    }

    private Action openFileAction(String type) {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        JDialog loadFrame = new JDialog();
        loadFrame.setModal(true);
        OpenFileAction openAction = new OpenFileAction(loadFrame, fc, type);
        return openAction;
    }

    private void cancelTriggered() {
        this.frame.dispose();
    }

    private static class InnerXDetFileFilter
    extends FileFilter {
        private InnerXDetFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xdet") || f.getName().endsWith(".Xdet");
        }

        @Override
        public String getDescription() {
            return "*.xdet";
        }
    }

    public class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JDialog frame;
        private JFileChooser chooser;
        private File file;
        private String name;
        private String type;
        private FileFilter filter;

        OpenFileAction(JDialog frame, JFileChooser chooser, String type) {
            super("Browse...");
            this.file = null;
            this.chooser = chooser;
            this.type = type;
            this.frame = frame;
            this.getFilter();
        }

        private void getFilter() {
            if (this.type == "xdet") {
                this.filter = new InnerXDetFileFilter();
            }
        }

        public void setSourceName(String aName) {
            this.name = aName;
        }

        public String getSourceName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.setFileFilter(this.filter);
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.setSourceName(this.file.getAbsolutePath());
                if (this.type == "xdet") {
                    LoadXDetFrame.this.xDetTtf.setText(this.getSourceName());
                    LoadXDetFrame.this.xDetTtf.setEnabled(true);
                    LoadXDetFrame.this.loadBtn.setEnabled(true);
                }
            }
        }
    }
}

