/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import model.SequenceImpl;
import org.jdesktop.swingx.JXButton;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import util.Alignment;
import util.NCBIBlastPDB;
import util.PDBAtomReader;
import util.PdbFileOpener;
import util.ScreenConfig;
import util.SequenceManager;
import view.AlignFrame;
import view.AlignPanel;
import view.AlignViewProps;
import view.NamePainter;
import view.SequencePainter;
import view.Structure3DFrame;

public class LoadStructureFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField pdbFileTtf;
    private LoadStructureFrame frame;
    private String filename;
    private JButton browspdbFileBtn;
    private JButton loadBtn;
    private JButton cancelBtn;
    private JLabel chooseFileLbl;
    private JTextField pdbCodeTtf;
    private JButton loadpdbonlineBtn;
    private JLabel pdbCodeLbl;
    private PdbFileOpener pdbfileOpener;
    private JTextArea downloadInfoArea;
    private String pdbCode;
    private JLabel statusLbl;
    private JPanel centerPnl;
    private JPanel statusPnl;
    private JLabel chainLbl;
    private JTextField chainTtf;
    private AlignViewProps viewprops;
    private JComboBox<String> comboBox;
    private JButton blastPdbOnlineBtn;
    private JPanel pdbFilePnl;
    private SequencePainter seqPainter;
    private NamePainter namePainter;
    private AlignPanel alignPanel;
    private AlignFrame parent;

    public LoadStructureFrame(AlignViewProps viewprops, SequencePainter seqPainter, NamePainter namePainter, AlignPanel alignPanel, AlignFrame parent) {
        super(parent, "Load XDet", true);
        this.viewprops = viewprops;
        this.seqPainter = seqPainter;
        this.namePainter = namePainter;
        this.alignPanel = alignPanel;
        this.parent = parent;
        this.setTitle("JMol File Selection");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoadStructureFrame.this.cancelTriggered();
            }
        });
        this.constructScreen();
        this.setDefaultCloseOperation(2);
    }

    private void constructScreen() {
        JPanel northPnl = null;
        JPanel southPnl = null;
        this.frame = this;
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(800, 500);
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        CellConstraints cc = new CellConstraints();
        northPnl = new JPanel(new FormLayout("10dlu, p:grow, 10dlu", "5dlu, p, 5dlu"));
        this.centerPnl = new JPanel(new FormLayout("10dlu, p:grow, 10dlu", "5dlu, p, 5dlu"));
        this.statusPnl = new JPanel(new FormLayout("10dlu, p, 3dlu, p:grow, 10dlu", "5dlu, p, 5dlu"));
        southPnl = new JPanel(new FormLayout("10dlu, right:p:grow, 10dlu", "p, 5dlu"));
        JPanel settingsPanel = new JPanel(new FormLayout("5dlu, p, 5dlu, p, 5dlu", "3dlu, p, 3dlu"));
        settingsPanel.setBorder(BorderFactory.createTitledBorder("Alignment sequence"));
        this.blastPdbOnlineBtn = new JButton("Look for suitable structure for");
        this.blastPdbOnlineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sequenceToBlast = SequenceManager.getSequence(LoadStructureFrame.this.comboBox.getSelectedItem().toString(), LoadStructureFrame.this.parent.getAlObj()).getSequenceAsString();
                sequenceToBlast = sequenceToBlast.replace("-", "");
                LoadStructureFrame.this.downloadInfoArea.setText("Blasting....");
                LoadStructureFrame.this.statusPnl.paintImmediately(LoadStructureFrame.this.statusPnl.getVisibleRect());
                System.out.println(sequenceToBlast);
                String blastResult = NCBIBlastPDB.blastThePDB(sequenceToBlast, 25.0);
                if (blastResult != null) {
                    if (!blastResult.isEmpty() && NCBIBlastPDB.evaluateBestHit(blastResult)) {
                        String[] splitResults = blastResult.split("\\|");
                        LoadStructureFrame.this.pdbCodeTtf.setText(splitResults[0]);
                        LoadStructureFrame.this.chainTtf.setText(splitResults[1]);
                        LoadStructureFrame.this.downloadInfoArea.setText("Structure found: " + splitResults[0] + " - Identity: " + splitResults[3] + "% - e-Value: " + splitResults[2]);
                    } else {
                        LoadStructureFrame.this.downloadInfoArea.setText("No matching structure found");
                    }
                } else {
                    LoadStructureFrame.this.downloadInfoArea.setText("Connection failed.");
                }
            }
        });
        settingsPanel.add((Component)this.blastPdbOnlineBtn, cc.xy(2, 2));
        int count = this.viewprops.getAlObj().getProteinNumber();
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.viewprops.getAlObj().getSequenceAt(i).getName();
        }
        this.comboBox = new JComboBox<String>(names);
        if (SequenceManager.getLastSelected() != null) {
            this.comboBox.setSelectedItem(SequenceManager.getLastSelected());
        } else {
            this.comboBox.setSelectedIndex(0);
        }
        settingsPanel.add(this.comboBox, cc.xy(4, 2));
        this.pdbFilePnl = new JPanel(new FormLayout("3dlu, p, 5dlu, p, 5dlu, p, 5dlu", "p, 5dlu, p, 5dlu, p, 3dlu, p"));
        this.pdbFilePnl.setBorder(BorderFactory.createTitledBorder("PDB file"));
        this.chooseFileLbl = new JLabel("Enter PDB file:");
        this.pdbFilePnl.add((Component)this.chooseFileLbl, cc.xy(2, 1));
        this.pdbFileTtf = new JTextField(10);
        this.pdbFileTtf.setEditable(false);
        this.pdbFileTtf.setEnabled(false);
        this.pdbFilePnl.add((Component)this.pdbFileTtf, cc.xy(4, 1));
        this.browspdbFileBtn = new JButton(this.openFileAction());
        this.pdbFilePnl.add((Component)this.browspdbFileBtn, cc.xy(6, 1));
        this.pdbCodeLbl = new JLabel("or Enter 4-letter PDB-Code:");
        this.pdbFilePnl.add((Component)this.pdbCodeLbl, cc.xy(2, 3));
        this.pdbCodeTtf = new JTextField(4);
        this.pdbCodeTtf.setEditable(true);
        this.pdbCodeTtf.setEnabled(true);
        this.pdbFilePnl.add((Component)this.pdbCodeTtf, cc.xy(4, 3));
        this.loadpdbonlineBtn = new JButton("Load from Server");
        this.loadpdbonlineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadStructureFrame.this.pdbCode = LoadStructureFrame.this.pdbCodeTtf.getText().toLowerCase();
                LoadStructureFrame.this.openPDBfromServer();
            }
        });
        this.pdbFilePnl.add((Component)this.loadpdbonlineBtn, cc.xy(6, 3));
        this.chainLbl = new JLabel("Chain:");
        this.pdbFilePnl.add((Component)this.chainLbl, cc.xy(2, 5));
        this.chainTtf = new JTextField(4);
        this.chainTtf.setEditable(true);
        this.chainTtf.setEnabled(true);
        this.chainTtf.setText("A");
        this.chainTtf.setHorizontalAlignment(0);
        this.pdbFilePnl.add((Component)this.chainTtf, cc.xy(4, 5));
        this.statusLbl = new JLabel("Status:");
        this.statusPnl.add((Component)this.statusLbl, cc.xy(2, 2));
        this.downloadInfoArea = new JTextArea();
        this.downloadInfoArea.setOpaque(false);
        this.statusPnl.add((Component)this.downloadInfoArea, cc.xy(4, 2));
        JPanel loadPanel = new JPanel(new FormLayout("p:grow", "3dlu, p ,3dlu"));
        loadPanel.add((Component)this.pdbFilePnl, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("150dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        this.loadBtn = new JXButton("Load");
        this.loadBtn.setEnabled(false);
        this.loadBtn.addActionListener(new ActionListener(){
            private Alignment alignment;

            @Override
            public void actionPerformed(ActionEvent e) {
                block10: {
                    if (LoadStructureFrame.this.pdbFileTtf.getText().length() > 0) {
                        try {
                            SequenceImpl alignSeq = LoadStructureFrame.this.viewprops.getAlObj().getSequenceAt(LoadStructureFrame.this.comboBox.getSelectedIndex());
                            String pdbSequence = new PDBAtomReader(LoadStructureFrame.this.pdbFileTtf.getText(), LoadStructureFrame.this.chainTtf.getText()).getPdbSequence();
                            if (pdbSequence.length() == 0) {
                                JOptionPane.showMessageDialog(new JFrame(), "Error! Retrieved sequence is empty, check selected chain.");
                                break block10;
                            }
                            this.alignment = new Alignment(alignSeq.getSequenceAsString(), pdbSequence);
                            LoadStructureFrame.this.frame.setVisible(false);
                            this.alignment.showAlignment();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    LoadStructureFrame.this.seqPainter.closeRegisteredWindows("Structures");
                                    SequenceManager.setMarkedSequenceName(LoadStructureFrame.this.comboBox.getSelectedItem().toString());
                                    LoadStructureFrame.this.namePainter.repaint();
                                    new Structure3DFrame(LoadStructureFrame.this.pdbFileTtf.getText(), LoadStructureFrame.this.seqPainter, LoadStructureFrame.this.chainTtf.getText(), alignment, LoadStructureFrame.this.namePainter, LoadStructureFrame.this.alignPanel);
                                }
                            });
                            LoadStructureFrame.this.cancelTriggered();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "The PDB file couldn't be loaded! \nPlease specify a proper format/location of the file.", "File load error", 0);
                        }
                    } else if (LoadStructureFrame.this.pdbfileOpener.getPdbFile() != null) {
                        try {
                            SequenceImpl alignSeq = LoadStructureFrame.this.viewprops.getAlObj().getSequenceAt(LoadStructureFrame.this.comboBox.getSelectedIndex());
                            String pdbSequence = new PDBAtomReader(LoadStructureFrame.this.pdbfileOpener.getPdbFile(), LoadStructureFrame.this.chainTtf.getText()).getPdbSequence();
                            if (pdbSequence.length() == 0) {
                                JOptionPane.showMessageDialog(new JFrame(), "Error! Retrieved sequence is empty, check selected chain.");
                            } else {
                                Alignment alignment = new Alignment(alignSeq.getSequenceAsString(), pdbSequence);
                                LoadStructureFrame.this.seqPainter.closeRegisteredWindows("Structures");
                                SequenceManager.setMarkedSequenceName(LoadStructureFrame.this.comboBox.getSelectedItem().toString());
                                LoadStructureFrame.this.namePainter.repaint();
                                LoadStructureFrame.this.frame.setVisible(false);
                                alignment.showAlignment();
                                new Structure3DFrame(LoadStructureFrame.this.pdbfileOpener.getPdbFile(), LoadStructureFrame.this.seqPainter, LoadStructureFrame.this.chainTtf.getText(), alignment, LoadStructureFrame.this.namePainter, LoadStructureFrame.this.alignPanel);
                                LoadStructureFrame.this.cancelTriggered();
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "The PDB file couldn't be loaded! \nPlease specify a proper location of the file.", "File load error", 0);
                        }
                    }
                }
            }
        });
        this.cancelBtn = new JXButton("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadStructureFrame.this.frame.dispose();
            }
        });
        actionPanel.add((Component)this.cancelBtn, cc.xy(2, 2));
        actionPanel.add((Component)this.loadBtn, cc.xy(4, 2));
        this.centerPnl.add((Component)loadPanel, cc.xy(2, 2));
        northPnl.add((Component)settingsPanel, cc.xy(2, 2));
        southPnl.add((Component)actionPanel, cc.xy(2, 1));
        contentPane.add(northPnl);
        contentPane.add(this.centerPnl);
        contentPane.add(this.statusPnl);
        contentPane.add(southPnl);
        this.frame.setResizable(false);
        this.frame.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.frame.setVisible(true);
    }

    private void cancelTriggered() {
        this.frame.dispose();
    }

    private void openPDBfromServer() {
        this.downloadInfoArea.setText("Downloading...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadStructureFrame.this.pdbfileOpener = new PdbFileOpener(LoadStructureFrame.this.pdbCode, LoadStructureFrame.this.downloadInfoArea);
                try {
                    LoadStructureFrame.this.pdbfileOpener.getThread().join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                LoadStructureFrame.this.loadBtn.setEnabled(true);
            }
        });
    }

    private Action openFileAction() {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        JDialog loadFrame = new JDialog();
        loadFrame.setModal(true);
        OpenFileAction openAction = new OpenFileAction(loadFrame, fc);
        return openAction;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private static class InnerPdbFileFilter
    extends FileFilter {
        private InnerPdbFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".pdb") || f.getName().toLowerCase().endsWith(".ent");
        }

        @Override
        public String getDescription() {
            return "*.pdb, *.ent";
        }
    }

    public class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JDialog frame;
        private JFileChooser chooser;
        private InnerPdbFileFilter filter;
        private File file;
        private String name;

        OpenFileAction(JDialog frame, JFileChooser chooser) {
            super("Browse...");
            this.filter = new InnerPdbFileFilter();
            this.file = null;
            this.name = null;
            this.chooser = chooser;
            this.frame = frame;
        }

        public void setSourceName(String aName) {
            this.name = aName;
        }

        public String getSourceName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.setFileFilter(this.filter);
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.setSourceName(this.file.getAbsolutePath());
                LoadStructureFrame.this.pdbFileTtf.setText(this.getSourceName());
                LoadStructureFrame.this.pdbFileTtf.setEnabled(true);
                LoadStructureFrame.this.loadBtn.setEnabled(true);
            }
        }
    }
}

