/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import model.AlignObject;
import model.Methods;
import model.S3DetObject;
import org.jdesktop.swingx.JXButton;
import parser.S3DetParser;
import util.ScreenConfig;
import view.AlignFrame;

public class LoadS3DetFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String filename = null;
    private JXButton loadBtn;
    private JXButton closeBtn;
    private AlignFrame parent;
    private LoadS3DetFrame frame;
    private Methods methods;
    private AlignObject alignObject;
    private JTextField s3detTtf;
    private JXButton browseS3DetFileBtn;
    private JPanel avRankPnl;
    private JLabel avRankCutoffLbl;
    private JTextField avRankCutoffTtf;

    public LoadS3DetFrame(AlignFrame parent) {
        super(parent, "Load S3Det", true);
        this.parent = parent;
        this.methods = parent.getMethods();
        this.alignObject = parent.getAlObj();
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoadS3DetFrame.this.cancelTriggered();
            }
        });
        this.frame = this;
        this.setDefaultCloseOperation(2);
        this.constructScreen();
    }

    private void constructScreen() {
        JPanel panelNorth = null;
        JPanel panelSouth = null;
        this.frame.setSize(800, 500);
        Container tContentPane = this.frame.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        panelNorth = new JPanel(new FormLayout("10dlu, p, 5dlu, p, 10dlu", "p, 5dlu"));
        panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel s3DetPanel = new JPanel(new FormLayout("3dlu, p, 3dlu, p", "p, 3dlu, p"));
        s3DetPanel.setBorder(BorderFactory.createTitledBorder("S3Det File"));
        this.s3detTtf = new JTextField(20);
        this.s3detTtf.setEditable(false);
        this.s3detTtf.setEnabled(false);
        this.avRankPnl = new JPanel(new FormLayout("p, 5dlu, p", "p"));
        this.avRankCutoffLbl = new JLabel("Average Rank Cutoff:");
        this.avRankCutoffTtf = new JTextField(3);
        this.avRankCutoffTtf.setText(new Double(10.0).toString());
        this.avRankPnl.add((Component)this.avRankCutoffLbl, cc.xy(1, 1));
        this.avRankPnl.add((Component)this.avRankCutoffTtf, cc.xy(3, 1));
        s3DetPanel.add((Component)this.avRankPnl, cc.xy(2, 1));
        s3DetPanel.add((Component)this.s3detTtf, cc.xy(2, 3));
        this.browseS3DetFileBtn = new JXButton(this.openFileAction("s3det"));
        s3DetPanel.add((Component)this.browseS3DetFileBtn, cc.xy(4, 3));
        JPanel loadPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu"));
        loadPanel.add((Component)s3DetPanel, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        this.loadBtn = new JXButton("Load");
        this.loadBtn.setEnabled(false);
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AlignFrame alignFrame = LoadS3DetFrame.this.loadAlignFrame();
                    if (LoadS3DetFrame.this.parent != null) {
                        LoadS3DetFrame.this.parent.closeOtherWindows();
                        LoadS3DetFrame.this.parent.dispose();
                    }
                    LoadS3DetFrame.this.frame.dispose();
                    alignFrame.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.closeBtn = new JXButton("Close");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadS3DetFrame.this.frame.dispose();
            }
        });
        actionPanel.add((Component)this.closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)this.loadBtn, cc.xy(4, 2));
        panelNorth.add((Component)loadPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelSouth, "South");
        this.frame.setResizable(false);
        this.frame.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.frame.setVisible(true);
    }

    private AlignFrame loadAlignFrame() throws Exception {
        AlignFrame alignFrame = null;
        S3DetParser s3detparser = new S3DetParser();
        S3DetObject s3DetObject = null;
        try {
            if (this.s3detTtf.getText().length() > 0) {
                s3DetObject = s3detparser.read(this.s3detTtf.getText(), this.alignObject);
                this.methods.setS3DetUsed(true);
                this.methods.setS3DetObject(s3DetObject);
                this.methods.setS3DetCutoff(new Double(this.avRankCutoffTtf.getText()));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "The S3Det file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
            throw new Exception();
        }
        alignFrame = new AlignFrame(this.alignObject, this.methods, 1100, 650, false);
        alignFrame.pack();
        return alignFrame;
    }

    private Action openFileAction(String type) {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        JDialog loadFrame = new JDialog();
        loadFrame.setModal(true);
        OpenFileAction openAction = new OpenFileAction(loadFrame, fc, type);
        return openAction;
    }

    private void cancelTriggered() {
        this.frame.dispose();
    }

    private static class InnerS3DetFileFilter
    extends FileFilter {
        private InnerS3DetFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".s3Det") || f.getName().endsWith(".S3det");
        }

        @Override
        public String getDescription() {
            return "*.S3det";
        }
    }

    public class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JDialog frame;
        private JFileChooser chooser;
        private File file;
        private String name;
        private String type;
        private FileFilter filter;

        OpenFileAction(JDialog frame, JFileChooser chooser, String type) {
            super("Browse...");
            this.file = null;
            this.chooser = chooser;
            this.type = type;
            this.frame = frame;
            this.getFilter();
        }

        private void getFilter() {
            if (this.type == "s3det") {
                this.filter = new InnerS3DetFileFilter();
            }
        }

        public void setSourceName(String aName) {
            this.name = aName;
        }

        public String getSourceName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.setFileFilter(this.filter);
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.setSourceName(this.file.getAbsolutePath());
                if (this.type == "s3det") {
                    LoadS3DetFrame.this.s3detTtf.setText(this.getSourceName());
                    LoadS3DetFrame.this.s3detTtf.setEnabled(true);
                    LoadS3DetFrame.this.loadBtn.setEnabled(true);
                }
            }
        }
    }
}

