/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import model.AlignObject;
import model.Methods;
import model.UDMObject;
import org.jdesktop.swingx.JXButton;
import parser.UDMParser;
import util.ScreenConfig;
import view.AlignFrame;

public class LoadMethodFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String filename = null;
    private JTextField otherTtf;
    private JXButton browseOtherFileBtn;
    private JXButton loadBtn;
    private JXButton closeBtn;
    private AlignFrame parent;
    private LoadMethodFrame loadMethodFrame = this;
    private Methods methods;
    private AlignObject alignObject;
    private JPanel scorePnl;
    private JLabel scoreCutoffLbl;
    private JTextField scoreCutoffTtf;
    private JCheckBox increasingScoreCB;

    public LoadMethodFrame(AlignFrame parent) {
        super(parent, "Add Method", true);
        this.methods = parent.getMethods();
        this.alignObject = parent.getAlObj();
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoadMethodFrame.this.loadMethodFrame.dispose();
            }
        });
        this.parent = parent;
        this.setDefaultCloseOperation(2);
        this.constructScreen();
    }

    private void constructScreen() {
        JPanel panelNorth = null;
        JPanel panelSouth = null;
        this.loadMethodFrame.setSize(800, 500);
        Container tContentPane = this.loadMethodFrame.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        panelNorth = new JPanel(new FormLayout("10dlu, p, 5dlu, p, 10dlu", "p, 5dlu"));
        panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel descPanel = new JPanel(new FormLayout("5dlu, p, 5dlu", "p, 3dlu, p, 1dlu, p, 5dlu"));
        descPanel.setBorder(BorderFactory.createTitledBorder("Method Format"));
        JLabel descLabel = new JLabel("The method to add has to fulfill the following conditions:");
        JLabel desc2Label = new JLabel("[Position] <SPACE> [Amino Acid Letter] <Space> [Score]");
        JLabel desc3Label = new JLabel("For example:      88    P    2.345  (one line of method file)");
        desc2Label.setForeground(Color.RED);
        desc3Label.setForeground(Color.RED);
        descPanel.add((Component)descLabel, cc.xy(2, 1));
        descPanel.add((Component)desc2Label, cc.xy(2, 3));
        descPanel.add((Component)desc3Label, cc.xy(2, 5));
        JPanel otherPanel = new JPanel(new FormLayout("3dlu, p, 3dlu, p", "p, 3dlu, p"));
        otherPanel.setBorder(BorderFactory.createTitledBorder("User Defined Method File"));
        this.scorePnl = new JPanel(new FormLayout("p, 5dlu, p, 20dlu, p", "p"));
        this.scoreCutoffLbl = new JLabel("Score Cutoff:");
        this.scoreCutoffTtf = new JTextField(3);
        this.scoreCutoffTtf.setText(new Double(2.0).toString());
        this.scorePnl.add((Component)this.scoreCutoffLbl, cc.xy(1, 1));
        this.scorePnl.add((Component)this.scoreCutoffTtf, cc.xy(3, 1));
        this.scoreCutoffTtf.setText(new Double(2.0).toString());
        this.scorePnl.add((Component)this.scoreCutoffLbl, cc.xy(1, 1));
        this.scorePnl.add((Component)this.scoreCutoffTtf, cc.xy(3, 1));
        this.increasingScoreCB = new JCheckBox("Increasing score", true);
        this.scorePnl.add((Component)this.increasingScoreCB, cc.xy(5, 1));
        this.otherTtf = new JTextField(20);
        this.otherTtf.setEditable(false);
        this.otherTtf.setEnabled(false);
        otherPanel.add((Component)this.scorePnl, cc.xy(2, 1));
        otherPanel.add((Component)this.otherTtf, cc.xy(2, 3));
        this.browseOtherFileBtn = new JXButton(this.openFileAction("other"));
        otherPanel.add((Component)this.browseOtherFileBtn, cc.xy(4, 3));
        JPanel loadPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu, p, 3dlu"));
        loadPanel.add((Component)descPanel, cc.xy(1, 2));
        loadPanel.add((Component)otherPanel, cc.xy(1, 4));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        this.loadBtn = new JXButton("Load");
        this.loadBtn.setEnabled(false);
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AlignFrame alignFrame = LoadMethodFrame.this.loadAlignFrame();
                    if (LoadMethodFrame.this.parent != null) {
                        LoadMethodFrame.this.parent.closeOtherWindows();
                        LoadMethodFrame.this.parent.dispose();
                    }
                    LoadMethodFrame.this.loadMethodFrame.dispose();
                    alignFrame.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.closeBtn = new JXButton("Close");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadMethodFrame.this.loadMethodFrame.dispose();
            }
        });
        actionPanel.add((Component)this.closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)this.loadBtn, cc.xy(4, 2));
        panelNorth.add((Component)loadPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelSouth, "South");
        this.loadMethodFrame.setResizable(false);
        this.loadMethodFrame.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.loadMethodFrame.setVisible(true);
    }

    private AlignFrame loadAlignFrame() throws Exception {
        AlignFrame alignFrame = null;
        UDMParser udmparser = new UDMParser();
        UDMObject udmObject = null;
        try {
            if (this.otherTtf.getText().length() > 0) {
                udmObject = udmparser.read(this.otherTtf.getText());
                udmObject.setScoreCutoff(new Double(this.scoreCutoffTtf.getText()));
                udmObject.setIncreasingScore(this.increasingScoreCB.isSelected());
                this.methods.addUdmObject(udmObject);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "The user defined method file couldn't be loaded! \nPlease specify a proper file format/location.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
            throw new Exception();
        }
        alignFrame = new AlignFrame(this.alignObject, this.methods, 1100, 650, false);
        alignFrame.pack();
        return alignFrame;
    }

    private Action openFileAction(String type) {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        JDialog loadFrame = new JDialog();
        loadFrame.setModal(true);
        OpenFileAction openAction = new OpenFileAction(loadFrame, fc, type);
        return openAction;
    }

    private static class InnerOtherFileFilter
    extends FileFilter {
        private InnerOtherFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.isFile();
        }

        @Override
        public String getDescription() {
            return "User Defined Method File (*.*) ";
        }
    }

    public class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JDialog frame;
        private JFileChooser chooser;
        private File file;
        private String name;
        private String type;
        private FileFilter filter;

        OpenFileAction(JDialog frame, JFileChooser chooser, String type) {
            super("Browse...");
            this.file = null;
            this.chooser = chooser;
            this.type = type;
            this.frame = frame;
            this.getFilter();
        }

        private void getFilter() {
            if (this.type == "other") {
                this.filter = new InnerOtherFileFilter();
            }
        }

        public void setSourceName(String aName) {
            this.name = aName;
        }

        public String getSourceName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.setFileFilter(this.filter);
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.setSourceName(this.file.getAbsolutePath());
                if (this.type == "other") {
                    LoadMethodFrame.this.otherTtf.setText(this.getSourceName());
                    LoadMethodFrame.this.otherTtf.setEnabled(true);
                    LoadMethodFrame.this.loadBtn.setEnabled(true);
                }
            }
        }
    }
}

