/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import model.AlignObject;
import model.Methods;
import org.jdesktop.swingx.JXButton;
import parser.MfaParser;
import util.ScreenConfig;
import util.SelectionManager;
import view.AlignFrame;

public class LoadAlignFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField multAlignTtf;
    private JXButton browseAlignFileBtn;
    private String filename = null;
    private JXButton loadBtn;
    private JXButton closeBtn;
    private JFrame parent;
    private LoadAlignFrame loadFrame = this;

    public LoadAlignFrame(JFrame parent) {
        super(parent, "Load Alignment", true);
        this.parent = parent;
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LoadAlignFrame.this.cancelTriggered();
            }
        });
        this.setDefaultCloseOperation(2);
        this.constructScreen();
    }

    private void constructScreen() {
        JPanel panelNorth = null;
        JPanel panelSouth = null;
        this.loadFrame.setSize(800, 500);
        Container tContentPane = this.loadFrame.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        panelNorth = new JPanel(new FormLayout("10dlu, p, 5dlu, p, 10dlu", "p, 5dlu"));
        panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel multAlignPanel = new JPanel(new FormLayout("3dlu, p, 3dlu, p", "p"));
        multAlignPanel.setBorder(BorderFactory.createTitledBorder("Multiple Alignment"));
        this.multAlignTtf = new JTextField(20);
        this.multAlignTtf.setEditable(false);
        this.multAlignTtf.setEnabled(false);
        multAlignPanel.add((Component)this.multAlignTtf, cc.xy(2, 1));
        this.browseAlignFileBtn = new JXButton(this.openFileAction());
        multAlignPanel.add((Component)this.browseAlignFileBtn, cc.xy(4, 1));
        JPanel loadPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu"));
        loadPanel.add((Component)multAlignPanel, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        this.loadBtn = new JXButton("Load");
        this.loadBtn.setEnabled(false);
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AlignFrame alignFrame = LoadAlignFrame.this.loadAlignFrame();
                    if (LoadAlignFrame.this.parent != null) {
                        ((AlignFrame)LoadAlignFrame.this.parent).closeOtherWindows();
                        LoadAlignFrame.this.parent.dispose();
                    }
                    LoadAlignFrame.this.loadFrame.dispose();
                    alignFrame.setVisible(true);
                    SelectionManager.setEnabled(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.closeBtn = new JXButton("Close");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoadAlignFrame.this.parent == null) {
                    LoadAlignFrame.this.loadFrame.close();
                } else {
                    LoadAlignFrame.this.loadFrame.dispose();
                }
            }
        });
        actionPanel.add((Component)this.closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)this.loadBtn, cc.xy(4, 2));
        panelNorth.add((Component)loadPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelSouth, "South");
        this.loadFrame.setResizable(false);
        this.loadFrame.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.loadFrame.setVisible(true);
    }

    private AlignFrame loadAlignFrame() throws Exception {
        AlignFrame alignFrame = null;
        MfaParser parser = new MfaParser();
        AlignObject alignObject = null;
        try {
            if (this.multAlignTtf.getText().length() <= 0) {
                throw new FileNotFoundException();
            }
            alignObject = parser.read(this.multAlignTtf.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "The alignment file couldn't be loaded! \nPlease specify a proper location/format of the file.\nDetails:\n       " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
            throw new Exception();
        }
        Methods methods = new Methods();
        alignFrame = new AlignFrame(alignObject, methods, 1100, 650, true);
        alignFrame.pack();
        return alignFrame;
    }

    private void close() {
        System.exit(0);
    }

    private Action openFileAction() {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        FileNameExtensionFilter fnef = new FileNameExtensionFilter("Multiple alignment file (*.mfa,*.pir,*.fasta,*.fas, *.fa)", "mfa", "fasta", "pir", "fas", "fa");
        fc.setFileFilter(fnef);
        JDialog loadFrame = new JDialog();
        loadFrame.setModal(true);
        OpenFileAction openAction = new OpenFileAction(loadFrame, fc);
        return openAction;
    }

    private void cancelTriggered() {
        this.loadFrame.dispose();
    }

    public class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private JDialog frame;
        private JFileChooser chooser;
        private File file;
        private String name;

        OpenFileAction(JDialog frame, JFileChooser chooser) {
            super("Browse...");
            this.file = null;
            this.chooser = chooser;
            this.frame = frame;
        }

        public void setSourceName(String aName) {
            this.name = aName;
        }

        public String getSourceName() {
            return this.name;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.setSourceName(this.file.getAbsolutePath());
                LoadAlignFrame.this.multAlignTtf.setText(this.getSourceName());
                LoadAlignFrame.this.multAlignTtf.setEnabled(true);
                LoadAlignFrame.this.loadBtn.setEnabled(true);
            }
        }
    }
}

