/*
 * Decompiled with CFR 0.152.
 */
package view;

import interfaces.Observable;
import interfaces.Observer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.Vector;
import javax.swing.JPanel;
import util.Constants;
import util.ResidueSelectionManager;
import util.SelectionManager;
import view.AlignViewProps;
import view.SequencePainter;

public class IndexPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1L;
    private AlignViewProps viewProps;
    private SequencePainter seqPainter;
    private boolean isInteractive = true;

    public IndexPanel() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(10, 30));
        this.setPreferredSize(new Dimension(10, 30));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JPanel panel = new JPanel();
        panel.setBackground(Constants.INDEXPANEL_BGCOLOR);
        this.add((Component)panel, "Center");
    }

    public IndexPanel(AlignViewProps viewProps, SequencePainter seqPainter) {
        this.viewProps = viewProps;
        this.setLayout(new BorderLayout());
        seqPainter.register(this);
        this.seqPainter = seqPainter;
        this.setMinimumSize(new Dimension(10, 30));
        this.setPreferredSize(new Dimension(10, 30));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        if (viewProps != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SelectionManager.isEnabled()) {
                        IndexPanel.this.notifyOnMouseClick(e);
                    }
                }
            });
        }
    }

    public IndexPanel(AlignViewProps viewProps) {
        this.viewProps = viewProps;
        this.setLayout(new BorderLayout());
        this.isInteractive = false;
        this.setMinimumSize(new Dimension(10, 30));
        this.setPreferredSize(new Dimension(10, 30));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isInteractive || SelectionManager.isEmpty() && ResidueSelectionManager.isEmpty()) {
            if (this.viewProps != null) {
                this.drawIndex(g, this.viewProps.getXStart(), this.viewProps.getXEnd(), this.getWidth(), this.getHeight());
            }
            if (this.isInteractive && SelectionManager.isEnabled()) {
                for (int i = 0; i < SelectionManager.getCurrentSelection().size(); ++i) {
                    this.highLightPosition(g, SelectionManager.getCurrentSelection().get(i) - 1);
                }
                this.markLastPosition(g);
            }
        } else if (this.viewProps != null) {
            this.drawSelectedIndex(g, this.viewProps.getXStart(), this.viewProps.getXEnd(), this.getWidth(), this.getHeight());
        }
    }

    public void drawIndex(Graphics g, int startx, int endx, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.viewProps.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Constants.INDEXPANEL_BGCOLOR);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.black);
        FontMetrics fm = g2d.getFontMetrics(this.viewProps.getFont());
        int x_index = startx / 10 * 10;
        int y_index = this.viewProps.getCharHeight() - fm.getDescent();
        int x_index_max = 0;
        if (x_index % 10 == 0) {
            x_index += 5;
        }
        for (int i = x_index; i < endx; i += 5) {
            if (i % 10 == 0) {
                String str_index = String.valueOf(i);
                if ((i - startx - 1) * this.viewProps.getCharWidth() > x_index_max) {
                    g2d.drawString(str_index, (i - startx - 1) * this.viewProps.getCharWidth(), y_index);
                    x_index_max = (i - startx + 1) * this.viewProps.getCharWidth() + fm.stringWidth(str_index);
                }
                g2d.drawLine((i - startx - 1) * this.viewProps.getCharWidth() + this.viewProps.getCharWidth() / 2, y_index + 5, (i - startx - 1) * this.viewProps.getCharWidth() + this.viewProps.getCharWidth() / 2, y_index + fm.getDescent() * 4);
                continue;
            }
            g2d.drawLine((i - startx - 1) * this.viewProps.getCharWidth() + this.viewProps.getCharWidth() / 2, y_index + fm.getDescent() - 2, (i - startx - 1) * this.viewProps.getCharWidth() + this.viewProps.getCharWidth() / 2, y_index + fm.getDescent() * 4);
        }
    }

    public void drawSelectedIndex(Graphics g, int startx, int endx, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.viewProps.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Constants.INDEXPANEL_BGCOLOR);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.black);
        Vector<Integer> currentSelection = SelectionManager.getFullSelection();
        for (int i = startx; i < currentSelection.size() && i < endx; ++i) {
            String str_index = currentSelection.get(i).toString();
            AffineTransform origXform = g2d.getTransform();
            AffineTransform newXform = (AffineTransform)origXform.clone();
            boolean xRot = false;
            int yRot = 30;
            newXform.rotate(Math.toRadians(270.0), (double)xRot, yRot);
            g2d.setTransform(newXform);
            g2d.drawString(str_index, 0, yRot + (1 + i - startx) * this.viewProps.getCharWidth());
            g2d.setTransform(origXform);
        }
    }

    private void highLightPosition(Graphics g, int pos) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f));
        int xPos = (pos - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
        double startX = new Integer(xPos).doubleValue();
        double endX = new Integer(xPos + this.viewProps.getCharWidth()).doubleValue();
        double startY = new Integer(0).doubleValue();
        double endY = new Integer(30).doubleValue();
        Line2D.Double leftLine = new Line2D.Double(startX, startY, startX, endY);
        Line2D.Double rightLine = new Line2D.Double(endX, startY, endX, endY);
        g2d.draw(leftLine);
        g2d.draw(rightLine);
    }

    private void markLastPosition(Graphics g) {
        if (SelectionManager.getLastSelection() != -1) {
            int xPos = (SelectionManager.getLastSelection() - 1 - this.viewProps.getXStart()) * this.viewProps.getCharWidth();
            Point p1 = new Point(xPos + 2, 20);
            Point p2 = new Point(xPos + this.viewProps.getCharWidth() - 2, 20);
            Point p3 = new Point(xPos + 2 + (this.viewProps.getCharWidth() - 4) / 2, 29);
            int[] xs = new int[]{p1.x, p2.x, p3.x};
            int[] ys = new int[]{p1.y, p2.y, p3.y};
            Polygon triangle = new Polygon(xs, ys, xs.length);
            g.setColor(Color.BLUE);
            g.fillPolygon(triangle);
        }
    }

    @Override
    public void update(Observable object) {
        if (object instanceof SequencePainter) {
            this.seqPainter = (SequencePainter)object;
            this.repaint();
        }
    }

    public void notifyOnMouseClick(MouseEvent ev) {
        SelectionManager.toggleSelection(this.viewProps.getAlObj().getSequenceAt(0).findPosition(this.seqPainter.getAAPosition(ev)), false);
        this.seqPainter.notifyOnMouseClick(ev);
        this.seqPainter.repaint();
    }
}

