/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import util.ColorScheme;

public class ColorSchemeInfo
extends Component {
    private static final long serialVersionUID = 1L;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private String paletteName = "";

    public ColorSchemeInfo(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.paletteName = "";
    }

    public ColorSchemeInfo(String paletteName) {
        this.paletteName = paletteName;
    }

    public void setPaletteName(String paletteName) {
        this.paletteName = paletteName;
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.repaint();
    }

    public void setValues(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.paletteName = "";
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        g.setFont(new Font("SansSerif", 1, 12));
        int textHeight = g.getFontMetrics().getAscent();
        if (!this.paletteName.equals("")) {
            g.setColor(Color.BLACK);
            g.drawString(this.paletteName, 0, textHeight);
        } else if (this.minValue != 0.0 && this.maxValue != 0.0) {
            double scale = 255.0 / (this.maxValue - this.minValue);
            int minValueWidth = g.getFontMetrics().stringWidth(this.minValue + "");
            g.setColor(Color.BLACK);
            g.drawString(this.minValue + "", 0, textHeight);
            int i = 0;
            while ((double)i < 10.0) {
                Color color = ColorScheme.getColorFromValue(this.minValue + (double)i * (this.maxValue - this.minValue) / 10.0, this.maxValue, this.minValue, scale, ColorScheme.getColorPalette());
                g.setColor(color);
                g.fillRect(minValueWidth + 5 + i * 100 / 10, 0, 10, 20);
                ++i;
            }
            g.setColor(Color.BLACK);
            g.drawString(this.maxValue + "", minValueWidth + 100 + 10, textHeight);
        }
    }
}

