/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import interfaces.Observable;
import interfaces.Observer;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import model.ClusterCoordinates;
import model.ClusterGroup;
import model.ResidueCoordinates;
import model.S3DetObject;
import model.SequenceCoordinates;
import util.Constants;
import util.ResidueSelectionManager;
import util.SelectionManager;
import util.SequenceManager;
import util.SequenceOrderer;
import view.AlignViewProps;
import view.ClusterWindowListener;
import view.PickPointsBehavior;
import view.SequencePainter;

public class Cluster3DFrame
extends JFrame
implements ItemListener,
Observer {
    private static final long serialVersionUID = 1L;
    private Color3f selProteinColor = new Color3f(Constants.SELECTED_PROTEIN_COLOR);
    private Color3f selResidueColor = new Color3f(Constants.SELECTED_RESIDUE_COLOR);
    private static final float CLUSTERTRANS = 0.4f;
    private static final float MAX_VALUE = 0.33f;
    private float highestValue = 0.33f;
    private float scaleFactor = 1.0f;
    private float min_x;
    private float min_y;
    private float min_z;
    private float max_x;
    private float max_y;
    private float max_z;
    private int[] boxValues;
    private S3DetObject s3detobj;
    private JPanel clusterPanel;
    private JPanel optionPanel;
    private Choice axesBox1;
    private Choice axesBox2;
    private Choice axesBox3;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JButton defaultBtn;
    private Canvas3D canvas3D;
    private SimpleUniverse simpleUni;
    private JPanel legendPanel;
    private JLabel subFamiliesLbl;
    private JLabel residuesLbl;
    private JLabel clusterCentersLbl;
    BranchGroup branchGroup;
    private SequenceOrderer seqOrderer;
    private HashMap<String, Integer> name2ClusterIndex;

    public Canvas3D getCanvas3D() {
        return this.canvas3D;
    }

    public Cluster3DFrame(S3DetObject s3detobj, AlignViewProps viewProps, SequencePainter seqPainter) {
        BranchGroup newBranchGroup;
        this.s3detobj = s3detobj;
        this.setTitle("Sequence Spaces");
        this.getDefaultBoxValues();
        this.name2ClusterIndex = s3detobj.getName2ClusterIndex();
        this.seqOrderer = new SequenceOrderer(viewProps.getAlObj(), s3detobj);
        this.clusterPanel = new JPanel();
        this.clusterPanel.setLayout(new BorderLayout());
        this.label1 = new JLabel("x-axis:");
        this.label2 = new JLabel("y-axis:");
        this.label3 = new JLabel("z-axis:");
        String axis = " axis";
        String[] comboContents = new String[]{"1st" + axis, "2nd" + axis, "3rd" + axis, "4th" + axis, "5th" + axis, "6th" + axis, "7th" + axis, "8th" + axis, "9th" + axis, "10th" + axis};
        this.axesBox1 = new Choice();
        this.axesBox2 = new Choice();
        this.axesBox3 = new Choice();
        for (int i = 0; i < comboContents.length; ++i) {
            this.axesBox1.add(comboContents[i]);
            this.axesBox2.add(comboContents[i]);
            this.axesBox3.add(comboContents[i]);
        }
        this.axesBox1.select(0);
        this.axesBox1.addItemListener(this);
        this.axesBox2.select(1);
        this.axesBox2.addItemListener(this);
        this.axesBox3.select(2);
        this.axesBox3.addItemListener(this);
        this.optionPanel = new JPanel(new FormLayout("50dlu, p, 5dlu, p, 10dlu, p, 5dlu, p, 10dlu, p, 5dlu, p, 10dlu, right:p ", "5dlu, p, 5dlu"));
        this.optionPanel.setBorder(BorderFactory.createTitledBorder("Axes Selection"));
        CellConstraints cc = new CellConstraints();
        this.optionPanel.add((Component)this.label1, cc.xy(2, 2));
        this.optionPanel.add((Component)this.axesBox1, cc.xy(4, 2));
        this.optionPanel.add((Component)this.label2, cc.xy(6, 2));
        this.optionPanel.add((Component)this.axesBox2, cc.xy(8, 2));
        this.optionPanel.add((Component)this.label3, cc.xy(10, 2));
        this.optionPanel.add((Component)this.axesBox3, cc.xy(12, 2));
        this.defaultBtn = new JButton("Default");
        this.defaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cluster3DFrame.this.axesBox1.select(0);
                Cluster3DFrame.this.axesBox2.select(1);
                Cluster3DFrame.this.axesBox3.select(2);
                Cluster3DFrame.this.getDefaultBoxValues();
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected String doInBackground() throws InterruptedException {
                        return null;
                    }

                    @Override
                    protected void done() {
                        Cluster3DFrame.this.refreshCanvas();
                    }
                };
                worker.execute();
            }
        });
        this.optionPanel.add((Component)this.defaultBtn, cc.xy(14, 2));
        try {
            GraphicsConfiguration graphConfig = SimpleUniverse.getPreferredConfiguration();
            this.canvas3D = new Canvas3D(graphConfig);
            this.canvas3D.setSize(100, 100);
            this.simpleUni = new SimpleUniverse(this.canvas3D);
        }
        catch (Error e) {
            JOptionPane.showMessageDialog(new JFrame(), "Java3D is not installed\nDownload at http://java3d.java.net/\n");
            this.dispose();
            return;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(new JFrame(), "Java3D is not installed\nDownload at http://java3d.java.net/\n");
            this.dispose();
            return;
        }
        this.branchGroup = newBranchGroup = this.createSceneGraph();
        newBranchGroup.compile();
        this.canvas3D.getView().setWindowEyepointPolicy(1);
        this.canvas3D.getView().setProjectionPolicy(0);
        this.canvas3D.getView().setFieldOfView(0.15);
        this.simpleUni.getViewingPlatform().setNominalViewingTransform();
        this.simpleUni.addBranchGraph(newBranchGroup);
        this.addWindowListener(new ClusterWindowListener(this, seqPainter));
        this.canvas3D.repaint();
        this.clusterPanel.add((Component)this.canvas3D, "Center");
        this.legendPanel = new JPanel(new FormLayout("center:p:grow, center:p:grow, ", "5dlu, center:p:grow, 5dlu, center:p:grow, 5dlu"));
        this.subFamiliesLbl = new JLabel("Proteins/Subfamilies");
        this.subFamiliesLbl.setFont(new Font("Verdana", 1, 14));
        this.subFamiliesLbl.setForeground(Color.RED);
        this.residuesLbl = new JLabel("Residues (gray)");
        this.clusterCentersLbl = new JLabel("Cluster Centers (black)");
        this.clusterCentersLbl.setFont(new Font("Verdana", 1, 14));
        this.clusterCentersLbl.setForeground(Color.BLACK);
        this.residuesLbl.setFont(new Font("Verdana", 1, 14));
        this.residuesLbl.setForeground(Color.BLUE);
        this.legendPanel.add((Component)this.subFamiliesLbl, cc.xy(1, 2));
        this.legendPanel.add((Component)this.residuesLbl, cc.xy(2, 2));
        this.legendPanel.add((Component)this.clusterCentersLbl, cc.xy(2, 4));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.optionPanel, "North");
        this.getContentPane().add((Component)this.clusterPanel, "Center");
        this.getContentPane().add((Component)this.legendPanel, "South");
        this.setMinimumSize(new Dimension(800, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.validate();
        this.repaint();
        this.setVisible(true);
        seqPainter.register(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.collectBoxValues();
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected String doInBackground() throws InterruptedException {
                    return null;
                }

                @Override
                protected void done() {
                    Cluster3DFrame.this.repaintClusters(Cluster3DFrame.this.branchGroup);
                }
            };
            worker.execute();
        }
    }

    private void refreshCanvas() {
        BranchGroup newBranchGroup = this.createSceneGraph();
        newBranchGroup.compile();
        this.simpleUni.getAllLocales();
        this.branchGroup.detach();
        this.branchGroup = newBranchGroup;
        this.simpleUni.getViewingPlatform().setNominalViewingTransform();
        this.simpleUni.addBranchGraph(newBranchGroup);
        this.canvas3D.repaint();
    }

    private void collectBoxValues() {
        this.boxValues = new int[3];
        this.boxValues[0] = this.axesBox1.getSelectedIndex();
        this.boxValues[1] = this.axesBox2.getSelectedIndex();
        this.boxValues[2] = this.axesBox3.getSelectedIndex();
    }

    private Color getColorForProteinName(String proteinName) {
        int index = this.name2ClusterIndex.get(proteinName);
        ClusterGroup[] clusterGroups = this.seqOrderer.getClusterGroups();
        ClusterGroup clGroup = clusterGroups[index];
        return clGroup.getColor();
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        objRoot.setCapability(12);
        TransformGroup objRotate = null;
        MouseRotate myMouseRotate = null;
        Transform3D transform = new Transform3D();
        this.min_z = 0.33f;
        this.min_y = 0.33f;
        this.min_x = 0.33f;
        this.max_z = -0.33f;
        this.max_y = -0.33f;
        this.max_x = -0.33f;
        this.calculateScaleFactor();
        Shape3D seqCoordShape = this.getSequencesShape();
        Shape3D resCoordShape = this.getResiduesShape();
        Shape3D selectedResCoordShape = this.getSelectedResiduesShape();
        Shape3D clusCoordShape = this.getClusterShape();
        transform = new Transform3D();
        transform.setTranslation(new Vector3d(-0.4f, 0.0, 0.0));
        objRotate = new TransformGroup(transform);
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        objRotate.setCapability(5);
        objRotate.setCapability(6);
        objRotate.setCapability(1);
        objRotate.setCapability(12);
        objRoot.addChild(objRotate);
        objRotate.addChild(seqCoordShape);
        objRotate.addChild(this.createAxis());
        myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objRotate);
        myMouseRotate.setSchedulingBounds(new BoundingSphere());
        objRoot.addChild(myMouseRotate);
        PickPointsBehavior behavior = new PickPointsBehavior(this.canvas3D, objRoot);
        behavior.setSchedulingBounds(new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2.0));
        objRoot.addChild(behavior);
        BoundingSphere bounds = new BoundingSphere(new Point3d(), 100.0);
        Background bg = new Background(new Color3f(1.0f, 1.0f, 1.0f));
        bg.setApplicationBounds(bounds);
        objRotate.addChild(bg);
        transform.setTranslation(new Vector3f(0.4f, 0.0f, 0.0f));
        objRotate = new TransformGroup(transform);
        objRotate.setCapability(18);
        objRotate.setCapability(17);
        objRotate.setCapability(5);
        objRotate.setCapability(6);
        objRotate.setCapability(1);
        objRotate.setCapability(12);
        objRoot.addChild(objRotate);
        objRotate.addChild(clusCoordShape);
        objRotate.addChild(resCoordShape);
        objRotate.addChild(selectedResCoordShape);
        objRotate.addChild(this.createAxis());
        myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objRotate);
        myMouseRotate.setSchedulingBounds(new BoundingSphere());
        objRoot.addChild(myMouseRotate);
        objRoot.setCapability(14);
        objRoot.setCapability(13);
        objRoot.compile();
        return objRoot;
    }

    public void repaintClusters(BranchGroup objRoot) {
        Enumeration rootChildren = objRoot.getAllChildren();
        Vector<TransformGroup> vRootChildren = new Vector<TransformGroup>();
        while (rootChildren.hasMoreElements()) {
            Object childRoot = rootChildren.nextElement();
            if (!(childRoot instanceof TransformGroup)) continue;
            vRootChildren.add((TransformGroup)childRoot);
        }
        this.calculateScaleFactor();
        for (int i = 0; i < vRootChildren.size(); ++i) {
            rootChildren = ((TransformGroup)vRootChildren.get(i)).getAllChildren();
            while (rootChildren.hasMoreElements()) {
                Shape3D shape;
                Object childRoot = rootChildren.nextElement();
                if (!(childRoot instanceof Shape3D) || (shape = (Shape3D)childRoot).getUserData() == null) continue;
                if (shape.getUserData().equals("Sequences")) {
                    shape.setGeometry(this.getSeqPoints());
                    continue;
                }
                if (shape.getUserData().equals("Residues")) {
                    shape.setGeometry(this.getResPoints());
                    continue;
                }
                if (shape.getUserData().equals("Cluster")) {
                    shape.setGeometry(this.getClusterPoints());
                    continue;
                }
                if (!shape.getUserData().equals("SelResidues")) continue;
                shape.setGeometry(this.getSelectedResPoints());
            }
        }
    }

    public void updateColors(BranchGroup objRoot) {
        Enumeration rootChildren = objRoot.getAllChildren();
        Vector<TransformGroup> vRootChildren = new Vector<TransformGroup>();
        while (rootChildren.hasMoreElements()) {
            Object childRoot = rootChildren.nextElement();
            if (!(childRoot instanceof TransformGroup)) continue;
            vRootChildren.add((TransformGroup)childRoot);
        }
        for (int i = 0; i < vRootChildren.size(); ++i) {
            rootChildren = ((TransformGroup)vRootChildren.get(i)).getAllChildren();
            while (rootChildren.hasMoreElements()) {
                Shape3D shape;
                Object childRoot = rootChildren.nextElement();
                if (!(childRoot instanceof Shape3D) || (shape = (Shape3D)childRoot).getUserData() == null) continue;
                if (shape.getUserData().equals("Sequences")) {
                    this.setSeqPointsColor((PointArray)shape.getGeometry());
                    continue;
                }
                if (shape.getUserData().equals("Residues")) {
                    this.setResPointsColor((PointArray)shape.getGeometry());
                    continue;
                }
                if (!shape.getUserData().equals("SelResidues")) continue;
                shape.setGeometry(this.getSelectedResPoints());
            }
        }
    }

    private void setSeqPointsColor(PointArray seqCoordPoints) {
        SequenceCoordinates[] seqCoords = this.s3detobj.getSeqCoords();
        int seqCoordNumber = seqCoords.length;
        for (int i = 0; i < seqCoordNumber; ++i) {
            if (SequenceManager.isSelected(seqCoords[i].getName())) {
                seqCoordPoints.setColor(i, this.selProteinColor);
                continue;
            }
            seqCoordPoints.setColor(i, new Color3f(this.getColorForProteinName(seqCoords[i].getName())));
        }
    }

    private PointArray getSeqPoints() {
        SequenceCoordinates[] seqCoords = this.s3detobj.getSeqCoords();
        int seqCoordNumber = seqCoords.length;
        Point3f[] seqPoints = new Point3f[seqCoordNumber];
        PointArray seqCoordPoints = new PointArray(seqCoordNumber, 5);
        for (int i = 0; i < seqCoordNumber; ++i) {
            float x = (float)seqCoords[i].getCoords()[this.boxValues[0]] * this.scaleFactor;
            float y = (float)seqCoords[i].getCoords()[this.boxValues[1]] * this.scaleFactor;
            float z = (float)seqCoords[i].getCoords()[this.boxValues[2]] * this.scaleFactor;
            seqPoints[i] = new Point3f(x, y, z);
            seqCoordPoints.setCoordinate(i, new Point3f(x, y, z));
            if (SequenceManager.isSelected(seqCoords[i].getName())) {
                seqCoordPoints.setColor(i, this.selProteinColor);
                continue;
            }
            seqCoordPoints.setColor(i, new Color3f(this.getColorForProteinName(seqCoords[i].getName())));
        }
        seqCoordPoints.setCapability(3);
        seqCoordPoints.setCapability(22);
        seqCoordPoints.setCapability(8);
        seqCoordPoints.setCapability(17);
        seqCoordPoints.setCapability(0);
        return seqCoordPoints;
    }

    private Shape3D getSequencesShape() {
        Appearance seqCoordApp = new Appearance();
        PointArray seqCoordPoints = this.getSeqPoints();
        PointAttributes pa = new PointAttributes();
        pa.setPointSize(4.0f);
        seqCoordApp.setPointAttributes(pa);
        Shape3D shape = new Shape3D(seqCoordPoints, seqCoordApp);
        shape.setUserData("Sequences");
        shape.setCapability(13);
        shape.setCapability(12);
        return shape;
    }

    private void setResPointsColor(PointArray resCoordPoints) {
        ResidueCoordinates[] resCoords = this.s3detobj.getResCoords();
        int resCoordNumber = resCoords.length;
        for (int i = 0; i < resCoordNumber; ++i) {
            if (ResidueSelectionManager.contains(resCoords[i].getPosition(), resCoords[i].getLetter()) || SelectionManager.contains(resCoords[i].getPosition())) {
                resCoordPoints.setColor(i, this.selResidueColor);
                continue;
            }
            resCoordPoints.setColor(i, new Color3f(Constants.DEFAULT_RESIDUE_COLOR));
        }
    }

    private PointArray getResPoints() {
        ResidueCoordinates[] resCoords = this.s3detobj.getResCoords();
        int resCoordNumber = resCoords.length;
        Point3f[] resPoints = new Point3f[resCoordNumber];
        PointArray resCoordPoints = new PointArray(resCoordNumber, 5);
        for (int i = 0; i < resCoordNumber; ++i) {
            float z;
            float y;
            float x = (float)resCoords[i].getCoords()[this.boxValues[0]] * this.scaleFactor;
            if (x < this.min_x) {
                this.min_x = x;
            }
            if (x > this.max_x) {
                this.max_x = x;
            }
            if ((y = (float)resCoords[i].getCoords()[this.boxValues[1]] * this.scaleFactor) < this.min_y) {
                this.min_y = y;
            }
            if (y > this.max_y) {
                this.max_y = y;
            }
            if ((z = (float)resCoords[i].getCoords()[this.boxValues[2]] * this.scaleFactor) < this.min_z) {
                this.min_z = z;
            }
            if (z > this.max_z) {
                this.max_z = z;
            }
            resPoints[i] = new Point3f(x, y, z);
            if (ResidueSelectionManager.contains(resCoords[i].getPosition(), resCoords[i].getLetter()) || SelectionManager.contains(resCoords[i].getPosition())) {
                resCoordPoints.setColor(i, this.selResidueColor);
            } else {
                resCoordPoints.setColor(i, new Color3f(Constants.DEFAULT_RESIDUE_COLOR));
            }
            resCoordPoints.setCoordinate(i, resPoints[i]);
        }
        resCoordPoints.setCapability(3);
        resCoordPoints.setCapability(22);
        resCoordPoints.setCapability(8);
        resCoordPoints.setCapability(17);
        resCoordPoints.setCapability(0);
        return resCoordPoints;
    }

    private Shape3D getResiduesShape() {
        PointArray resCoordPoints = this.getResPoints();
        Appearance resCoordApp = new Appearance();
        PointAttributes pa = new PointAttributes();
        pa.setPointSize(2.0f);
        resCoordApp.setPointAttributes(pa);
        Shape3D shape = new Shape3D(resCoordPoints, resCoordApp);
        shape.setUserData("Residues");
        shape.setCapability(13);
        shape.setCapability(12);
        return shape;
    }

    private PointArray getSelectedResPoints() {
        ResidueCoordinates[] resCoords = this.s3detobj.getResCoords();
        int resCoordNumber = resCoords.length;
        Point3f[] resPoints = new Point3f[resCoordNumber];
        PointArray resCoordPoints = new PointArray(resCoordNumber, 5);
        for (int i = 0; i < resCoordNumber; ++i) {
            if (!ResidueSelectionManager.contains(resCoords[i].getPosition(), resCoords[i].getLetter()) && !SelectionManager.contains(resCoords[i].getPosition())) continue;
            float x = (float)resCoords[i].getCoords()[this.boxValues[0]] * this.scaleFactor;
            float y = (float)resCoords[i].getCoords()[this.boxValues[1]] * this.scaleFactor;
            float z = (float)resCoords[i].getCoords()[this.boxValues[2]] * this.scaleFactor;
            resPoints[i] = new Point3f(x, y, z);
            resCoordPoints.setColor(i, this.selResidueColor);
            resCoordPoints.setCoordinate(i, resPoints[i]);
        }
        resCoordPoints.setCapability(3);
        resCoordPoints.setCapability(22);
        resCoordPoints.setCapability(8);
        resCoordPoints.setCapability(17);
        resCoordPoints.setCapability(0);
        return resCoordPoints;
    }

    private Shape3D getSelectedResiduesShape() {
        PointArray resCoordPoints = this.getSelectedResPoints();
        Appearance resCoordApp = new Appearance();
        PointAttributes pa = new PointAttributes();
        pa.setPointSize(4.0f);
        resCoordApp.setPointAttributes(pa);
        Shape3D shape = new Shape3D(resCoordPoints, resCoordApp);
        shape.setUserData("SelResidues");
        shape.setCapability(13);
        shape.setCapability(12);
        return shape;
    }

    private PointArray getClusterPoints() {
        ClusterCoordinates[] clusCoords = this.s3detobj.getClusterCoords();
        int clusCoordNumber = clusCoords.length;
        Point3f[] clusPoints = new Point3f[clusCoordNumber];
        PointArray clusCoordPoints = new PointArray(clusCoordNumber, 5);
        ClusterGroup[] clGroups = this.seqOrderer.getClusterGroups();
        for (int i = 0; i < clusCoordNumber; ++i) {
            float x = (float)clusCoords[i].getCoords()[this.boxValues[0]] * this.scaleFactor;
            float y = (float)clusCoords[i].getCoords()[this.boxValues[1]] * this.scaleFactor;
            float z = (float)clusCoords[i].getCoords()[this.boxValues[2]] * this.scaleFactor;
            clusPoints[i] = new Point3f(x + 0.4f, y, z);
            clusCoordPoints.setCoordinate(i, new Point3f(x, y, z));
            if (i < clGroups.length) {
                clusCoordPoints.setColor(i, new Color3f(clGroups[i].getColor()));
                continue;
            }
            clusCoordPoints.setColor(i, new Color3f(Constants.DEFAULT_CLUSTER_COLOR));
        }
        return clusCoordPoints;
    }

    private Shape3D getClusterShape() {
        PointArray clusCoordPoints = this.getClusterPoints();
        Appearance clusCoordApp = new Appearance();
        PointAttributes pa = new PointAttributes();
        pa.setPointSize(4.0f);
        clusCoordApp.setPointAttributes(pa);
        Shape3D shape = new Shape3D(clusCoordPoints, clusCoordApp);
        shape.setUserData("Cluster");
        shape.setCapability(13);
        shape.setCapability(12);
        return shape;
    }

    private Group createAxis() {
        ColoringAttributes axisColor = new ColoringAttributes(new Color3f(Constants.DEFAULT_AXIS_COLOR), 2);
        Group lineGroup = new Group();
        Point3f[] x_axis = new Point3f[]{new Point3f(this.min_x, 0.0f, 0.0f), new Point3f(this.max_x, 0.0f, 0.0f)};
        LineArray xArray = new LineArray(2, 1);
        xArray.setCapability(8);
        xArray.setCoordinates(0, x_axis);
        Point3f[] y_axis = new Point3f[]{new Point3f(0.0f, this.min_y, 0.0f), new Point3f(0.0f, this.max_y, 0.0f)};
        LineArray yArray = new LineArray(2, 1);
        yArray.setCapability(8);
        yArray.setCoordinates(0, y_axis);
        Point3f[] z_axis = new Point3f[]{new Point3f(0.0f, 0.0f, this.max_z), new Point3f(0.0f, 0.0f, this.min_z)};
        LineArray zArray = new LineArray(2, 1);
        zArray.setCapability(8);
        zArray.setCoordinates(0, z_axis);
        LineAttributes dotDashLa = new LineAttributes();
        dotDashLa.setLineWidth(1.0f);
        dotDashLa.setLinePattern(1);
        Appearance dotDashApp = new Appearance();
        dotDashApp.setLineAttributes(dotDashLa);
        dotDashApp.setColoringAttributes(axisColor);
        Shape3D xLine = new Shape3D(xArray, dotDashApp);
        Shape3D yLine = new Shape3D(yArray, dotDashApp);
        Shape3D zLine = new Shape3D(zArray, dotDashApp);
        lineGroup.addChild(xLine);
        lineGroup.addChild(yLine);
        lineGroup.addChild(zLine);
        return lineGroup;
    }

    private void getDefaultBoxValues() {
        this.boxValues = new int[3];
        this.boxValues[0] = 0;
        this.boxValues[1] = 1;
        this.boxValues[2] = 2;
    }

    @Override
    public void update(Observable object) {
        if (object instanceof SequencePainter) {
            this.updateColors(this.branchGroup);
        }
    }

    public void enablePicking(Node node) {
        Enumeration e;
        node.setPickable(true);
        node.setCapability(1);
        try {
            Group group = (Group)node;
            e = group.getAllChildren();
            while (e.hasMoreElements()) {
                this.enablePicking((Node)e.nextElement());
            }
        }
        catch (ClassCastException group) {
            // empty catch block
        }
        try {
            Shape3D shape = (Shape3D)node;
            PickTool.setCapabilities(node, 4100);
            e = shape.getAllGeometries();
            while (e.hasMoreElements()) {
                Geometry g = (Geometry)e.nextElement();
                g.setCapability(18);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void calculateScaleFactor() {
        this.highestValue = 0.33f;
        ResidueCoordinates[] resCoords = this.s3detobj.getResCoords();
        for (int i = 0; i < resCoords.length; ++i) {
            float z;
            float y;
            float x = (float)resCoords[i].getCoords()[this.boxValues[0]];
            if (x > this.highestValue) {
                this.highestValue = x;
            }
            if ((y = (float)resCoords[i].getCoords()[this.boxValues[1]]) > this.highestValue) {
                this.highestValue = y;
            }
            if (!((z = (float)resCoords[i].getCoords()[this.boxValues[2]]) > this.highestValue)) continue;
            this.highestValue = z;
        }
        SequenceCoordinates[] seqCoords = this.s3detobj.getSeqCoords();
        for (int i = 0; i < seqCoords.length; ++i) {
            float z;
            float y;
            float x = (float)seqCoords[i].getCoords()[this.boxValues[0]];
            if (x > this.highestValue) {
                this.highestValue = x;
            }
            if ((y = (float)seqCoords[i].getCoords()[this.boxValues[1]]) > this.highestValue) {
                this.highestValue = y;
            }
            if (!((z = (float)seqCoords[i].getCoords()[this.boxValues[2]]) > this.highestValue)) continue;
            this.highestValue = z;
        }
        this.scaleFactor = 0.33f / this.highestValue;
    }
}

