/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import model.S3DetObject;
import model.SequenceImpl;
import util.Constants;
import util.ImageExporter;
import util.SequenceOrderer;
import view.AlignFrame;
import view.AlignViewProps;
import view.IndexPanel;
import view.MethodPanel;
import view.NamePanel;
import view.SequencePanel;
import view.SliderPanel;

public class AlignPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private AlignViewProps viewProps;
    private IndexPanel indexPanel;
    private NamePanel namePanel;
    private SequencePanel seqPanel;
    private AlignFrame alignFrame;
    private JPanel wholeSequencePnl = new JPanel();
    private JScrollBar horizontalScrollbar;
    private JScrollBar verticalScrollbar;
    private JPanel descriptionPnl;
    private JLabel textLabel;
    private JPanel descBoxPanel;
    private JPanel upperPanel;
    private MethodPanel methodPanel;
    private JPanel upperDescPnl;
    private ImageExporter imageExporter;
    private SliderPanel sliderPanel;
    private int horizontalChange = 0;
    private int verticalChange = 0;
    private S3DetObject s3detobj;

    public AlignPanel(AlignFrame alignFrame) {
        this.alignFrame = alignFrame;
        this.init();
    }

    public AlignPanel(AlignFrame alignFrame, AlignViewProps viewProps) {
        this.alignFrame = alignFrame;
        this.viewProps = viewProps;
        this.s3detobj = alignFrame.getMethods().getS3DetObject();
        this.init();
        this.repaint();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(1100, 510));
        this.textLabel = new JLabel("Protein ID");
        this.textLabel.setPreferredSize(new Dimension(265, 30));
        this.textLabel.setMinimumSize(new Dimension(265, 30));
        this.textLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.descBoxPanel = new JPanel();
        this.descBoxPanel.setLayout(new BoxLayout(this.descBoxPanel, 0));
        this.descBoxPanel.setBackground(Constants.DESCBOXPNL_BGCOLOR);
        this.descBoxPanel.add(Box.createRigidArea(new Dimension(5, 30)));
        this.descBoxPanel.add(this.textLabel);
        this.upperDescPnl = new JPanel(new BorderLayout());
        this.upperPanel = new JPanel(new BorderLayout());
        if (this.viewProps == null) {
            this.indexPanel = new IndexPanel();
            this.namePanel = new NamePanel();
            this.seqPanel = new SequencePanel();
            this.descriptionPnl = new JPanel(new BorderLayout());
            this.descriptionPnl.setBackground(Color.WHITE);
            this.methodPanel = new MethodPanel();
            this.sliderPanel = new SliderPanel();
            this.upperDescPnl.add((Component)this.sliderPanel, "North");
            this.upperPanel.add((Component)this.methodPanel, "North");
            this.upperDescPnl.add((Component)this.descBoxPanel, "Center");
            this.upperPanel.add((Component)this.indexPanel, "Center");
            this.descriptionPnl.add((Component)this.upperDescPnl, "North");
            this.descriptionPnl.add((Component)this.namePanel, "Center");
            this.wholeSequencePnl = new JPanel(new BorderLayout());
            this.wholeSequencePnl.add((Component)this.upperPanel, "North");
            this.wholeSequencePnl.add((Component)this.seqPanel, "Center");
            this.add(this.descriptionPnl);
            this.add(this.wholeSequencePnl);
        } else {
            this.seqPanel = new SequencePanel(this.viewProps, this);
            this.namePanel = new NamePanel(this.viewProps, this, this.seqPanel.getSeqPainter());
            this.indexPanel = new IndexPanel(this.viewProps, this.seqPanel.getSeqPainter());
            this.methodPanel = new MethodPanel(this.viewProps, this, this.seqPanel.getSeqPainter());
            this.sliderPanel = new SliderPanel(this.alignFrame);
            this.upperDescPnl.add((Component)this.sliderPanel, "North");
            this.upperPanel.add((Component)this.methodPanel, "North");
            this.upperPanel.add((Component)this.indexPanel, "Center");
            this.descriptionPnl = new JPanel(new BorderLayout());
            this.descriptionPnl.setBackground(Color.WHITE);
            this.upperDescPnl.add((Component)this.descBoxPanel, "Center");
            this.descriptionPnl.add((Component)this.upperDescPnl, "North");
            this.descriptionPnl.add((Component)this.namePanel, "Center");
            this.descriptionPnl.setPreferredSize(new Dimension(250, 450));
            this.descriptionPnl.setMinimumSize(new Dimension(250, 450));
            this.descriptionPnl.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.wholeSequencePnl = new JPanel(new BorderLayout());
            this.wholeSequencePnl.add((Component)this.upperPanel, "North");
            this.wholeSequencePnl.add((Component)this.seqPanel, "Center");
            this.horizontalScrollbar = new JScrollBar(0);
            this.horizontalScrollbar.addAdjustmentListener(new ScrollAdjuster());
            this.wholeSequencePnl.add((Component)this.horizontalScrollbar, "South");
            this.verticalScrollbar = new JScrollBar(1);
            this.verticalScrollbar.addAdjustmentListener(new ScrollAdjuster());
            this.add(this.descriptionPnl);
            this.add(this.wholeSequencePnl);
            this.add((Component)this.verticalScrollbar, "East");
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.viewProps != null) {
            this.setScrollValues(this.viewProps.getXStart(), this.viewProps.getYStart());
        }
    }

    public void setScrollValues(int x, int y) {
        int width = this.viewProps.getAlObj().getWidth();
        int height = this.viewProps.getAlObj().getHeight();
        this.horizontalChange = this.seqPanel.getWidth() / this.viewProps.getCharWidth();
        this.verticalChange = this.seqPanel.getHeight() / this.viewProps.getCharHeight();
        if (this.horizontalChange > width) {
            this.horizontalChange = width;
        }
        if (this.verticalChange > height) {
            this.verticalChange = height;
        }
        if (this.horizontalChange + x > width) {
            x = width - this.horizontalChange;
        }
        if (this.verticalChange + y > height) {
            y = height - this.verticalChange;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        this.horizontalScrollbar.setValues(x, this.horizontalChange, 0, width);
        this.verticalScrollbar.setValues(y, this.verticalChange, 0, height);
    }

    public void exportPNGFile(File pngfile) {
        int height = (this.viewProps.getAlObj().getHeight() + 1) * this.viewProps.getCharHeight() + this.indexPanel.getHeight() + this.methodPanel.getHeight();
        int width = this.viewProps.getAlObj().getWidth() * this.viewProps.getCharWidth() + this.namePanel.getWidth();
        this.imageExporter = new ImageExporter(this, "Export PNG image from the alignment", width, height, pngfile);
        if (this.imageExporter.getGraphics() != null) {
            try {
                this.printPanel(this.imageExporter.getGraphics(), width, height, 0);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            this.imageExporter.write();
        }
    }

    public MethodPanel getMethodPanel() {
        return this.methodPanel;
    }

    public IndexPanel getIndexPanel() {
        return this.indexPanel;
    }

    public SequencePanel getSeqPanel() {
        return this.seqPanel;
    }

    public NamePanel getNamePanel() {
        return this.namePanel;
    }

    public AlignFrame getAlignFrame() {
        return this.alignFrame;
    }

    @Override
    public int print(Graphics g, PageFormat format, int p) throws PrinterException {
        g.translate((int)format.getImageableX(), (int)format.getImageableY());
        int w = (int)format.getImageableWidth();
        int h = (int)format.getImageableHeight();
        return this.printPanel(g, w, h, p);
    }

    public int printPanel(Graphics graphics, int imageWidth, int imageHeight, int p) throws PrinterException {
        int startY;
        int endY;
        this.setScrollValues(0, 0);
        int nameWidth = this.namePanel.getWidth();
        FontMetrics fontMetrics = this.getFontMetrics(this.viewProps.getFont());
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        graphics.setFont(this.viewProps.getFont());
        int absHeight = this.viewProps.getCharHeight() + fontMetrics.getDescent();
        int x = (imageWidth - nameWidth) / this.viewProps.getCharWidth();
        int y = (imageHeight - absHeight) / this.viewProps.getCharHeight() - 1;
        int wide = this.viewProps.getAlObj().getWidth() / x + 1;
        int startX = p % wide * x;
        int endX = startX + x - 1;
        if (endX > this.viewProps.getAlObj().getWidth() - 1) {
            endX = this.viewProps.getAlObj().getWidth() - 1;
        }
        if ((endY = (startY = p / wide * y) + y) > this.viewProps.getAlObj().getHeight()) {
            endY = this.viewProps.getAlObj().getHeight();
        }
        int pagesHigh = (this.viewProps.getAlObj().getHeight() / y + 1) * imageHeight;
        if (p >= wide * (pagesHigh /= imageHeight)) {
            return 1;
        }
        this.sliderPanel.drawPanel(graphics, startX, endX, nameWidth, this.methodPanel.getHeight());
        graphics.translate(nameWidth, 0);
        this.methodPanel.drawSquares(graphics, startX, endX, imageWidth, this.methodPanel.getHeight());
        graphics.translate(0, this.methodPanel.getHeight());
        this.indexPanel.drawIndex(graphics, startX, endX, imageWidth - nameWidth, absHeight);
        graphics.translate(-nameWidth, absHeight);
        Color color = null;
        Color currentTextColor = null;
        if (this.s3detobj == null) {
            for (int i = startY; i < endY; ++i) {
                SequenceImpl sequence = this.viewProps.getAlObj().getSequenceAt(i);
                color = Color.white;
                currentTextColor = Color.black;
                graphics.setColor(color);
                graphics.fillRect(0, (i - startY) * this.viewProps.getCharHeight(), nameWidth, this.viewProps.getCharHeight());
                graphics.setColor(currentTextColor);
                int xValue = 0;
                graphics.drawString(sequence.getName(), xValue, (i - startY) * this.viewProps.getCharHeight() + this.viewProps.getCharHeight() - this.viewProps.getCharHeight() / 5);
            }
            graphics.setFont(this.viewProps.getFont());
            graphics.translate(nameWidth, 0);
            this.seqPanel.getSeqPainter().drawPanel(graphics, startX, endX, startY, endY, 0);
            graphics.translate(-nameWidth, absHeight);
        } else {
            SequenceOrderer seqOrderer = new SequenceOrderer(this.viewProps.getAlObj(), this.s3detobj);
            SequenceImpl[] sequences = seqOrderer.getClusterSequences();
            for (int i = startY; i < endY; ++i) {
                SequenceImpl sequence = sequences[i];
                this.namePanel.getNameRenderer().drawName((Graphics2D)graphics, sequence, 0, (i - startY) * this.viewProps.getCharHeight(), sequence.getClusterColor());
            }
            graphics.setFont(this.viewProps.getFont());
            graphics.translate(nameWidth, 0);
            this.seqPanel.getSeqPainter().setExport(true);
            this.seqPanel.getSeqPainter().drawPanel(graphics, startX, endX, startY, endY, 0);
            graphics.translate(-nameWidth, absHeight);
            this.seqPanel.getSeqPainter().setExport(false);
        }
        return 0;
    }

    public JScrollBar getHorizontalScrollbar() {
        return this.horizontalScrollbar;
    }

    public void setHorizontalScrollbar(JScrollBar horizontalScrollbar) {
        this.horizontalScrollbar = horizontalScrollbar;
    }

    public JScrollBar getVerticalScrollbar() {
        return this.verticalScrollbar;
    }

    public void setVerticalScrollbar(JScrollBar verticalScrollbar) {
        this.verticalScrollbar = verticalScrollbar;
    }

    public class ScrollAdjuster
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            int oldX = AlignPanel.this.viewProps.getXStart();
            int oldY = AlignPanel.this.viewProps.getYStart();
            if (evt.getSource() == AlignPanel.this.verticalScrollbar) {
                int y = AlignPanel.this.verticalScrollbar.getValue();
                AlignPanel.this.viewProps.setYStart(y);
                int yQuot = AlignPanel.this.seqPanel.getSeqPainter().getHeight() / AlignPanel.this.viewProps.getCharHeight();
                if (y + yQuot <= AlignPanel.this.viewProps.getAlObj().getHeight()) {
                    AlignPanel.this.viewProps.setYEnd(y + yQuot);
                } else {
                    AlignPanel.this.viewProps.setYEnd(AlignPanel.this.viewProps.getAlObj().getHeight());
                }
            }
            if (evt.getSource() == AlignPanel.this.horizontalScrollbar) {
                int x = AlignPanel.this.horizontalScrollbar.getValue();
                AlignPanel.this.viewProps.setXStart(x);
                AlignPanel.this.viewProps.setXEnd(x + AlignPanel.this.seqPanel.getSeqPainter().getWidth() / AlignPanel.this.viewProps.getCharWidth());
            }
            int scrollX = AlignPanel.this.viewProps.getXStart() - oldX;
            int scrollY = AlignPanel.this.viewProps.getYStart() - oldY;
            if (scrollX > AlignPanel.this.viewProps.getXEnd() - AlignPanel.this.viewProps.getXStart()) {
                scrollX = AlignPanel.this.viewProps.getXEnd() - AlignPanel.this.viewProps.getXStart();
            } else if (scrollX < AlignPanel.this.viewProps.getXStart() - AlignPanel.this.viewProps.getXEnd()) {
                scrollX = AlignPanel.this.viewProps.getXStart() - AlignPanel.this.viewProps.getXEnd();
            }
            if (scrollY > AlignPanel.this.viewProps.getYEnd() - AlignPanel.this.viewProps.getYStart()) {
                scrollY = AlignPanel.this.viewProps.getYEnd() - AlignPanel.this.viewProps.getYStart();
            } else if (scrollY < AlignPanel.this.viewProps.getYStart() - AlignPanel.this.viewProps.getYEnd()) {
                scrollY = AlignPanel.this.viewProps.getYStart() - AlignPanel.this.viewProps.getYEnd();
            }
            if (scrollX != 0 || scrollY != 0) {
                AlignPanel.this.seqPanel.getSeqPainter().scrollPainting(scrollX, scrollY);
                AlignPanel.this.namePanel.getNameRenderer().scrollPainting(scrollX, scrollY);
                AlignPanel.this.indexPanel.repaint();
                AlignPanel.this.methodPanel.repaint();
            }
        }
    }
}

