/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import model.AlignObject;
import model.Methods;
import model.S3DetObject;
import model.SequenceImpl;
import model.UDMObject;
import model.XDetObject;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.skin.BusinessBlackSteelSkin;
import parser.MfaParser;
import parser.S3DetParser;
import parser.XDetParser;
import util.AlignmentExporter;
import util.ColorScheme;
import util.Constants;
import util.FileDrop;
import util.FilterAlignment;
import util.PluginLoader;
import util.ResidueSelectionManager;
import util.RunMethods;
import util.ScreenConfig;
import util.SelectionManager;
import util.SequenceLogo;
import util.SequenceManager;
import view.AlignPanel;
import view.AlignViewProps;
import view.Cluster3DFrame;
import view.LoadAlignFrame;
import view.LoadMethodFrame;
import view.LoadS3DetFrame;
import view.LoadStructureFrame;
import view.LoadXDetFrame;
import view.NamePainter;
import view.SelectionFrame;
import view.SequencePainter;
import view.StatusPanel;

public class AlignFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private AlignViewProps viewProps;
    private AlignPanel alignPanel;
    private Methods methods;
    private JMenuItem loadAlignmentItem;
    private JMenuItem exitMenuItem;
    private AlignFrame alignFrame;
    private JMenuItem exportMenuItem;
    private JMenuItem saveAlignmentItem;
    private AlignObject alObj;
    private JMenuItem loadMethodItem;
    private JMenuItem loadS3DetItem;
    private JMenuItem loadStructureItem;
    private JMenuItem loadClusterItem;
    private JMenuItem loadXDetItem;
    private JMenu loadMethodMenu;
    private JMenu saveMethodMenu;
    private JMenuItem saveS3DetItem;
    private JMenuItem saveXDetItem;
    private SequencePainter seqPainter;
    private NamePainter namePainter;
    private StatusPanel statusPnl;
    private JMenu selectMethodItem;
    private JMenuItem selectEntropyItem;
    private JMenuItem selectXDetItem;
    private JMenuItem selectS3Item;
    private JMenuItem filterAlignment;
    private JMenu runMethodMenu;
    private JMenuItem runXDetItem;
    private JMenuItem runS3DetItem;
    private JMenu selectUdm;
    private JMenuItem[] selectUdmItems;
    private JMenuItem unselectResiduesItem;
    private JMenuItem unselectProteinsItem;
    private JMenuItem exportFastaItem;
    private JMenuItem showSelectionItem;
    private JMenuItem sequenceLogoItem;
    private JMenuItem dualLogoItem;
    private JMenuItem clusterLogoItem;
    private JMenuItem manualMenuItem;
    private JMenuItem tutorialMenuItem;
    private JMenuItem aboutMenuItem;
    private JCheckBoxMenuItem defaultColorItem;
    private JCheckBoxMenuItem mwColorItem;
    private JCheckBoxMenuItem polgColorItem;
    private JCheckBoxMenuItem hdfColorItem;
    private JCheckBoxMenuItem userDefColorItem;
    private JCheckBoxMenuItem paletteRgbItem;
    private JCheckBoxMenuItem paletteRbItem;
    private Vector<JCheckBoxMenuItem> colorSchemeItems;
    private Vector<JCheckBoxMenuItem> colorPaletteItems;
    private JPanel buttonBar;
    public static boolean jarMode = true;
    JButton addGapButton;
    JButton removeGapButton;
    int gapId = 0;

    public AlignFrame() {
        super("JDet 1.4.10 (2025/12/09)");
        this.setSize(new Dimension(1100, 650));
        this.alignFrame = this;
        this.alignPanel = new AlignPanel(this);
        this.statusPnl = new StatusPanel();
        SelectionManager.setUpperSelectionOn(false);
        Container cp = this.getContentPane();
        try {
            AlignFrame.getImageIcon("img/add.png");
        }
        catch (Exception e) {
            jarMode = false;
        }
        this.constructButtonBar();
        cp.add((Component)this.alignPanel, "Center");
        cp.add((Component)this.statusPnl, "South");
        this.constructMenu();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.pack();
        new FileDrop(System.out, this.alignPanel, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                for (int i = 0; i < files.length; ++i) {
                    try {
                        AlignFrame.this.processDroppedFile(files[i].getCanonicalPath());
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        SequenceManager.emptySelectedSequences();
        SelectionManager.emptyCurrentSelection();
        ResidueSelectionManager.emptyCurrentSelection();
        ScreenConfig.centerInScreen(this);
        this.setVisible(true);
    }

    public AlignFrame(AlignObject alObj, Methods methods, int width, int height, boolean clearSelection) {
        super("JDet 1.4.10 (2025/12/09)");
        this.setSize(new Dimension(width, height));
        this.alignFrame = this;
        this.methods = methods;
        if (methods.getMethodNumber() > 0) {
            SelectionManager.setUpperSelectionOn(true);
        }
        this.alObj = alObj;
        this.viewProps = new AlignViewProps(alObj);
        this.alignPanel = new AlignPanel(this, this.viewProps);
        this.seqPainter = this.alignPanel.getSeqPanel().getSeqPainter();
        this.namePainter = this.alignPanel.getNamePanel().getNameRenderer();
        this.statusPnl = new StatusPanel(this.viewProps);
        Container cp = this.getContentPane();
        try {
            AlignFrame.getImageIcon("img/add.png");
        }
        catch (Exception e) {
            jarMode = false;
        }
        this.constructButtonBar();
        cp.add((Component)this.alignPanel, "Center");
        cp.add((Component)this.statusPnl, "South");
        this.constructMenu();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.pack();
        new FileDrop(System.out, this.alignPanel, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                for (int i = 0; i < files.length; ++i) {
                    try {
                        AlignFrame.this.processDroppedFile(files[i].getCanonicalPath());
                        System.out.println(files[i].getCanonicalPath() + "\n");
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        if (clearSelection) {
            SequenceManager.emptySelectedSequences();
            SelectionManager.emptyCurrentSelection();
            ResidueSelectionManager.emptyCurrentSelection();
        }
        ScreenConfig.centerInScreen(this);
        this.setVisible(true);
    }

    public void close() {
        System.exit(0);
    }

    private void constructMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenu editMenu = new JMenu("Selection");
        editMenu.setMnemonic('L');
        JMenu colorMenu = new JMenu("Color");
        colorMenu.setMnemonic('O');
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(colorMenu);
        menuBar.add(helpMenu);
        this.loadAlignmentItem = new JMenuItem();
        this.filterAlignment = new JMenuItem();
        this.loadS3DetItem = new JMenuItem();
        this.loadXDetItem = new JMenuItem();
        this.loadMethodItem = new JMenuItem();
        this.runS3DetItem = new JMenuItem();
        this.runXDetItem = new JMenuItem();
        this.saveXDetItem = new JMenuItem();
        this.saveS3DetItem = new JMenuItem();
        this.loadStructureItem = new JMenuItem();
        this.loadClusterItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.saveAlignmentItem = new JMenuItem();
        this.loadAlignmentItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.loadAlignmentItem.setMnemonic('N');
        this.loadAlignmentItem.setText("Load Alignment");
        this.loadAlignmentItem.setToolTipText("Loads a new alignment");
        this.loadAlignmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadAlignFrame(AlignFrame.this.alignFrame);
            }
        });
        fileMenu.add(this.loadAlignmentItem);
        this.filterAlignment.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.filterAlignment.setMnemonic('T');
        this.filterAlignment.setText("Filter Alignment");
        this.filterAlignment.setToolTipText("Filter Alignment");
        this.filterAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new FilterAlignment(AlignFrame.this.alignFrame, AlignFrame.this.viewProps);
            }
        });
        fileMenu.add(this.filterAlignment);
        this.saveAlignmentItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.saveAlignmentItem.setMnemonic('S');
        this.saveAlignmentItem.setText("Save Alignment");
        this.saveAlignmentItem.setToolTipText("Export the alignment as FASTA File");
        this.saveAlignmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportFasta(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, evt, false);
            }
        });
        fileMenu.add(this.saveAlignmentItem);
        fileMenu.addSeparator();
        this.loadMethodMenu = new JMenu("Load Method Result");
        this.loadMethodMenu.setToolTipText("Load Method Result");
        fileMenu.add(this.loadMethodMenu);
        this.loadXDetItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.loadXDetItem.setMnemonic('D');
        this.loadXDetItem.setText("XDet");
        this.loadXDetItem.setToolTipText("Load XDet Method");
        this.loadXDetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadXDetFrame(AlignFrame.this.alignFrame);
            }
        });
        this.loadMethodMenu.add(this.loadXDetItem);
        this.loadS3DetItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.loadS3DetItem.setMnemonic('3');
        this.loadS3DetItem.setText("S3Det");
        this.loadS3DetItem.setToolTipText("Load S3Det Method");
        this.loadS3DetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadS3DetFrame(AlignFrame.this.alignFrame);
            }
        });
        this.loadMethodMenu.add(this.loadS3DetItem);
        this.loadMethodItem.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.loadMethodItem.setMnemonic('U');
        this.loadMethodItem.setText("User Defined");
        this.loadMethodItem.setToolTipText("Load User Defined Method");
        this.loadMethodItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadMethodFrame(AlignFrame.this.alignFrame);
            }
        });
        this.loadMethodMenu.add(this.loadMethodItem);
        if (PluginLoader.getPlugins(1).size() != 0) {
            JMenu conversionPluginsMenu = new JMenu("Plugins");
            for (String pluginName : PluginLoader.getPlugins(2)) {
                JMenuItem loadPluginItem = new JMenuItem(pluginName);
                loadPluginItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PluginLoader.loadConversionPlugin(((JMenuItem)evt.getSource()).getText(), AlignFrame.this.alObj, AlignFrame.this.alignFrame);
                    }
                });
                conversionPluginsMenu.add(loadPluginItem);
            }
            this.loadMethodMenu.add(conversionPluginsMenu);
            if (this.alObj == null) {
                conversionPluginsMenu.setEnabled(false);
            }
        }
        this.runMethodMenu = new JMenu("Run Method");
        this.runMethodMenu.setToolTipText("Run Method");
        fileMenu.add(this.runMethodMenu);
        this.runXDetItem.setText("XDet");
        this.runXDetItem.setToolTipText("Run XDet Method");
        this.runXDetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new RunMethods(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, "Xdet");
            }
        });
        this.runMethodMenu.add(this.runXDetItem);
        this.runS3DetItem.setText("S3Det");
        this.runS3DetItem.setToolTipText("Run S3Det Method");
        this.runS3DetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new RunMethods(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, "S3Det");
            }
        });
        this.runMethodMenu.add(this.runS3DetItem);
        if (PluginLoader.getPlugins(1).size() != 0) {
            JMenu pluginsMenu = new JMenu("Plugins");
            for (String pluginName : PluginLoader.getPlugins(1)) {
                JMenuItem runPluginItem = new JMenuItem(pluginName);
                runPluginItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PluginLoader.loadMethodPlugin(((JMenuItem)evt.getSource()).getText(), AlignFrame.this.alObj, AlignFrame.this.alignFrame);
                    }
                });
                pluginsMenu.add(runPluginItem);
            }
            this.runMethodMenu.add(pluginsMenu);
            if (this.alObj == null) {
                pluginsMenu.setEnabled(false);
            }
        }
        this.saveMethodMenu = new JMenu("Save Method Result");
        this.saveMethodMenu.setToolTipText("Save Method Result");
        fileMenu.add(this.saveMethodMenu);
        this.saveXDetItem.setText("XDet");
        this.saveXDetItem.setToolTipText("Save XDet Method");
        this.saveXDetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportMethodFile(AlignFrame.this.alignFrame, evt, "xdet");
            }
        });
        this.saveMethodMenu.add(this.saveXDetItem);
        if (this.methods != null && !this.methods.isxDetUsed()) {
            this.saveXDetItem.setEnabled(false);
        }
        this.saveS3DetItem.setText("S3Det");
        this.saveS3DetItem.setToolTipText("Save S3Det Method");
        this.saveS3DetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportMethodFile(AlignFrame.this.alignFrame, evt, "S3Det");
            }
        });
        this.saveMethodMenu.add(this.saveS3DetItem);
        if (this.methods != null && !this.methods.isS3DetUsed()) {
            this.saveS3DetItem.setEnabled(false);
        }
        if (this.methods != null && !this.methods.isS3DetUsed() && !this.methods.isxDetUsed()) {
            this.saveMethodMenu.setEnabled(false);
        }
        fileMenu.addSeparator();
        this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.exportMenuItem.setMnemonic('E');
        this.exportMenuItem.setText("Export PNG File");
        this.exportMenuItem.setToolTipText("Export the alignment as PNG File");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportPNGFile(AlignFrame.this.alignFrame, evt);
            }
        });
        fileMenu.add(this.exportMenuItem);
        fileMenu.addSeparator();
        this.loadStructureItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.loadStructureItem.setMnemonic('P');
        this.loadStructureItem.setText("Load Stucture (PDB)");
        this.loadStructureItem.setToolTipText("Load Stucture (PDB)");
        this.loadStructureItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame.setDefaultLookAndFeelDecorated(true);
                        SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                        new LoadStructureFrame(AlignFrame.this.viewProps, AlignFrame.this.seqPainter, AlignFrame.this.namePainter, AlignFrame.this.alignFrame.getAlignPanel(), AlignFrame.this.alignFrame);
                    }
                });
            }
        });
        fileMenu.add(this.loadStructureItem);
        this.loadClusterItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.loadClusterItem.setMnemonic('C');
        this.loadClusterItem.setText("Show Sequence Spaces");
        this.loadClusterItem.setToolTipText("Show Sequence Spaces");
        this.loadClusterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Cluster3DFrame(AlignFrame.this.alignFrame.getMethods().getS3DetObject(), AlignFrame.this.viewProps, AlignFrame.this.seqPainter);
                    }
                });
            }
        });
        if (this.methods != null && !this.methods.isS3DetUsed()) {
            this.loadClusterItem.setEnabled(false);
        }
        fileMenu.add(this.loadClusterItem);
        if (this.alObj == null) {
            this.filterAlignment.setEnabled(false);
            this.saveAlignmentItem.setEnabled(false);
            this.loadClusterItem.setEnabled(false);
            this.loadMethodMenu.setEnabled(false);
            this.runMethodMenu.setEnabled(false);
            this.saveMethodMenu.setEnabled(false);
            this.loadStructureItem.setEnabled(false);
            this.loadClusterItem.setEnabled(false);
            this.exportMenuItem.setEnabled(false);
        }
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.setToolTipText("Exit jDet");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignFrame.this.close();
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(this.exitMenuItem);
        this.selectMethodItem = new JMenu();
        this.unselectResiduesItem = new JMenuItem();
        this.unselectProteinsItem = new JMenuItem();
        this.exportFastaItem = new JMenuItem();
        this.showSelectionItem = new JMenuItem();
        this.sequenceLogoItem = new JMenuItem();
        this.dualLogoItem = new JMenuItem();
        this.clusterLogoItem = new JMenuItem();
        this.selectMethodItem.setText("Selection from method");
        this.selectMethodItem.setToolTipText("Get selection from method ");
        this.selectEntropyItem = new JMenuItem();
        this.selectEntropyItem.setText("Entropy");
        this.selectEntropyItem.setToolTipText("Get selection from Entropy");
        this.selectEntropyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignFrame.this.selectEntropyItems(0);
            }
        });
        this.selectMethodItem.add(this.selectEntropyItem);
        if (this.methods != null && this.methods.isEntropyUsed()) {
            this.selectEntropyItem.setEnabled(true);
        } else {
            this.selectEntropyItem.setEnabled(false);
        }
        this.selectXDetItem = new JMenuItem();
        this.selectXDetItem.setText("XDet");
        this.selectXDetItem.setToolTipText("Get selection from XDet");
        this.selectXDetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignFrame.this.selectXDetItems(0);
            }
        });
        this.selectMethodItem.add(this.selectXDetItem);
        if (this.methods != null && this.methods.isxDetUsed()) {
            this.selectXDetItem.setEnabled(true);
        } else {
            this.selectXDetItem.setEnabled(false);
        }
        this.selectS3Item = new JMenuItem();
        this.selectS3Item.setText("S3");
        this.selectS3Item.setToolTipText("Get selection from S3");
        this.selectS3Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignFrame.this.selectS3DetItems(0);
            }
        });
        if (this.methods != null && this.methods.isS3DetUsed()) {
            this.selectS3Item.setEnabled(true);
        } else {
            this.selectS3Item.setEnabled(false);
        }
        this.selectMethodItem.add(this.selectS3Item);
        if (this.methods != null && (this.methods.isS3DetUsed() || this.methods.isEntropyUsed() || this.methods.isxDetUsed() || this.methods.getUdmNumber() > 0)) {
            this.selectMethodItem.setEnabled(true);
        } else {
            this.selectMethodItem.setEnabled(false);
        }
        editMenu.add(this.selectMethodItem);
        this.selectUdm = new JMenu();
        this.selectUdm.setText("User Defined");
        if (this.methods != null && this.methods.getUdmNumber() > 0) {
            this.selectUdmItems = new JMenuItem[this.methods.getUdmNumber()];
            for (int j = 0; j < this.methods.getUdmNumber(); ++j) {
                this.selectUdmItems[j] = new JMenuItem();
                this.selectUdmItems[j].setText(this.methods.getUdmObjects()[j].getMethodName());
                this.selectUdmItems[j].setToolTipText("Get selection from " + this.methods.getUdmObjects()[j].getMethodName());
                this.selectUdmItems[j].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JMenuItem source = (JMenuItem)evt.getSource();
                        AlignFrame.this.selectUserDefItems(source.getToolTipText(), 0);
                    }
                });
                this.selectUdm.add(this.selectUdmItems[j]);
            }
            this.selectUdm.setEnabled(true);
        } else {
            this.selectUdm.setEnabled(false);
        }
        this.selectMethodItem.add(this.selectUdm);
        this.unselectProteinsItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.unselectProteinsItem.setMnemonic('T');
        this.unselectProteinsItem.setText("Unselect Proteins");
        this.unselectProteinsItem.setToolTipText("Clear the current selection");
        this.unselectProteinsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceManager.emptySelectedSequences();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        if (this.alObj == null) {
            this.unselectProteinsItem.setEnabled(false);
        }
        editMenu.add(this.unselectProteinsItem);
        this.unselectResiduesItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.unselectResiduesItem.setMnemonic('R');
        this.unselectResiduesItem.setText("Unselect Residues");
        this.unselectResiduesItem.setToolTipText("Clear the current selection");
        this.unselectResiduesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionManager.emptyCurrentSelection();
                ResidueSelectionManager.emptyCurrentSelection();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        if (this.alObj == null) {
            this.unselectResiduesItem.setEnabled(false);
        }
        editMenu.add(this.unselectResiduesItem);
        editMenu.addSeparator();
        this.exportFastaItem.setAccelerator(KeyStroke.getKeyStroke(86, 8));
        this.exportFastaItem.setMnemonic('V');
        this.exportFastaItem.setText("Export as fasta");
        this.exportFastaItem.setToolTipText("Export selection as fasta");
        this.exportFastaItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportFasta(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, evt, true);
            }
        });
        if (this.alObj == null) {
            this.exportFastaItem.setEnabled(false);
        }
        editMenu.add(this.exportFastaItem);
        this.showSelectionItem.setAccelerator(KeyStroke.getKeyStroke(87, 8));
        this.showSelectionItem.setMnemonic('W');
        this.showSelectionItem.setText("Show selection");
        this.showSelectionItem.setToolTipText("Show selection in new window");
        this.showSelectionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SelectionFrame(AlignFrame.this.viewProps, AlignFrame.this.alignFrame.getMethods().getS3DetObject());
            }
        });
        if (this.alObj == null) {
            this.showSelectionItem.setEnabled(false);
        }
        editMenu.add(this.showSelectionItem);
        this.sequenceLogoItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        this.sequenceLogoItem.setMnemonic('Q');
        this.sequenceLogoItem.setText("Sequence logo");
        this.sequenceLogoItem.setToolTipText("Create sequence logo from selection");
        this.sequenceLogoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SequenceLogo(AlignFrame.this.viewProps);
            }
        });
        if (this.alObj == null) {
            this.sequenceLogoItem.setEnabled(false);
        }
        editMenu.add(this.sequenceLogoItem);
        this.dualLogoItem.setText("Selection Vs Complementary logo");
        this.dualLogoItem.setToolTipText("Create sequence for selection vs complementary set.");
        this.dualLogoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SequenceManager.isEmpty()) {
                    new SequenceLogo(AlignFrame.this.viewProps);
                } else {
                    new SequenceLogo(AlignFrame.this.viewProps, true);
                }
            }
        });
        if (this.alObj == null) {
            this.dualLogoItem.setEnabled(false);
        }
        editMenu.add(this.dualLogoItem);
        this.clusterLogoItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.clusterLogoItem.setMnemonic('B');
        this.clusterLogoItem.setText("Subfamilies logo");
        this.clusterLogoItem.setToolTipText("Create logo independently for subfamilies");
        this.clusterLogoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SequenceLogo(AlignFrame.this.viewProps, AlignFrame.this.methods.getS3DetObject());
            }
        });
        if (this.methods != null && this.methods.isS3DetUsed()) {
            this.clusterLogoItem.setEnabled(true);
        } else {
            this.clusterLogoItem.setEnabled(false);
        }
        editMenu.add(this.clusterLogoItem);
        this.colorSchemeItems = new Vector();
        this.defaultColorItem = new JCheckBoxMenuItem();
        this.colorSchemeItems.add(this.defaultColorItem);
        this.mwColorItem = new JCheckBoxMenuItem();
        this.colorSchemeItems.add(this.mwColorItem);
        this.polgColorItem = new JCheckBoxMenuItem();
        this.colorSchemeItems.add(this.polgColorItem);
        this.hdfColorItem = new JCheckBoxMenuItem();
        this.colorSchemeItems.add(this.hdfColorItem);
        this.userDefColorItem = new JCheckBoxMenuItem();
        this.colorSchemeItems.add(this.userDefColorItem);
        this.colorPaletteItems = new Vector();
        this.paletteRgbItem = new JCheckBoxMenuItem();
        this.colorPaletteItems.add(this.paletteRgbItem);
        this.paletteRbItem = new JCheckBoxMenuItem();
        this.colorPaletteItems.add(this.paletteRbItem);
        this.defaultColorItem.setText("ClustalX (default)");
        this.defaultColorItem.setToolTipText("Set ClustalX color scheme");
        this.defaultColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorScheme("ClustalX");
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.mwColorItem.setText("Molecular weight");
        this.mwColorItem.setToolTipText("Set Molecular weight color scheme");
        this.mwColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorScheme("Molecular weight");
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.polgColorItem.setText("Polarity");
        this.polgColorItem.setToolTipText("Set Polarity color scheme");
        this.polgColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorScheme("Polarity");
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.hdfColorItem.setText("Hidrophobicity");
        this.hdfColorItem.setToolTipText("Set Hidrophobicity color scheme");
        this.hdfColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorScheme("Hidrophobicity");
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.userDefColorItem.setText("User defined");
        this.userDefColorItem.setToolTipText("Load user defined color scheme");
        this.userDefColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ColorScheme.loadColorScheme(AlignFrame.this.alignFrame)) {
                    AlignFrame.this.seqPainter.repaint();
                    AlignFrame.this.seqPainter.notifyObservers();
                }
                AlignFrame.this.checkSelectedColor();
            }
        });
        this.paletteRgbItem.setText("RGB scale");
        this.paletteRgbItem.setToolTipText("Load red-green-blue scale");
        this.paletteRgbItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorPalette(0);
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.paletteRbItem.setText("RB scale");
        this.paletteRbItem.setToolTipText("Load redblue scale");
        this.paletteRbItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorScheme.setColorPalette(1);
                AlignFrame.this.checkSelectedColor();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        ColorScheme.init();
        if (this.alObj == null) {
            this.defaultColorItem.setEnabled(false);
            this.mwColorItem.setEnabled(false);
            this.polgColorItem.setEnabled(false);
            this.hdfColorItem.setEnabled(false);
            this.userDefColorItem.setEnabled(false);
            this.paletteRgbItem.setEnabled(false);
            this.paletteRbItem.setEnabled(false);
        } else {
            this.checkSelectedColor();
        }
        colorMenu.add(this.defaultColorItem);
        colorMenu.add(this.mwColorItem);
        colorMenu.add(this.polgColorItem);
        colorMenu.add(this.hdfColorItem);
        colorMenu.add(this.userDefColorItem);
        colorMenu.addSeparator();
        colorMenu.add(this.paletteRgbItem);
        colorMenu.add(this.paletteRbItem);
        this.manualMenuItem = new JMenuItem();
        this.tutorialMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.manualMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 8));
        this.manualMenuItem.setText("User manual");
        this.manualMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    URI uri = new URI("file://" + Constants.MANUAL_PATH);
                    desktop.browse(uri);
                }
                catch (Exception e) {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                        try {
                            Runtime.getRuntime().exec("start " + Constants.MANUAL_PATH);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Web browser couldn't be opened. \nPlease, manually open the " + Constants.MANUAL_PATH + " file.", "Web browser couldn't be opened.", 0);
                        }
                    }
                    JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Web browser couldn't be opened. \nPlease, manually open the " + Constants.MANUAL_PATH + " file.", "Web browser couldn't be opened.", 0);
                }
            }
        });
        helpMenu.add(this.manualMenuItem);
        this.tutorialMenuItem.setText("Tutorial");
        this.tutorialMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Desktop desktop = Desktop.getDesktop();
                    URI uri = new URI("file://" + Constants.TUTORIAL_PATH);
                    desktop.browse(uri);
                }
                catch (Exception e) {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                        try {
                            Runtime.getRuntime().exec("start " + Constants.TUTORIAL_PATH);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Web browser couldn't be opened. \nPlease, manually open the " + Constants.TUTORIAL_PATH + " file.", "Web browser couldn't be opened.", 0);
                        }
                    }
                    JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Web browser couldn't be opened. \nPlease, manually open the " + Constants.TUTORIAL_PATH + " file.", "Web browser couldn't be opened.", 0);
                }
            }
        });
        helpMenu.add(this.tutorialMenuItem);
        helpMenu.addSeparator();
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignFrame.this.aboutTriggered();
            }
        });
        helpMenu.add(this.aboutMenuItem);
        this.setJMenuBar(menuBar);
    }

    private void checkSelectedColor() {
        int i;
        ColorScheme.updatePaletteImage(this.statusPnl.getColorPalette());
        this.statusPnl.repaint();
        for (i = 0; i < this.colorSchemeItems.size(); ++i) {
            if (i == ColorScheme.getColorScheme()) {
                this.colorSchemeItems.get(i).setSelected(true);
                continue;
            }
            this.colorSchemeItems.get(i).setSelected(false);
        }
        if (ColorScheme.getColorSchemeNames() == null || ColorScheme.getColorScheme() == ColorScheme.getColorSchemeNames().indexOf("ClustalX")) {
            for (i = 0; i < this.colorPaletteItems.size(); ++i) {
                this.colorPaletteItems.get(i).setEnabled(false);
                this.colorPaletteItems.get(i).setSelected(false);
            }
        } else {
            for (i = 0; i < this.colorPaletteItems.size(); ++i) {
                this.colorPaletteItems.get(i).setEnabled(true);
                if (i == ColorScheme.getColorPalette()) {
                    this.colorPaletteItems.get(i).setSelected(true);
                    continue;
                }
                this.colorPaletteItems.get(i).setSelected(false);
            }
        }
    }

    private void constructButtonBar() {
        this.buttonBar = new JPanel();
        this.buttonBar.setLayout(new FormLayout("2dlu, p, 2dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, 10dlu, p, 10dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 10dlu, p, 2dlu, p", "30px"));
        CellConstraints cc = new CellConstraints();
        ImageIcon loadAlignmentIcon = AlignFrame.getImageIcon("img/align.png");
        JButton loadAlignmentButton = new JButton(loadAlignmentIcon);
        loadAlignmentButton.setToolTipText("Load Alignment");
        loadAlignmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadAlignFrame(AlignFrame.this.alignFrame);
            }
        });
        this.buttonBar.add((Component)loadAlignmentButton, cc.xy(2, 1));
        ImageIcon filterAlignmentIcon = AlignFrame.getImageIcon("img/filteralign.png");
        JButton filterAlignmentButton = new JButton(filterAlignmentIcon);
        filterAlignmentButton.setToolTipText("Filter Alignment");
        filterAlignmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new FilterAlignment(AlignFrame.this.alignFrame, AlignFrame.this.viewProps);
            }
        });
        this.buttonBar.add((Component)filterAlignmentButton, cc.xy(4, 1));
        ImageIcon saveAlignmentIcon = AlignFrame.getImageIcon("img/savealign.png");
        JButton saveAlignmentButton = new JButton(saveAlignmentIcon);
        saveAlignmentButton.setToolTipText("Save Alignment");
        saveAlignmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportFasta(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, evt, false);
            }
        });
        this.buttonBar.add((Component)saveAlignmentButton, cc.xy(6, 1));
        ImageIcon loadXDetIcon = AlignFrame.getImageIcon("img/xdet.png");
        JButton loadXDetButton = new JButton(loadXDetIcon);
        loadXDetButton.setToolTipText("Load XDet Method");
        loadXDetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadXDetFrame(AlignFrame.this.alignFrame);
            }
        });
        this.buttonBar.add((Component)loadXDetButton, cc.xy(8, 1));
        ImageIcon loadS3DetIcon = AlignFrame.getImageIcon("img/s3det.png");
        JButton loadS3DetButton = new JButton(loadS3DetIcon);
        loadS3DetButton.setToolTipText("Load S3Det Method");
        loadS3DetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadS3DetFrame(AlignFrame.this.alignFrame);
            }
        });
        this.buttonBar.add((Component)loadS3DetButton, cc.xy(10, 1));
        ImageIcon loadMethodIcon = AlignFrame.getImageIcon("img/userdef.png");
        JButton loadMethodButton = new JButton(loadMethodIcon);
        loadMethodButton.setToolTipText("Load User Defined Method");
        loadMethodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new LoadMethodFrame(AlignFrame.this.alignFrame);
            }
        });
        this.buttonBar.add((Component)loadMethodButton, cc.xy(12, 1));
        ImageIcon runXDetIcon = AlignFrame.getImageIcon("img/run_xdet.png");
        JButton runXDetButton = new JButton(runXDetIcon);
        runXDetButton.setToolTipText("Run XDet on current alignment.");
        runXDetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new RunMethods(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, "Xdet");
            }
        });
        this.buttonBar.add((Component)runXDetButton, cc.xy(14, 1));
        ImageIcon runS3DetIcon = AlignFrame.getImageIcon("img/run_s3det.png");
        JButton runS3DetButton = new JButton(runS3DetIcon);
        runS3DetButton.setToolTipText("Run S3Det on current alignment.");
        runS3DetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new RunMethods(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, "S3Det");
            }
        });
        this.buttonBar.add((Component)runS3DetButton, cc.xy(16, 1));
        ImageIcon saveXDetIcon = AlignFrame.getImageIcon("img/save_xdet.png");
        JButton saveXDetButton = new JButton(saveXDetIcon);
        saveXDetButton.setToolTipText("Save XDet results.");
        saveXDetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportMethodFile(AlignFrame.this.alignFrame, evt, "xdet");
            }
        });
        this.buttonBar.add((Component)saveXDetButton, cc.xy(18, 1));
        ImageIcon saveS3DetIcon = AlignFrame.getImageIcon("img/save_s3det.png");
        JButton saveS3DetButton = new JButton(saveS3DetIcon);
        saveS3DetButton.setToolTipText("Save S3Det results.");
        saveS3DetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportMethodFile(AlignFrame.this.alignFrame, evt, "S3Det");
            }
        });
        this.buttonBar.add((Component)saveS3DetButton, cc.xy(20, 1));
        ImageIcon exportIcon = AlignFrame.getImageIcon("img/export.png");
        JButton exportButton = new JButton(exportIcon);
        exportButton.setToolTipText("Export the alignment as PNG File");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportPNGFile(AlignFrame.this.alignFrame, evt);
            }
        });
        this.buttonBar.add((Component)exportButton, cc.xy(22, 1));
        ImageIcon loadStructureIcon = AlignFrame.getImageIcon("img/structure.png");
        JButton loadStructureButton = new JButton(loadStructureIcon);
        loadStructureButton.setToolTipText("Load Stucture (PDB)");
        loadStructureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame.setDefaultLookAndFeelDecorated(true);
                        SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                        new LoadStructureFrame(AlignFrame.this.viewProps, AlignFrame.this.seqPainter, AlignFrame.this.namePainter, AlignFrame.this.alignFrame.getAlignPanel(), AlignFrame.this.alignFrame);
                    }
                });
            }
        });
        this.buttonBar.add((Component)loadStructureButton, cc.xy(24, 1));
        ImageIcon loadClusterIcon = AlignFrame.getImageIcon("img/cluster.png");
        JButton loadClusterButton = new JButton(loadClusterIcon);
        loadClusterButton.setToolTipText("Show Sequence Spaces");
        loadClusterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Cluster3DFrame(AlignFrame.this.alignFrame.getMethods().getS3DetObject(), AlignFrame.this.viewProps, AlignFrame.this.seqPainter);
                    }
                });
            }
        });
        this.buttonBar.add((Component)loadClusterButton, cc.xy(26, 1));
        ImageIcon unselectProteinsIcon = AlignFrame.getImageIcon("img/unselectproteins.png");
        JButton unselectProteinsButton = new JButton(unselectProteinsIcon);
        unselectProteinsButton.setToolTipText("Clear current protein selection");
        unselectProteinsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SequenceManager.emptySelectedSequences();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.buttonBar.add((Component)unselectProteinsButton, cc.xy(28, 1));
        ImageIcon unselectResiduesIcon = AlignFrame.getImageIcon("img/unselectresidues.png");
        JButton unselectResiduesButton = new JButton(unselectResiduesIcon);
        unselectResiduesButton.setToolTipText("Clear current residue selection");
        unselectResiduesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectionManager.emptyCurrentSelection();
                ResidueSelectionManager.emptyCurrentSelection();
                AlignFrame.this.seqPainter.repaint();
                AlignFrame.this.seqPainter.notifyObservers();
            }
        });
        this.buttonBar.add((Component)unselectResiduesButton, cc.xy(30, 1));
        ImageIcon exportFastaIcon = AlignFrame.getImageIcon("img/fasta.png");
        JButton exportFastaButton = new JButton(exportFastaIcon);
        exportFastaButton.setToolTipText("Export selection as fasta");
        exportFastaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignmentExporter.exportFasta(AlignFrame.this.alignFrame, AlignFrame.this.viewProps, evt, true);
            }
        });
        this.buttonBar.add((Component)exportFastaButton, cc.xy(32, 1));
        ImageIcon showSelectionIcon = AlignFrame.getImageIcon("img/showselection.png");
        JButton showSelectionButton = new JButton(showSelectionIcon);
        showSelectionButton.setToolTipText("Show selection in new window");
        showSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SelectionFrame((AlignViewProps)AlignFrame.this.viewProps.clone(), AlignFrame.this.alignFrame.getMethods().getS3DetObject());
            }
        });
        this.buttonBar.add((Component)showSelectionButton, cc.xy(34, 1));
        ImageIcon sequenceLogoIcon = AlignFrame.getImageIcon("img/logos.png");
        JButton sequenceLogoButton = new JButton(sequenceLogoIcon);
        sequenceLogoButton.setToolTipText("Create sequence logo from selection");
        sequenceLogoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SequenceLogo(AlignFrame.this.viewProps);
            }
        });
        this.buttonBar.add((Component)sequenceLogoButton, cc.xy(36, 1));
        ImageIcon dualLogoIcon = AlignFrame.getImageIcon("img/dualLogos.png");
        JButton dualLogoButton = new JButton(dualLogoIcon);
        dualLogoButton.setToolTipText("Create sequence for selection vs complementary set.");
        dualLogoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SequenceManager.isEmpty()) {
                    new SequenceLogo(AlignFrame.this.viewProps);
                } else {
                    new SequenceLogo(AlignFrame.this.viewProps, true);
                }
            }
        });
        this.buttonBar.add((Component)dualLogoButton, cc.xy(38, 1));
        ImageIcon clusterLogoIcon = AlignFrame.getImageIcon("img/clusterLogos.png");
        JButton clusterLogoButton = new JButton(clusterLogoIcon);
        clusterLogoButton.setToolTipText("Create logo independently for subfamilies");
        clusterLogoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SequenceLogo(AlignFrame.this.viewProps, AlignFrame.this.methods.getS3DetObject());
            }
        });
        this.buttonBar.add((Component)clusterLogoButton, cc.xy(40, 1));
        ImageIcon addGapIcon = AlignFrame.getImageIcon("img/addgap.png");
        this.addGapButton = new JButton(addGapIcon);
        this.addGapButton.setToolTipText("Add gap on selected position");
        this.addGapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AlignFrame.this.methods.getMethodNumber() != 0) {
                    if (JOptionPane.showConfirmDialog(AlignFrame.this.alignFrame, "There is a method loaded, to enable alignment modification it will be unloaded. Do you want to continue?") == 0) {
                        AlignFrame.this.alObj.reloadOnlyAlignment(AlignFrame.this.alignFrame);
                    }
                } else if (SelectionManager.getLastSelection() != -1) {
                    int gapPosition = SelectionManager.getLastSelection() - 1;
                    if (!SequenceManager.isEmpty()) {
                        SequenceImpl[] seqs = AlignFrame.this.alignFrame.getAlObj().getSequences();
                        boolean allRemainAreGaps = true;
                        for (SequenceImpl currentSeq : seqs) {
                            if (currentSeq.getLetterAt(gapPosition) == '-' || SequenceManager.getSelectedSequences().contains(currentSeq.getName())) continue;
                            allRemainAreGaps = false;
                        }
                        if (!allRemainAreGaps) {
                            for (int i = 0; i < seqs.length; ++i) {
                                if (SequenceManager.getSelectedSequences().contains(seqs[i].getName())) {
                                    seqs[i].setSequence(seqs[i].getSequenceAsString().substring(0, gapPosition) + "-" + seqs[i].getSequenceAsString().substring(gapPosition));
                                    continue;
                                }
                                seqs[i].setSequence(seqs[i].getSequenceAsString() + "-");
                            }
                        } else {
                            for (int i = 0; i < seqs.length; ++i) {
                                if (SequenceManager.getSelectedSequences().contains(seqs[i].getName())) continue;
                                seqs[i].setSequence(seqs[i].getSequenceAsString().substring(0, gapPosition) + seqs[i].getSequenceAsString().substring(gapPosition + 1) + "-");
                            }
                        }
                        AlignFrame.this.alObj.setSequences(seqs);
                        AlignFrame.this.alObj.clearGaps();
                        AlignFrame.this.statusPnl.updateWidth();
                        AlignFrame.this.seqPainter.repaint();
                        AlignFrame.this.seqPainter.notifyObservers();
                    } else {
                        JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Select at least one sequence to add gaps.", "Unselected sequences.", 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Select a position to add gaps.", "No selection", 1);
                }
            }
        });
        this.buttonBar.add((Component)this.addGapButton, cc.xy(42, 1));
        ImageIcon removeGapIcon = AlignFrame.getImageIcon("img/removegap.png");
        this.removeGapButton = new JButton(removeGapIcon);
        this.removeGapButton.setToolTipText("Remove gap selected position");
        this.removeGapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AlignFrame.this.methods.getMethodNumber() != 0) {
                    if (JOptionPane.showConfirmDialog(AlignFrame.this.alignFrame, "There are method(s) loaded, to enable alignment modification thy will be unloaded. Do you want to continue?") == 0) {
                        AlignFrame.this.alObj.reloadOnlyAlignment(AlignFrame.this.alignFrame);
                    }
                } else if (SelectionManager.getLastSelection() != -1) {
                    int gapPosition = SelectionManager.getLastSelection() - 1;
                    if (!SequenceManager.isEmpty()) {
                        boolean allGaps = true;
                        for (String currentSeq : SequenceManager.getSelectedSequences()) {
                            if (SequenceManager.getSequence(currentSeq, AlignFrame.this.alignFrame.getAlObj()).getLetterAt(gapPosition) == '-') continue;
                            allGaps = false;
                        }
                        SequenceImpl[] seqs = AlignFrame.this.alignFrame.getAlObj().getSequences();
                        if (allGaps) {
                            for (int i = 0; i < seqs.length; ++i) {
                                if (!SequenceManager.getSelectedSequences().contains(seqs[i].getName())) continue;
                                seqs[i].setSequence(seqs[i].getSequenceAsString().substring(0, gapPosition) + seqs[i].getSequenceAsString().substring(gapPosition + 1) + "-");
                            }
                        } else {
                            for (int i = 0; i < seqs.length; ++i) {
                                if (SequenceManager.getSelectedSequences().contains(seqs[i].getName())) {
                                    seqs[i].setSequence(seqs[i].getSequenceAsString() + "-");
                                    continue;
                                }
                                seqs[i].setSequence(seqs[i].getSequenceAsString().substring(0, gapPosition) + "-" + seqs[i].getSequenceAsString().substring(gapPosition));
                            }
                        }
                        AlignFrame.this.alObj.setSequences(seqs);
                        AlignFrame.this.alObj.clearGaps();
                        AlignFrame.this.statusPnl.updateWidth();
                        AlignFrame.this.seqPainter.repaint();
                        AlignFrame.this.seqPainter.notifyObservers();
                    } else {
                        JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Select at least one sequence to remove gaps.", "Unselected sequences", 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(AlignFrame.this.alignFrame, "Select a position to remove gaps.", "No selection", 1);
                }
            }
        });
        this.buttonBar.add((Component)this.removeGapButton, cc.xy(44, 1));
        if (this.alObj == null) {
            saveAlignmentButton.setEnabled(false);
            filterAlignmentButton.setEnabled(false);
            loadXDetButton.setEnabled(false);
            loadS3DetButton.setEnabled(false);
            loadMethodButton.setEnabled(false);
            runXDetButton.setEnabled(false);
            runS3DetButton.setEnabled(false);
            saveXDetButton.setEnabled(false);
            saveS3DetButton.setEnabled(false);
            loadClusterButton.setEnabled(false);
            loadStructureButton.setEnabled(false);
            exportButton.setEnabled(false);
            unselectResiduesButton.setEnabled(false);
            unselectProteinsButton.setEnabled(false);
            exportFastaButton.setEnabled(false);
            showSelectionButton.setEnabled(false);
            sequenceLogoButton.setEnabled(false);
            dualLogoButton.setEnabled(false);
            clusterLogoButton.setEnabled(false);
            this.addGapButton.setEnabled(false);
            this.removeGapButton.setEnabled(false);
        }
        if (this.methods != null && !this.methods.isxDetUsed()) {
            saveXDetButton.setEnabled(false);
        }
        if (this.methods != null && !this.methods.isS3DetUsed()) {
            clusterLogoButton.setEnabled(false);
            loadClusterButton.setEnabled(false);
            saveS3DetButton.setEnabled(false);
        }
        this.getContentPane().add((Component)this.buttonBar, "North");
    }

    public void selectXDetItems(int mode) {
        Vector currentSel = (Vector)SelectionManager.getCurrentSelection().clone();
        if (mode == 0 || mode == 1) {
            SelectionManager.emptyCurrentSelection();
        }
        double xdetThreshold = this.methods.getCurrentXDetCutoff();
        for (int i = 0; i < this.alObj.getWidth(); ++i) {
            if (!this.methods.getxDetObject().getPos2ResMap().containsKey(i) || !(this.methods.getxDetObject().getPos2ResMap().get(i).getCorrelation().doubleValue() >= xdetThreshold)) continue;
            if (mode == 1) {
                if (!currentSel.contains(i)) continue;
                SelectionManager.addToCurrentSelection(i);
                continue;
            }
            SelectionManager.addToCurrentSelection(i);
        }
        this.seqPainter.repaint();
        this.seqPainter.notifyObservers();
    }

    public void selectEntropyItems(int mode) {
        Vector currentSel = (Vector)SelectionManager.getCurrentSelection().clone();
        if (mode == 0 || mode == 1) {
            SelectionManager.emptyCurrentSelection();
        }
        double entropyThreshold = this.methods.getCurrentEntropyCutoff();
        for (int i = 0; i < this.alObj.getWidth(); ++i) {
            if (!this.methods.getxDetObject().getPos2ResMap().containsKey(i) || !(this.methods.getxDetObject().getPos2ResMap().get(i).getEntropy().doubleValue() <= entropyThreshold) || !(this.methods.getxDetObject().getPos2ResMap().get(i).getEntropy().doubleValue() >= 0.0)) continue;
            if (mode == 1) {
                if (!currentSel.contains(i)) continue;
                SelectionManager.addToCurrentSelection(i);
                continue;
            }
            SelectionManager.addToCurrentSelection(i);
        }
        this.seqPainter.repaint();
        this.seqPainter.notifyObservers();
    }

    public void selectS3DetItems(int mode) {
        Vector currentSel = (Vector)SelectionManager.getCurrentSelection().clone();
        if (mode == 0 || mode == 1) {
            SelectionManager.emptyCurrentSelection();
        }
        double s3Threshold = this.methods.getCurrentS3DetCutoff();
        for (int i = 0; i < this.alObj.getWidth(); ++i) {
            if (!this.methods.getS3DetObject().getPos2PredPosition().containsKey(i) || !(this.methods.getS3DetObject().getPos2PredPosition().get(i).getAverageRank().doubleValue() <= s3Threshold)) continue;
            if (mode == 1) {
                if (!currentSel.contains(i)) continue;
                SelectionManager.addToCurrentSelection(i);
                continue;
            }
            SelectionManager.addToCurrentSelection(i);
        }
        this.seqPainter.repaint();
        this.seqPainter.notifyObservers();
    }

    public void selectUserDefItems(String methodName, int mode) {
        int index = 0;
        Vector currentSel = (Vector)SelectionManager.getCurrentSelection().clone();
        if (mode == 0 || mode == 1) {
            SelectionManager.emptyCurrentSelection();
        }
        UDMObject[] udmObjects = this.methods.getUdmObjects();
        for (int i = 0; i < udmObjects.length; ++i) {
            if (!udmObjects[i].getMethodName().equals(methodName)) continue;
            index = i;
        }
        double methodThreshold = this.methods.getUdmObjects()[index].getCurrentScoreCutoff();
        for (int i = 0; i < this.alObj.getWidth(); ++i) {
            if (!this.methods.getUdmObjects()[index].getPos2ResMap().containsKey(i) || !(this.methods.getUdmObjects()[index].isIncreasingScore() && this.methods.getUdmObjects()[index].getPos2ResMap().get(i).getScore().doubleValue() >= methodThreshold) && (this.methods.getUdmObjects()[index].isIncreasingScore() || !(this.methods.getUdmObjects()[index].getPos2ResMap().get(i).getScore().doubleValue() <= methodThreshold))) continue;
            if (mode == 1) {
                if (!currentSel.contains(i)) continue;
                SelectionManager.addToCurrentSelection(i);
                continue;
            }
            SelectionManager.addToCurrentSelection(i);
        }
        this.seqPainter.repaint();
        this.seqPainter.notifyObservers();
    }

    private void aboutTriggered() {
        StringBuffer tMsg = new StringBuffer();
        tMsg.append("JDet 1.4.10 (2025/12/09)");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("JDet is a multiplatform software for the interactive calculation and \nvisualization of function-related conservation patterns in multiple \nsequence alignments and structures.");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("The latest version and info is available at http://csbg.cnb.csic.es/JDet");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("If any questions arise, contact the corresponding authors: ");
        tMsg.append("\n");
        tMsg.append("Thilo.Muth@uni-jena.de\n");
        tMsg.append("ja.garcia@cnb.csic.es");
        tMsg.append("\n");
        tMsg.append("\n");
        tMsg.append("");
        tMsg.append("");
        JOptionPane.showMessageDialog(this, tMsg, "About JDet 1.4.10 (2025/12/09)", 1);
    }

    public void closeOtherWindows() {
        if (this.seqPainter != null) {
            this.seqPainter.closeRegisteredWindows("All");
        }
    }

    public AlignPanel getAlignPanel() {
        return this.alignPanel;
    }

    public Methods getMethods() {
        return this.methods;
    }

    public AlignObject getAlObj() {
        return this.alObj;
    }

    public static ImageIcon getImageIcon(String name) {
        if (jarMode) {
            return new ImageIcon(ClassLoader.getSystemResource(name));
        }
        return new ImageIcon(name);
    }

    public void processDroppedFile(String fileName) {
        if (fileName.endsWith(".mfa") || fileName.endsWith("fasta") || fileName.endsWith("pir") || fileName.endsWith("fas") || fileName.endsWith("fa")) {
            AlignObject alignObject = null;
            MfaParser parser = new MfaParser();
            try {
                if (fileName.length() <= 0) {
                    throw new FileNotFoundException();
                }
                alignObject = parser.read(fileName);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "The alignment file couldn't be loaded! \nPlease specify a proper location/format of the file.\nDetails:\n       " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                return;
            }
            Methods methods = new Methods();
            this.alignFrame.closeOtherWindows();
            this.alignFrame = new AlignFrame(alignObject, methods, 1100, 650, true);
            this.alignFrame.pack();
            this.dispose();
            this.alignFrame.setVisible(true);
            SelectionManager.setEnabled(true);
        } else if (fileName.endsWith(".Xdet")) {
            if (this.alObj != null) {
                XDetParser xdetparser = new XDetParser();
                XDetObject xdetObject = null;
                try {
                    if (fileName.length() > 0) {
                        xdetObject = xdetparser.read(fileName, this.alObj);
                        this.methods.setxDetUsed(true);
                        this.methods.setxDetObject(xdetObject);
                        this.methods.setxDetCutoff(0.6);
                        this.methods.setEntropyUsed(true);
                        this.methods.setEntropyCutoff(2.5);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "The XDet file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                    return;
                }
                this.alignFrame.closeOtherWindows();
                this.alignFrame = new AlignFrame(this.alObj, this.methods, 1100, 650, false);
                this.alignFrame.pack();
                this.dispose();
                this.alignFrame.setVisible(true);
                SelectionManager.setEnabled(true);
            }
        } else if (fileName.endsWith(".S3det") && this.alObj != null) {
            S3DetParser s3detparser = new S3DetParser();
            S3DetObject s3DetObject = null;
            try {
                if (fileName.length() > 0) {
                    s3DetObject = s3detparser.read(fileName, this.alObj);
                    this.methods.setS3DetUsed(true);
                    this.methods.setS3DetObject(s3DetObject);
                    this.methods.setS3DetCutoff(10.0);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "The S3Det file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                return;
            }
            this.alignFrame.closeOtherWindows();
            this.alignFrame = new AlignFrame(this.alObj, this.methods, 1100, 650, false);
            this.alignFrame.pack();
            this.dispose();
            this.alignFrame.setVisible(true);
            SelectionManager.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        PluginLoader.loadPlugins();
        JFrame.setDefaultLookAndFeelDecorated(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SubstanceLookAndFeel.setSkin(new BusinessBlackSteelSkin());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new AlignFrame();
            }
        });
    }
}

