/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.util.HashMap;
import model.AlignObject;
import model.ClusterGroup;
import model.S3DetObject;
import model.SequenceCluster;
import model.SequenceImpl;
import util.Constants;

public class SequenceOrderer {
    private AlignObject alignObj;
    private S3DetObject s3detobj;
    private HashMap<String, Integer> name2clusterMap;

    public SequenceOrderer(AlignObject alignObj, S3DetObject s3detobj) {
        this.alignObj = alignObj;
        this.s3detobj = s3detobj;
    }

    public ClusterGroup[] getClusterGroups() {
        int clusterNumber = this.getClusterNumber(this.s3detobj.getSeqClusters());
        this.name2clusterMap = this.s3detobj.getName2ClusterIndex();
        ClusterGroup[] clusterGroups = new ClusterGroup[clusterNumber];
        clusterGroups[0] = new ClusterGroup();
        SequenceImpl[] sequences = this.alignObj.getSequences();
        SequenceCluster[] seqClusters = this.s3detobj.getSeqClusters();
        for (int i = 0; i < seqClusters.length; ++i) {
            for (SequenceImpl seq : sequences) {
                if (!seq.getName().equals(seqClusters[i].getName())) continue;
                int index = this.name2clusterMap.get(seqClusters[i].getName());
                if (clusterGroups[index] == null) {
                    clusterGroups[index] = new ClusterGroup();
                }
                clusterGroups[index].addSequence(seq);
            }
        }
        for (int j = 0; j < clusterGroups.length; ++j) {
            clusterGroups[j].setColor(Constants.GROUPCOLORS[j % Constants.GROUPCOLORS.length]);
        }
        return clusterGroups;
    }

    public SequenceImpl[] getClusterSequences() {
        ClusterGroup[] clusterGroups = this.getClusterGroups();
        SequenceImpl[] clusterSeqs = new SequenceImpl[this.alignObj.getProteinNumber()];
        int j = 0;
        for (ClusterGroup group : clusterGroups) {
            Color boxColor = group.getColor();
            SequenceImpl[] sequences = group.getSequences();
            if (sequences == null) continue;
            for (int i = 0; i < sequences.length; ++i) {
                clusterSeqs[j] = new SequenceImpl(sequences[i]);
                if (i == 0) {
                    clusterSeqs[j].setClusterStart(true);
                }
                clusterSeqs[j].setClusterColor(boxColor);
                ++j;
            }
            clusterSeqs[j - 1].setClusterEnd(true);
        }
        return clusterSeqs;
    }

    private int getClusterNumber(SequenceCluster[] seqClusters) {
        int max = -1;
        for (SequenceCluster seqCluster : seqClusters) {
            if (seqCluster.getClusterIndex() <= max) continue;
            max = seqCluster.getClusterIndex();
        }
        return max + 1;
    }
}

