/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Vector;
import model.AlignObject;
import model.S3DetObject;
import model.SequenceImpl;

public class SequenceManager {
    private static String markedSequenceName;
    private static Vector<String> selectedSequences;
    private static S3DetObject s3detobj;
    private static String lastSelected;

    public static String getMarkedSequenceName() {
        return markedSequenceName;
    }

    public static void setMarkedSequenceName(String markedSequenceName) {
        SequenceManager.markedSequenceName = markedSequenceName;
    }

    public static Vector<String> getSelectedSequences() {
        return selectedSequences;
    }

    public static void setSelectedSequences(Vector<String> selectedSequences) {
        SequenceManager.selectedSequences = selectedSequences;
    }

    public static void addSequence(String sequence) {
        selectedSequences.add(sequence);
        SequenceManager.setLastSelected(sequence);
    }

    public static void toggleSequence(String sequence) {
        if (selectedSequences.contains(sequence)) {
            selectedSequences.remove(sequence);
            SequenceManager.setLastSelected(null);
        } else {
            selectedSequences.add(sequence);
            SequenceManager.setLastSelected(sequence);
        }
    }

    public static boolean isSelected(String sequence) {
        return selectedSequences.contains(sequence);
    }

    public static void emptySelectedSequences() {
        selectedSequences.clear();
        SequenceManager.setLastSelected(null);
    }

    public static S3DetObject getS3detobj() {
        return s3detobj;
    }

    public static void setS3detobj(S3DetObject s3detobj) {
        SequenceManager.s3detobj = s3detobj;
    }

    public static String getLastSelected() {
        return lastSelected;
    }

    public static void setLastSelected(String lastSelected) {
        SequenceManager.lastSelected = lastSelected;
    }

    public static void addSequenceByPosition(int position) {
        if (s3detobj != null) {
            SequenceManager.addSequence(s3detobj.getSeqCoords()[position].getName());
        }
    }

    public static boolean contains(String sequence) {
        return selectedSequences.contains(sequence);
    }

    public static boolean isEmpty() {
        return selectedSequences.isEmpty();
    }

    public static SequenceImpl getSequence(String seqName, AlignObject alObj) {
        SequenceImpl seqRet = null;
        for (int j = 0; j < alObj.getHeight(); ++j) {
            if (!alObj.getSequenceAt(j).getName().equals(seqName)) continue;
            seqRet = alObj.getSequenceAt(j);
        }
        return seqRet;
    }

    static {
        selectedSequences = new Vector();
    }
}

