/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import model.ClusterGroup;
import model.S3DetObject;
import model.SequenceImpl;
import util.ColorScheme;
import util.Constants;
import util.ResidueSelectionManager;
import util.ScreenConfig;
import util.SelectionManager;
import util.SequenceManager;
import util.SequenceOrderer;
import view.AlignViewProps;

public class SequenceLogo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Vector<Vector<double[]>> frequencyMatrix;
    private Vector<Color> clusterColors;
    private Vector<Integer> currentSelection;
    private JScrollBar horizontalScrollbar;
    private JScrollBar verticalScrollbar;
    JPanel logoPanel;
    private int horizontalChange = 0;
    private int verticalChange = 0;
    private JFrame logoFrame = this;
    private int startX = 0;
    private int endX = 0;
    private int startY = 0;
    private int endY = 1;
    private SequenceOrderer seqOrderer;
    private int sequenceLength = 0;
    private int clusterPanelScale = 1;
    private int logoHeight = 240;

    public SequenceLogo(AlignViewProps viewProps) {
        int i;
        SequenceImpl[] currentSequences;
        this.frequencyMatrix = new Vector();
        this.clusterColors = new Vector();
        this.currentSelection = new Vector();
        if (SequenceManager.getSelectedSequences().size() == 0) {
            currentSequences = viewProps.getAlObj().getSequences();
        } else {
            currentSequences = new SequenceImpl[SequenceManager.getSelectedSequences().size()];
            for (i = 0; i < SequenceManager.getSelectedSequences().size(); ++i) {
                currentSequences[i] = SequenceManager.getSequence(SequenceManager.getSelectedSequences().get(i), viewProps.getAlObj());
            }
        }
        this.fillFrequencyMatrix(currentSequences);
        this.startX = 0;
        if (SelectionManager.isEmpty() && ResidueSelectionManager.isEmpty()) {
            this.sequenceLength = viewProps.getAlObj().getSequenceAt(0).getLength();
            for (i = 0; i < this.sequenceLength; ++i) {
                this.currentSelection.add(i + 1);
            }
        } else {
            this.currentSelection = SelectionManager.getFullSelection();
            this.sequenceLength = this.currentSelection.size();
        }
        this.endX = this.sequenceLength > 20 ? 20 : this.sequenceLength;
        this.createLogo();
    }

    public SequenceLogo(AlignViewProps viewProps, boolean selectedSequence) {
        int i;
        this.frequencyMatrix = new Vector();
        this.clusterColors = new Vector();
        this.currentSelection = new Vector();
        SequenceImpl[] currentSequences = new SequenceImpl[SequenceManager.getSelectedSequences().size()];
        for (i = 0; i < SequenceManager.getSelectedSequences().size(); ++i) {
            currentSequences[i] = SequenceManager.getSequence(SequenceManager.getSelectedSequences().get(i), viewProps.getAlObj());
        }
        this.fillFrequencyMatrix(currentSequences);
        this.clusterColors.add(Constants.NAMEPANEL_SELECTED_BGSEQUENCE);
        this.startX = 0;
        this.startY = 0;
        if (SelectionManager.isEmpty() && ResidueSelectionManager.isEmpty()) {
            this.sequenceLength = viewProps.getAlObj().getSequenceAt(0).getLength();
            for (i = 0; i < this.sequenceLength; ++i) {
                this.currentSelection.add(i + 1);
            }
        } else {
            this.currentSelection = SelectionManager.getFullSelection();
            this.sequenceLength = this.currentSelection.size();
        }
        currentSequences = new SequenceImpl[viewProps.getAlObj().getSequences().length - SequenceManager.getSelectedSequences().size()];
        int insertPos = 0;
        for (SequenceImpl tmpSeq : viewProps.getAlObj().getSequences()) {
            if (SequenceManager.contains(tmpSeq.getName())) continue;
            currentSequences[insertPos] = tmpSeq;
            ++insertPos;
        }
        this.fillFrequencyMatrix(currentSequences);
        this.clusterColors.add(Color.WHITE);
        this.startX = 0;
        this.startY = 0;
        if (SelectionManager.isEmpty() && ResidueSelectionManager.isEmpty()) {
            this.sequenceLength = viewProps.getAlObj().getSequenceAt(0).getLength();
            for (int i2 = 0; i2 < this.sequenceLength; ++i2) {
                this.currentSelection.add(i2 + 1);
            }
        } else {
            this.currentSelection = SelectionManager.getFullSelection();
            this.sequenceLength = this.currentSelection.size();
        }
        this.endX = this.sequenceLength > 20 ? 20 : this.sequenceLength;
        this.clusterPanelScale = 2;
        this.logoHeight = 200 / this.clusterPanelScale + 40;
        this.createLogo();
    }

    public SequenceLogo(AlignViewProps viewProps, S3DetObject s3detobj) {
        HashMap<String, Integer> name2ClusterIndex = s3detobj.getName2ClusterIndex();
        this.seqOrderer = new SequenceOrderer(viewProps.getAlObj(), s3detobj);
        this.frequencyMatrix = new Vector();
        this.clusterColors = new Vector();
        ClusterGroup[] cl = this.seqOrderer.getClusterGroups();
        for (int c = 0; c < cl.length; ++c) {
            SequenceImpl[] currentSequences;
            this.currentSelection = new Vector();
            if (SequenceManager.getSelectedSequences().size() == 0) {
                currentSequences = cl[c].getSequences();
            } else {
                int nSeqCluster = 0;
                for (int i = 0; i < SequenceManager.getSelectedSequences().size(); ++i) {
                    if (name2ClusterIndex.get(SequenceManager.getSelectedSequences().get(i)) != c) continue;
                    ++nSeqCluster;
                }
                currentSequences = new SequenceImpl[nSeqCluster];
                int posAdded = 0;
                for (int i = 0; i < SequenceManager.getSelectedSequences().size(); ++i) {
                    if (name2ClusterIndex.get(SequenceManager.getSelectedSequences().get(i)) != c) continue;
                    currentSequences[posAdded] = SequenceManager.getSequence(SequenceManager.getSelectedSequences().get(i), viewProps.getAlObj());
                    ++posAdded;
                }
            }
            if (currentSequences != null && currentSequences.length > 0) {
                this.fillFrequencyMatrix(currentSequences);
                this.clusterColors.add(cl[name2ClusterIndex.get(currentSequences[0].getName())].getColor());
            }
            this.startX = 0;
            this.startY = 0;
            if (SelectionManager.isEmpty() && ResidueSelectionManager.isEmpty()) {
                this.sequenceLength = viewProps.getAlObj().getSequenceAt(0).getLength();
                for (int i = 0; i < this.sequenceLength; ++i) {
                    this.currentSelection.add(i + 1);
                }
            } else {
                this.currentSelection = SelectionManager.getFullSelection();
                this.sequenceLength = this.currentSelection.size();
            }
            this.endX = this.sequenceLength > 20 ? 20 : this.sequenceLength;
        }
        this.clusterPanelScale = 1 + (int)Math.floor(Math.log(this.frequencyMatrix.size()));
        this.logoHeight = 200 / this.clusterPanelScale + 40;
        this.createLogo();
    }

    private void fillFrequencyMatrix(SequenceImpl[] currentSequences) {
        Vector<double[]> newFrecuencyMatrix = new Vector<double[]>();
        for (int i = 0; i < currentSequences[0].getLength(); ++i) {
            int j;
            double[] frequencyElement = new double[Constants.AA_CODES.size()];
            for (j = 0; j < frequencyElement.length; ++j) {
                frequencyElement[j] = 0.0;
            }
            for (j = 0; j < currentSequences.length; ++j) {
                int n = Constants.AA_CODES.get(String.valueOf(currentSequences[j].getLetterAt(i)));
                frequencyElement[n] = frequencyElement[n] + 1.0;
            }
            newFrecuencyMatrix.add(frequencyElement);
        }
        this.frequencyMatrix.add(newFrecuencyMatrix);
    }

    private void createLogo() {
        this.logoPanel = new JPanel();
        this.horizontalScrollbar = new JScrollBar(0);
        this.horizontalScrollbar.addAdjustmentListener(new LogoScrollAdjuster());
        if (this.frequencyMatrix.size() > 1) {
            this.verticalScrollbar = new JScrollBar(1);
            this.verticalScrollbar.addAdjustmentListener(new LogoScrollAdjuster());
        }
        this.setTitle("Sequence Logo");
        this.getContentPane().setLayout(new BorderLayout());
        if (this.verticalScrollbar == null) {
            this.setSize(new Dimension((this.endX - this.startX) * 30 + 6, 296));
        } else {
            this.setSize(new Dimension((this.endX - this.startX) * 30 + 6 + (int)this.verticalScrollbar.getPreferredSize().getWidth(), 296));
        }
        this.repaint();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SequenceLogo.this.repaint();
            }
        });
        this.getContentPane().add((Component)this.horizontalScrollbar, "South");
        if (this.frequencyMatrix.size() > 1) {
            this.getContentPane().add((Component)this.verticalScrollbar, "East");
        }
        this.getContentPane().add((Component)this.logoPanel, "Center");
        ScreenConfig.centerInScreen(this);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.setScrollValues();
        this.logoPanel.removeAll();
        this.logoPanel.setLayout(null);
        this.logoPanel.setSize(new Dimension((this.endX - this.startX) * 30, this.logoHeight * (this.endY - this.startY)));
        this.logoPanel.setMaximumSize(new Dimension(this.frequencyMatrix.get(0).size() * 30, this.logoHeight * this.frequencyMatrix.size()));
        for (int j = this.startY; j < this.endY; ++j) {
            Color background = null;
            if (this.frequencyMatrix.size() > 1) {
                background = this.clusterColors.get(j);
            }
            JPanel clusterPanel = new JPanel();
            clusterPanel.setLayout(new BoxLayout(clusterPanel, 0));
            clusterPanel.setSize(new Dimension((this.endX - this.startX) * 30, this.logoHeight));
            for (int i = this.startX; i < this.endX; ++i) {
                LogoPosition letterLogo = new LogoPosition(this.frequencyMatrix.get(j).get(this.currentSelection.get(i) - 1), this.currentSelection.get(i), background);
                letterLogo.setAlignmentX(0.0f);
                clusterPanel.add(letterLogo);
            }
            this.logoPanel.add(clusterPanel);
            clusterPanel.setBounds(0, this.logoHeight * (j - this.startY), (this.endX - this.startX) * 30, this.logoHeight);
        }
        this.validate();
    }

    public void setScrollValues() {
        int width = this.currentSelection.size();
        this.horizontalChange = this.getWidth() / 30;
        if (this.horizontalChange > width) {
            this.horizontalChange = width;
        }
        if (this.horizontalChange + this.startX > width) {
            this.startX = width - this.horizontalChange;
        }
        if (this.startX < 0) {
            this.startX = 0;
        }
        this.horizontalScrollbar.setValues(this.startX, this.horizontalChange, 0, width);
        if (this.frequencyMatrix.size() > 1) {
            int height = this.frequencyMatrix.size();
            this.verticalChange = this.getHeight() / this.logoHeight;
            if (this.verticalChange > height) {
                this.verticalChange = height;
            }
            if (this.verticalChange + this.startY > height) {
                this.startY = height - this.verticalChange;
            }
            if (this.startY < 0) {
                this.startY = 0;
            }
            this.verticalScrollbar.setValues(this.startY, this.verticalChange, 0, height);
        }
    }

    public class FrequencyImage
    implements Comparable<FrequencyImage> {
        Image image;
        double frequency;

        public FrequencyImage(Image image, double frequency) {
            this.image = image;
            this.frequency = frequency;
        }

        public double getFrequency() {
            return this.frequency;
        }

        public Image getImage() {
            return this.image;
        }

        @Override
        public int compareTo(FrequencyImage b) {
            return new Double(this.frequency - b.getFrequency()).intValue();
        }
    }

    public class LogoPosition
    extends JComponent {
        private static final long serialVersionUID = 1L;
        Image header;
        Vector<FrequencyImage> fImages;
        int imageHeight;
        int imageWidth;
        int position;

        public LogoPosition(double[] frequencies, int position, Color background) {
            this.imageHeight = 200 / SequenceLogo.this.clusterPanelScale;
            this.imageWidth = 30;
            this.position = position;
            BufferedImage tImg = new BufferedImage(40, 30, 2);
            Graphics2D g2d = (Graphics2D)tImg.getGraphics();
            if (background != null) {
                g2d.setColor(background);
                g2d.fillRect(0, 0, 40, 30);
            }
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("SansSerif", 1, 12));
            AffineTransform origXform = g2d.getTransform();
            AffineTransform newXform = (AffineTransform)origXform.clone();
            g2d.drawString("" + position, 5, 16);
            BufferedImage tImgCont = new BufferedImage(30, 40, 2);
            Graphics2D g2dC = (Graphics2D)tImgCont.getGraphics();
            boolean xRot = false;
            int yRot = 40;
            newXform.translate((double)xRot, yRot);
            newXform.rotate(Math.toRadians(270.0));
            g2dC.drawImage(tImg, newXform, this);
            this.header = tImgCont;
            Set<String> aaCodes = Constants.AA_CODES.keySet();
            Iterator<String> aaIt = aaCodes.iterator();
            Font fittedfont = System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0 ? new Font("monospaced", 1, 42) : new Font("monospaced", 1, 50);
            this.fImages = new Vector();
            int i = 0;
            int nSequences = 0;
            for (int j = 0; j < frequencies.length; ++j) {
                nSequences = (int)((double)nSequences + frequencies[j]);
            }
            double scale = (double)this.imageHeight * 1.0 / ((double)nSequences * 1.0);
            while (aaIt.hasNext()) {
                String aaCode = aaIt.next();
                int j = Constants.AA_CODES.get(aaCode);
                if (!(frequencies[j] > 0.0)) continue;
                int height = (int)Math.round(frequencies[j] * scale);
                BufferedImage bImg = new BufferedImage(30, 30, 2);
                Graphics2D g = (Graphics2D)bImg.getGraphics();
                g.setColor(ColorScheme.getColor(Character.valueOf(aaCode.charAt(0))));
                g.setBackground(Color.WHITE);
                g.setFont(fittedfont);
                if (!aaCode.equals("-")) {
                    g.drawString(aaCode, 0, 30);
                }
                this.fImages.add(new FrequencyImage(bImg.getScaledInstance(this.imageWidth, height, 2), frequencies[j]));
                ++i;
            }
            Collections.sort(this.fImages);
        }

        public Font calculateFittingFont() {
            Font testFont;
            FontMetrics fm;
            BufferedImage bImg = new BufferedImage(30, 30, 2);
            Graphics g = bImg.getGraphics();
            int i = 0;
            do {
                testFont = new Font("monospaced", 1, 20 + ++i);
                g.setFont(testFont);
            } while ((fm = g.getFontMetrics(testFont)).getAscent() < 30);
            testFont = new Font("monospaced", 1, 30 + i - 1);
            return testFont;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.header, 0, 0, this);
            int yPos = 40;
            for (int i = 0; i < this.fImages.size(); ++i) {
                g.drawImage(this.fImages.get(i).getImage(), 0, yPos, this);
                yPos += this.fImages.get(i).getImage().getHeight(this);
            }
        }
    }

    public class LogoScrollAdjuster
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (evt.getSource() == SequenceLogo.this.horizontalScrollbar) {
                SequenceLogo.this.startX = SequenceLogo.this.horizontalScrollbar.getValue();
                SequenceLogo.this.endX = SequenceLogo.this.startX + SequenceLogo.this.logoFrame.getWidth() / 30;
            }
            if (evt.getSource() == SequenceLogo.this.verticalScrollbar) {
                SequenceLogo.this.startY = SequenceLogo.this.verticalScrollbar.getValue();
                SequenceLogo.this.endY = SequenceLogo.this.startY + (int)Math.ceil((double)SequenceLogo.this.logoFrame.getHeight() * 1.0 / ((double)SequenceLogo.this.logoHeight * 1.0));
                if (SequenceLogo.this.endY > SequenceLogo.this.frequencyMatrix.size()) {
                    SequenceLogo.this.endY = SequenceLogo.this.frequencyMatrix.size();
                } else if (SequenceLogo.this.endY < 0) {
                    SequenceLogo.this.endY = 0;
                }
            }
            if (SequenceLogo.this.endX > SequenceLogo.this.sequenceLength) {
                SequenceLogo.this.endX = SequenceLogo.this.sequenceLength;
            } else if (SequenceLogo.this.endX < 0) {
                SequenceLogo.this.endX = 0;
            }
            SequenceLogo.this.repaint();
        }
    }
}

