/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Collections;
import java.util.Vector;
import model.S3DetObject;
import util.ResidueSelectionManager;
import view.SequencePainter;

public class SelectionManager {
    private static boolean enabled;
    private static Vector<Integer> currentSelection;
    public static final int NO_SELECTION = -1;
    private static int lastSelection;
    private static SequencePainter seqPainter;
    private static S3DetObject s3detobj;
    private static boolean upperSelectionOn;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        SelectionManager.enabled = enabled;
    }

    public static Vector<Integer> getCurrentSelection() {
        return currentSelection;
    }

    public static void setCurrentSelection(Vector<Integer> currentSelection) {
        SelectionManager.currentSelection = currentSelection;
    }

    public static void addToCurrentSelection(int newSelection) {
        if (!currentSelection.contains(newSelection)) {
            currentSelection.add(newSelection);
            SelectionManager.setLastSelection(newSelection, false);
        }
        Collections.sort(currentSelection);
    }

    public static void toggleSelection(int newSelection, boolean centerSelection) {
        if (!currentSelection.contains(newSelection)) {
            currentSelection.add(newSelection);
            SelectionManager.setLastSelection(newSelection, centerSelection);
        } else {
            currentSelection.remove((Object)newSelection);
        }
        Collections.sort(currentSelection);
    }

    public static void emptyCurrentSelection() {
        currentSelection.clear();
        SelectionManager.setLastSelection(-1, false);
    }

    public static boolean isUpperSelectionOn() {
        return upperSelectionOn;
    }

    public static void setUpperSelectionOn(boolean upperSelectionOn) {
        SelectionManager.upperSelectionOn = upperSelectionOn;
    }

    public static SequencePainter getSeqPainter() {
        return seqPainter;
    }

    public static void setSeqPainter(SequencePainter seqPainter) {
        SelectionManager.seqPainter = seqPainter;
    }

    public static void updateSeqPainter() {
        seqPainter.repaint();
        seqPainter.notifyObservers();
    }

    public static S3DetObject getS3detobj() {
        return s3detobj;
    }

    public static void setS3detobj(S3DetObject s3detobj) {
        SelectionManager.s3detobj = s3detobj;
    }

    public static void addSequenceByPosition(int position) {
        if (s3detobj != null) {
            SelectionManager.addToCurrentSelection(s3detobj.getResCoords()[position].getPosition());
        }
    }

    public static boolean contains(int newSelection) {
        return currentSelection.contains(newSelection);
    }

    public static boolean isEmpty() {
        return currentSelection.size() == 0;
    }

    public static Vector<Integer> getFullSelection() {
        int i;
        Vector<Integer> currentSelection = new Vector<Integer>();
        for (i = 0; i < SelectionManager.getCurrentSelection().size(); ++i) {
            currentSelection.add(SelectionManager.getCurrentSelection().get(i));
        }
        for (i = 0; i < ResidueSelectionManager.getCurrentSelection().size(); ++i) {
            if (currentSelection.contains(ResidueSelectionManager.getCurrentSelection().get(i).getPosition())) continue;
            currentSelection.add(ResidueSelectionManager.getCurrentSelection().get(i).getPosition());
        }
        Collections.sort(currentSelection);
        return currentSelection;
    }

    public static int getLastSelection() {
        return lastSelection;
    }

    public static void setLastSelection(int lastSelection, boolean centerSelection) {
        SelectionManager.lastSelection = lastSelection;
        if (centerSelection && lastSelection != -1) {
            int scrollPos = lastSelection - (seqPainter.getViewProps().getXEnd() - seqPainter.getViewProps().getXStart()) / 2;
            if (scrollPos < 0) {
                scrollPos = 0;
            } else if (scrollPos > seqPainter.getViewProps().getAlObj().getWidth() - seqPainter.getViewProps().getXEnd() + seqPainter.getViewProps().getXStart()) {
                scrollPos = seqPainter.getViewProps().getAlObj().getWidth() - seqPainter.getViewProps().getXEnd() + seqPainter.getViewProps().getXStart();
            }
            seqPainter.getAlignPanel().getHorizontalScrollbar().setValue(scrollPos);
        }
    }

    static {
        currentSelection = new Vector();
        lastSelection = -1;
        upperSelectionOn = false;
    }
}

