/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import model.S3DetObject;
import model.XDetObject;
import org.jdesktop.swingx.JXButton;
import parser.S3DetParser;
import parser.XDetParser;
import util.AlignmentExporter;
import util.Constants;
import util.ScreenConfig;
import view.AlignFrame;
import view.AlignViewProps;

public class RunMethods
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AlignFrame parent;
    private AlignViewProps viewProps;
    private String method;
    private RunMethods runDialog;
    private JTextField paramsTtf;
    private JLabel warningsLabel;

    public RunMethods() {
    }

    public RunMethods(AlignFrame parent, AlignViewProps viewProps, String method) {
        super(parent, "Run " + method, true);
        this.parent = parent;
        this.viewProps = viewProps;
        this.method = method;
        this.runDialog = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RunMethods.this.cancelTriggered();
            }
        });
        this.setDefaultCloseOperation(2);
        this.constructScreen(method);
    }

    private void constructScreen(String methodName) {
        this.setSize(800, 500);
        Container tContentPane = this.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        JPanel panelNorth = new JPanel(new FormLayout("10dlu, p, 10dlu", "p, 5dlu"));
        JPanel panelCenter = new JPanel(new FormLayout("10dlu, p, 10dlu", "p, 5dlu"));
        JPanel panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel paramsPanel = new JPanel(new FormLayout("3dlu, p, 3dlu", "p"));
        this.warningsLabel = new JLabel();
        paramsPanel.setBorder(BorderFactory.createTitledBorder("Command line options"));
        this.paramsTtf = new JTextField(26);
        if (this.method.equals("Xdet")) {
            this.paramsTtf.setText(Constants.METHOD_METRICS_FILE);
            if (this.parent.getAlObj().getHeight() > 80) {
                this.warningsLabel.setText("<html><p><b>Warning: </b></p><p>Your alignment contains a large number of sequences. </p><p></p> <p>Xdet running time grows quadratically with the number</p><p>of sequences  and hence it could take a long time to  </p><p>run for this alignment. </p><p></p><p>It is recommended to run Xdet (outside Jdet) in a HPC </p><p>machine or similar and then load the results file. </p><p>Another possibility is, in case the alignment contains </p><p>very similar (redundant) sequences, is to filter it in </p><p>order to remove this redundancy (File->Filter alignment)</p><html>");
            }
        } else if (this.method.equals("S3Det")) {
            this.paramsTtf.setText("-v");
        }
        paramsPanel.add((Component)this.paramsTtf, cc.xy(2, 1));
        JPanel optionsPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu"));
        optionsPanel.add((Component)paramsPanel, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        JXButton runBtn = new JXButton("Run");
        runBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RunMethods.this.runDialog.runMethod(RunMethods.this.parent, RunMethods.this.viewProps, e, RunMethods.this.method, null, RunMethods.this.paramsTtf.getText());
                    RunMethods.this.runDialog.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JXButton closeBtn = new JXButton("Close");
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunMethods.this.runDialog.dispose();
            }
        });
        actionPanel.add((Component)closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)runBtn, cc.xy(4, 2));
        panelNorth.add((Component)this.warningsLabel, cc.xy(2, 1));
        panelCenter.add((Component)optionsPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelCenter, "Center");
        tContentPane.add((Component)panelSouth, "South");
        this.runDialog.setResizable(false);
        this.runDialog.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.runDialog.setVisible(true);
    }

    private void cancelTriggered() {
        this.dispose();
    }

    public void writeProgress(String text) {
        System.out.println(text);
    }

    public void runMethod(AlignFrame alignFrame, AlignViewProps viewProps, ActionEvent evt, String method, String outFileName, String params) {
        boolean success;
        params = params.trim();
        File file = new File(System.getProperty("user.dir") + Constants.dS + Constants.TMP_DIR);
        if (!file.exists() && !(success = new File(Constants.TMP_DIR).mkdir())) {
            JOptionPane.showMessageDialog(null, "Temp directory cannot be created.", "Tmp directory create error", 0);
            return;
        }
        String tmpFileName = Constants.TMP_DIR + "tmp.mfa";
        File tmpFile = new File(tmpFileName);
        try {
            AlignmentExporter.saveFasta(viewProps, tmpFile, false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(alignFrame, "Temporary file cannot be created.", "File create error", 0);
            return;
        }
        if (method.equals("Xdet")) {
            if (outFileName == null) {
                outFileName = Constants.TMP_DIR + "tmp.Xdet";
                try {
                    File tmpDelete = new File(outFileName);
                    tmpDelete.delete();
                }
                catch (Exception tmpDelete) {
                    // empty catch block
                }
            }
            String command = Constants.METHODS_DIR;
            if (System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0) {
                if (System.getProperty("os.arch").indexOf("amd64") >= 0) {
                    command = command + "xdet_linux64";
                    System.out.println("Executing 64 bits version");
                } else {
                    command = command + "xdet_linux32";
                    System.out.println("Executing 32 bits version");
                }
            } else if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                command = command + "xdet.exe";
            } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
                command = command + "xdet_osx";
            }
            try {
                String completeCommand = command + " " + tmpFileName + " " + params;
                Process proc = Runtime.getRuntime().exec(completeCommand);
                StreamGobbler s1 = new StreamGobbler("stdin", proc.getInputStream(), outFileName);
                s1.start();
                try {
                    String line;
                    JDialog progress = new JDialog((Window)this, Dialog.ModalityType.MODELESS);
                    progress.setTitle("Running Xdet...");
                    JLabel pb = new JLabel("");
                    pb.setBackground(Color.WHITE);
                    pb.setForeground(Color.BLACK);
                    pb.setSize(250, 40);
                    JPanel panelNorth = new JPanel();
                    panelNorth.add(pb);
                    progress.setLayout(null);
                    progress.setContentPane(panelNorth);
                    progress.getRootPane().add(panelNorth);
                    progress.validate();
                    progress.pack();
                    ScreenConfig.centerInComponent(progress, this);
                    progress.setVisible(true);
                    progress.toFront();
                    InputStreamReader isr = new InputStreamReader(proc.getErrorStream());
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        pb.setText(line.trim());
                        progress.validate();
                        progress.pack();
                        progress.repaint();
                        panelNorth.paintImmediately(panelNorth.getBounds());
                    }
                    proc.getErrorStream().close();
                }
                catch (Exception ex) {
                    System.out.println("Problem reading stream " + ex);
                    ex.printStackTrace();
                }
                proc.waitFor();
                AlignFrame newAlignFrame = null;
                XDetParser xdetparser = new XDetParser();
                XDetObject xdetObject = null;
                try {
                    xdetObject = xdetparser.read(outFileName, alignFrame.getAlObj());
                    alignFrame.getMethods().setxDetUsed(true);
                    alignFrame.getMethods().setxDetObject(xdetObject);
                    alignFrame.getMethods().setxDetCutoff(new Double(0.6));
                    alignFrame.getMethods().setEntropyUsed(true);
                    alignFrame.getMethods().setEntropyCutoff(new Double(2.5));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "The XDet file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                    return;
                }
                newAlignFrame = new AlignFrame(alignFrame.getAlObj(), alignFrame.getMethods(), 1100, 650, false);
                newAlignFrame.pack();
                if (alignFrame != null) {
                    alignFrame.closeOtherWindows();
                    alignFrame.dispose();
                }
                newAlignFrame.setVisible(true);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "XDet method cannot be executed! \nThere is no version of XDet available for current SO.\nDetails:\n    " + (e.getMessage().indexOf(":") != -1 ? e.getMessage().substring(e.getMessage().indexOf(":") + 1) : e.getMessage()), "File load error", 0);
                e.printStackTrace();
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (method.equals("S3Det")) {
            if (outFileName == null) {
                outFileName = Constants.TMP_DIR + "tmp.S3det";
                try {
                    File tmpDelete = new File(outFileName);
                    tmpDelete.delete();
                }
                catch (Exception tmpDelete) {
                    // empty catch block
                }
            }
            String command = Constants.METHODS_DIR;
            if (System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0) {
                command = System.getProperty("os.arch").indexOf("amd64") >= 0 ? "./s3det_linux64" : "./s3det_linux32";
            } else if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                command = "s3det.exe";
            } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
                command = "./s3det_osx";
            }
            try {
                String completeCommand = command + " -i .." + Constants.dS + tmpFileName + " -o .." + Constants.dS + outFileName + " " + params;
                Vector<String> procElems = new Vector<String>();
                procElems.add(System.getProperty("user.dir") + Constants.dS + Constants.METHODS_DIR + command);
                procElems.add("-i");
                procElems.add("../" + tmpFileName);
                procElems.add("-o");
                procElems.add("../" + outFileName);
                String[] paramsArr = params.split("\\s");
                for (int i = 0; i < paramsArr.length; ++i) {
                    procElems.add(paramsArr[i]);
                }
                ProcessBuilder procB = new ProcessBuilder(procElems);
                procB.directory(new File(System.getProperty("user.dir") + Constants.dS + Constants.METHODS_DIR));
                Process proc = procB.start();
                StreamGobbler s2 = new StreamGobbler("stderr", proc.getInputStream(), null);
                s2.start();
                JDialog progress = new JDialog((Window)this, Dialog.ModalityType.MODELESS);
                progress.setTitle("Running S3det...");
                JProgressBar pb = new JProgressBar();
                pb.setSize(200, 40);
                pb.setIndeterminate(true);
                JPanel panelNorth = new JPanel();
                panelNorth.add(pb);
                progress.setLayout(null);
                progress.setContentPane(panelNorth);
                progress.getRootPane().add(panelNorth);
                progress.validate();
                progress.pack();
                ScreenConfig.centerInComponent(progress, this);
                progress.setVisible(true);
                panelNorth.paintImmediately(panelNorth.getBounds());
                progress.toFront();
                proc.waitFor();
                if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    try {
                        String nextLine;
                        String s3detConfFile = Constants.METHODS_DIR + "conf.h";
                        BufferedReader reader = new BufferedReader(new FileReader(s3detConfFile));
                        String commandR = "";
                        String exec_directory = "";
                        String tmp_directory = "";
                        Pattern patCmd = Pattern.compile("^(\\s*)string(\\s+)order(\\s*)=(\\s*)\"(.+)\"(\\s*);(\\s*)$");
                        Pattern patTmp = Pattern.compile("^(\\s*)string(\\s+)tmp_directory(\\s*)=(\\s*)\"(.+)\"(\\s*);(\\s*)$");
                        Pattern patExec = Pattern.compile("^(\\s*)string(\\s+)exec_directory(\\s*)=(\\s*)\"(.+)\"(\\s*);(\\s*)$");
                        Matcher mat = null;
                        while ((nextLine = reader.readLine()) != null) {
                            mat = patCmd.matcher(nextLine);
                            if (mat.find()) {
                                commandR = nextLine.substring(nextLine.indexOf(34) + 1, nextLine.lastIndexOf(34));
                                commandR = commandR.trim();
                            }
                            if ((mat = patTmp.matcher(nextLine)).find()) {
                                tmp_directory = nextLine.substring(nextLine.indexOf(34) + 1, nextLine.lastIndexOf(34));
                                tmp_directory = tmp_directory.trim();
                            }
                            if (!(mat = patExec.matcher(nextLine)).find()) continue;
                            exec_directory = nextLine.substring(nextLine.indexOf(34) + 1, nextLine.lastIndexOf(34));
                            exec_directory = exec_directory.trim();
                        }
                        String completeCommandR = commandR + " " + exec_directory + "S3det_Wilcoxon_test.R " + tmp_directory;
                        procB = new ProcessBuilder(commandR, System.getProperty("user.dir") + Constants.dS + Constants.METHODS_DIR + "S3det_Wilcoxon_test.R", tmp_directory);
                        procB.directory(new File(System.getProperty("user.dir") + Constants.dS + Constants.METHODS_DIR));
                        proc = procB.start();
                        System.out.println(completeCommandR);
                        proc.waitFor();
                        if (proc.exitValue() != 0) {
                            JOptionPane.showMessageDialog(null, "Error running S3Det! \nRscript was not found on specified path.\nPlease check if R is installed and the correct path of Rscript is included in programs/conf.h file.");
                            reader.close();
                            return;
                        }
                        procB = new ProcessBuilder(procElems);
                        procB.directory(new File(System.getProperty("user.dir") + Constants.dS + Constants.METHODS_DIR));
                        proc = procB.start();
                        System.out.println(completeCommand);
                        s2 = new StreamGobbler("stderr", proc.getInputStream(), null);
                        s2.start();
                        proc.waitFor();
                        reader.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found error: " + e.getMessage());
                        JOptionPane.showMessageDialog(null, "Error running S3Det! \nRscript was not found on specified path.\nPlease check if R is installed and the correct path of Rscript is included in programs/conf.h file.");
                        return;
                    }
                    catch (IOException e) {
                        System.out.println("IO error: " + e.getMessage());
                        JOptionPane.showMessageDialog(null, "Error running S3Det! \nRscript was not found on specified path.\nPlease check if R is installed and the correct path of Rscript is included in programs/conf.h file.");
                        return;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Number format error:" + e.getMessage());
                        JOptionPane.showMessageDialog(null, "Error running S3Det! \nRscript was not found on specified path.\nPlease check if R is installed and the correct path of Rscript is included in programs/conf.h file.");
                        return;
                    }
                    catch (Exception e) {
                        System.out.println("Other error:" + e.getMessage());
                        JOptionPane.showMessageDialog(null, "Error running S3Det! \nRscript was not found on specified path.\nPlease check if R is installed and the correct path of Rscript is included in programs/conf.h file.");
                        return;
                    }
                } else if (proc.exitValue() != 0) {
                    JOptionPane.showMessageDialog(null, "Error running S3Det! \nR was not found on specified path, cluster data cannot be obtained.\nPlease check configuration on programs/conf.h file.");
                    return;
                }
                AlignFrame newAlignFrame = null;
                S3DetParser s3detparser = new S3DetParser();
                S3DetObject s3DetObject = null;
                try {
                    s3DetObject = s3detparser.read(outFileName, viewProps.getAlObj());
                    alignFrame.getMethods().setS3DetUsed(true);
                    alignFrame.getMethods().setS3DetObject(s3DetObject);
                    alignFrame.getMethods().setS3DetCutoff(10.0);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "The S3Det file couldn't be loaded! \nPlease specify a proper format/location of the file.\nDetails:\n    " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                    return;
                }
                newAlignFrame = new AlignFrame(viewProps.getAlObj(), alignFrame.getMethods(), 1100, 650, false);
                newAlignFrame.pack();
                if (alignFrame != null) {
                    alignFrame.closeOtherWindows();
                    alignFrame.dispose();
                }
                newAlignFrame.setVisible(true);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "S3Det method cannot be executed! \nThere is no version of S3Det available for current SO.\nDetails:\n    " + (e.getMessage().indexOf(":") != -1 ? e.getMessage().substring(e.getMessage().indexOf(":") + 1) : e.getMessage()), "File load error", 0);
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public class StreamGobbler
    implements Runnable {
        String name;
        InputStream is;
        String outFileName;
        Thread thread;

        public StreamGobbler(String name, InputStream is, String outFileName) {
            this.name = name;
            this.is = is;
            this.outFileName = outFileName;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                FileWriter outWriter = null;
                if (this.outFileName != null) {
                    outWriter = new FileWriter(this.outFileName);
                }
                while ((line = br.readLine()) != null) {
                    if (this.outFileName != null) {
                        outWriter.write(line + "\n");
                        continue;
                    }
                    System.out.println(line);
                }
                this.is.close();
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (Exception ex) {
                System.out.println("Problem reading stream " + this.name + "... :" + ex);
                ex.printStackTrace();
            }
        }
    }
}

