/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Collections;
import java.util.Vector;
import model.FuncResidueImpl;
import model.S3DetObject;
import util.SelectionManager;
import view.SequencePainter;

public class ResidueSelectionManager {
    private static Vector<FuncResidueImpl> currentSelection = new Vector();
    private static S3DetObject s3detobj;
    private static SequencePainter seqPainter;

    public static Vector<FuncResidueImpl> getCurrentSelection() {
        return currentSelection;
    }

    public static void emptyCurrentSelection() {
        currentSelection.clear();
    }

    public static void setCurrentSelection(Vector<FuncResidueImpl> currentSelection) {
        ResidueSelectionManager.currentSelection = currentSelection;
    }

    public static void addToCurrentSelection(FuncResidueImpl newSelection) {
        if (ResidueSelectionManager.contains(newSelection) == null) {
            currentSelection.add(newSelection);
            SelectionManager.setLastSelection(newSelection.getPosition(), false);
        }
        Collections.sort(currentSelection);
    }

    public static void toggleSelection(FuncResidueImpl newSelection) {
        FuncResidueImpl exists = ResidueSelectionManager.contains(newSelection);
        if (exists == null) {
            currentSelection.add(newSelection);
            SelectionManager.setLastSelection(newSelection.getPosition(), false);
        } else {
            currentSelection.remove(exists);
        }
        Collections.sort(currentSelection);
    }

    public static S3DetObject getS3detobj() {
        return s3detobj;
    }

    public static void setS3detobj(S3DetObject s3detobj) {
        ResidueSelectionManager.s3detobj = s3detobj;
    }

    public static void addResidueByPosition(int position) {
        if (s3detobj != null) {
            char letter = s3detobj.getResCoords()[position].getLetter() == '#' ? (char)'-' : (char)s3detobj.getResCoords()[position].getLetter();
            FuncResidueImpl fri = new FuncResidueImpl(s3detobj.getResCoords()[position].getPosition(), letter);
            ResidueSelectionManager.addToCurrentSelection(fri);
        }
    }

    public static SequencePainter getSeqPainter() {
        return seqPainter;
    }

    public static void setSeqPainter(SequencePainter seqPainter) {
        ResidueSelectionManager.seqPainter = seqPainter;
    }

    public static void updateSeqPainter() {
        seqPainter.repaint();
        seqPainter.notifyObservers();
    }

    public static FuncResidueImpl contains(FuncResidueImpl funcResidue) {
        FuncResidueImpl exists = null;
        char letter = funcResidue.getAa() == '#' ? (char)'-' : (char)funcResidue.getAa();
        for (int i = 0; i < currentSelection.size(); ++i) {
            if (funcResidue.getPosition() != currentSelection.get(i).getPosition() || letter != currentSelection.get(i).getAa()) continue;
            exists = currentSelection.get(i);
        }
        return exists;
    }

    public static boolean contains(int position, char aa) {
        boolean exists = false;
        char letter = aa == '#' ? (char)'-' : (char)aa;
        for (int i = 0; i < currentSelection.size(); ++i) {
            if (position != currentSelection.get(i).getPosition() || letter != currentSelection.get(i).getAa()) continue;
            exists = true;
        }
        return exists;
    }

    public static boolean contains(int position) {
        boolean exists = false;
        for (int i = 0; i < currentSelection.size(); ++i) {
            if (position != currentSelection.get(i).getPosition()) continue;
            exists = true;
        }
        return exists;
    }

    public static boolean isEmpty() {
        return currentSelection.size() == 0;
    }
}

