/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import model.AlignObject;
import model.ResidueImpl;
import model.SequenceImpl;
import model.UDMObject;
import plugins.conversion.ConversionPlugin;
import plugins.method.MethodPlugin;
import view.AlignFrame;

public class PluginLoader {
    static ArrayList<String> methodPluginsList;
    static ArrayList<String> conversionPluginsList;

    public static void loadPlugins() {
        File pluginsDir = new File("plugins/method");
        methodPluginsList = new ArrayList();
        File[] plugins = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        System.out.println("Method plugins:");
        for (File f : plugins) {
            methodPluginsList.add(f.getName().substring(0, f.getName().lastIndexOf(".")));
            System.out.println("\t" + f.getName().substring(0, f.getName().lastIndexOf(".")));
        }
        pluginsDir = new File("plugins/conversion");
        conversionPluginsList = new ArrayList();
        plugins = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        System.out.println("Conversion plugins:");
        for (File f : plugins) {
            conversionPluginsList.add(f.getName().substring(0, f.getName().lastIndexOf(".")));
            System.out.println("\t" + f.getName().substring(0, f.getName().lastIndexOf(".")));
        }
    }

    public static String getPluginName(int i, int type) {
        if (type == 1) {
            return methodPluginsList.get(i);
        }
        if (type == 2) {
            return conversionPluginsList.get(i);
        }
        return null;
    }

    public static ArrayList<String> getPlugins(int type) {
        if (type == 1) {
            return methodPluginsList;
        }
        if (type == 2) {
            return conversionPluginsList;
        }
        return null;
    }

    public static void loadMethodPlugin(String name, AlignObject alObj, AlignFrame parent) {
        UDMObject udmObject = new UDMObject();
        Class<?>[] classParm = null;
        Object[] objectParm = null;
        try {
            Class<?> cl = Class.forName("plugins.method." + name);
            Constructor<?> co = cl.getConstructor(classParm);
            MethodPlugin dp = (MethodPlugin)co.newInstance(objectParm);
            ArrayList<String> alignment = new ArrayList<String>();
            for (SequenceImpl sequenceImpl : alObj.getSequences()) {
                alignment.add(sequenceImpl.getSequenceAsString());
            }
            dp.runPlugin(alignment);
            String[] output = dp.getMethodOutput();
            if (output != null) {
                try {
                    ArrayList<ResidueImpl> resList = new ArrayList<ResidueImpl>();
                    HashMap<Integer, ResidueImpl> pos2ResMap = new HashMap<Integer, ResidueImpl>();
                    for (String nextLine : output) {
                        StringTokenizer tokenizer = new StringTokenizer(nextLine, " ");
                        ArrayList<String> tokenList = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens()) {
                            tokenList.add(tokenizer.nextToken());
                        }
                        ResidueImpl res = new ResidueImpl();
                        res.setPosition(Integer.parseInt((String)tokenList.get(0)));
                        res.setAa(((String)tokenList.get(1)).charAt(0));
                        res.setScore(new BigDecimal((String)tokenList.get(2)));
                        resList.add(res);
                        pos2ResMap.put(res.getPosition(), res);
                    }
                    ResidueImpl[] residueImplArray = new ResidueImpl[resList.size()];
                    for (int i = 0; i < resList.size(); ++i) {
                        residueImplArray[i] = (ResidueImpl)resList.get(i);
                    }
                    udmObject.setResidues(residueImplArray);
                    udmObject.setResNumber(residueImplArray.length);
                    udmObject.setPos2ResMap(pos2ResMap);
                    udmObject.setMethodName(name);
                    udmObject.setScoreCutoff(dp.getCutoff());
                    parent.getMethods().addUdmObject(udmObject);
                    AlignFrame alignFrame = new AlignFrame(parent.getAlObj(), parent.getMethods(), 1100, 650, false);
                    if (parent != null) {
                        parent.closeOtherWindows();
                        parent.dispose();
                    }
                    alignFrame.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error reading output from " + name + " plugin.\n .The plugin output has to fulfill the following conditions:\n[Position] <SPACE> [Amino Acid Letter] <Space> [Score]", "Plugin output load error", 0);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error loading " + name + " plugin.\n Use the batch launcher 'RUNME' to set a valid classpath in order to use plugins.", "Plugin load error", 0);
        }
    }

    public static void loadConversionPlugin(String name, AlignObject alObj, AlignFrame parent) {
        UDMObject udmObject = new UDMObject();
        Class<?>[] classParm = null;
        Object[] objectParm = null;
        try {
            Class<?> cl = Class.forName("plugins.conversion." + name);
            Constructor<?> co = cl.getConstructor(classParm);
            ConversionPlugin dp = (ConversionPlugin)co.newInstance(objectParm);
            ArrayList<String> alignment = new ArrayList<String>();
            for (SequenceImpl sequenceImpl : alObj.getSequences()) {
                alignment.add(sequenceImpl.getSequenceAsString());
            }
            dp.runPlugin(alignment, parent);
            String[] output = dp.getMethodOutput();
            if (output != null) {
                try {
                    udmObject.setIncreasingScore(dp.isIncreasingScore());
                    ArrayList<ResidueImpl> resList = new ArrayList<ResidueImpl>();
                    HashMap<Integer, ResidueImpl> pos2ResMap = new HashMap<Integer, ResidueImpl>();
                    for (String nextLine : output) {
                        StringTokenizer tokenizer = new StringTokenizer(nextLine, " ");
                        ArrayList<String> tokenList = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens()) {
                            tokenList.add(tokenizer.nextToken());
                        }
                        ResidueImpl res = new ResidueImpl();
                        res.setPosition(Integer.parseInt((String)tokenList.get(0)));
                        res.setAa(((String)tokenList.get(1)).charAt(0));
                        res.setScore(new BigDecimal((String)tokenList.get(2)));
                        resList.add(res);
                        pos2ResMap.put(res.getPosition(), res);
                    }
                    ResidueImpl[] residueImplArray = new ResidueImpl[resList.size()];
                    for (int i = 0; i < resList.size(); ++i) {
                        residueImplArray[i] = (ResidueImpl)resList.get(i);
                    }
                    udmObject.setResidues(residueImplArray);
                    udmObject.setResNumber(residueImplArray.length);
                    udmObject.setPos2ResMap(pos2ResMap);
                    udmObject.setMethodName(name);
                    udmObject.setScoreCutoff(dp.getCutoff());
                    parent.getMethods().addUdmObject(udmObject);
                    AlignFrame alignFrame = new AlignFrame(parent.getAlObj(), parent.getMethods(), 1100, 650, false);
                    if (parent != null) {
                        parent.closeOtherWindows();
                        parent.dispose();
                    }
                    alignFrame.setVisible(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error reading output from " + name + " plugin.\n .The plugin output has to fulfill the following conditions:\n[Position] <SPACE> [Amino Acid Letter] <Space> [Score]", "Plugin output load error", 0);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error loading " + name + " plugin.\n Use the batch launcher 'RUNME' to set a valid classpath in order to use plugins.", "Plugin load error", 0);
        }
    }
}

