/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PdbFileOpener
implements Runnable {
    private String pdbCode;
    private String gzipFile;
    private String pdbFile;
    private URL url;
    private Thread thread;
    private int downloaded;
    private JTextArea progressInfo = null;

    public PdbFileOpener(String pdbCode) {
        this.pdbCode = pdbCode;
        this.gzipFile = "pdb" + pdbCode + ".ent.gz";
        this.getURL();
        this.start();
    }

    public PdbFileOpener(String pdbCode, JTextArea progressInfo) {
        this.pdbCode = pdbCode;
        this.gzipFile = "pdb" + pdbCode + ".ent.gz";
        this.progressInfo = progressInfo;
        this.getURL();
        this.start();
    }

    private void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public int getDownloaded() {
        return this.downloaded;
    }

    private void getURL() {
        try {
            this.url = new URL("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/pdb/" + this.gzipFile);
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(null, "Couldn't get the URL of the FTP...\nUse a valid filename for the file...", e.getMessage(), 0);
        }
    }

    private void downloadFile() {
        try {
            URLConnection con = this.url.openConnection();
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            FileOutputStream out = new FileOutputStream("pdb" + this.pdbCode + ".ent.gz");
            this.downloaded = 0;
            int i = 0;
            byte[] buffer = new byte[1024];
            while ((i = in.read(buffer)) >= 0) {
                out.write(buffer, 0, i);
                this.downloaded += i;
                if (this.progressInfo == null) continue;
                this.progressInfo.setText(this.downloaded + "kB downloaded...");
            }
            out.close();
            in.close();
        }
        catch (UnknownHostException e) {
            if (this.progressInfo != null) {
                this.progressInfo.setText("Download error.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "The PDB file couldn't be retrieved from the server! \nPlease check your connection to server...", "Unknown host error", 0);
                }
            });
            return;
        }
        catch (Exception ex) {
            if (this.progressInfo != null) {
                this.progressInfo.setText("Download error.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "The PDB file couldn't be downloaded.! \nPlease use a valid 4-digit-code for an existing PDB file.", "Download file error", 0);
                }
            });
            return;
        }
        if (this.progressInfo != null) {
            this.progressInfo.setText("Download complete.");
        }
    }

    private void uncompressFile() {
        try {
            int len;
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(this.gzipFile));
            this.pdbFile = this.pdbCode + ".pdb";
            FileOutputStream out = new FileOutputStream(this.pdbFile);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.downloadFile();
        this.uncompressFile();
    }

    public String getPdbFile() {
        return this.pdbFile;
    }

    public Thread getThread() {
        return this.thread;
    }
}

