/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileInputStream;
import java.util.Set;
import pdb.AbstractAminoAcid;
import pdb.PDBinterpreter;
import util.AAMap;

public class PDBFile
extends PDBinterpreter {
    private String filename;
    private String chain;
    private AAMap aaMap;
    private String pdbSequence;

    public PDBFile(String filename, String chain) {
        this.filename = filename;
        this.chain = chain;
        this.aaMap = new AAMap();
        this.read();
    }

    public void read() {
        try {
            FileInputStream fil = new FileInputStream(this.filename);
            this.open(fil);
            this.parse();
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String readLine() {
        String line = super.readLine();
        return line;
    }

    @Override
    public boolean hasKey(String key) {
        boolean value = super.hasKey(key);
        return value;
    }

    @Override
    public void endPrimaryStructureSection() {
        StringBuilder sBuilder = new StringBuilder();
        Set keys = this.primaryStructure.keySet();
        for (String chainID : keys) {
            if (!chainID.equals(this.chain)) continue;
            PDBinterpreter.PrimaryStructureData chain = (PDBinterpreter.PrimaryStructureData)this.primaryStructure.get(chainID);
            for (AbstractAminoAcid amino : chain.resSequence) {
                if (this.aaMap == null) continue;
                if (this.aaMap.containsKey(amino.toString().toUpperCase())) {
                    sBuilder.append(this.aaMap.get(amino.toString().toUpperCase()));
                    continue;
                }
                sBuilder.append("X");
            }
        }
        this.pdbSequence = sBuilder.toString();
    }

    public String getPdbSequence() {
        return this.pdbSequence;
    }
}

