/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import util.AAMap;

public class PDBAtomReader {
    private String filename;
    private String chain;
    private AAMap aaMap;
    private String pdbSequence;
    BufferedReader reader = null;
    String line = null;
    private int pos = 0;

    public String sub(int n) {
        return this.line.substring(this.pos, this.pos += n);
    }

    public String sub(int i, int n) {
        this.pos = i + n;
        return this.line.substring(i, i + n);
    }

    public PDBAtomReader(String filename, String chain) {
        this.filename = filename;
        this.chain = chain;
        this.aaMap = new AAMap();
        this.read();
    }

    public void read() {
        String chainPos = "0";
        int firstPos = 0;
        StringBuilder sBuilder = new StringBuilder();
        try {
            FileInputStream fil = new FileInputStream(this.filename);
            this.open(fil);
            do {
                this.nextLine();
                if (!this.hasKey("ATOM  ") || !this.chain.equals(this.sub(21, 1).trim()) || chainPos.equals(this.sub(23, 6).trim())) continue;
                chainPos = this.sub(23, 6).trim();
                if (firstPos == 0) {
                    firstPos = Integer.parseInt(chainPos);
                    for (int i = 1; i < firstPos; ++i) {
                        sBuilder.append('X');
                    }
                }
                if (this.aaMap.containsKey(this.sub(17, 3).trim().toString())) {
                    sBuilder.append(((Character)this.aaMap.get(this.sub(17, 3).trim())).toString());
                    continue;
                }
                sBuilder.append('X');
            } while (this.line != null);
            this.pdbSequence = sBuilder.toString();
            System.out.println(this.pdbSequence);
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void open(Reader rd) {
        this.reader = new BufferedReader(rd);
    }

    public void open(InputStream stream) {
        this.open(new InputStreamReader(stream));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public void nextLine() {
        this.line = this.readLine();
    }

    public boolean hasKey(String key) {
        if (this.line == null) {
            return false;
        }
        this.pos = key.length();
        return this.line.startsWith(key);
    }

    public String getPdbSequence() {
        return this.pdbSequence;
    }
}

