/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;

public class NCBIBlastPDB {
    public static String blastThePDB(String _sequence, double _eCutOff) {
        String bestHit;
        block14: {
            String rid = "";
            bestHit = null;
            try {
                URL uReq = new URL("https://www.ncbi.nlm.nih.gov/blast/Blast.cgi?DATABASE=pdb&BLAST_PROGRAM=blastp&PROGRAM=blastp&FORMAT_TYPE=XML&HITLIST_SIZE=1&CMD=Put&QUERY_BELIEVE_DEFLINE=no&FORMAT_OBJECT=Alignment&EXPECT_LOW=1e-25&QUERY=" + _sequence);
                try {
                    String line;
                    InputStream in = NCBIBlastPDB.doPOST(uReq);
                    ArrayList<String> pdbIds = new ArrayList<String>();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(in));
                    while ((line = rd.readLine()) != null) {
                        if (!line.contains("RID =")) continue;
                        rid = line.substring(line.indexOf("=") + 1).trim();
                    }
                    rd.close();
                    if (rid.isEmpty()) break block14;
                    long t0 = System.currentTimeMillis();
                    boolean blastFinished = false;
                    System.out.print("Waiting for blast results");
                    do {
                        pdbIds.clear();
                        System.out.print(".");
                        URL uRes = new URL("https://www.ncbi.nlm.nih.gov/blast/Blast.cgi?FORMAT_TYPE=Text&ALIGNMENTS=1&DESCRIPTION=100&CMD=Get&RID=" + rid);
                        in = NCBIBlastPDB.doPOST(uRes);
                        rd = new BufferedReader(new InputStreamReader(in));
                        while ((line = rd.readLine()) != null) {
                            if (line.contains("Status=READY")) {
                                blastFinished = true;
                            }
                            pdbIds.add(line);
                        }
                        rd.close();
                        if (blastFinished) {
                            bestHit = "";
                            for (String string : pdbIds) {
                                boolean bestHitFound = false;
                                if (bestHitFound || !string.matches("[A-Z0-9]{4}_[A-Z]+(.+)(\\s+)([0-9]+)(\\s+)(([0-9]+.?[0-9]*)|([0-9].[0-9]+))([Ee][+-]?[0-9]+)?\\s*")) continue;
                                String[] arrString = string.split("\\s+");
                                String[] arrPbdId = arrString[0].split("_");
                                bestHit = arrPbdId[0] + "|" + arrPbdId[1] + "|" + arrString[arrString.length - 1] + "|" + arrString[arrString.length - 2];
                                bestHitFound = true;
                            }
                        } else {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (System.currentTimeMillis() - t0 < 300000L && !blastFinished);
                    System.out.println(".");
                    if (blastFinished) {
                        System.out.println("BLAST finished");
                        break block14;
                    }
                    System.out.println("Timeout exceeded!");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return bestHit;
    }

    public static InputStream doPOST(URL url) throws IOException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setDoOutput(true);
        return conn.getInputStream();
    }

    public static String findBestHit(String blastResult) {
        String bestHit = "";
        String[] resultLines = blastResult.split("\n");
        boolean readingResults = false;
        boolean foundId = false;
        boolean readingDetails = false;
        String resultId = "";
        String resultString = "";
        String resultEvalue = "";
        String resultScore = "";
        String resultIdentities = "";
        for (int i = 0; i < resultLines.length; ++i) {
            if (resultLines[i].indexOf("Sequences producing significant alignments") != -1) {
                readingResults = true;
                continue;
            }
            if (readingResults && resultLines[i].indexOf("#") != -1) {
                resultId = resultLines[i].substring(resultLines[i].indexOf("#") + 1, resultLines[i].indexOf(">"));
                resultString = resultLines[i].substring(0, resultLines[i].indexOf(" "));
                resultEvalue = resultLines[i].substring(resultLines[i].lastIndexOf(">") + 1).trim();
                readingResults = false;
                foundId = true;
                continue;
            }
            if (foundId && resultLines[i].indexOf("<a name = " + resultId + ">") != -1) {
                readingDetails = true;
                continue;
            }
            if (!readingDetails) continue;
            if (resultLines[i].indexOf("Score") != -1) {
                resultScore = resultLines[i];
                continue;
            }
            if (resultLines[i].indexOf("Identities") != -1) {
                resultIdentities = resultLines[i];
                continue;
            }
            if (resultLines[i].indexOf("</PRE>") == -1) continue;
            readingDetails = false;
        }
        String identitiesValue = resultIdentities.substring(resultIdentities.indexOf("(") + 1, resultIdentities.indexOf("%"));
        String pdbId = resultString.substring(0, resultString.indexOf(":"));
        String pdbChain = resultString.substring(resultString.lastIndexOf(":") + 1, resultString.lastIndexOf(":") + 2);
        bestHit = pdbId + "|" + pdbChain + "|" + resultEvalue + "|" + identitiesValue;
        return bestHit;
    }

    public static boolean evaluateBestHit(String bestHit) {
        boolean isValid = true;
        String[] bestHitFields = bestHit.split("\\|");
        if (bestHitFields[2].charAt(0) == 'e') {
            bestHitFields[2] = "1.0" + bestHitFields[2];
        }
        double eValue = Double.parseDouble(bestHitFields[2]);
        int identities = Integer.parseInt(bestHitFields[3]);
        isValid = !(eValue > 1.0E-4) && !((double)identities < 25.0);
        return isValid;
    }
}

