/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import view.AlignPanel;

public class ImageExporter {
    private BufferedImage image;
    private Graphics g;
    private FileOutputStream out;

    public ImageExporter(AlignPanel alignPanel, String title, int width, int height, File file) {
        if (file != null) {
            try {
                this.out = new FileOutputStream(file);
                this.initPNGFile(width, height);
            }
            catch (Exception ex) {
                System.out.println("Error exporting PNG file.");
            }
        }
    }

    private void initPNGFile(int width, int height) {
        this.image = new BufferedImage(width, height, 1);
        this.g = this.image.getGraphics();
        Graphics2D g2d = (Graphics2D)this.g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void write() {
        try {
            ImageIO.write((RenderedImage)this.image, "png", this.out);
            this.out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Graphics getGraphics() {
        return this.g;
    }
}

