/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.AlignObject;
import model.Methods;
import org.jdesktop.swingx.JXButton;
import parser.MfaParser;
import util.AlignmentExporter;
import util.Constants;
import util.ScreenConfig;
import view.AlignFrame;
import view.AlignViewProps;

public class FilterAlignment
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AlignFrame parent;
    private AlignViewProps viewProps;
    private String method;
    private FilterAlignment filterDialog;
    private JTextField paramMttf;
    private JTextField paramRttf;
    private JTextField paramFttf;
    private JCheckBox paramGttf;
    private JComboBox<String> presetsCombo;
    private HashMap<String, PresetItem> presets;

    public FilterAlignment() {
    }

    public FilterAlignment(AlignFrame parent, AlignViewProps viewProps) {
        super(parent, "Filter Alignment", true);
        this.parent = parent;
        this.viewProps = viewProps;
        this.filterDialog = this;
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FilterAlignment.this.cancelTriggered();
            }
        });
        this.setDefaultCloseOperation(2);
        this.constructScreen(this.method);
    }

    private void constructScreen(String methodName) {
        JPanel panelNorth = null;
        JPanel panelCenter = null;
        JPanel panelSouth = null;
        this.setSize(800, 500);
        Container tContentPane = this.getContentPane();
        tContentPane.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        panelNorth = new JPanel(new FormLayout("10dlu, p, 10dlu", "p"));
        panelCenter = new JPanel(new FormLayout("p, 10dlu", "p, 5dlu"));
        panelSouth = new JPanel(new FormLayout("10dlu, p, 3dlu, p, 10dlu", "p, 5dlu"));
        JPanel paramsPanel = new JPanel(new FormLayout("15dlu, p, 5dlu, p, 15dlu", "p, 5dlu, p, 5dlu, p, 5dlu, p, 5dlu"));
        paramsPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        JLabel labelMttf = new JLabel("Remove sequences with %ID with master lower than");
        paramsPanel.add((Component)labelMttf, cc.xy(2, 1));
        this.paramMttf = new JTextField(2);
        paramsPanel.add((Component)this.paramMttf, cc.xy(4, 1));
        JLabel labelRttf = new JLabel("Remove redundancy at %ID");
        paramsPanel.add((Component)labelRttf, cc.xy(2, 3));
        this.paramRttf = new JTextField(2);
        paramsPanel.add((Component)this.paramRttf, cc.xy(4, 3));
        JLabel labelFttf = new JLabel("Remove fragments, %coverage with master lower than");
        paramsPanel.add((Component)labelFttf, cc.xy(2, 5));
        this.paramFttf = new JTextField(2);
        paramsPanel.add((Component)this.paramFttf, cc.xy(4, 5));
        JLabel labelGttf = new JLabel("Remove positions with a gap in master sequence");
        paramsPanel.add((Component)labelGttf, cc.xy(2, 7));
        this.paramGttf = new JCheckBox();
        paramsPanel.add((Component)this.paramGttf, cc.xy(4, 7));
        JPanel presetsPanel = new JPanel(new FormLayout("15dlu, p, 15dlu, p", "p, 5dlu"));
        JLabel presetsLabel = new JLabel("Load default values for");
        this.presetsCombo = new JComboBox();
        this.presets = new HashMap();
        this.loadPresets(this.presets, this.presetsCombo);
        this.presetsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String selectedPreset = cb.getSelectedItem().toString();
                FilterAlignment.this.loadPresetValues(selectedPreset);
            }
        });
        this.loadPresetValues(this.presetsCombo.getSelectedItem().toString());
        presetsPanel.add((Component)presetsLabel, cc.xy(2, 1));
        presetsPanel.add(this.presetsCombo, cc.xy(4, 1));
        panelCenter.add((Component)presetsPanel, cc.xy(1, 1));
        JPanel optionsPanel = new JPanel(new FormLayout("p", "3dlu, p, 3dlu"));
        optionsPanel.add((Component)paramsPanel, cc.xy(1, 2));
        JPanel actionPanel = new JPanel(new FormLayout("100dlu, p, 5dlu, right:p", "5dlu, p, 5dlu"));
        JXButton runBtn = new JXButton("Filter");
        runBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (FilterAlignment.this.paramMttf.getText().isEmpty() || FilterAlignment.this.paramRttf.getText().isEmpty() || FilterAlignment.this.paramFttf.getText().isEmpty()) {
                        JOptionPane.showMessageDialog(FilterAlignment.this.parent, "Parameters can't be empty.", "Parameters error", 1);
                        return;
                    }
                    try {
                        Double.parseDouble(FilterAlignment.this.paramMttf.getText());
                        Double.parseDouble(FilterAlignment.this.paramRttf.getText());
                        Double.parseDouble(FilterAlignment.this.paramFttf.getText());
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(FilterAlignment.this.parent, "Parameter values must be numeric.", "Parameters error", 1);
                        return;
                    }
                    FilterAlignment.this.filterDialog.filterAlignment(FilterAlignment.this.parent, FilterAlignment.this.viewProps, e, null, FilterAlignment.this.paramMttf.getText(), FilterAlignment.this.paramRttf.getText(), FilterAlignment.this.paramFttf.getText(), FilterAlignment.this.paramGttf.isSelected());
                    FilterAlignment.this.filterDialog.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JXButton closeBtn = new JXButton("Close");
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterAlignment.this.filterDialog.dispose();
            }
        });
        actionPanel.add((Component)closeBtn, cc.xy(2, 2));
        actionPanel.add((Component)runBtn, cc.xy(4, 2));
        panelNorth.add((Component)optionsPanel, cc.xy(2, 1));
        panelSouth.add((Component)actionPanel, cc.xy(4, 1));
        tContentPane.add((Component)panelNorth, "North");
        tContentPane.add((Component)panelCenter, "Center");
        tContentPane.add((Component)panelSouth, "South");
        this.filterDialog.setResizable(false);
        this.filterDialog.pack();
        ScreenConfig.centerInComponent(this, this.parent);
        this.filterDialog.setVisible(true);
    }

    private void loadPresetValues(String selectedPreset) {
        PresetItem preset = this.presets.get(selectedPreset);
        this.paramMttf.setText(preset.getmValue());
        this.paramRttf.setText(preset.getrValue());
        this.paramFttf.setText(preset.getfValue());
        this.paramGttf.setSelected(preset.getgValue());
    }

    public void loadPresets(HashMap<String, PresetItem> presets, JComboBox<String> newPresetsCombo) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(Constants.FILTER_PRESETS_FILE));
            String nextLine = reader.readLine();
            while (nextLine != null) {
                if ((nextLine = nextLine.trim()).charAt(0) != '#' && nextLine.length() > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(nextLine, "\t");
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    if (tokenList.size() < 5) {
                        reader.close();
                        throw new IOException("Bad format in " + Constants.FILTER_PRESETS_FILE);
                    }
                    presets.put((String)tokenList.get(0), new PresetItem((String)tokenList.get(0), (String)tokenList.get(1), (String)tokenList.get(2), (String)tokenList.get(3), !((String)tokenList.get(4)).equals("0")));
                    newPresetsCombo.addItem((String)tokenList.get(0));
                }
                nextLine = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error applying filter! \nDetails:\n       " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
        }
    }

    private void cancelTriggered() {
        this.dispose();
    }

    public void filterAlignment(AlignFrame alignFrame, AlignViewProps viewProps, ActionEvent evt, String outFileName, String paramM, String paramR, String paramF, boolean paramG) {
        String methodsDirName;
        boolean success;
        String dS = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "\\" : "/";
        File file = new File(System.getProperty("user.dir") + dS + Constants.TMP_DIR);
        if (!file.exists() && !(success = new File(Constants.TMP_DIR).mkdir())) {
            JOptionPane.showMessageDialog(null, "Temp directory cannot be created.", "Tmp directory create error", 0);
            return;
        }
        String tmpFileName = System.getProperty("user.dir") + dS + Constants.TMP_DIR + dS + "tmp.mfa";
        File tmpFile = new File(tmpFileName);
        tmpFileName = "." + dS + Constants.TMP_DIR + dS + "tmp.mfa";
        try {
            AlignmentExporter.saveFasta(viewProps, tmpFile, false);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(alignFrame, "Temporary file cannot be created.", "File create error", 0);
            return;
        }
        if (outFileName == null) {
            outFileName = System.getProperty("user.dir") + dS + Constants.TMP_DIR + dS + "tmp.filtered.mfa";
        }
        String command = methodsDirName = "." + dS + Constants.METHODS_DIR + dS;
        if (System.getProperty("os.name").toLowerCase().indexOf("nix") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0) {
            command = command + "filter_aln_linux32";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            command = command + "filter_aln.exe";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            command = command + "filter_aln.osx";
        }
        try {
            String matrixRoute = Constants.CONFIG_DIR + "Maxhom_McLachlan.metric";
            String params = matrixRoute + " -M " + paramM + " -R " + paramR + " -F " + paramF + " " + (paramG ? "-G" : "") + " -O=F";
            String completeCommand = command + " " + tmpFileName + " " + params;
            Process proc = Runtime.getRuntime().exec(completeCommand);
            StreamGobbler s1 = new StreamGobbler("stdin", proc.getInputStream(), outFileName);
            StreamGobbler s2 = new StreamGobbler("stderr", proc.getErrorStream(), null);
            s1.start();
            s2.start();
            proc.waitFor();
            AlignFrame newAlignFrame = null;
            MfaParser parser = new MfaParser();
            AlignObject alignObject = null;
            try {
                alignObject = parser.read(outFileName);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "The alignment file couldn't be loaded! \nPlease specify a proper location/format of the file.\nDetails:\n       " + (ex.getMessage().indexOf(":") != -1 ? ex.getMessage().substring(ex.getMessage().indexOf(":") + 1) : ex.getMessage()), "File load error", 0);
                return;
            }
            Methods methods = new Methods();
            newAlignFrame = new AlignFrame(alignObject, methods, 1100, 650, true);
            newAlignFrame.pack();
            if (alignFrame != null) {
                alignFrame.closeOtherWindows();
                alignFrame.dispose();
            }
            newAlignFrame.setVisible(true);
            JOptionPane.showMessageDialog(newAlignFrame, "Filtered alignment succesfully loaded.", "Alignment filtered", 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class PresetItem {
        String name;
        String mValue;
        String rValue;
        String fValue;
        boolean gValue;

        public PresetItem(String name, String mValue, String rValue, String fValue, boolean gValue) {
            this.name = name;
            this.mValue = mValue;
            this.rValue = rValue;
            this.fValue = fValue;
            this.gValue = gValue;
        }

        public String getName() {
            return this.name;
        }

        public String getmValue() {
            return this.mValue;
        }

        public String getrValue() {
            return this.rValue;
        }

        public String getfValue() {
            return this.fValue;
        }

        public boolean getgValue() {
            return this.gValue;
        }
    }

    public class StreamGobbler
    implements Runnable {
        String name;
        InputStream is;
        String outFileName;
        Thread thread;

        public StreamGobbler(String name, InputStream is, String outFileName) {
            this.name = name;
            this.is = is;
            this.outFileName = outFileName;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                FileWriter outWriter = null;
                if (this.outFileName != null) {
                    outWriter = new FileWriter(this.outFileName);
                }
                while ((line = br.readLine()) != null) {
                    if (this.outFileName == null) continue;
                    outWriter.write(line + "\n");
                }
                this.is.close();
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (Exception ex) {
                System.out.println("Problem reading stream " + this.name + "... :" + ex);
                ex.printStackTrace();
            }
        }
    }
}

