/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFileChooser;
import parser.ColorParser;
import view.AlignFrame;
import view.ColorSchemeInfo;

public class ColorScheme {
    private static Vector<HashMap<Character, Color>> colorSchemes;
    private static HashMap<Integer, Double> minValues;
    private static HashMap<Integer, Double> maxValues;
    private static Vector<String> colorSchemeNames;
    private static HashMap<Character, Double> userDefSchemeValues;
    private static int currentScheme;
    private static int colorPalette;
    private static final long serialVersionUID = 1L;
    private static final Color RED;
    private static final Color BLUE;
    private static final Color GREEN;
    private static final Color CYAN;
    private static final Color PINK;
    private static final Color MAGENTA;
    private static final Color ORANGE;
    private static final Color YELLOW;
    public static final String CLUSTAL_X = "ClustalX";
    public static final String MW = "Molecular weight";
    public static final String POL_G = "Polarity";
    public static final String HDF = "Hidrophobicity";
    public static final String USER_DEF = "User defined";
    public static final int PAL_RED_GREEN_BLUE = 0;
    public static final int PAL_RED_BLUE = 1;
    public static final int PALETTE_WIDTH = 100;
    public static final int PALETTE_HEIGHT = 20;
    public static final int PALETTE_TEXT_MARGIN = 5;
    public static final double PALETTE_STEPS = 10.0;
    public static final HashMap<Character, Color> defScheme;
    public static final HashMap<Character, Double> mwScheme;
    public static final HashMap<Character, Double> polScheme;
    public static final HashMap<Character, Double> hdfScheme;

    public ColorScheme() {
        ColorScheme.init();
    }

    public static void init() {
        if (colorSchemes == null) {
            colorSchemes = new Vector();
            colorSchemeNames = new Vector();
            minValues = new HashMap();
            maxValues = new HashMap();
            colorPalette = 0;
            ColorScheme.addFixedScheme(defScheme, CLUSTAL_X);
            ColorScheme.setColorPalette(0);
        }
    }

    public static Color getColor(Character key) {
        return colorSchemes.get(currentScheme).get(key);
    }

    public static void setColorPalette(int colorPaletteCode) {
        colorPalette = colorPaletteCode;
        ColorScheme.addGradualScheme(mwScheme, MW);
        ColorScheme.addGradualScheme(polScheme, POL_G);
        ColorScheme.addGradualScheme(hdfScheme, HDF);
        if (userDefSchemeValues != null) {
            ColorScheme.addGradualScheme(userDefSchemeValues, colorSchemeNames.get(currentScheme));
        }
    }

    public static int getColorPalette() {
        return colorPalette;
    }

    public static void setUserDefSchemeValues(HashMap<Character, Double> newUserDefSchemeValues) {
        userDefSchemeValues = newUserDefSchemeValues;
    }

    private static void addFixedScheme(HashMap<Character, Color> colorScheme, String schemeName) {
        colorSchemes.add(colorScheme);
        colorSchemeNames.add(schemeName);
    }

    public static void addGradualScheme(HashMap<Character, Double> colorScheme, String schemeName) {
        HashMap<Character, Color> newScheme = new HashMap<Character, Color>();
        Set<Character> keys = colorScheme.keySet();
        Iterator<Character> itKeys = keys.iterator();
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        while (itKeys.hasNext()) {
            Character c = itKeys.next();
            if (colorScheme.get(c) > maxValue) {
                maxValue = colorScheme.get(c);
            }
            if (!(colorScheme.get(c) < minValue)) continue;
            minValue = colorScheme.get(c);
        }
        double scale = 255.0 / (maxValue - minValue);
        for (Character c : keys) {
            Color color = ColorScheme.getColorFromValue(colorScheme.get(c), maxValue, minValue, scale, colorPalette);
            newScheme.put(c, color);
        }
        if (colorSchemeNames.contains(schemeName)) {
            int index = colorSchemeNames.indexOf(schemeName);
            colorSchemes.add(index, newScheme);
        } else {
            minValues.put(colorSchemes.size(), minValue);
            maxValues.put(colorSchemes.size(), maxValue);
            colorSchemes.add(newScheme);
            colorSchemeNames.add(schemeName);
        }
    }

    public static Color getColorFromValue(double value, double maxValue, double minValue, double scale, int colorPalette) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (colorPalette == 1) {
            Double modifier = Math.floor((value - minValue) * scale);
            r = modifier.intValue();
            g = 0;
            b = 255 - modifier.intValue();
        } else {
            int modifier = (int)((value - minValue) * scale - 127.5);
            r = modifier > 0 ? 0 : -(modifier * 2);
            g = 255 - 2 * Math.abs(modifier);
            b = modifier < 0 ? 0 : modifier * 2;
        }
        return new Color(r, g, b);
    }

    public static boolean containsKey(Character key) {
        return colorSchemes.get(currentScheme).containsKey(key);
    }

    public static void setColorScheme(String colorSchemeName) {
        if (colorSchemeNames.contains(colorSchemeName)) {
            currentScheme = colorSchemeNames.indexOf(colorSchemeName);
        }
    }

    public static int getColorScheme() {
        return currentScheme;
    }

    public static Vector<String> getColorSchemeNames() {
        return colorSchemeNames;
    }

    public static boolean loadColorScheme(AlignFrame alignFrame) {
        boolean retValue = false;
        String filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(filename));
        fc.requestFocusInWindow();
        fc.showOpenDialog(alignFrame);
        File file = fc.getSelectedFile();
        if (file != null) {
            ColorParser cp = new ColorParser();
            retValue = cp.read(file.getAbsolutePath());
        }
        return retValue;
    }

    public static ColorSchemeInfo getPaletteImage() {
        if (ColorScheme.getColorSchemeNames() == null) {
            return new ColorSchemeInfo("");
        }
        if (currentScheme == ColorScheme.getColorSchemeNames().indexOf(CLUSTAL_X)) {
            return new ColorSchemeInfo(CLUSTAL_X);
        }
        return new ColorSchemeInfo(minValues.get(currentScheme), maxValues.get(currentScheme));
    }

    public static void updatePaletteImage(ColorSchemeInfo paletteCanvas) {
        if (paletteCanvas != null) {
            if (currentScheme == ColorScheme.getColorSchemeNames().indexOf(CLUSTAL_X)) {
                paletteCanvas.setPaletteName(CLUSTAL_X);
            } else {
                paletteCanvas.setValues(minValues.get(currentScheme), maxValues.get(currentScheme));
            }
        }
    }

    static {
        userDefSchemeValues = null;
        currentScheme = 0;
        colorPalette = 0;
        RED = new Color(230, 50, 25);
        BLUE = new Color(25, 127, 230);
        GREEN = new Color(25, 204, 25);
        CYAN = new Color(25, 178, 178);
        PINK = new Color(239, 127, 127);
        MAGENTA = new Color(204, 77, 204);
        ORANGE = new Color(230, 154, 77);
        YELLOW = new Color(204, 204, 0);
        defScheme = new HashMap();
        defScheme.put(Character.valueOf('A'), BLUE);
        defScheme.put(Character.valueOf('W'), BLUE);
        defScheme.put(Character.valueOf('L'), BLUE);
        defScheme.put(Character.valueOf('V'), BLUE);
        defScheme.put(Character.valueOf('I'), BLUE);
        defScheme.put(Character.valueOf('M'), BLUE);
        defScheme.put(Character.valueOf('F'), BLUE);
        defScheme.put(Character.valueOf('K'), RED);
        defScheme.put(Character.valueOf('R'), RED);
        defScheme.put(Character.valueOf('T'), GREEN);
        defScheme.put(Character.valueOf('S'), GREEN);
        defScheme.put(Character.valueOf('N'), GREEN);
        defScheme.put(Character.valueOf('Q'), GREEN);
        defScheme.put(Character.valueOf('C'), PINK);
        defScheme.put(Character.valueOf('D'), MAGENTA);
        defScheme.put(Character.valueOf('E'), MAGENTA);
        defScheme.put(Character.valueOf('G'), ORANGE);
        defScheme.put(Character.valueOf('H'), CYAN);
        defScheme.put(Character.valueOf('Y'), CYAN);
        defScheme.put(Character.valueOf('P'), YELLOW);
        mwScheme = new HashMap();
        mwScheme.put(Character.valueOf('A'), 89.0);
        mwScheme.put(Character.valueOf('W'), 204.0);
        mwScheme.put(Character.valueOf('L'), 131.0);
        mwScheme.put(Character.valueOf('V'), 117.0);
        mwScheme.put(Character.valueOf('I'), 131.0);
        mwScheme.put(Character.valueOf('M'), 149.0);
        mwScheme.put(Character.valueOf('F'), 165.0);
        mwScheme.put(Character.valueOf('K'), 146.0);
        mwScheme.put(Character.valueOf('R'), 174.0);
        mwScheme.put(Character.valueOf('T'), 119.0);
        mwScheme.put(Character.valueOf('S'), 105.0);
        mwScheme.put(Character.valueOf('N'), 132.0);
        mwScheme.put(Character.valueOf('Q'), 146.0);
        mwScheme.put(Character.valueOf('C'), 121.0);
        mwScheme.put(Character.valueOf('D'), 133.0);
        mwScheme.put(Character.valueOf('E'), 147.0);
        mwScheme.put(Character.valueOf('G'), 75.0);
        mwScheme.put(Character.valueOf('H'), 155.0);
        mwScheme.put(Character.valueOf('Y'), 181.0);
        mwScheme.put(Character.valueOf('P'), 115.0);
        polScheme = new HashMap();
        polScheme.put(Character.valueOf('A'), 8.1);
        polScheme.put(Character.valueOf('W'), 5.4);
        polScheme.put(Character.valueOf('L'), 4.9);
        polScheme.put(Character.valueOf('V'), 5.9);
        polScheme.put(Character.valueOf('I'), 5.2);
        polScheme.put(Character.valueOf('M'), 5.7);
        polScheme.put(Character.valueOf('F'), 5.2);
        polScheme.put(Character.valueOf('K'), 11.3);
        polScheme.put(Character.valueOf('R'), 10.5);
        polScheme.put(Character.valueOf('T'), 8.6);
        polScheme.put(Character.valueOf('S'), 9.2);
        polScheme.put(Character.valueOf('N'), 11.6);
        polScheme.put(Character.valueOf('Q'), 10.5);
        polScheme.put(Character.valueOf('C'), 5.5);
        polScheme.put(Character.valueOf('D'), 13.0);
        polScheme.put(Character.valueOf('E'), 12.3);
        polScheme.put(Character.valueOf('G'), 9.0);
        polScheme.put(Character.valueOf('H'), 10.4);
        polScheme.put(Character.valueOf('Y'), 6.2);
        polScheme.put(Character.valueOf('P'), 8.0);
        hdfScheme = new HashMap();
        hdfScheme.put(Character.valueOf('A'), 0.62);
        hdfScheme.put(Character.valueOf('W'), 0.81);
        hdfScheme.put(Character.valueOf('L'), 1.06);
        hdfScheme.put(Character.valueOf('V'), 1.08);
        hdfScheme.put(Character.valueOf('I'), 1.38);
        hdfScheme.put(Character.valueOf('M'), 0.64);
        hdfScheme.put(Character.valueOf('F'), 1.19);
        hdfScheme.put(Character.valueOf('K'), -1.5);
        hdfScheme.put(Character.valueOf('R'), -2.53);
        hdfScheme.put(Character.valueOf('T'), -0.05);
        hdfScheme.put(Character.valueOf('S'), 0.18);
        hdfScheme.put(Character.valueOf('N'), -0.78);
        hdfScheme.put(Character.valueOf('Q'), -0.85);
        hdfScheme.put(Character.valueOf('C'), 0.29);
        hdfScheme.put(Character.valueOf('D'), -0.9);
        hdfScheme.put(Character.valueOf('E'), -0.74);
        hdfScheme.put(Character.valueOf('G'), 0.48);
        hdfScheme.put(Character.valueOf('H'), -0.4);
        hdfScheme.put(Character.valueOf('Y'), 0.26);
        hdfScheme.put(Character.valueOf('P'), 1.08);
    }
}

