/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.net.URL;
import javax.swing.JOptionPane;
import org.pdb.webservices.PdbWebService;
import org.pdb.webservices.PdbWebServiceServiceLocator;

public class BlastPDB {
    public static String blastThePDB(String _sequence, double _eCutOff) {
        String pdbResult = "";
        PdbWebServiceServiceLocator locator = new PdbWebServiceServiceLocator();
        try {
            String _url = "http://www.pdb.org/pdb/services/pdbws?wsdl";
            URL url = new URL(_url);
            PdbWebService p = locator.getpdbws(url);
            String output = p.blastPDB(_sequence, _eCutOff, "BLOSUM62", "HTML");
            pdbResult = BlastPDB.findBestHit(output);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to connect to http://www.pdb.org/pdb/services/pdbws?wsdl\n Check your internet connection and try again.", "File load error", 0);
            return null;
        }
        return pdbResult;
    }

    public static String findBestHit(String blastResult) {
        String bestHit = "";
        String[] resultLines = blastResult.split("\n");
        boolean readingResults = false;
        boolean foundId = false;
        boolean readingDetails = false;
        String resultId = "";
        String resultString = "";
        String resultEvalue = "";
        String resultScore = "";
        String resultIdentities = "";
        for (int i = 0; i < resultLines.length; ++i) {
            if (resultLines[i].indexOf("Sequences producing significant alignments") != -1) {
                readingResults = true;
                continue;
            }
            if (readingResults && resultLines[i].indexOf("#") != -1) {
                resultId = resultLines[i].substring(resultLines[i].indexOf("#") + 1, resultLines[i].indexOf(">"));
                resultString = resultLines[i].substring(0, resultLines[i].indexOf(" "));
                resultEvalue = resultLines[i].substring(resultLines[i].lastIndexOf(">") + 1).trim();
                readingResults = false;
                foundId = true;
                continue;
            }
            if (foundId && resultLines[i].indexOf("<a name = " + resultId + ">") != -1) {
                readingDetails = true;
                continue;
            }
            if (!readingDetails) continue;
            if (resultLines[i].indexOf("Score") != -1) {
                resultScore = resultLines[i];
                continue;
            }
            if (resultLines[i].indexOf("Identities") != -1) {
                resultIdentities = resultLines[i];
                continue;
            }
            if (resultLines[i].indexOf("</PRE>") == -1) continue;
            readingDetails = false;
        }
        String identitiesValue = resultIdentities.substring(resultIdentities.indexOf("(") + 1, resultIdentities.indexOf("%"));
        String pdbId = resultString.substring(0, resultString.indexOf(":"));
        String pdbChain = resultString.substring(resultString.lastIndexOf(":") + 1, resultString.lastIndexOf(":") + 2);
        bestHit = pdbId + "|" + pdbChain + "|" + resultEvalue + "|" + identitiesValue;
        return bestHit;
    }

    public static boolean evaluateBestHit(String bestHit) {
        boolean isValid = true;
        String[] bestHitFields = bestHit.split("\\|");
        if (bestHitFields[2].charAt(0) == 'e') {
            bestHitFields[2] = "1.0" + bestHitFields[2];
        }
        double eValue = Double.parseDouble(bestHitFields[2]);
        int identities = Integer.parseInt(bestHitFields[3]);
        isValid = !(eValue > 1.0E-4) && !((double)identities < 25.0);
        return isValid;
    }
}

