/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import model.SequenceImpl;
import util.FastaFileFilter;
import util.PngFileFilter;
import util.SelectionManager;
import util.SequenceManager;
import view.AlignFrame;
import view.AlignViewProps;

public class AlignmentExporter {
    private static String lastSelectedFolder = "user.home";

    public static void exportFasta(AlignFrame alignFrame, AlignViewProps viewProps, ActionEvent evt, boolean saveSelection) {
        JFileChooser chooser = new JFileChooser(lastSelectedFolder);
        chooser.setFileFilter(new FastaFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export MFA File Details");
        chooser.requestFocusInWindow();
        int returnVal = chooser.showSaveDialog(alignFrame);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".mfa")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".mfa");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(alignFrame, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(lastSelectedFolder);
                chooser.setFileFilter(new PngFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export FASTA File Details");
                returnVal = chooser.showSaveDialog(alignFrame);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".mfa")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".mfa");
            }
            alignFrame.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".mfa")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".mfa");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                AlignmentExporter.saveFasta(viewProps, selectedFile, saveSelection);
                lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(alignFrame, "An error occured when exporting the PNG file.", "Error Exporting PNG File", 0);
                ex.printStackTrace();
            }
            alignFrame.setCursor(new Cursor(0));
        }
    }

    public static void saveFasta(AlignViewProps viewProps, File selectedFile, boolean saveSelection) throws IOException {
        int i;
        Vector<Integer> currentSelection = SelectionManager.getFullSelection();
        if (currentSelection.size() == 0 || !saveSelection) {
            currentSelection.clear();
            int sequenceLength = viewProps.getAlObj().getSequenceAt(0).getLength();
            for (i = 0; i < sequenceLength; ++i) {
                currentSelection.add(i + 1);
            }
        }
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(selectedFile));
        if (SequenceManager.getSelectedSequences().size() == 0 || !saveSelection) {
            for (i = 0; i < viewProps.getAlObj().getHeight(); ++i) {
                out.write(">" + viewProps.getAlObj().getSequenceAt(i).getName() + "\n");
                SequenceImpl currentSeq = viewProps.getAlObj().getSequenceAt(i);
                for (int j = 0; j < currentSelection.size(); ++j) {
                    ((Writer)out).write(currentSeq.getSequence()[currentSelection.get(j) - 1]);
                    if ((j + 1) % 80 != 0) continue;
                    out.write("\n");
                }
                out.write("\n");
            }
        } else {
            for (i = 0; i < SequenceManager.getSelectedSequences().size(); ++i) {
                out.write(">" + SequenceManager.getSelectedSequences().get(i) + "_Fragment\n");
                SequenceImpl currentSeq = SequenceManager.getSequence(SequenceManager.getSelectedSequences().get(i), viewProps.getAlObj());
                for (int j = 0; j < currentSelection.size(); ++j) {
                    ((Writer)out).write(currentSeq.getSequence()[currentSelection.get(j) - 1]);
                    if ((j + 1) % 80 != 0) continue;
                    out.write("\n");
                }
                out.write("\n");
            }
        }
        ((Writer)out).close();
    }

    public static void exportPNGFile(AlignFrame alignFrame, ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(lastSelectedFolder);
        chooser.setFileFilter(new PngFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export PNG File Details");
        chooser.requestFocusInWindow();
        chooser.requestFocusInWindow();
        int returnVal = chooser.showSaveDialog(alignFrame);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".png")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".png");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(alignFrame, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(lastSelectedFolder);
                chooser.setFileFilter(new PngFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export PNG File Details");
                returnVal = chooser.showSaveDialog(alignFrame);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".png")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".png");
            }
            alignFrame.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".png")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".png");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                alignFrame.getAlignPanel().exportPNGFile(selectedFile);
                lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(alignFrame, "An error occured when exporting the PNG file.", "Error Exporting PNG File", 0);
                ex.printStackTrace();
            }
            alignFrame.setCursor(new Cursor(0));
        }
    }

    public static void exportMethodFile(AlignFrame alignFrame, ActionEvent evt, String method) {
        JFileChooser chooser = new JFileChooser(lastSelectedFolder);
        if (method.equals("S3Det")) {
            chooser.setFileFilter(new InnerS3DetFileFilter());
        } else if (method.equals("xdet")) {
            chooser.setFileFilter(new InnerXDetFileFilter());
        }
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export " + method + " File Details");
        chooser.requestFocusInWindow();
        int returnVal = chooser.showSaveDialog(alignFrame);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(method)) {
                selectedFile = new File(selectedFile.getAbsolutePath() + "." + method);
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(alignFrame, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(lastSelectedFolder);
                if (method.equals("S3Det")) {
                    chooser.setFileFilter(new InnerS3DetFileFilter());
                } else if (method.equals("xdet")) {
                    chooser.setFileFilter(new InnerXDetFileFilter());
                }
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export " + method + " File Details");
                returnVal = chooser.showSaveDialog(alignFrame);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith("." + method)) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + "." + method);
            }
            alignFrame.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith("." + method)) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + "." + method);
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                try {
                    selectedFile.createNewFile();
                    if (method.equals("S3Det")) {
                        AlignmentExporter.saveFile(alignFrame.getMethods().getS3DetObject().getFilename(), selectedFile);
                    } else if (method.equals("xdet")) {
                        AlignmentExporter.saveFile(alignFrame.getMethods().getxDetObject().getFilename(), selectedFile);
                    }
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(alignFrame, ex.getMessage() + " in the specified directory.", "Error Exporting " + method + " File", 0);
                    return;
                }
                lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(alignFrame, "An error occured when exporting " + method + " file.", "Error Exporting " + method + " File", 0);
                ex.printStackTrace();
            }
            alignFrame.setCursor(new Cursor(0));
        }
    }

    public static void saveFile(String inputFile, File outFile) throws FileNotFoundException, IOException {
        int len;
        File s3detInput = new File(inputFile);
        FileInputStream in = new FileInputStream(s3detInput);
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static class InnerXDetFileFilter
    extends FileFilter {
        private InnerXDetFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xdet") || f.getName().endsWith(".Xdet");
        }

        @Override
        public String getDescription() {
            return "*.xdet";
        }
    }

    private static class InnerS3DetFileFilter
    extends FileFilter {
        private InnerS3DetFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".s3Det") || f.getName().endsWith(".S3det");
        }

        @Override
        public String getDescription() {
            return "*.S3det";
        }
    }
}

