/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Alignment {
    private char[] pdbSequence;
    private char[] alignSequence;
    private char[] cleanAlignSequence;
    private HashMap<Integer, Integer> correspCleanVsAlign;
    private boolean startFlag;
    private int startRow;
    private int startCol;
    private boolean[][] dotplot;
    private HashMap<Integer, Integer> align2PDBPositionMap;
    private HashMap<Integer, Integer> pdb2alignPositionMap;

    public Alignment(String alignSequence, String pdbSequence) {
        this.alignSequence = alignSequence.toCharArray();
        this.pdbSequence = pdbSequence.toCharArray();
        this.alignSequenceToStructure();
        this.checkAlignment();
    }

    private boolean[][] getDotPlotMatrix() {
        boolean[][] matrixBool = new boolean[this.cleanAlignSequence.length][this.pdbSequence.length];
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumCols(); ++j) {
                if (this.cleanAlignSequence[i] != this.pdbSequence[j]) continue;
                matrixBool[i][j] = true;
            }
        }
        return matrixBool;
    }

    private void removeGapsFromAlign() {
        this.correspCleanVsAlign = new HashMap();
        int cleanSequenceSize = 0;
        for (int i = 0; i < this.alignSequence.length; ++i) {
            if (this.alignSequence[i] == '-') continue;
            ++cleanSequenceSize;
        }
        this.cleanAlignSequence = new char[cleanSequenceSize];
        int j = 0;
        for (int i = 0; i < this.alignSequence.length; ++i) {
            if (this.alignSequence[i] == '-') continue;
            this.cleanAlignSequence[j] = this.alignSequence[i];
            this.correspCleanVsAlign.put(j, i);
            ++j;
        }
    }

    public int getNumCols() {
        return this.pdbSequence.length;
    }

    public int getNumRows() {
        return this.cleanAlignSequence.length;
    }

    public void alignSequenceToStructure() {
        int j;
        int i;
        this.removeGapsFromAlign();
        this.dotplot = this.getDotPlotMatrix();
        for (i = 1; i < this.getNumRows() - 1; ++i) {
            for (j = 1; j < this.getNumCols() - 1; ++j) {
                if (!this.dotplot[i][j] || this.dotplot[i + 1][j + 1] || this.dotplot[i - 1][j - 1]) continue;
                this.dotplot[i][j] = false;
            }
        }
        this.startFlag = false;
        for (i = 0; i < this.getNumRows(); ++i) {
            for (j = 0; j < this.getNumCols(); ++j) {
                if (this.startFlag || i + 3 >= this.getNumRows() || j + 3 >= this.getNumCols() || !this.dotplot[i][j] || !this.dotplot[i + 1][j + 1] || !this.dotplot[i + 2][j + 2] || !this.dotplot[i + 3][j + 3]) continue;
                this.startFlag = true;
                this.startRow = i;
                this.startCol = j;
                break;
            }
            if (this.startFlag) break;
        }
        this.align2PDBPositionMap = new HashMap();
        this.pdb2alignPositionMap = new HashMap();
        if (this.startFlag) {
            int row = this.startRow;
            int col = this.startCol;
            while (col < this.getNumCols() && row < this.getNumRows()) {
                if (this.dotplot[row][col]) {
                    this.align2PDBPositionMap.put(this.correspCleanVsAlign.get(row) + 1, col + 1);
                    this.pdb2alignPositionMap.put(col + 1, this.correspCleanVsAlign.get(row) + 1);
                    ++col;
                    ++row;
                    continue;
                }
                boolean foundNextGroup = false;
                int range = 1;
                while (!foundNextGroup && row + range < this.getNumRows() && col + range < this.getNumCols()) {
                    int i2;
                    for (i2 = 0; i2 <= range; ++i2) {
                        if (!this.dotplot[row + range][col + i2]) continue;
                        row += range;
                        col += i2;
                        foundNextGroup = true;
                        break;
                    }
                    if (!foundNextGroup) {
                        for (i2 = 0; i2 <= range; ++i2) {
                            if (!this.dotplot[row + i2][col + range]) continue;
                            row += i2;
                            col += range;
                            foundNextGroup = true;
                            break;
                        }
                    }
                    if (row + ++range < this.getNumRows() && col + range < this.getNumCols()) continue;
                    row = this.getNumRows();
                    col = this.getNumCols();
                }
            }
        }
    }

    public HashMap<Integer, Integer> getAlign2PDBPositionMap() {
        return this.align2PDBPositionMap;
    }

    public HashMap<Integer, Integer> getPdb2alignPositionMap() {
        return this.pdb2alignPositionMap;
    }

    public void checkAlignment() {
        double coverage = Double.valueOf(this.align2PDBPositionMap.size()) / (double)this.cleanAlignSequence.length;
        if (coverage < 0.1) {
            DecimalFormat df = new DecimalFormat("#.## %");
            JOptionPane.showMessageDialog(new JFrame(), "Warning! Aligned matches only covers " + df.format(coverage) + " of the sequence.");
        }
    }

    public void showAlignment() {
        int l;
        int difference;
        int i;
        int i2;
        DecimalFormat df = new DecimalFormat("(#.## %)", new DecimalFormatSymbols(new Locale("en")));
        double coverageAlign = Double.valueOf(this.align2PDBPositionMap.size()) / (double)this.cleanAlignSequence.length;
        double coveragePdb = Double.valueOf(this.pdb2alignPositionMap.size()) / (double)this.pdbSequence.length;
        int matchesLength = new String("(" + this.align2PDBPositionMap.size() + ")").length();
        int maxLength = Math.max(matchesLength, Math.max(df.format(coverageAlign).length(), df.format(coveragePdb).length()));
        StringBuffer header = new StringBuffer("  MATCHES " + String.format("%" + maxLength + "s:", "(" + this.align2PDBPositionMap.size() + ")"));
        StringBuffer line1 = new StringBuffer(" SEQUENCE " + String.format("%" + maxLength + "s:", df.format(coverageAlign)));
        StringBuffer line2 = new StringBuffer("STRUCTURE " + String.format("%" + maxLength + "s:", df.format(coveragePdb)));
        int firstMatchMin = Math.min(this.startRow, this.startCol);
        int firstMatchMax = Math.max(this.startRow, this.startCol);
        if (this.startCol > this.startRow) {
            for (i2 = 0; i2 < firstMatchMax - firstMatchMin; ++i2) {
                header.append("-");
                line1.append(" ");
                line2.append(this.pdbSequence[i2]);
            }
        } else {
            for (i2 = 0; i2 < firstMatchMax - firstMatchMin; ++i2) {
                header.append("-");
                line1.append(this.cleanAlignSequence[i2]);
                line2.append(" ");
            }
        }
        for (i2 = firstMatchMax - firstMatchMin; i2 < firstMatchMax; ++i2) {
            header.append("-");
            if (this.startCol > this.startRow) {
                line1.append(this.cleanAlignSequence[i2 - (firstMatchMax - firstMatchMin)]);
                line2.append(this.pdbSequence[i2]);
                continue;
            }
            line1.append(this.cleanAlignSequence[i2]);
            line2.append(this.pdbSequence[i2 - (firstMatchMax - firstMatchMin)]);
        }
        int lastMatchSeq = this.startRow;
        int lastMatchPdb = this.startCol;
        int j = this.startCol;
        for (i = this.startRow; i < this.getNumRows(); ++i) {
            if (!this.align2PDBPositionMap.containsKey(this.correspCleanVsAlign.get(i) + 1)) continue;
            j = this.align2PDBPositionMap.get(this.correspCleanVsAlign.get(i) + 1) - 1;
            difference = Math.min(i - lastMatchSeq, j - lastMatchPdb);
            for (l = 0; l < difference; ++l) {
                header.append("-");
                line1.append(this.cleanAlignSequence[lastMatchSeq + l]);
                line2.append(this.pdbSequence[lastMatchPdb + l]);
            }
            for (l = difference; l < Math.max(i - lastMatchSeq, j - lastMatchPdb); ++l) {
                header.append("-");
                if (i - lastMatchSeq > j - lastMatchPdb) {
                    line1.append(this.cleanAlignSequence[lastMatchSeq + l]);
                    line2.append("-");
                    continue;
                }
                line1.append("-");
                line2.append(this.pdbSequence[lastMatchPdb + l]);
            }
            header.append("*");
            line1.append(this.cleanAlignSequence[i]);
            line2.append(this.pdbSequence[j]);
            lastMatchSeq = i + 1;
            lastMatchPdb = j + 1;
        }
        i = this.getNumRows();
        j = this.getNumCols();
        difference = Math.min(i - lastMatchSeq, j - lastMatchPdb);
        for (l = 0; l < difference; ++l) {
            header.append("-");
            line1.append(this.cleanAlignSequence[lastMatchSeq + l]);
            line2.append(this.pdbSequence[lastMatchPdb + l]);
        }
        for (l = difference; l < Math.max(i - lastMatchSeq, j - lastMatchPdb); ++l) {
            header.append("-");
            if (i - lastMatchSeq > j - lastMatchPdb) {
                line1.append(this.cleanAlignSequence[lastMatchSeq + l]);
                line2.append(" ");
                continue;
            }
            line1.append(" ");
            line2.append(this.pdbSequence[lastMatchPdb + l]);
        }
        header.append("\n");
        header.append(line1);
        header.append("\n");
        header.append(line2);
        JScrollPane alignedFrame = new JScrollPane(null, 20, 30);
        alignedFrame.setPreferredSize(new Dimension(600, 80));
        alignedFrame.setMaximumSize(new Dimension(600, 80));
        JTextArea alignedText = new JTextArea(header.toString());
        alignedText.setEditable(false);
        alignedText.setLineWrap(false);
        alignedText.setWrapStyleWord(false);
        alignedText.setFont(new Font("monospaced", 0, 14));
        alignedFrame.setViewportView(alignedText);
        JOptionPane.showMessageDialog(null, alignedFrame, "Alignment Information", 1);
    }

    public int getAlignPos(int pdbPos) {
        int alignPos = this.pdb2alignPositionMap.containsKey(pdbPos) ? this.pdb2alignPositionMap.get(pdbPos) : -1;
        return alignPos;
    }

    public int getPDBPos(int alignPos) {
        int pdbPos = this.align2PDBPositionMap.containsKey(alignPos) ? this.align2PDBPositionMap.get(alignPos) : -1;
        return pdbPos;
    }
}

