/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Set;
import pdb.AbstractAminoAcid;
import pdb.AbstractPDBparser;
import pdb.DataPrintStream;
import pdb.PDBinterpreter;

public class Test
extends PDBinterpreter {
    static DataPrintStream out;
    static DataPrintStream outLog;
    static DataPrintStream outError;
    static DataPrintStream outRes;
    static DataPrintStream outRes2;
    static DataPrintStream outSec;
    static DataPrintStream outAtoms;

    static {
        outLog = out = new DataPrintStream(System.out);
        outError = out;
        outRes = out;
        outRes2 = out;
        outSec = out;
        outAtoms = out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Give filename as option.");
            System.exit(0);
        }
        String filename = "C:/Users/User/workspace/jDet/pdb1ohv.ent";
        Test reader = new Test();
        FileInputStream fil = new FileInputStream(filename);
        reader.open(fil);
        reader.setExceptionPrintStream(outError);
        reader.parse();
        reader.close();
        if (reader.exceptionList.size() > 0) {
            outLog.println("Number of exceptions in parsing: " + reader.exceptionList.size());
        } else {
            outError.println("File parsed without errors.");
        }
    }

    public String readLine() {
        String line = super.readLine();
        return line;
    }

    public boolean hasKey(String key) {
        boolean value = super.hasKey(key);
        return value;
    }

    public void newHeader(String t) {
        outLog.println(t);
    }

    public void newTitle(String t) {
        outLog.println(t);
    }

    public void beginPrimaryStructureSection() {
        outLog.println("Reading primary structure.");
        outRes.println("Primary structure:");
    }

    public void endPrimaryStructureSection() {
        outRes.space(" ");
        Set keys = this.primaryStructure.keySet();
        for (String chainID : keys) {
            outRes.println("Chain: \"" + chainID + "\"");
            outRes.prefix(String.valueOf(chainID) + "   ");
            PDBinterpreter.PrimaryStructureData chain = (PDBinterpreter.PrimaryStructureData)this.primaryStructure.get(chainID);
            for (AbstractAminoAcid amino : chain.resSequence) {
                outRes.print(amino.toString());
            }
            outRes.prefix("");
        }
        outRes.println();
        if (this.mapModRes.size() > 0) {
            outRes.println("Modified residues:");
            Iterator<Object> i = this.mapModRes.keyIterator();
            while (i.hasNext()) {
                outRes.print("   " + (String)i.next() + ": ");
            }
        }
    }

    public void beginSecondaryStructureSection() {
        outLog.prefix("Structures: ").space(" ");
    }

    public AbstractPDBparser.SecondaryStructureData newSecondaryStructure(Object type) {
        outLog.print(type.toString());
        return new SecondaryStructure(type);
    }

    public void endSecondaryStructureSection() {
        outLog.prefix("");
    }

    public void newModel(int modelId) {
        outLog.println("Model " + modelId);
        outAtoms.prefix("").println("Model " + modelId + ":");
    }

    public AbstractPDBparser.AtomicData newAtom(String name) {
        outAtoms.print("Atom  : ");
        AtomData atom = new AtomData();
        atom.setName(name);
        return atom;
    }

    public AbstractPDBparser.AtomicData newHetatm(String name) {
        outAtoms.print("Hetatm: ");
        AtomData atom = new AtomData();
        atom.setName(name);
        return atom;
    }

    public void endParse() {
        outLog.println("End of parsing.");
    }

    public void endCoordinateSection() {
        outRes2.println("Primary structure:");
        outRes2.space(" ");
        Set keys = this.primaryStructure.keySet();
        for (String chainID : keys) {
            outRes2.println("Chain: \"" + chainID + "\"");
            outRes2.prefix(String.valueOf(chainID) + "   ");
            PDBinterpreter.PrimaryStructureData chain = (PDBinterpreter.PrimaryStructureData)this.primaryStructure.get(chainID);
            if (chain.atomResSequence == null) {
                outRes2.println("null");
            } else {
                for (AbstractAminoAcid amino : chain.atomResSequence) {
                    if (amino == null) {
                        outRes2.print("---");
                        continue;
                    }
                    outRes2.print(amino.toString());
                }
            }
            outRes2.prefix("");
        }
        outRes2.println();
    }

    public class AtomData
    extends AbstractPDBparser.AtomicData {
        public void setName(String name) {
            outAtoms.print(name);
        }

        public void make() {
            outAtoms.println();
        }

        public void setCoord(float x, float y, float z) {
            outAtoms.print("  [" + x + "," + y + "," + z + "]");
        }
    }

    public class SecondaryStructure
    extends AbstractPDBparser.SecondaryStructureData {
        public SecondaryStructure(Object type) {
            super(type);
        }

        public void make() {
            outSec.println(String.valueOf(this.type.toString()) + ": " + this.chainID + "  " + this.start + " - " + this.stop);
        }
    }
}

