/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import java.io.PrintStream;
import java.util.ArrayList;
import pdb.AbstractPDBparser;
import pdb.ChangeIndicator;
import pdb.ChangeIntIndicator;
import pdb.ChangeObjectIndicator;
import pdb.ParseException;

public class PDBparser
extends AbstractPDBparser {
    public AbstractPDBparser.AtomicData nullAtomicData;
    public PrintStream exceptionPrintStream;
    public ArrayList<Exception> exceptionList;
    private ChangeIndicator atomAlt;
    private ChangeIntIndicator residueID;
    private ChangeObjectIndicator chainID;

    public PDBparser() {
        this.nullAtomicData = this.forgetAtomicData;
        this.exceptionPrintStream = null;
        this.exceptionList = new ArrayList();
        this.atomAlt = new ChangeIndicator(){

            public void resetThis() {
            }

            public boolean changed(Object t) {
                return t.equals("") || t.equals(" ") || t.equals("A");
            }
        };
        this.residueID = new ChangeIntIndicator();
        this.chainID = new ChangeObjectIndicator();
    }

    public String readLine() {
        String line;
        while (!this.lineHasKnownKey(line = super.readLine())) {
            this.addParseException("Unrecognized keyword", line);
        }
        return line;
    }

    public void addException(Exception e) {
        this.exceptionList.add(e);
        this.printException(e);
    }

    public void addParseException(String s, Exception e) {
        this.addException(new ParseException(String.valueOf(s) + "\n[" + this.line() + "]", e));
    }

    public void addParseException(String s, String line) {
        this.addException(new ParseException(String.valueOf(s) + "\n[" + line + "]"));
    }

    public void addParseException(String s) {
        this.addParseException(s, this.line());
    }

    public void printException(Exception e) {
        if (this.exceptionPrintStream != null) {
            this.exceptionPrintStream.println(e);
        }
    }

    public void setExceptionPrintStream(PrintStream ps) {
        this.exceptionPrintStream = ps;
    }

    public void parse() {
        this.init();
        this.nextLine();
        this.beginParse();
        this.parseTitleSection();
        this.parsePrimaryStructureSection();
        this.parseHeterogenSection();
        this.parseSecondaryStructureSection();
        this.parseConnectivityAnnotationSection();
        this.parseMiscellaneousFeaturesSection();
        this.parseCoordinateTransformationSection();
        this.parseCoordinateSection();
        this.parseConnectivitySection();
        this.parseBookkeepingSection();
        this.endParse();
    }

    public int getResidueID() {
        return this.residueID.value;
    }

    public String getChainId() {
        return (String)this.chainID.value;
    }

    private void init() {
        this.residueID.nest(this.atomAlt);
        this.chainID.nest(this.residueID);
    }

    private void parseTitleSection() {
        this.beginTitleSection();
        if (this.checkKey("HEADER")) {
            this.newHeader(this.sub(10, 40).trim(), this.sub(50, 9), this.sub(62, 4));
            this.nextLine();
        }
        while (this.hasKey("OBSLTE")) {
            String date = this.sub(11, 9);
            String thisID = this.sub(21, 4);
            int i = 8;
            while (i-- > 0) {
                this.skip(1);
                String newID = this.sub(4).trim();
                if (newID.equals("")) break;
                this.newObslte(date, thisID, newID);
            }
            this.nextLine();
        }
        while (this.hasKey("TITLE ")) {
            this.pos(10);
            this.newTitle(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("CAVEAT")) {
            this.newCaveat(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("COMPND")) {
            this.newCompnd(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("SOURCE")) {
            this.newSource(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("KEYWDS")) {
            this.newKeywds(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("EXPDTA")) {
            this.newExpdta(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("AUTHOR")) {
            this.newAuthor(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("REVDAT")) {
            this.newRevdat(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("SPRSDE")) {
            this.newSprsde(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("JRNL  ")) {
            this.newJrnl(this.rest().trim());
            this.nextLine();
        }
        while (this.hasKey("REMARK")) {
            this.newRemark(this.rest().trim());
            this.nextLine();
        }
        this.endTitleSection();
    }

    private void parsePrimaryStructureSection() {
        this.beginPrimaryStructureSection();
        this.chainID.reset();
        while (this.hasKey("DBREF ")) {
            this.newDbref();
            this.nextLine();
        }
        this.chainID.reset();
        while (this.hasKey("SEQADV")) {
            this.newSeqadv();
            this.nextLine();
        }
        this.chainID.reset();
        while (this.hasKey("SEQRES")) {
            this.newSeqres();
            this.nextLine();
        }
        this.chainID.reset();
        while (this.hasKey("MODRES")) {
            this.newModres();
            this.nextLine();
        }
        while (this.hasKey("FTNOTE")) {
            this.nextLine();
        }
        this.endPrimaryStructureSection();
    }

    private void newSeqres() {
        if (this.chainID.changed(this.sub(11, 1))) {
            this.newSeqresChain(this.getChainId());
        }
        this.pos(19);
        int i = 13;
        while (i-- > 0) {
            String res = this.sub(3).trim();
            if (res.equals("")) break;
            this.newResidue(res);
            this.skip(1);
        }
    }

    private void parseHeterogenSection() {
        this.beginHeterogenSection();
        while (this.hasKey("HET   ")) {
            this.newHet();
            this.nextLine();
        }
        while (this.hasKey("HETNAM")) {
            this.newHetnam();
            this.nextLine();
        }
        while (this.hasKey("HETSYN")) {
            this.newHetsyn();
            this.nextLine();
        }
        while (this.hasKey("FORMUL")) {
            this.newFormul();
            this.nextLine();
        }
        this.endHeterogenSection();
    }

    private void parseSecondaryStructureSection() {
        AbstractPDBparser.SecondaryStructureData structure;
        this.beginSecondaryStructureSection();
        while (this.hasKey("HELIX ")) {
            structure = this.newHelix();
            structure.setChainId(this.sub(19, 1));
            try {
                structure.setStartStop(this.getInt(21, 4), this.getInt(33, 4));
                structure.setClass(this.getInt(38, 2));
            }
            catch (NumberFormatException e) {
                this.addParseException("Invalid HELIX specification:", e);
            }
            structure.make();
            this.nextLine();
        }
        while (this.hasKey("SHEET ")) {
            structure = this.newSheet();
            structure.setChainId(this.sub(21, 1));
            try {
                structure.setStartStop(this.getInt(22, 4), this.getInt(33, 4));
                int sense = this.getInt(38, 2);
                structure.setClass(sense);
                if (sense != 0) {
                    try {
                        structure.setSheetBond(this.getInt(50, 4), this.sub(64, 1), this.getInt(65, 4));
                    }
                    catch (NumberFormatException e) {
                        this.addParseException("Beta sheet without proper specification of previous beta sheet:", e);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.addParseException("Invalid SHEET specification:", e);
            }
            structure.make();
            this.nextLine();
        }
        while (this.hasKey("TURN  ")) {
            structure = this.newTurn();
            structure.setChainId(this.sub(19, 1));
            try {
                structure.setStartStop(this.getInt(20, 4), this.getInt(31, 4));
            }
            catch (NumberFormatException e) {
                this.addParseException("Invalid TURN specification:", e);
            }
            structure.make();
            this.nextLine();
        }
        this.endSecondaryStructureSection();
    }

    private void parseConnectivityAnnotationSection() {
        this.beginConnectivityAnnotationSection();
        while (this.hasKey("SSBOND")) {
            this.newSSbond();
            this.nextLine();
        }
        while (this.hasKey("LINK  ")) {
            this.newLink();
            this.nextLine();
        }
        while (this.hasKey("HYDBND")) {
            this.newHydbnd();
            this.nextLine();
        }
        while (this.hasKey("SLTBRG")) {
            this.newSltbrg();
            this.nextLine();
        }
        while (this.hasKey("CISPEP")) {
            this.newCispep();
            this.nextLine();
        }
        this.endConnectivityAnnotationSection();
    }

    private void parseMiscellaneousFeaturesSection() {
        this.beginMiscellaneousFeaturesSection();
        while (this.hasKey("SITE  ")) {
            this.newSite();
            this.nextLine();
        }
        this.endMiscellaneousFeaturesSection();
    }

    private void parseCoordinateTransformationSection() {
        this.beginCoordinateTransformationSection();
        while (this.hasKey("CRYST1")) {
            this.newModres();
            this.nextLine();
        }
        while (this.hasKey("ORIGX")) {
            this.newOrigx();
            this.nextLine();
        }
        while (this.hasKey("SCALE")) {
            this.newScale();
            this.nextLine();
        }
        while (this.hasKey("MTRIX")) {
            this.newMtrix();
            this.nextLine();
        }
        while (this.hasKey("TVECT")) {
            this.newTvect();
            this.nextLine();
        }
        this.endCoordinateTransformationSection();
    }

    /*
     * Unable to fully structure code
     */
    private void parseCoordinateSection() {
        block4: {
            this.beginCoordinateSection();
            if (!this.hasKey("ATOM  ") && !this.hasKey("HETATM")) ** GOTO lbl18
            this.newModel(0);
            this.parseModel();
            this.endModel();
            break block4;
lbl-1000:
            // 1 sources

            {
                try {
                    this.newModel(this.getInt(10, 4));
                }
                catch (NumberFormatException e) {
                    this.addParseException("Invalid MODEL numbering:", e);
                    this.newModel(0);
                }
                this.nextLine();
                this.parseModel();
                if (this.checkKey("ENDMDL")) {
                    this.nextLine();
                }
                this.endModel();
lbl18:
                // 2 sources

                ** while (this.hasKey((String)"MODEL "))
            }
        }
        this.endCoordinateSection();
    }

    private void parseModel() {
        AbstractPDBparser.AtomicData atom = this.forgetAtomicData;
        while (true) {
            if (this.hasKey("ATOM  ") || this.hasKey("HETATM")) {
                if (this.isNewAtom()) {
                    atom.make();
                    atom = this.hasKey("ATOM  ") ? this.newAtom(this.sub(12, 4).trim()) : this.newHetatm(this.sub(12, 4).trim());
                    this.doAtomHead(atom);
                } else {
                    atom = this.alternateAtom(atom);
                }
                this.doAtomDetails(atom);
            } else if (this.hasKey("SIGATM")) {
                this.newSigatm();
            } else if (this.hasKey("ANISOU")) {
                this.newAnisou();
            } else if (this.hasKey("SIGUIJ")) {
                this.newSiguij();
            } else {
                if (!this.hasKey("TER   ")) break;
                atom.make();
                atom = this.nullAtomicData;
                this.endAtomResidue();
                this.terChain();
            }
            this.nextLine();
        }
        atom.make();
        this.endAtomChain();
    }

    private boolean isNewAtom() {
        if (this.chainID.changed(this.sub(21, 1))) {
            this.newAtomChain(this.getChainId());
        }
        if (this.residueID.changed(this.getInt(22, 4))) {
            this.newAtomResidue(this.sub(17, 3));
        }
        return this.atomAlt.changed(this.sub(16, 1));
    }

    private void doAtomHead(AbstractPDBparser.AtomicData atom) {
    }

    private void doAtomDetails(AbstractPDBparser.AtomicData atom) {
        atom.setAltLoc(this.sub(16, 1));
        atom.setICode(this.sub(26, 1).trim());
        try {
            atom.setCoord(this.getNum(30, 8), this.getNum(8), this.getNum(8));
            atom.setOccupancy(this.getNum(6));
            atom.setTempFactor(this.getNum(6));
        }
        catch (NumberFormatException e) {
            this.addParseException("Invalid atomic data:", e);
        }
    }

    private void parseConnectivitySection() {
        this.beginConnectivitySection();
        while (this.hasKey("CONECT")) {
            this.newConect();
            this.nextLine();
        }
        this.endConnectivitySection();
    }

    private void parseBookkeepingSection() {
        if (this.hasKey("MASTER")) {
            this.newMaster();
            this.nextLine();
        }
        this.checkKey("END   ");
    }
}

