/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import java.util.ArrayList;
import java.util.HashMap;
import pdb.AbstractAminoAcid;
import pdb.AbstractAminoAcidMap;
import pdb.AbstractPDBparser;
import pdb.AminoAcid;
import pdb.AminoAcidMap;
import pdb.PDBparser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDBinterpreter
extends PDBparser {
    PrimaryStructureData presentPrimary;
    AbstractAminoAcid presentResidue;
    public HashMap<String, PrimaryStructureData> primaryStructure = new HashMap();
    public AbstractAminoAcidMap mapStandardRes;
    public AbstractAminoAcidMap mapModRes;
    public HashMap<String, ArrayList<AbstractPDBparser.SecondaryStructureData>> secondaryStructures = new HashMap();

    public PDBinterpreter() {
        this.mapStandardRes = this.getStandardResMap();
        this.mapModRes = this.newAminoAcidMap();
    }

    public AbstractAminoAcidMap newAminoAcidMap() {
        return new AminoAcidMap();
    }

    public AbstractAminoAcidMap getStandardResMap() {
        return AminoAcid.aminoAcids;
    }

    public AbstractAminoAcid newModifiedResidue(String acronym) {
        AminoAcid amino = new AminoAcid('?', acronym, acronym);
        this.mapModRes.put(acronym, amino);
        return amino;
    }

    public AbstractAminoAcid getResidue(String acronym) {
        AbstractAminoAcid amino = this.mapStandardRes.get(acronym);
        if (amino == null) {
            amino = this.mapModRes.get(acronym);
        }
        return amino;
    }

    @Override
    public final void newSeqresChain(String chain) {
        this.presentPrimary = new PrimaryStructureData();
        this.primaryStructure.put(chain, this.presentPrimary);
    }

    @Override
    public final void newResidue(String acronym) {
        AbstractAminoAcid amino = this.getResidue(acronym);
        if (amino == null) {
            amino = this.newModifiedResidue(acronym);
        }
        this.presentPrimary.addRes(amino);
    }

    @Override
    public final void newAtomChain(String chain) {
        this.presentPrimary = this.primaryStructure.get(chain);
    }

    @Override
    public final void newAtomResidue(String acronym) {
        AbstractAminoAcid amino = this.getResidue(acronym);
        if (amino != null) {
            this.presentPrimary.addAtomRes(this.getResidueID(), amino);
        }
    }

    @Override
    public AbstractPDBparser.SecondaryStructureData newSecondaryStructure(Object type) {
        return new SecondaryStructure(type);
    }

    public ArrayList<AbstractPDBparser.SecondaryStructureData> getSecondaryStructureList(String chainID) {
        ArrayList<AbstractPDBparser.SecondaryStructureData> list = this.secondaryStructures.get(chainID);
        if (list == null) {
            list = new ArrayList();
            this.secondaryStructures.put(chainID, list);
        }
        return list;
    }

    public class PrimaryStructureData {
        public ArrayList<AbstractAminoAcid> resSequence = new ArrayList();
        public ArrayList<AbstractAminoAcid> atomResSequence = null;
        int atomResIndex0 = 0;

        public void addRes(AbstractAminoAcid amino) {
            this.resSequence.add(amino);
        }

        public void addAtomRes(int index, AbstractAminoAcid amino) {
            if (this.atomResSequence == null) {
                this.atomResIndex0 = index;
                this.atomResSequence = new ArrayList();
            }
            int i = index - this.atomResIndex0 - this.atomResSequence.size();
            while (i-- >= 0) {
                this.atomResSequence.add(null);
            }
            while (index < this.atomResIndex0) {
                this.atomResSequence.add(0, null);
                --this.atomResIndex0;
            }
            this.atomResSequence.set(index - this.atomResIndex0, amino);
        }
    }

    public class SecondaryStructure
    extends AbstractPDBparser.SecondaryStructureData {
        public SecondaryStructure(Object type) {
            super(type);
        }

        public void make() {
            ArrayList<AbstractPDBparser.SecondaryStructureData> list = PDBinterpreter.this.getSecondaryStructureList(this.chainID);
            list.add(this);
        }
    }
}

