/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class DataFileReader {
    BufferedReader reader = null;
    String line = null;
    private int pos = 0;
    private String value;

    public void open(Reader rd) {
        this.reader = new BufferedReader(rd);
    }

    public void open(InputStream stream) {
        this.open(new InputStreamReader(stream));
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public void nextLine() {
        this.line = this.readLine();
    }

    public boolean hasKey(String key) {
        if (this.line == null) {
            return false;
        }
        this.pos = key.length();
        return this.line.startsWith(key);
    }

    public boolean checkKey(String key) {
        if (!this.hasKey(key)) {
            System.out.println("Missing key: " + key);
            return false;
        }
        return true;
    }

    public boolean hasValue(int n) {
        this.value = this.sub(n);
        return this.value.trim().length() > 0;
    }

    public DataFileReader pos(int i) {
        this.pos = i;
        return this;
    }

    public DataFileReader skip(int n) {
        this.pos += n;
        return this;
    }

    public String line() {
        return this.line;
    }

    public String rest() {
        return this.line.substring(this.pos);
    }

    public String getValue() {
        return this.value;
    }

    public String sub(int n) {
        return this.line.substring(this.pos, this.pos += n);
    }

    public String sub(int i, int n) {
        this.pos = i + n;
        return this.line.substring(i, i + n);
    }

    public int getInt() {
        return this.getInt(this.value);
    }

    public int getInt(String t) {
        return Integer.parseInt(t.trim());
    }

    public int getInt(int n) {
        return this.getInt(this.sub(n));
    }

    public int getInt(int i, int n) {
        return this.getInt(this.sub(i, n));
    }

    public float getNum() {
        return this.getNum(this.value);
    }

    public float getNum(String t) {
        return Float.parseFloat(t.trim());
    }

    public float getNum(int n) {
        return this.getNum(this.sub(n));
    }

    public float getNum(int i, int n) {
        return this.getNum(this.sub(i, n));
    }
}

