/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.AlignObject;
import model.FuncResidueImpl;
import model.XDetObject;
import util.Constants;

public class XDetParser {
    char xDetUndefined = (char)46;

    public XDetObject read(String xdetfile, AlignObject alObj) {
        XDetObject xdetObject = new XDetObject();
        xdetObject.setFilename(xdetfile);
        try {
            String nextLine;
            BufferedReader reader = new BufferedReader(new FileReader(xdetfile));
            ArrayList<FuncResidueImpl> funcResList = new ArrayList<FuncResidueImpl>();
            HashMap<Integer, FuncResidueImpl> pos2ResMap = new HashMap<Integer, FuncResidueImpl>();
            Pattern p = Pattern.compile("^\\*\\*");
            while ((nextLine = reader.readLine()) != null) {
                Matcher m = p.matcher(nextLine);
                if (m.find()) {
                    throw new NumberFormatException("Xdet error: " + nextLine);
                }
                StringTokenizer tokenizer = new StringTokenizer(nextLine, " ");
                ArrayList<String> tokenList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    tokenList.add(tokenizer.nextToken());
                }
                try {
                    Double.parseDouble((String)tokenList.get(3));
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("Old Xdet format not supported. Change the chain ID by empty space and re-load");
                }
                if (!(((String)tokenList.get(1)).charAt(0) == alObj.getSequenceAt(0).getLetterAt(Integer.parseInt((String)tokenList.get(0)) - 1) || ((String)tokenList.get(1)).charAt(0) == this.xDetUndefined || alObj.getSequenceAt(0).getLetterAt(Integer.parseInt((String)tokenList.get(0)) - 1) == 'X' || Constants.isGap(((String)tokenList.get(1)).charAt(0)) && Constants.isGap(alObj.getSequenceAt(0).getLetterAt(Integer.parseInt((String)tokenList.get(0)) - 1)))) {
                    throw new RuntimeException(":Xdet file data doesn't fit with master sequence.");
                }
                FuncResidueImpl funcRes = new FuncResidueImpl();
                funcRes.setPosition(Integer.parseInt((String)tokenList.get(0)));
                funcRes.setAa(((String)tokenList.get(1)).charAt(0));
                funcRes.setEntropy(new BigDecimal((String)tokenList.get(4)));
                funcRes.setCorrelation(new BigDecimal((String)tokenList.get(8)));
                funcResList.add(funcRes);
                pos2ResMap.put(funcRes.getPosition(), funcRes);
            }
            FuncResidueImpl[] funcResidues = new FuncResidueImpl[funcResList.size()];
            for (int i = 0; i < funcResList.size(); ++i) {
                funcResidues[i] = (FuncResidueImpl)funcResList.get(i);
            }
            xdetObject.setFuncResidues(funcResidues);
            xdetObject.setResNumber(funcResidues.length);
            xdetObject.setPos2ResMap(pos2ResMap);
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        return xdetObject;
    }
}

