/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import model.ResidueImpl;
import model.UDMObject;

public class UDMParser {
    public UDMObject read(String file) {
        UDMObject udmObject = new UDMObject();
        udmObject.setFilename(file);
        String methodName = file;
        if (methodName.lastIndexOf("/") != -1) {
            methodName = methodName.substring(methodName.lastIndexOf("/") + 1);
        }
        if (methodName.lastIndexOf("\\") != -1) {
            methodName = methodName.substring(methodName.lastIndexOf("\\") + 1);
        }
        if (methodName.indexOf(".") != -1) {
            methodName = methodName.substring(0, methodName.indexOf("."));
        }
        udmObject.setMethodName(methodName);
        try {
            String nextLine;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ArrayList<ResidueImpl> resList = new ArrayList<ResidueImpl>();
            HashMap<Integer, ResidueImpl> pos2ResMap = new HashMap<Integer, ResidueImpl>();
            while ((nextLine = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(nextLine, " ");
                ArrayList<String> tokenList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    tokenList.add(tokenizer.nextToken());
                }
                ResidueImpl res = new ResidueImpl();
                res.setPosition(Integer.parseInt((String)tokenList.get(0)));
                res.setAa(((String)tokenList.get(1)).charAt(0));
                res.setScore(new BigDecimal((String)tokenList.get(2)));
                resList.add(res);
                pos2ResMap.put(res.getPosition(), res);
            }
            ResidueImpl[] residues = new ResidueImpl[resList.size()];
            for (int i = 0; i < resList.size(); ++i) {
                residues[i] = (ResidueImpl)resList.get(i);
            }
            udmObject.setResidues(residues);
            udmObject.setResNumber(residues.length);
            udmObject.setPos2ResMap(pos2ResMap);
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return udmObject;
    }
}

