/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import model.AlignObject;
import model.ClusterCoordinates;
import model.PredictedPosition;
import model.ResidueCoordinates;
import model.S3DetObject;
import model.SequenceCluster;
import model.SequenceCoordinates;

public class S3DetParser {
    public S3DetObject read(String s3detfile, AlignObject alignObject) {
        S3DetObject s3detObject = new S3DetObject();
        s3detObject.setFilename(s3detfile);
        try {
            int i;
            int i2;
            String nextLine;
            BufferedReader reader = new BufferedReader(new FileReader(s3detfile));
            ArrayList<SequenceCoordinates> seqCoordList = new ArrayList<SequenceCoordinates>();
            ArrayList<ResidueCoordinates> resCoordList = new ArrayList<ResidueCoordinates>();
            ArrayList<SequenceCluster> seqClusList = new ArrayList<SequenceCluster>();
            ArrayList<ClusterCoordinates> clusCoordList = new ArrayList<ClusterCoordinates>();
            ArrayList<PredictedPosition> predPosList = new ArrayList<PredictedPosition>();
            ArrayList<Integer> consPosList = new ArrayList<Integer>();
            HashMap<Integer, PredictedPosition> pos2predPos = new HashMap<Integer, PredictedPosition>();
            HashMap<String, Integer> name2cluster = new HashMap<String, Integer>();
            double[] clusCoordArr = new double[10];
            ClusterCoordinates clusCoord = new ClusterCoordinates();
            clusCoord.setName("Cluster_0");
            clusCoord.setCoords(clusCoordArr);
            clusCoordList.add(clusCoord);
            while ((nextLine = reader.readLine()) != null) {
                int i3;
                StringTokenizer tokenizer;
                if (nextLine.startsWith("UI:")) {
                    String[] uiFields = nextLine.split(":");
                    if (uiFields[1].trim().equals("Initial number of sequences")) {
                        try {
                            int nSeqs = Integer.parseInt(uiFields[2].trim());
                            if (nSeqs == alignObject.getHeight()) continue;
                            throw new RuntimeException(":Selected file doesn't match number of sequences.\n    Expected: " + alignObject.getHeight() + "\n    Found:" + nSeqs);
                        }
                        catch (NumberFormatException nfe) {
                            throw new RuntimeException(":Bad file format, error reading number of sequences.");
                        }
                    }
                    if (!uiFields[1].trim().equals("Initial number of positions")) continue;
                    try {
                        int nPos = Integer.parseInt(uiFields[2].trim());
                        if (nPos == alignObject.getWidth()) continue;
                        throw new RuntimeException(":Selected file doesn't match alignment length.\n    Expected: " + alignObject.getWidth() + "\n    Found:" + nPos);
                    }
                    catch (NumberFormatException nfe) {
                        throw new RuntimeException(":Bad file format, error reading alignment length.");
                    }
                }
                if (nextLine.startsWith("SeqCoord")) {
                    tokenizer = new StringTokenizer(nextLine, "\t");
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    double[] seqCoordArray = new double[10];
                    SequenceCoordinates seqCoords = new SequenceCoordinates();
                    seqCoords.setName((String)tokenList.get(1));
                    for (i3 = 0; i3 < 10; ++i3) {
                        seqCoordArray[i3] = new Double((String)tokenList.get(i3 + 2));
                    }
                    seqCoords.setCoords(seqCoordArray);
                    seqCoordList.add(seqCoords);
                    continue;
                }
                if (nextLine.startsWith("ResCoord")) {
                    tokenizer = new StringTokenizer(nextLine);
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    double[] resCoordArray = new double[10];
                    ResidueCoordinates resCoords = new ResidueCoordinates();
                    String[] temp = ((String)tokenList.get(1)).split("/");
                    resCoords.setPosition(new Integer(temp[0]));
                    resCoords.setLetter(temp[1].charAt(0));
                    for (i2 = 0; i2 < 10; ++i2) {
                        resCoordArray[i2] = new Double((String)tokenList.get(i2 + 2));
                    }
                    resCoords.setCoords(resCoordArray);
                    resCoordList.add(resCoords);
                    continue;
                }
                if (nextLine.startsWith("CL:")) {
                    nextLine = nextLine.substring(4);
                    tokenizer = new StringTokenizer(nextLine, "\t");
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    SequenceCluster seqCluster = new SequenceCluster();
                    seqCluster.setName((String)tokenList.get(0));
                    seqCluster.setClusterIndex(new Integer((String)tokenList.get(1)));
                    seqClusList.add(seqCluster);
                    name2cluster.put(seqCluster.getName(), seqCluster.getClusterIndex());
                    continue;
                }
                if (nextLine.startsWith("ClusCoord")) {
                    tokenizer = new StringTokenizer(nextLine);
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    double[] clusCoordArray = new double[10];
                    ClusterCoordinates clusCoords = new ClusterCoordinates();
                    clusCoords.setName((String)tokenList.get(1));
                    for (i3 = 0; i3 < 10; ++i3) {
                        clusCoordArray[i3] = new Double((String)tokenList.get(i3 + 2));
                    }
                    clusCoords.setCoords(clusCoordArray);
                    clusCoordList.add(clusCoords);
                    continue;
                }
                if (nextLine.startsWith("RE")) {
                    tokenizer = new StringTokenizer(nextLine);
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    PredictedPosition predPosition = new PredictedPosition();
                    predPosition.setPositionRes(new Integer((String)tokenList.get(1)));
                    predPosition.setAverageRank(new BigDecimal((String)tokenList.get(2)));
                    predPosition.setGroupNumber(new Integer((String)tokenList.get(3)));
                    predPosList.add(predPosition);
                    pos2predPos.put(predPosition.getPositionRes(), predPosition);
                    continue;
                }
                if (nextLine.startsWith("CP")) {
                    tokenizer = new StringTokenizer(nextLine);
                    ArrayList<String> tokenList = new ArrayList<String>();
                    while (tokenizer.hasMoreTokens()) {
                        tokenList.add(tokenizer.nextToken());
                    }
                    consPosList.add(new Integer((String)tokenList.get(1)));
                    continue;
                }
                if (!nextLine.contains("Number of axes selected")) continue;
                tokenizer = new StringTokenizer(nextLine);
                ArrayList<String> tokenList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    tokenList.add(tokenizer.nextToken());
                }
                s3detObject.setNumberOfSelectedAxes(new Integer((String)tokenList.get(5)));
            }
            reader.close();
            SequenceCoordinates[] seqCoordinates = new SequenceCoordinates[seqCoordList.size()];
            for (int i4 = 0; i4 < seqCoordList.size(); ++i4) {
                seqCoordinates[i4] = (SequenceCoordinates)seqCoordList.get(i4);
            }
            ResidueCoordinates[] resCoordinates = new ResidueCoordinates[resCoordList.size()];
            for (i = 0; i < resCoordList.size(); ++i) {
                resCoordinates[i] = (ResidueCoordinates)resCoordList.get(i);
            }
            for (i = 0; i < alignObject.getHeight(); ++i) {
                boolean exists = false;
                for (int j = 0; j < seqClusList.size(); ++j) {
                    if (!alignObject.getSequenceAt(i).getName().equals(((SequenceCluster)seqClusList.get(j)).getName())) continue;
                    exists = true;
                }
                if (exists) continue;
                SequenceCluster seqCluster = new SequenceCluster();
                seqCluster.setName(alignObject.getSequenceAt(i).getName());
                seqCluster.setClusterIndex(0);
                seqClusList.add(seqCluster);
                name2cluster.put(seqCluster.getName(), seqCluster.getClusterIndex());
            }
            SequenceCluster[] seqClusters = new SequenceCluster[seqClusList.size()];
            for (int i5 = 0; i5 < seqClusList.size(); ++i5) {
                seqClusters[i5] = (SequenceCluster)seqClusList.get(i5);
            }
            ClusterCoordinates[] clusCoordinates = new ClusterCoordinates[clusCoordList.size()];
            for (int i6 = 0; i6 < clusCoordList.size(); ++i6) {
                clusCoordinates[i6] = (ClusterCoordinates)clusCoordList.get(i6);
            }
            PredictedPosition[] predPositions = new PredictedPosition[predPosList.size()];
            for (i2 = 0; i2 < predPosList.size(); ++i2) {
                predPositions[i2] = (PredictedPosition)predPosList.get(i2);
            }
            int[] consPositions = new int[consPosList.size()];
            for (int i7 = 0; i7 < consPosList.size(); ++i7) {
                consPositions[i7] = (Integer)consPosList.get(i7);
            }
            s3detObject.setSeqCoords(seqCoordinates);
            s3detObject.setResCoords(resCoordinates);
            s3detObject.setSeqClusters(seqClusters);
            s3detObject.setClusterCoords(clusCoordinates);
            s3detObject.setPredictedPositions(predPositions);
            s3detObject.setConservedPositions(consPositions);
            s3detObject.setPos2PredPosition(pos2predPos);
            s3detObject.setName2ClusterIndex(name2cluster);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return s3detObject;
    }
}

