/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import util.ColorScheme;

public class ColorParser {
    public boolean read(String colorfile) {
        boolean uploadOK = true;
        String message = "Color scheme successfully loaded\n";
        try {
            String nextLine;
            BufferedReader reader = new BufferedReader(new FileReader(colorfile));
            HashMap<Character, Double> userColorMap = new HashMap<Character, Double>();
            while ((nextLine = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(nextLine, "\t");
                ArrayList<String> tokenList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    tokenList.add(tokenizer.nextToken());
                }
                Character character = Character.valueOf(((String)tokenList.get(0)).charAt(0));
                Double value = new Double((String)tokenList.get(1));
                userColorMap.put(character, value);
            }
            ColorScheme.addGradualScheme(userColorMap, "User defined");
            ColorScheme.setUserDefSchemeValues(userColorMap);
            ColorScheme.setColorScheme("User defined");
            reader.close();
        }
        catch (FileNotFoundException e) {
            uploadOK = false;
            message = "Error: File " + colorfile + " not found.\n";
        }
        catch (IOException e) {
            uploadOK = false;
            message = "Error reading file:\nFormat is Aminoacid{tab}Value.\n";
        }
        catch (NumberFormatException e) {
            uploadOK = false;
            message = "Error reading file:\nFormat is Aminoacid{tab}Numeric Value\n";
        }
        catch (Exception e) {
            uploadOK = false;
            message = "Wrong file format:\nFormat is Aminoacid{tab}Numeric Value\n";
        }
        if (!uploadOK) {
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return uploadOK;
    }
}

