/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;

public class Orbitals
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String newline = "\n";
    JButton OrbopenButton;
    JButton OrbdeleteButton;
    JButton CooropenButton;
    JButton saveButton;
    JTextField Coorfile;
    JTextField appletPath;
    JFileChooser fc;
    JList OrbList;
    JComboBox RenderMode;
    JComboBox FormatBox;
    private static final int SmallAtomDot = 1;
    private static final int Wireframe = 2;

    public JComponent getPanel() {
        JLabel jLabel = new JLabel("Create a web page with one Jmol Applet to display orbitals on one molecule or atom.");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.appletPath, "Last");
        jPanel.setBorder(BorderFactory.createTitledBorder("Relative Path to Jmol Applet:"));
        this.Coorfile = new JTextField(20);
        this.Coorfile.addActionListener(this);
        this.Coorfile.setText("");
        this.CooropenButton = new JButton("Select Coordinate File...");
        this.CooropenButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.Coorfile, "Center");
        jPanel2.add((Component)this.CooropenButton, "Last");
        jPanel2.setBorder(BorderFactory.createTitledBorder("File containing atom coordinates:"));
        JLabel jLabel2 = new JLabel("Rendering Mode:");
        String[] stringArray = new String[]{"Small Atom Dot", "Wireframe"};
        this.RenderMode = new JComboBox<String>(stringArray);
        this.RenderMode.setSelectedIndex(0);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel2);
        jPanel3.add(this.RenderMode);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel, "First");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "Last");
        JLabel jLabel3 = new JLabel("Page Format:");
        String[] stringArray2 = new String[]{"Single orbital", "Up to 2 orbitals at once", "Up to 3 orbitals at once", "Up to 4 orbitals at once"};
        this.FormatBox = new JComboBox<String>(stringArray2);
        this.FormatBox.setSelectedIndex(3);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jLabel3);
        jPanel5.add(this.FormatBox);
        this.saveButton = new JButton("Save .html as...");
        this.saveButton.addActionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.saveButton);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel4, "First");
        jPanel7.add((Component)jPanel5, "Center");
        jPanel7.add((Component)jPanel6, "Last");
        this.fc = new JFileChooser();
        DefaultListModel defaultListModel = new DefaultListModel();
        this.OrbList = new JList(defaultListModel);
        this.OrbList.setSelectionMode(1);
        this.OrbList.setDragEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.OrbList);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.OrbopenButton = new JButton("Add File(s)...");
        this.OrbopenButton.addActionListener(this);
        this.OrbdeleteButton = new JButton("Delete Selected");
        this.OrbdeleteButton.addActionListener(this);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.OrbopenButton);
        jPanel8.add(this.OrbdeleteButton);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)jPanel8, "First");
        jPanel9.add((Component)jScrollPane, "Last");
        jPanel9.setBorder(BorderFactory.createTitledBorder("Orbital Files (Drag to Preferred Order):"));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)jLabel, "First");
        jPanel10.add((Component)jPanel7, "Center");
        jPanel10.add((Component)jPanel9, "After");
        return jPanel10;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.OrbopenButton) {
            this.fc.setMultiSelectionEnabled(true);
            this.fc.setDialogTitle("Choose the Orbital Files:");
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File[] fileArray = this.fc.getSelectedFiles();
                DefaultListModel defaultListModel = (DefaultListModel)this.OrbList.getModel();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string = fileArray[i].getName();
                    defaultListModel.addElement(string);
                }
            }
        } else if (actionEvent.getSource() == this.OrbdeleteButton) {
            DefaultListModel defaultListModel = (DefaultListModel)this.OrbList.getModel();
            int[] nArray = this.OrbList.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                defaultListModel.remove(nArray[i]);
            }
        } else if (actionEvent.getSource() == this.saveButton) {
            this.fc.setDialogTitle("Save .html file as:");
            int n = this.fc.showSaveDialog(this);
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                DefaultListModel defaultListModel = (DefaultListModel)this.OrbList.getModel();
                LogPanel.log("Saving: " + file.getName() + "." + newline);
                LogPanel.log("  Coordinate file: " + this.Coorfile.getText() + "." + newline);
                for (int i = 0; i < defaultListModel.getSize(); ++i) {
                    LogPanel.log("  Orbital file #" + i + " is " + defaultListModel.getElementAt(i) + ".");
                }
                String string = this.Coorfile.getText();
                boolean bl = true;
                try {
                    bl = this.orbtohtml(this.FormatBox.getSelectedIndex() + 1, this.RenderMode.getSelectedIndex() + 1, file, string, this.OrbList, this.appletPath.getText());
                }
                catch (IOException iOException) {
                    LogPanel.log(iOException.getMessage());
                }
                if (!bl) {
                    LogPanel.log("Call to orbtohtml unsuccessful.");
                }
            } else {
                LogPanel.log("Save command cancelled by \"user\".");
            }
        } else if (actionEvent.getSource() == this.CooropenButton) {
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setDialogTitle("Choose a Coordinate File:");
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                this.Coorfile.removeAll();
                String string = file.getName();
                this.Coorfile.setText(string);
            } else {
                LogPanel.log("Coordinate file selection cancelled by user.");
            }
        }
    }

    private boolean checkformat(int n) throws IOException {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                throw new IOException("WideOneOrb format not yet implemented.");
            }
            case 6: {
                throw new IOException("WideTwoOrb format not yet implemented.");
            }
        }
        throw new IOException("Unacceptable format choice for web page.");
    }

    public boolean orbtohtml(int n, int n2, File file, String string, JList jList, String string2) throws IOException {
        boolean bl = false;
        bl = this.checkformat(n);
        if (bl) {
            PrintStream printStream = null;
            printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            printStream.println("<html>");
            printStream.println("<head>");
            printStream.println("  <meta content=\"text/html; charset=ISO-8859-1\"");
            printStream.println(" http-equiv=\"content-type\">");
            printStream.println("  <title>Sufaces using jmol</title>");
            printStream.println("  <meta content=\"???\" name=\"author\">");
            printStream.println("  <meta content=\"chemistry, orbital, orbitals, isosurface, wavefunction, Jmol, image, animation, rotatable, live display\" name=\"keywords\">");
            printStream.println("  <meta content=\"Orbital display using jmol\" name=\"description\">");
            printStream.println("  <meta");
            printStream.println(" content=\"Page design and layout by J. Gutow 5-2006, page written by Orbitals to Web.jar\"");
            printStream.println(" name=\"details\">");
            printStream.println("  <meta");
            printStream.println(" content=\"This page is designed to have the text and normal html edited in a standard web design\"");
            printStream.println(" name=\"instr1\">");
            printStream.println("  <meta");
            printStream.println(" content=\"program.  The javascript is to control the jmol applet (see below).  It is best to use\"");
            printStream.println(" name=\"instr2\">");
            printStream.println("  <meta");
            printStream.println(" content=\"the java program to generate the proper java script to allow orbital display.  It is\"");
            printStream.println(" name=\"instr3\">");
            printStream.println("  <meta");
            printStream.println(" content=\"important to have all the gzipped files in the same directory as the .html file.  The\"");
            printStream.println(" name=\"instr4\">");
            printStream.println("  <meta");
            printStream.println(" content=\"files needed are: 1) a gzipped file with the atom coordinates, in any of the formats Jmol\"");
            printStream.println(" name=\"instr5\">");
            printStream.println("  <meta");
            printStream.println(" content=\"can read. 2) a gzipped gaussian cube file for each of the orbitals to be displayed.  To\"");
            printStream.println(" name=\"instr6\">");
            printStream.println("  <meta");
            printStream.println(" content=\"save loading time it seems to be better to avoid including the atom coordinates in the\"");
            printStream.println(" name=\"instr7\">");
            printStream.println("  <meta");
            printStream.println(" content=\"cube files.  It is also recommended that the file names for the surfaces correspond to\"");
            printStream.println(" name=\"instr8\">");
            printStream.println("  <meta");
            printStream.println(" content=\"reasonable names for the orbitals as the file names are used to generate the menu items\"");
            printStream.println(" name=\"instr9\">");
            printStream.println("  <meta content=\"that appear in the popup menus for selecting orbitals.\"");
            printStream.println(" name=\"instr10\">");
            printStream.println("  <meta");
            printStream.println(" content=\"The relative path to Jmol on your server must be correct below!!\"");
            printStream.println(" name=\"instr11\">");
            printStream.println("  <script src=\"" + string2 + "/Jmol.js\"></script>");
            printStream.println("</head>");
            printStream.println("<body>");
            printStream.println("<div style=\"text-align: center;\"><big><big><span");
            printStream.println(" style=\"font-weight: bold;\">&lt;Replace this text with your title&gt;<br>");
            printStream.println("</span></big></big>");
            printStream.println("<div style=\"text-align: left;\"><big><big><span");
            printStream.println(" style=\"font-weight: bold;\"></span></big></big>&lt;Describe your");
            printStream.println("molecule and orbitals here. Don't forget to mention that there is a");
            printStream.println("live display below.&nbsp; The user's browser window may be too small to");
            printStream.println("display your text and the table containing the Jmol applet without");
            printStream.println("scrolling.&gt;<br>");
            printStream.println("<br>");
            printStream.println("<big><big><span style=\"font-weight: bold;\"></span></big></big>");
            printStream.println("<table style=\"width: 100%; text-align: left;\" border=\"1\" cellpadding=\"2\"");
            printStream.println(" cellspacing=\"2\">");
            printStream.println("  <tbody>");
            printStream.println("    <tr>");
            printStream.println("      <td style=\"vertical-align: top;\">");
            printStream.println("      <script>");
            printStream.println("jmolInitialize(\"" + string2 + "\");");
            switch (n2) {
                case 1: {
                    printStream.println("jmolApplet(300, \"load " + string + "; spacefill 2%; background white\"); ");
                    break;
                }
                case 2: {
                    printStream.println("jmolApplet(300, \"load " + string + "; spacefill 0%; wireframe; labels %e; set labeloffset 0 0; background white\"); ");
                }
            }
            printStream.println("jmolBr();");
            printStream.println("jmolHtml(\"This image may be rotated and zoomed.  See below for more instructions.\");");
            printStream.println("        </script>");
            printStream.println("      <br>");
            printStream.println("      </td>");
            printStream.println("      <td style=\"vertical-align: top;\">");
            printStream.println("      <div style=\"text-align: right;\"> </div>");
            printStream.println("      <form>");
            printStream.println("        <div style=\"text-align: right;\"> </div>");
            printStream.println("        <table style=\"width: 100%; text-align: left;\" border=\"0\"");
            printStream.println(" cellpadding=\"2\" cellspacing=\"2\">");
            printStream.println("          <tbody>");
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            for (int i = 1; i <= n; ++i) {
                switch (i) {
                    case 1: {
                        string4 = "red";
                        string3 = "blue";
                        string5 = "'true'";
                        string6 = " ";
                        string7 = " ";
                        string8 = " ";
                        break;
                    }
                    case 2: {
                        string4 = "yellow";
                        string3 = "green";
                        string5 = " ";
                        string6 = "'true'";
                        string7 = " ";
                        string8 = " ";
                        break;
                    }
                    case 3: {
                        string4 = "cyan";
                        string3 = "purple";
                        string5 = " ";
                        string6 = " ";
                        string7 = "'true'";
                        string8 = " ";
                        break;
                    }
                    case 4: {
                        string4 = "pink";
                        string3 = "brown";
                        string5 = " ";
                        string6 = " ";
                        string7 = " ";
                        string8 = "'true'";
                        break;
                    }
                    default: {
                        System.out.println(i + ": executing default");
                    }
                }
                printStream.println("            <tr>");
                printStream.println("              <td colspan=\"1\" rowspan=\"1\"");
                printStream.println(" style=\"vertical-align: top; white-space: nowrap; text-align: right;\"><span");
                printStream.println(" style=\"font-weight: bold;\">Orbital");
                printStream.println(i + ":</span><br>");
                printStream.println("              </td>");
                printStream.println("              <td style=\"vertical-align: top;\">");
                printStream.println("              <script>");
                printStream.println("   jmolMenu([");
                printStream.println("   ['isosurface neg" + i + " delete; isosurface pos" + i + " delete;','none'],");
                for (int j = 0; j < jList.getModel().getSize(); ++j) {
                    int n3 = jList.getModel().getElementAt(j).toString().indexOf(".");
                    String string9 = jList.getModel().getElementAt(j).toString().substring(0, n3);
                    printStream.println("   ['isosurface neg" + i + " delete; isosurface pos" + i + " delete; isosurface neg" + i + " -0.06 \"" + jList.getModel().getElementAt(j) + "\"; color isosurface " + string4 + ";isosurface pos" + i + " 0.06 \"" + jList.getModel().getElementAt(j) + "\";color isosurface " + string3 + ";',\"" + string9 + "\"],");
                }
                printStream.println("   ]);");
                printStream.println("   </script>");
                printStream.println("              <br>");
                printStream.println("              </td>");
                printStream.println("            </tr>");
                printStream.println("            <tr>");
                printStream.println("              <td");
                printStream.println(" style=\"vertical-align: top; text-align: right; white-space: nowrap;\">Surface");
                printStream.println("Type:<br>");
                printStream.println("              </td>");
                printStream.println("              <td");
                printStream.println(" style=\"vertical-align: top; text-align: left; white-space: nowrap;\">");
                printStream.println("              <script>");
                printStream.println("   jmolRadioGroup([['isosurface neg" + i + " fill nomesh nodots; isosurface pos" + i + " fill nomesh nodots;','Solid','true'],");
                printStream.println("   ['isosurface neg" + i + " mesh nofill nodots; isosurface pos" + i + " mesh nofill nodots;', 'Mesh'],");
                printStream.println("   ['isosurface neg" + i + " dots nomesh nofill; isosurface pos" + i + " dots nomesh nofill;', 'Dot']");
                printStream.println("    ]);");
                printStream.println("   </script><br>");
                printStream.println("              </td>");
                printStream.println("            </tr>");
                printStream.println("            <tr>");
                printStream.println("              <td");
                printStream.println(" style=\"vertical-align: top; text-align: right; white-space: nowrap;\">Surface");
                printStream.println("Color:<br>");
                printStream.println("              </td>");
                printStream.println("              <td");
                printStream.println(" style=\"vertical-align: top; text-align: left; white-space: nowrap;\">");
                printStream.println("              <script>");
                printStream.println("   jmolRadioGroup([['isosurface neg" + i + "; color isosurface red; isosurface pos" + i + "; color isosurface blue;',\"blue/red\"," + string5 + "],");
                printStream.println("   ['isosurface neg" + i + "; color isosurface yellow; isosurface pos" + i + "; color isosurface green;',\"green/yellow\"," + string6 + "],");
                printStream.println("   ['isosurface neg" + i + "; color isosurface cyan; isosurface pos" + i + "; color isosurface purple;',\"purple/cyan\"," + string7 + "],");
                printStream.println("   ['isosurface neg" + i + "; color isosurface pink; isosurface pos" + i + "; color isosurface brown;',\"brown/pink\"," + string8 + "]");
                printStream.println("   ]);");
                printStream.println("   </script>");
                printStream.println("              <br>");
                printStream.println("              </td>");
                printStream.println("            </tr>");
            }
            printStream.println("          </tbody>");
            printStream.println("        </table>");
            printStream.println("      </form>");
            printStream.println("&lt;This space can be used as a short caption for the applet at left.&gt;<br><br>");
            String string10 = "";
            string10 = WebExport.TimeStamp_WebLink();
            printStream.println(string10);
            printStream.println("Original");
            printStream.println("page composed by <a href=\"http://www.uwosh.edu/faculty_staff/gutow/\">J.");
            printStream.println("Gutow 4/2006</a>. </small> </td>");
            printStream.println("    </tr>");
            printStream.println("    <tr>");
            printStream.println("      <td colspan=\"2\" rowspan=\"1\" style=\"vertical-align: top;\">");
            printStream.println("      <div style=\"text-align: center;\"><span style=\"font-weight: bold;\">Instructions");
            printStream.println("for using Jmol to display");
            printStream.println("orbitals</span>: <br>");
            printStream.println("      </div>");
            printStream.println("      <ol>");
            printStream.println("        <li>Choose which orbitals to display by selecting them using the");
            printStream.println("orbital popup menus.&nbsp; You can control orbital color and fill mode");
            printStream.println("by selecting the appropriate options following each orbital menu.&nbsp;");
            printStream.println("        </li>");
            printStream.println("        <li>ROTATE the image by");
            printStream.println("holding");
            printStream.println("down the mouse button while moving the cursor over the image.&nbsp; </li>");
            printStream.println("        <li>ZOOM by holding down the shift key while moving the cursor");
            printStream.println("up");
            printStream.println("(decrease magnification) or down (increase magnification) on top of the");
            printStream.println("image.&nbsp; </li>");
            printStream.println("        <li>Other options are available in the control menu accessible by");
            printStream.println("holding");
            printStream.println("the mouse button down while the cursor is over \"Jmol\" in the lower");
            printStream.println("right corner (right click also works on a multibutton mouse).&nbsp; </li>");
            printStream.println("        <li>For more info about Jmol go to <a target=\"_blank\"");
            printStream.println(" href=\"http://www.jmol.org\">www.jmol.org.</a></li>");
            printStream.println("      </ol>");
            printStream.println("      </td>");
            printStream.println("    </tr>");
            printStream.println("  </tbody>");
            printStream.println("</table>");
            printStream.println("</div>");
            printStream.println("</div>");
            printStream.println("</body>");
            printStream.println("</html>");
            printStream.close();
        }
        return true;
    }
}

