/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.export.dialog.Dialog;
import org.jmol.export.history.HistoryFile;
import org.jmol.export.image.ImageCreator;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.ConsoleTextArea;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.FileDropper;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface {
    public JmolViewer viewer;
    JmolAdapter modelAdapter;
    JmolApp jmolApp;
    DisplayPanel display;
    StatusBar status;
    protected GaussianDialog gaussianDialog;
    private PreferencesDialog preferencesDialog;
    MeasurementTable measurementTable;
    RecentFilesDialog recentFiles;
    public AtomSetChooser atomSetChooser;
    private ExecuteScriptAction executeScriptAction;
    protected JFrame frame;
    GuiMap guimap = new GuiMap();
    private static int numWindows = 0;
    private static Dimension screenSize = null;
    int startupWidth;
    int startupHeight;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final String CONSOLE_WINDOW_NAME = "Console";
    private static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    protected SplashInterface splash;
    protected JFrame consoleframe;
    String appletContext;
    static HistoryFile historyFile;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String editorAction = "editor";
    private static final String consoleAction = "console";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private static final String gaussianAction = "gauss";
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    int qualityJPG = -1;
    int qualityPNG = -1;
    String imageType;
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction, new GaussianAction()};
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    public static final String chemFileProperty = "chemFile";
    static /* synthetic */ Class class$java$net$URI;

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame jFrame, JmolPanel jmolPanel, int n, int n2, String string, Point point) {
        super(true);
        Object object;
        Object object2;
        this.jmolApp = jmolApp;
        this.frame = jFrame;
        this.startupWidth = n;
        this.startupHeight = n2;
        historyFile = jmolApp.historyFile;
        ++numWindows;
        try {
            this.say("history file is " + historyFile.getFile().getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.setTitle("Jmol");
        jFrame.getContentPane().setBackground(Color.lightGray);
        jFrame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.status = (StatusBar)this.createStatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        this.appletContext = string;
        this.viewer = JmolViewer.allocateViewer(this.display, this.modelAdapter, null, null, null, this.appletContext, new MyStatusListener());
        this.display.setViewer(this.viewer);
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(this, jFrame, this.guimap, this.viewer);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(jFrame);
        this.say(GT._("Initializing Script Window..."));
        this.viewer.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        this.measurementTable = new MeasurementTable(this.viewer, jFrame);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable();
        if (this.display != null) {
            object2 = this.getActions();
            for (int i = 0; i < ((Action[])object2).length; ++i) {
                object = object2[i];
                this.commands.put(object.getValue("Name"), object);
            }
        }
        this.menuItems = new Hashtable();
        this.say(GT._("Building Menubar..."));
        this.executeScriptAction = new ExecuteScriptAction();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        object2 = new JPanel();
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add("North", this.createToolbar());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.display);
        ((Container)object2).add("Center", jPanel);
        this.add("Center", (Component)object2);
        this.add("South", this.status);
        this.say(GT._("Starting display..."));
        this.display.start();
        if (jmolApp.menuFile != null) {
            this.viewer.getProperty("DATA_API", "setMenu", this.viewer.getFileAsString(jmolApp.menuFile));
        }
        if (point != null) {
            jFrame.setLocation(point);
        } else if (jmolPanel != null) {
            object = jmolPanel.frame.getLocationOnScreen();
            int n3 = JmolPanel.screenSize.width - 50;
            int n4 = JmolPanel.screenSize.height - 50;
            ((Point)object).x += 40;
            ((Point)object).y += 40;
            if (((Point)object).x > n3 || ((Point)object).y > n4) {
                ((Point)object).setLocation(0, 0);
            }
            jFrame.setLocation((Point)object);
        }
        jFrame.getContentPane().add("Center", this);
        jFrame.addWindowListener(new AppCloser());
        jFrame.pack();
        jFrame.setSize(n, n2);
        object = JmolResourceHandler.getIconX("icon");
        Image image = ((ImageIcon)object).getImage();
        jFrame.setIconImage(image);
        Component component = (Component)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (component != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, component, 200, 100);
        }
        if ((component = (Component)this.viewer.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.repositionWindow(EDITOR_WINDOW_NAME, component, 150, 50);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        FileDropper fileDropper = new FileDropper();
        final JFrame jFrame2 = jFrame;
        fileDropper.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jFrame2.setCursor(Cursor.getPredefinedCursor(3));
                if (propertyChangeEvent.getPropertyName().equals("filename")) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    JmolPanel.this.viewer.openFileAsynchronously(string);
                } else if (propertyChangeEvent.getPropertyName().equals("inline")) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    JmolPanel.this.viewer.openStringInline(string);
                }
                jFrame2.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.setDropTarget(new DropTarget(this, fileDropper));
        this.setEnabled(true);
        this.say(GT._("Launching main frame..."));
    }

    protected static void startJmol(JmolApp jmolApp) {
        Dialog.setupUIManager();
        JFrame jFrame = new JFrame();
        Jmol jmol = null;
        try {
            if (jmolApp.jmolPosition != null) {
                jFrame.setLocation(jmolApp.jmolPosition);
            }
            jmol = JmolPanel.getJmol(jmolApp, jFrame);
            jmolApp.startViewer(jmol.viewer, jmol.splash);
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        if (jmolApp.haveConsole) {
            jmol.consoleframe = new JFrame(GT._("Jmol Console"));
            jmol.consoleframe.setIconImage(jmol.frame.getIconImage());
            try {
                final ConsoleTextArea consoleTextArea = new ConsoleTextArea(true);
                consoleTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
                if (Boolean.getBoolean("clearConsoleButton")) {
                    JButton jButton = new JButton(GT._("Clear"));
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            consoleTextArea.setText("");
                        }
                    });
                    jmol.consoleframe.getContentPane().add((Component)jButton, "South");
                }
            }
            catch (IOException iOException) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                jTextArea.append(GT._("Could not create ConsoleTextArea: ") + iOException);
            }
            JmolPanel.setWindow(CONSOLE_WINDOW_NAME, jmol.consoleframe, jmol);
        }
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame jFrame) {
        Accessible accessible;
        String string = jmolApp.commandOptions;
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            accessible = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + accessible);
            }
            splash = new Splash((Frame)(string != null && string.indexOf("-L") >= 0 ? null : jFrame), (ImageIcon)accessible);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        accessible = new Jmol(jmolApp, splash, jFrame, null, jmolApp.startupWidth, jmolApp.startupHeight, string, null);
        if (jmolApp.haveDisplay) {
            jFrame.setVisible(true);
        }
        return accessible;
    }

    private static void setWindow(String string, JFrame jFrame, JmolPanel jmolPanel) {
        Point point = jmolPanel.frame.getLocation();
        Dimension dimension = jmolPanel.frame.getSize();
        Dimension dimension2 = historyFile.getWindowSize(string);
        Point point2 = historyFile.getWindowPosition(string);
        if (dimension2 != null && point2 != null) {
            jFrame.setBounds(point2.x, point2.y, dimension2.width, dimension2.height);
        } else {
            jFrame.setBounds(point.x, point.y + dimension.height, dimension.width, 200);
        }
        Boolean bl = historyFile.getWindowVisibility(string);
        if (bl != null && bl.equals(Boolean.TRUE)) {
            jFrame.setVisible(true);
        }
    }

    public void showStatus(String string) {
        this.splash.showStatus(string);
    }

    void report(String string) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(string);
    }

    private void say(String string) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(string);
            } else {
                this.splash.showStatus(string);
            }
        }
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.defaultActions));
        arrayList.addAll(Arrays.asList(this.display.getActions()));
        arrayList.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return arrayList.toArray(new Action[0]);
    }

    void doClose() {
        if (historyFile != null && this.display != null) {
            this.jmolApp.border.x = this.getFrame().getWidth() - this.display.dimSize.width;
            this.jmolApp.border.y = this.getFrame().getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo("Jmol", this.frame, this.jmolApp.border);
        }
        this.dispose(this.frame);
    }

    private void dispose(JFrame jFrame) {
        Component component = (Component)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (component != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, component, null);
        }
        if ((component = (Component)this.viewer.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, component, null);
        }
        if (historyFile != null && this.webExport != null) {
            WebExport.saveHistory();
            WebExport.cleanUp();
        }
        if (numWindows <= 1) {
            this.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.viewer.setModeMouse(-1);
            try {
                jFrame.dispose();
            }
            catch (Exception exception) {
                System.out.println("frame disposal exception");
            }
        }
    }

    protected void setupNewFrame(String string) {
        JFrame jFrame = new JFrame();
        JFrame jFrame2 = this.frame;
        Jmol jmol = new Jmol(this.jmolApp, null, jFrame, (Jmol)this, this.startupWidth, this.startupHeight, "", string == null ? null : jFrame2.getLocationOnScreen());
        jFrame.setVisible(true);
        if (string != null) {
            this.dispose(jFrame2);
            jmol.viewer.evalStringQuiet(string);
        }
    }

    protected Frame getFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = string.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(string, false) : this.guimap.newJMenuItem(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(imageIcon);
        }
        if (string.endsWith("Script")) {
            jMenuItem.setActionCommand(JmolResourceHandler.getStringX(string));
            jMenuItem.addActionListener(this.executeScriptAction);
        } else {
            jMenuItem.setActionCommand(string);
            Action action = this.getAction(string);
            if (action != null) {
                jMenuItem.addActionListener(action);
                action.addPropertyChangeListener(new ActionChangedListener(jMenuItem));
                jMenuItem.setEnabled(action.isEnabled());
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(stringArray[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected AbstractButton createToolbarButton(String string) {
        String string2;
        boolean bl;
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        AbstractButton abstractButton = new JButton(imageIcon);
        String string3 = JmolResourceHandler.getStringX(string + "Toggle");
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            abstractButton = new JToggleButton(imageIcon);
            if (string.equals("rotate")) {
                this.display.buttonRotate = (JToggleButton)abstractButton;
            }
            this.display.toolbarButtonGroup.add(abstractButton);
            string2 = JmolResourceHandler.getStringX(string + "ToggleSelected");
            if (string2 != null) {
                boolean bl2 = Boolean.valueOf(string2);
                abstractButton.setSelected(bl2);
            }
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        Action action = null;
        string2 = null;
        if (string.endsWith("Script")) {
            string2 = JmolResourceHandler.getStringX(string);
            action = this.executeScriptAction;
        } else {
            string2 = string;
            action = this.getAction(string);
        }
        if (action != null) {
            abstractButton.setActionCommand(string2);
            abstractButton.addActionListener(action);
            action.addPropertyChangeListener(new ActionChangedListener(abstractButton));
            abstractButton.setEnabled(action.isEnabled());
        } else {
            abstractButton.setEnabled(false);
        }
        String string4 = this.guimap.getLabel(string + "Tip");
        if (string4 != null) {
            abstractButton.setToolTipText(string4);
        }
        return abstractButton;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected Component createStatusBar() {
        return new StatusBar();
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addNormalMenuBar(jMenuBar);
        this.addMacrosMenuBar(jMenuBar);
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMacrosMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.guimap.newJMenu("macros");
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + file);
        this.report("       exists: " + file.exists());
        this.report("  isDirectory: " + file.isDirectory());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (!string.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + string);
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    String string2 = properties.getProperty("Title");
                    String string3 = properties.getProperty("Script");
                    JMenuItem jMenuItem = new JMenuItem(string2);
                    jMenuItem.setActionCommand(string3);
                    jMenuItem.addActionListener(this.executeScriptAction);
                    jMenu.add(jMenuItem);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(iOException);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        fileInputStream = null;
                    }
                }
            }
        }
        jMenuBar.add(jMenu);
    }

    protected void addNormalMenuBar(JMenuBar jMenuBar) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        String string = "help";
        JMenu jMenu = this.createMenu(string);
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX(string));
        JMenu jMenu = this.guimap.newJMenu(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon(imageIcon);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem;
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (string2.endsWith("Menu")) {
                jMenuItem = "recentFilesMenu".equals(string2) ? this.createMenu(string2) : this.createMenu(string2);
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = this.createMenuItem(string2);
            jMenu.add(jMenuItem);
        }
        jMenu.addMenuListener(this.display.getMenuListener());
        return jMenu;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.display);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Logger.error("Error while printing", printerException);
            }
        }
    }

    String createImageStatus(String string, String string2, Object object, int n) {
        if (string != null && object != null) {
            return null;
        }
        String string3 = string;
        if (string3 != null && !string3.startsWith("OK") && this.status != null) {
            this.status.setStatus(1, GT._("IO Exception:"));
            this.status.setStatus(2, string3);
        }
        return string3;
    }

    public static File getUserDirectory() {
        String string = System.getProperty("user.dir");
        return string == null ? null : new File(System.getProperty("user.dir"));
    }

    String getOpenFileNameFromDialog(String string) {
        return new Dialog().getOpenFileNameFromDialog(this.appletContext, this.viewer, string, historyFile, FILE_OPEN_WINDOW_NAME, string == null);
    }

    static {
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.measurementTable.activate();
            }
            JmolPanel.this.viewer.evalStringQuiet(string);
        }
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public boolean notifyEnabled(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: {
                    return true;
                }
            }
            return false;
        }

        public void notifyCallback(int n, Object[] objectArray) {
            String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (n) {
                case 5: {
                    this.notifyFileLoaded(string, (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
                    break;
                }
                case 0: {
                    int[] nArray = (int[])objectArray[1];
                    this.notifyFrameChanged(nArray[0], nArray[1], nArray[2]);
                    break;
                }
                case 11: {
                    int n2 = (Integer)objectArray[3];
                    if (n2 != 0 || objectArray[2] == null || JmolPanel.this.display == null) break;
                    JmolPanel.this.display.status.setStatus(1, (String)objectArray[2]);
                    break;
                }
                case 1: {
                    this.sendConsoleEcho(string);
                    break;
                }
                case 6: {
                    String string2 = (String)objectArray[3];
                    if (string2.indexOf("Picked") >= 0) {
                        this.notifyAtomPicked(string);
                    } else if (string2.indexOf("Completed") >= 0) {
                        this.sendConsoleEcho(string.substring(string.lastIndexOf(",") + 2, string.length() - 1));
                    }
                    if (string2.indexOf("Pending") >= 0 || JmolPanel.this.display == null) break;
                    JmolPanel.this.measurementTable.updateTables();
                    break;
                }
                case 7: {
                    this.sendConsoleMessage(objectArray == null ? null : string);
                    break;
                }
                case 9: {
                    this.notifyAtomPicked(string);
                    break;
                }
            }
        }

        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("menu")) {
                JmolPanel.this.setupNewFrame(JmolPanel.this.viewer.getStateInfo());
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                Dialog.setupUIManager();
                if (JmolPanel.this.webExport != null) {
                    WebExport.saveHistory();
                    WebExport.dispose();
                    JmolPanel.this.webExport = WebExport.createAndShowGUI(JmolPanel.this.viewer, historyFile, JmolPanel.WEB_MAKER_WINDOW_NAME);
                }
                JmolPanel.this.setupNewFrame(JmolPanel.this.viewer.getStateInfo());
                return;
            }
        }

        public String eval(String string) {
            this.sendConsoleMessage("javascript: " + string);
            return "# 'eval' is implemented only for the applet.";
        }

        public String createImage(String string, String string2, Object object, int n) {
            return null;
        }

        private void notifyAtomPicked(String string) {
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleMessage(string);
                jmolAppConsoleInterface.sendConsoleMessage("\n");
            }
        }

        private void notifyFileLoaded(String string, String string2, String string3, String string4) {
            if (string4 != null) {
                return;
            }
            if (!JmolPanel.this.jmolApp.haveDisplay) {
                return;
            }
            String string5 = "Jmol";
            if (string3 != null && string2 != null) {
                string5 = string2 + " - " + string3;
            } else if (string2 != null) {
                string5 = string2;
            } else if (string3 != null) {
                string5 = string3;
            }
            JmolPanel.this.recentFiles.notifyFileOpen(string);
            JmolPanel.this.frame.setTitle(string5);
            if (JmolPanel.this.atomSetChooser == null) {
                JmolPanel.this.atomSetChooser = new AtomSetChooser(JmolPanel.this.viewer, JmolPanel.this.frame);
                JmolPanel.this.pcs.addPropertyChangeListener(JmolPanel.chemFileProperty, JmolPanel.this.atomSetChooser);
            }
            JmolPanel.this.pcs.firePropertyChange(JmolPanel.chemFileProperty, null, null);
        }

        private void notifyFrameChanged(int n, int n2, int n3) {
            if (JmolPanel.this.display != null) {
                JmolPanel.this.display.status.setStatus(1, n2 + "." + n3);
            }
        }

        private void sendConsoleEcho(String string) {
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleEcho(string);
            }
        }

        private void sendConsoleMessage(String string) {
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleMessage(string);
            }
        }

        public void showUrl(String string) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("getDesktop", new Class[0]);
                Object object = method.invoke(null, (Object[])new Class[0]);
                Method method2 = clazz.getMethod("browse", class$java$net$URI == null ? (class$java$net$URI = JmolPanel.class$("java.net.URI")) : class$java$net$URI);
                Object[] objectArray = new Object[]{new URI(string)};
                method2.invoke(object, objectArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
                if (jmolAppConsoleInterface != null) {
                    jmolAppConsoleInterface.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
                }
                Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
            }
        }

        public float[][] functionXY(String string, int n, int n2) {
            n = Math.abs(n);
            n2 = Math.abs(n2);
            float[][] fArray = new float[n][n2];
            boolean bl = string.indexOf("2") >= 0;
            int n3 = n;
            while (--n3 >= 0) {
                int n4 = n2;
                while (--n4 >= 0) {
                    fArray[n3][n4] = bl ? (float)(n3 + n4 - n) / 2.0f : (float)Math.sqrt(Math.abs(n3 * n3 + n4 * n4)) / 2.0f;
                }
            }
            return fArray;
        }

        public float[][][] functionXYZ(String string, int n, int n2, int n3) {
            n = Math.abs(n);
            n2 = Math.abs(n2);
            n3 = Math.abs(n3);
            float[][][] fArray = new float[n][n2][n3];
            int n4 = n;
            while (--n4 >= 0) {
                int n5 = n2;
                while (--n5 >= 0) {
                    int n6 = n3;
                    while (--n6 >= 0) {
                        float f = (float)n4 / ((float)(n - 1) / 2.0f) - 1.0f;
                        float f2 = (float)n5 / ((float)(n2 - 1) / 2.0f) - 1.0f;
                        float f3 = (float)n6 / ((float)(n3 - 1) / 2.0f) - 1.0f;
                        fArray[n4][n5][n6] = f * f + f2 - f3 * f3;
                    }
                }
            }
            return fArray;
        }

        public Hashtable getRegistryInfo() {
            return null;
        }

        public String dialogAsk(String string, String string2) {
            if (string.equals("load")) {
                return JmolPanel.this.getOpenFileNameFromDialog(string2);
            }
            if (string.equals("save")) {
                return new Dialog().getSaveFileNameFromDialog(JmolPanel.this.viewer, string2, null);
            }
            if (string.equals("saveImage")) {
                Dialog dialog = new Dialog();
                string2 = dialog.getImageFileNameFromDialog(JmolPanel.this.viewer, string2, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
                JmolPanel.this.imageType = dialog.getType();
                JmolPanel.this.qualityJPG = dialog.getQuality("JPG");
                JmolPanel.this.qualityPNG = dialog.getQuality("PNG");
                return string2;
            }
            return null;
        }
    }

    class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.measurementTable.activate();
        }
    }

    class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((ToWebAction)ToWebAction.this).JmolPanel.this.webExport = WebExport.createAndShowGUI(((ToWebAction)ToWebAction.this).JmolPanel.this.viewer, historyFile, JmolPanel.WEB_MAKER_WINDOW_NAME);
                }
            });
        }
    }

    class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.viewer, null, "SPT");
            if (string != null) {
                Logger.info(JmolPanel.this.viewer.createImage(string, "SPT", JmolPanel.this.viewer.getStateInfo(), Integer.MIN_VALUE, 0, 0));
            }
        }
    }

    class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)JmolPanel.this.viewer.getProperty("DATA_API", "getScriptEditor", null);
            if (component != null) {
                component.setVisible(true);
            }
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (component != null) {
                component.setVisible(true);
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.recentFiles.setVisible(true);
            String string = JmolPanel.this.recentFiles.getFile();
            if (string != null) {
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = new Dialog();
            String string = dialog.getImageFileNameFromDialog(JmolPanel.this.viewer, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (string == null) {
                return;
            }
            JmolPanel.this.qualityJPG = dialog.getQuality("JPG");
            JmolPanel.this.qualityPNG = dialog.getQuality("PNG");
            JmolPanel.this.imageType = dialog.getType();
            String string2 = JmolPanel.this.imageType;
            if (string2 == null) {
                string2 = string;
                int n = string2.lastIndexOf(".");
                if (n < 0) {
                    return;
                }
                string2 = string2.substring(n + 1).toUpperCase();
            }
            Logger.info(JmolPanel.this.viewer.createImage(string, string2, null, dialog.getQuality(string2), 0, 0));
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(JmolPanel.exitAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.doClose();
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(JmolPanel.newAction);
        }

        NewAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.revalidate();
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (string != null) {
                if (string.indexOf("://") == -1) {
                    string = "http://" + string;
                }
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(JmolPanel.openAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JmolPanel.this.getOpenFileNameFromDialog(null);
            if (string == null) {
                return;
            }
            if (string.startsWith("load append")) {
                JmolPanel.this.viewer.scriptWait(string);
            } else {
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ImageCreator(JmolPanel.this.viewer).clipImage((String)JmolPanel.this.viewer.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ImageCreator(JmolPanel.this.viewer).clipImage(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ImageCreator.getClipboardTextStatic();
            if (string != null && string.length() > 0) {
                JmolPanel.this.viewer.loadInline(string, false);
            }
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new HelpDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame();
            new Jmol(JmolPanel.this.jmolApp, null, jFrame, (Jmol)JmolPanel.this, JmolPanel.this.startupWidth, JmolPanel.this.startupHeight, "", null);
            jFrame.setVisible(true);
        }
    }

    class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewDialog whatsNewDialog = new WhatsNewDialog(JmolPanel.this.frame);
            whatsNewDialog.setVisible(true);
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JmolPanel.this.frame);
            aboutDialog.setVisible(true);
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(JmolPanel.closeAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.frame.setVisible(false);
            JmolPanel.this.doClose();
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(string2);
                }
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            JmolPanel.this.doClose();
        }
    }
}

