/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.EnterListener;
import org.openscience.jmol.app.jmolpanel.HelpDialog;

public final class AppConsole
extends JmolConsole
implements JmolAppConsoleInterface,
EnterListener {
    protected ConsoleTextPane console;
    private JButton varButton;
    private JButton haltButton;
    private JButton closeButton;
    private JButton clearButton;
    private JButton questButton;
    private JButton helpButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton checkButton;
    protected JButton stepButton;
    private JButton topButton;
    JPanel buttonPanel = new JPanel();
    boolean isError = false;
    ExecuteCommandThread execThread;
    static int MAXUNDO = 50;
    String[] undoStack = new String[MAXUNDO];
    int undoPointer = 0;
    boolean undoSaved = false;

    public AppConsole() {
    }

    public JmolAppConsoleInterface getAppConsole(Viewer viewer, Component component) {
        return new AppConsole(viewer, component instanceof DisplayPanel ? ((DisplayPanel)component).getFrame() : (component instanceof JFrame ? (JFrame)component : null));
    }

    public AppConsole(JmolViewer jmolViewer, JFrame jFrame) {
        super(jmolViewer, jFrame, GT._("Jmol Script Console") + " " + Viewer.getJmolVersion(), false);
        this.layoutWindow(this.getContentPane());
        this.setSize(645, 400);
        this.setLocationRelativeTo(jFrame);
    }

    JButton setButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        this.buttonPanel.add(jButton);
        return jButton;
    }

    void layoutWindow(Container container) {
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        this.console.setDragEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.console);
        this.editButton = this.setButton(GT._("Editor"));
        this.checkButton = this.setButton(GT._("Check"));
        this.topButton = this.setButton(GT._("Top"));
        this.stepButton = this.setButton(GT._("Step"));
        this.varButton = this.setButton(GT._("Variables"));
        this.clearButton = this.setButton(GT._("Clear"));
        this.haltButton = this.setButton(GT._("Halt"));
        this.historyButton = this.setButton(GT._("History"));
        this.stateButton = this.setButton(GT._("State"));
        this.helpButton = this.setButton(GT._("Help"));
        this.closeButton = this.setButton(GT._("Close"));
        this.undoButton = this.setButton(GT._("Undo"));
        this.redoButton = this.setButton(GT._("Redo"));
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buttonPanel, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(new Dimension(5000, 5000));
        jPanel.setMinimumSize(new Dimension(60, 60));
        jPanel.setMaximumSize(new Dimension(1000, 60));
        jPanel.setPreferredSize(new Dimension(60, 60));
        jSplitPane.setDividerSize(0);
        jSplitPane.setResizeWeight(0.95);
        container.add(jSplitPane);
    }

    public void sendConsoleEcho(String string) {
        if (string != null && !this.isError) {
            this.console.outputEcho(string);
        }
        this.setError(false);
    }

    private void setError(boolean bl) {
        this.isError = bl;
    }

    public void sendConsoleMessage(String string) {
        if (string == null) {
            this.console.clearContent(null);
            this.console.outputStatus("");
        } else if (string.indexOf("ERROR:") >= 0) {
            this.console.outputError(string);
            this.setError(true);
        } else if (!this.isError) {
            this.console.outputStatus(string);
        }
    }

    public void enterPressed() {
        this.executeCommandAsThread(null);
    }

    protected void execute(String string) {
        this.executeCommandAsThread(string);
    }

    void executeCommandAsThread(String string) {
        if (string == null) {
            string = this.console.getCommandString().trim();
        }
        if (string.equalsIgnoreCase("undo")) {
            this.undoRedo(false);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("redo")) {
            this.undoRedo(true);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        } else if (string.length() == 0) {
            string = "!resume";
        }
        if (string.length() > 0) {
            this.execThread = new ExecuteCommandThread(string);
            this.execThread.start();
        }
    }

    public void zap() {
        this.undoClear();
    }

    private void undoClear() {
        for (int i = 0; i < MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    void undoSetEnabled() {
        this.undoButton.setEnabled(this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
        this.redoButton.setEnabled(this.undoPointer + 1 < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
    }

    void undoRedo(boolean bl) {
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        if (!this.undoSaved) {
            this.undoSave();
        }
        String string = this.undoStack[this.undoPointer];
        int n = this.undoPointer + (bl ? 1 : -1);
        if (n == MAXUNDO) {
            --n;
        }
        if (n < 0) {
            n = 0;
        }
        if ((string = this.undoStack[n]) != null) {
            string = string + "#----";
            this.setError(false);
            this.viewer.evalStringQuiet(string);
            this.undoPointer = n;
        }
        this.undoSetEnabled();
    }

    void undoSave() {
        int n;
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        ++this.undoPointer;
        if (this.undoPointer == MAXUNDO) {
            for (n = 1; n < MAXUNDO; ++n) {
                this.undoStack[n - 1] = this.undoStack[n];
            }
            --this.undoPointer;
        }
        for (n = this.undoPointer; n < MAXUNDO; ++n) {
            this.undoStack[n] = null;
        }
        Logger.startTimer();
        this.undoStack[this.undoPointer] = (String)this.viewer.getProperty("readable", "stateInfo", null);
        if (Logger.checkTimer(null) > 1000L) {
            this.viewer.setBooleanProperty("undo", false);
            Logger.info("command processing slow; undo disabled");
            this.undoClear();
        } else {
            this.undoSetEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String string) {
        boolean bl;
        this.console.appendNewline();
        this.console.setPrompt();
        if (string.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (string.charAt(0) != '!' && this.viewer.getBooleanProperty("executionPaused")) {
            string = "!" + string;
        }
        if (string.charAt(0) != '!' && !this.isError) {
            this.undoSave();
        }
        this.setError(false);
        this.undoSaved = false;
        String string2 = null;
        boolean bl2 = bl = string.indexOf("WAITTEST ") == 0;
        if (bl) {
            Vector vector = (Vector)this.viewer.scriptWaitStatus(string.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                for (int j = 0; j < vector2.size(); ++j) {
                    Vector vector3 = (Vector)vector2.get(j);
                    Logger.info("msg#=" + vector3.get(0) + " " + vector3.get(1) + " intInfo=" + vector3.get(2) + " stringInfo=" + vector3.get(3));
                }
            }
            this.console.appendNewline();
        } else {
            boolean bl3 = this.viewer.isScriptExecuting();
            string2 = "";
            if (this.viewer.checkHalt(string)) {
                String string3 = string2 = bl3 ? "script execution halted with " + string : "no script was executing";
            }
            if (string2.length() > 0) {
                this.console.outputError(string2);
            } else {
                this.viewer.script(string + (string.indexOf("\u0000##") >= 0 ? "" : "\u0000## EDITOR_IGNORE ##"));
            }
        }
        if (string.indexOf("\u0000##") < 0) {
            this.console.grabFocus();
        }
    }

    protected void clearContent(String string) {
        this.console.clearContent(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.console.grabFocus();
        Object object = actionEvent.getSource();
        if (object == this.topButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.gotoTop();
            }
            return;
        }
        if (object == this.checkButton && this.scriptEditor != null) {
            this.scriptEditor.checkScript();
        }
        if (object == this.stepButton) {
            if (this.scriptEditor != null) {
                this.scriptEditor.doStep();
            }
            return;
        }
        if (object == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (object == this.haltButton) {
            this.viewer.haltScriptExecution();
            return;
        }
        if (object == this.questButton) {
            this.execute("!?");
            return;
        }
        if (object == this.varButton) {
            this.execute("!show variables");
            return;
        }
        if (object == this.clearButton) {
            this.console.clearContent(null);
            return;
        }
        if (object == this.undoButton) {
            this.undoRedo(false);
            return;
        }
        if (object == this.redoButton) {
            this.undoRedo(true);
            return;
        }
        if (object == this.helpButton) {
            URL uRL = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            HelpDialog helpDialog = new HelpDialog(null, uRL);
            helpDialog.setVisible(true);
        }
        super.actionPerformed(actionEvent);
    }

    public Object getMyMenuBar() {
        return null;
    }

    public String getText() {
        return this.console.getText();
    }

    class ConsoleDocument
    extends DefaultStyledDocument {
        ConsoleTextPane consoleTextPane;
        SimpleAttributeSet attError = new SimpleAttributeSet();
        SimpleAttributeSet attEcho;
        SimpleAttributeSet attPrompt;
        SimpleAttributeSet attUserInput;
        SimpleAttributeSet attStatus;
        Position positionBeforePrompt;
        Position positionAfterPrompt;
        int offsetAfterPrompt;

        ConsoleDocument() {
            StyleConstants.setForeground(this.attError, Color.red);
            this.attPrompt = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attPrompt, Color.magenta);
            this.attUserInput = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attUserInput, Color.black);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, Color.blue);
            StyleConstants.setBold(simpleAttributeSet, true);
            this.attStatus = new SimpleAttributeSet();
            StyleConstants.setForeground(this.attStatus, Color.black);
            StyleConstants.setItalic(this.attStatus, true);
        }

        void setConsoleTextPane(ConsoleTextPane consoleTextPane) {
            this.consoleTextPane = consoleTextPane;
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (BadLocationException badLocationException) {
                Logger.error("Could not clear script window content", badLocationException);
            }
        }

        void setPrompt() {
            try {
                super.insertString(this.getLength(), "$ ", this.attPrompt);
                this.setOffsetPositions();
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void setOffsetPositions() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void setNoPrompt() {
            try {
                this.offsetAfterPrompt = this.getLength();
                this.positionAfterPrompt = this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt);
                this.consoleTextPane.setCaretPosition(this.offsetAfterPrompt);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void outputBeforePrompt(String string, SimpleAttributeSet simpleAttributeSet) {
            try {
                int n = this.consoleTextPane.getCaretPosition();
                Position position = this.createPosition(n);
                n = this.positionBeforePrompt.getOffset();
                super.insertString(n, string + "\n", simpleAttributeSet);
                this.offsetAfterPrompt += string.length() + 1;
                this.positionBeforePrompt = this.createPosition(this.offsetAfterPrompt - 2);
                this.positionAfterPrompt = this.createPosition(this.offsetAfterPrompt - 1);
                n = position.getOffset();
                this.consoleTextPane.setCaretPosition(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
        }

        void outputError(String string) {
            this.outputBeforePrompt(string, this.attError);
        }

        void outputErrorForeground(String string) {
            try {
                super.insertString(this.getLength(), string + "\n", this.attError);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        void outputEcho(String string) {
            this.outputBeforePrompt(string, this.attEcho);
        }

        void outputStatus(String string) {
            this.outputBeforePrompt(string, this.attStatus);
        }

        void appendNewline() {
            try {
                super.insertString(this.getLength(), "\n", this.attUserInput);
                this.consoleTextPane.setCaretPosition(this.getLength());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = string.indexOf(10);
            if (n2 != 0) {
                if (n < this.offsetAfterPrompt) {
                    n = this.getLength();
                }
                super.insertString(n, string, attributeSet == this.attError ? attributeSet : this.attUserInput);
                this.consoleTextPane.setCaretPosition(n + string.length());
            }
            if (n2 >= 0) {
                this.consoleTextPane.enterPressed();
            }
        }

        String getCommandString() {
            String string = "";
            try {
                int n = this.positionAfterPrompt.getOffset();
                string = this.getText(n, this.getLength() - n);
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return string;
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (n < this.offsetAfterPrompt) {
                if ((n2 -= this.offsetAfterPrompt - n) <= 0) {
                    return;
                }
                n = this.offsetAfterPrompt;
            }
            super.remove(n, n2);
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n < this.offsetAfterPrompt) {
                if (n + n2 < this.offsetAfterPrompt) {
                    n = this.getLength();
                    n2 = 0;
                } else {
                    n2 -= this.offsetAfterPrompt - n;
                    n = this.offsetAfterPrompt;
                }
            }
            super.replace(n, n2, string, attributeSet);
        }

        void replaceCommand(String string, boolean bl) throws BadLocationException {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.replace(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, string, bl ? this.attError : this.attUserInput);
        }

        void colorCommand(SimpleAttributeSet simpleAttributeSet) {
            if (this.positionAfterPrompt == this.positionBeforePrompt) {
                return;
            }
            this.setCharacterAttributes(this.offsetAfterPrompt, this.getLength() - this.offsetAfterPrompt, simpleAttributeSet, true);
        }
    }

    class ConsoleTextPane
    extends JTextPane {
        ConsoleDocument consoleDoc;
        EnterListener enterListener;
        boolean checking;
        private int nTab;

        ConsoleTextPane(AppConsole appConsole2) {
            super(new ConsoleDocument());
            this.checking = false;
            this.nTab = 0;
            this.consoleDoc = (ConsoleDocument)this.getDocument();
            this.consoleDoc.setConsoleTextPane(this);
            this.enterListener = appConsole2;
        }

        public String getCommandString() {
            String string = this.consoleDoc.getCommandString();
            return string;
        }

        public void setPrompt() {
            this.consoleDoc.setPrompt();
        }

        public void appendNewline() {
            this.consoleDoc.appendNewline();
        }

        public void outputError(String string) {
            this.consoleDoc.outputError(string);
        }

        public void outputErrorForeground(String string) {
            this.consoleDoc.outputErrorForeground(string);
        }

        public void outputEcho(String string) {
            this.consoleDoc.outputEcho(string);
        }

        public void outputStatus(String string) {
            this.consoleDoc.outputStatus(string);
        }

        public void enterPressed() {
            if (this.enterListener != null) {
                this.enterListener.enterPressed();
            }
        }

        public void clearContent(String string) {
            this.consoleDoc.clearContent();
            if (string != null) {
                this.consoleDoc.outputEcho(string);
            }
            this.setPrompt();
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getID();
            if (n == 9) {
                ++this.nTab;
                this.completeCommand();
                return;
            }
            this.nTab = 0;
            if (n == 38 && n2 == 401 && !keyEvent.isControlDown()) {
                this.recallCommand(true);
            } else if (n == 40 && n2 == 401 && !keyEvent.isControlDown()) {
                this.recallCommand(false);
            } else if ((n == 40 || n == 38) && n2 == 401 && keyEvent.isControlDown()) {
                super.processKeyEvent(new KeyEvent((Component)keyEvent.getSource(), n2, keyEvent.getWhen(), 0, n, keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            } else {
                super.processKeyEvent(keyEvent);
                if (n2 == 402 && keyEvent.getModifiers() < 2 && (n > 40 && n < 400 || n == 8)) {
                    this.checkCommand();
                }
            }
        }

        private void completeCommand() {
            String string = this.consoleDoc.getCommandString();
            String string2 = Token.completeCommand(string, this.nTab);
            if (!string2.equals(string)) {
                try {
                    this.consoleDoc.replaceCommand(string2, false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        void recallCommand(boolean bl) {
            String string = AppConsole.this.viewer.getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            boolean bl2 = false;
            try {
                if (string.endsWith("#??")) {
                    bl2 = true;
                    string = string.substring(0, string.indexOf("#??"));
                }
                string = TextFormat.trim(string, ";");
                this.consoleDoc.replaceCommand(string, bl2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        synchronized void checkCommand() {
            String string = this.consoleDoc.getCommandString();
            if (string.length() == 0 || string.charAt(0) == '!' || AppConsole.this.viewer.isScriptExecuting() || AppConsole.this.viewer.getBooleanProperty("executionPaused")) {
                return;
            }
            this.checking = true;
            this.consoleDoc.colorCommand(AppConsole.this.viewer.scriptCheck(string) instanceof String ? this.consoleDoc.attError : this.consoleDoc.attUserInput);
            this.checking = false;
        }
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String string) {
            this.strCommand = string;
            this.setName("appConsoleExecuteCommandThread");
        }

        public void run() {
            try {
                while (AppConsole.this.console.checking) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
                AppConsole.this.executeCommand(this.strCommand);
            }
            catch (Exception exception) {
                Logger.error("execution command interrupted!", exception);
            }
        }
    }
}

