/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.export.history.HistoryFile;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.openscience.jmol.app.SplashInterface;

public class JmolApp {
    public int startupWidth;
    public int startupHeight;
    public Point border;
    public boolean haveBorder;
    public File userPropsFile;
    public HistoryFile historyFile;
    public String menuFile;
    public boolean splashEnabled = true;
    public boolean useIndependentCommandThread;
    public boolean transparentBackground;
    public boolean checkScriptNoFiles;
    public boolean checkScriptAndOpenFiles;
    public boolean exitUponCompletion;
    public boolean haveConsole = true;
    public boolean haveDisplay = true;
    public boolean isDataOnly;
    public boolean isPrintOnly;
    public boolean isSilent;
    public boolean listCommands;
    public String commandOptions = "";
    public String modelFilename;
    public String scriptFilename;
    public String script1 = "";
    public String script;
    public String script2 = "";
    public Point jmolPosition;
    public JmolViewer viewer;
    public JmolAdapter modelAdapter;

    public JmolApp() {
    }

    public JmolApp(String[] stringArray) {
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT._("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File file = new File(new File(System.getProperty("user.home")), ".jmol");
        file.mkdirs();
        this.userPropsFile = new File(file, "properties");
        this.historyFile = new HistoryFile(new File(file, "history"), "Jmol's persistent values");
        this.parseCommandLine(stringArray);
    }

    public void parseCommandLine(String[] stringArray) {
        Options options = this.getOptions(stringArray);
        CommandLine commandLine = null;
        try {
            PosixParser posixParser = new PosixParser();
            commandLine = posixParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("Unexpected exception: " + parseException.toString());
        }
        stringArray = commandLine.getArgs();
        if (stringArray.length > 0) {
            this.modelFilename = stringArray[0];
        }
        this.checkOptions(commandLine, options);
    }

    private Options getOptions(String[] stringArray) {
        Options options = new Options();
        options.addOption("b", "backgroundtransparent", false, GT._("transparent background"));
        options.addOption("h", "help", false, GT._("give this help page"));
        options.addOption("n", "nodisplay", false, GT._("no display (and also exit when done)"));
        options.addOption("c", "check", false, GT._("check script syntax only - no file loading"));
        options.addOption("C", "checkload", false, GT._("check script syntax only - with file loading"));
        options.addOption("d", "debug", false, GT._("debug"));
        options.addOption("i", "silent", false, GT._("silent startup operation"));
        options.addOption("l", "list", false, GT._("list commands during script execution"));
        options.addOption("L", "nosplash", false, GT._("start with no splash screen"));
        options.addOption("o", "noconsole", false, GT._("no console -- all output to sysout"));
        options.addOption("p", "printOnly", false, GT._("send only output from print messages to console (implies -i)"));
        options.addOption("t", "threaded", false, GT._("independent command thread"));
        options.addOption("x", "exit", false, GT._("exit after script (implicit with -n)"));
        OptionBuilder.withLongOpt("script");
        OptionBuilder.withDescription(GT._("script file to execute or '-' for System.in"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withLongOpt("jmolscript1");
        OptionBuilder.withDescription(GT._("Jmol script to execute BEFORE -s option"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("J"));
        OptionBuilder.withLongOpt("jmolscript2");
        OptionBuilder.withDescription(GT._("Jmol script to execute AFTER -s option"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("j"));
        OptionBuilder.withLongOpt("menu");
        OptionBuilder.withDescription("menu file to use");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("m"));
        OptionBuilder.withArgName(GT._("property=value"));
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription(GT._("supported options are given below"));
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withLongOpt("geometry");
        OptionBuilder.withDescription(GT._("window width x height, e.g. {0}", "-g500x500"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("g"));
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.withDescription(GT._("JPG image quality (1-100; default 75) or PNG image compression (0-9; default 2, maximum compression 9)"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("q"));
        OptionBuilder.withLongOpt("write");
        OptionBuilder.withDescription(GT._("{0} or {1}:filename", new Object[]{"CLIP", "GIF|JPG|JPG64|PNG|PPM"}));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("w"));
        return options;
    }

    private void checkOptions(CommandLine commandLine, Options options) {
        HelpFormatter helpFormatter;
        if (commandLine.hasOption("h")) {
            helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("Jmol", options);
            System.out.println();
            System.out.println(GT._("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT._("The -D options are as follows (defaults in parenthesis):"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  JmolConsole=[true|false] (true)");
            System.out.println("  logger.debug=[true|false] (false)");
            System.out.println("  logger.error=[true|false] (true)");
            System.out.println("  logger.fatal=[true|false] (true)");
            System.out.println("  logger.info=[true|false] (true)");
            System.out.println("  logger.logLevel=[true|false] (false)");
            System.out.println("  logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[CA|CS|DE|EN|ES|FR|NL|PT|TR] (EN)");
            System.exit(0);
        }
        if (commandLine.hasOption("d")) {
            Logger.setLogLevel(5);
        }
        String string = this.commandOptions = this.isDataOnly ? "JmolData " : "Jmol ";
        if (commandLine.hasOption("p")) {
            this.isPrintOnly = true;
        }
        if (this.isPrintOnly) {
            this.commandOptions = this.commandOptions + "-p";
            this.isSilent = true;
        }
        if (commandLine.hasOption("i")) {
            this.isSilent = true;
        }
        if (this.isSilent) {
            this.commandOptions = this.commandOptions + "-i";
        }
        if (commandLine.hasOption("o")) {
            this.haveConsole = false;
        }
        if (!this.haveConsole) {
            this.commandOptions = this.commandOptions + "-o";
        }
        if (commandLine.hasOption("b")) {
            this.transparentBackground = true;
        }
        if (this.transparentBackground) {
            this.commandOptions = this.commandOptions + "-b";
        }
        if (commandLine.hasOption("t")) {
            this.useIndependentCommandThread = true;
        }
        if (this.useIndependentCommandThread) {
            this.commandOptions = this.commandOptions + "-t";
        }
        if (commandLine.hasOption("l")) {
            this.listCommands = true;
        }
        if (this.listCommands) {
            this.commandOptions = this.commandOptions + "-l";
        }
        if (commandLine.hasOption("L")) {
            this.splashEnabled = false;
        }
        if (!this.splashEnabled) {
            this.commandOptions = this.commandOptions + "-L";
        }
        if (commandLine.hasOption("c")) {
            this.checkScriptNoFiles = true;
        } else if (commandLine.hasOption("C")) {
            this.checkScriptAndOpenFiles = true;
        }
        if (this.checkScriptNoFiles) {
            this.commandOptions = this.commandOptions + "-c";
        } else if (this.checkScriptAndOpenFiles) {
            this.commandOptions = this.commandOptions + "-c";
        }
        if (commandLine.hasOption("m")) {
            this.menuFile = commandLine.getOptionValue("m");
        }
        if (commandLine.hasOption("J")) {
            this.commandOptions = this.commandOptions + "-J";
            this.script1 = commandLine.getOptionValue("J");
        }
        if (commandLine.hasOption("s")) {
            this.commandOptions = this.commandOptions + "-s";
            this.scriptFilename = commandLine.getOptionValue("s");
        }
        if (commandLine.hasOption("j")) {
            this.commandOptions = this.commandOptions + "-j";
            this.script2 = commandLine.getOptionValue("j");
        }
        helpFormatter = null;
        if (this.haveDisplay) {
            Dimension dimension;
            String string2 = System.getProperty("java.version");
            if (string2.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if ((dimension = this.historyFile.getWindowSize("Jmol")) != null) {
                this.startupWidth = dimension.width;
                this.startupHeight = dimension.height;
            }
            this.historyFile.getWindowBorder("Jmol");
            this.border = helpFormatter == null || ((Point)((Object)helpFormatter)).x > 50 ? new Point(12, 116) : new Point(((Point)((Object)helpFormatter)).x, ((Point)((Object)helpFormatter)).y);
        }
        int n = 500;
        int n2 = 500;
        if (commandLine.hasOption("g")) {
            String string3 = commandLine.getOptionValue("g");
            int n3 = string3.indexOf(120);
            if (n3 > 0) {
                n = Parser.parseInt(string3.substring(0, n3));
                n2 = Parser.parseInt(string3.substring(n3 + 1));
            } else {
                n = n2 = Parser.parseInt(string3);
            }
            this.startupWidth = -1;
        }
        if (this.startupWidth <= 0 || this.startupHeight <= 0) {
            if (this.haveDisplay) {
                this.startupWidth = n + this.border.x;
                this.startupHeight = n2 + this.border.y;
            } else {
                this.startupWidth = n;
                this.startupHeight = n2;
            }
        }
        if (commandLine.hasOption("w")) {
            String string4;
            int n4 = -1;
            if (commandLine.hasOption("q")) {
                n4 = Parser.parseInt(commandLine.getOptionValue("q"));
            }
            if ((string4 = commandLine.getOptionValue("w")) != null) {
                if (string4.length() == 0) {
                    string4 = "JPG:jpg";
                }
                if (string4.indexOf(":") < 0) {
                    string4 = string4 + ":jpg";
                }
                int n5 = string4.indexOf(":");
                String string5 = string4.substring(0, n5).toUpperCase();
                string4 = " \"" + string4.substring(n5 + 1) + "\"";
                if (string5.indexOf(" ") < 0) {
                    string5 = string5 + " " + n4;
                }
                this.script2 = this.script2 + ";write image " + n + " " + n2 + " " + string5 + string4;
            }
        }
        if (commandLine.hasOption("n")) {
            this.haveDisplay = false;
            this.exitUponCompletion = true;
        }
        if (commandLine.hasOption("x")) {
            this.exitUponCompletion = true;
        }
        if (!this.haveDisplay) {
            this.commandOptions = this.commandOptions + "-n";
        }
        if (this.exitUponCompletion) {
            this.commandOptions = this.commandOptions + "-x";
            this.script2 = this.script2 + ";exitJmol // " + this.commandOptions;
        }
    }

    public void startViewer(JmolViewer jmolViewer, SplashInterface splashInterface) {
        this.viewer = jmolViewer;
        if (this.modelFilename != null) {
            jmolViewer.openFileAsynchronously(this.modelFilename);
        }
        if (this.script1 != null && this.script1.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script1);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT._("Executing script 1..."));
            }
            jmolViewer.script(this.script1);
        }
        if (this.scriptFilename != null) {
            if (!this.isSilent) {
                Logger.info("Executing script from file: " + this.scriptFilename);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT._("Executing script file..."));
            }
            if (this.scriptFilename.equals("-")) {
                Scanner scanner = new Scanner(System.in);
                String string = "";
                StringBuffer stringBuffer = new StringBuffer();
                while (scanner.hasNextLine() && (string = scanner.nextLine()) != null && !string.equals("!quit")) {
                    stringBuffer.append(string).append("\n");
                }
                jmolViewer.script(stringBuffer.toString());
            } else {
                jmolViewer.evalFile(this.scriptFilename);
            }
        }
        if (this.script2 != null && this.script2.length() > 0) {
            if (!this.isSilent) {
                Logger.info("Executing script: " + this.script2);
            }
            if (splashInterface != null) {
                splashInterface.showStatus(GT._("Executing script 2..."));
            }
            jmolViewer.script(this.script2);
        }
    }
}

