/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Bond;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;

class ScriptVariable
extends Token {
    private static final ScriptVariable vT = new ScriptVariable(0x10000D, 1, "true");
    private static final ScriptVariable vF = new ScriptVariable(0x10000C, 0, "false");
    static ScriptVariable vAll = new ScriptVariable(0x100003, "all");
    int index = Integer.MAX_VALUE;
    String name;
    private static final int FLAG_CANINCREMENT = 1;
    private static final int FLAG_LOCALVAR = 2;
    int flags = 2;
    static final Point3f pt0 = new Point3f();

    ScriptVariable() {
        this.tok = 4;
        this.value = "";
    }

    ScriptVariable(int n) {
        this.tok = n;
    }

    ScriptVariable(int n, int n2, Object object) {
        super(n, n2, object);
    }

    ScriptVariable(int n, Object object) {
        super(n, object);
    }

    ScriptVariable(int n, int n2) {
        super(n, n2);
    }

    ScriptVariable(BitSet bitSet, int n) {
        this.value = bitSet;
        this.index = n;
        this.tok = 0x40000007;
    }

    ScriptVariable(Token token) {
        this.tok = token.tok;
        this.intValue = token.intValue;
        this.value = token.value;
    }

    static ScriptVariable getVariable(Object object) {
        if (object == null) {
            return new ScriptVariable();
        }
        if (object instanceof ScriptVariable) {
            return (ScriptVariable)object;
        }
        if (object instanceof String) {
            if ((object = ScriptVariable.unescapePointOrBitsetAsVariable((String)object)) instanceof ScriptVariable) {
                return (ScriptVariable)object;
            }
            return new ScriptVariable(4, object);
        }
        if (object instanceof Boolean) {
            return ScriptVariable.getBoolean((Boolean)object);
        }
        if (object instanceof Integer) {
            return new ScriptVariable(2, (int)((Integer)object));
        }
        if (object instanceof Float) {
            return new ScriptVariable(3, object);
        }
        if (object instanceof float[]) {
            float[] fArray = (float[])object;
            String[] stringArray = new String[fArray.length];
            int n = fArray.length;
            while (--n >= 0) {
                stringArray[n] = "" + fArray[n];
            }
            return new ScriptVariable(6, stringArray);
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            String[] stringArray = new String[dArray.length];
            int n = dArray.length;
            while (--n >= 0) {
                stringArray[n] = "" + dArray[n];
            }
            return new ScriptVariable(6, stringArray);
        }
        if (object instanceof Float[]) {
            return new ScriptVariable(10, object);
        }
        if (object instanceof String[]) {
            return new ScriptVariable(6, object);
        }
        if (object instanceof String) {
            return new ScriptVariable(4, object);
        }
        if (object instanceof Vector3f) {
            return new ScriptVariable(7, new Point3f((Vector3f)object));
        }
        if (object instanceof Point3f) {
            return new ScriptVariable(7, object);
        }
        if (object instanceof Point4f) {
            return new ScriptVariable(8, object);
        }
        if (object instanceof BitSet) {
            return new ScriptVariable(0x40000007, object);
        }
        if (object instanceof Quaternion) {
            return new ScriptVariable(8, ((Quaternion)object).toPoint4f());
        }
        return null;
    }

    ScriptVariable set(ScriptVariable scriptVariable) {
        this.index = scriptVariable.index;
        this.intValue = scriptVariable.intValue;
        this.tok = scriptVariable.tok;
        if (this.tok == 6) {
            int n = ((String[])scriptVariable.value).length;
            this.value = new String[n];
            System.arraycopy(scriptVariable.value, 0, this.value, 0, n);
        } else {
            this.value = scriptVariable.value;
        }
        return this;
    }

    ScriptVariable setName(String string) {
        this.name = string;
        this.flags |= 1;
        return this;
    }

    ScriptVariable setGlobal() {
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    boolean canIncrement() {
        return ScriptVariable.tokAttr(this.flags, 1);
    }

    boolean increment(int n) {
        if (!this.canIncrement()) {
            return false;
        }
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                break;
            }
            case 3: {
                this.value = new Float(((Float)this.value).floatValue() + (float)n);
                break;
            }
            default: {
                this.value = ScriptVariable.nValue(this);
                if (this.value instanceof Integer) {
                    this.tok = 2;
                    this.intValue = (Integer)this.value;
                    break;
                }
                this.tok = 3;
            }
        }
        return true;
    }

    static ScriptVariable getVariableSelected(int n, Object object) {
        ScriptVariable scriptVariable = new ScriptVariable(0x40000007, object);
        scriptVariable.index = n;
        return scriptVariable;
    }

    boolean asBoolean() {
        return ScriptVariable.bValue(this);
    }

    int asInt() {
        return ScriptVariable.iValue(this);
    }

    float asFloat() {
        return ScriptVariable.fValue(this);
    }

    String asString() {
        return ScriptVariable.sValue(this);
    }

    Object getValAsObj() {
        return this.tok == 2 ? new Integer(this.intValue) : this.value;
    }

    static final ScriptVariable intVariable(int n) {
        return new ScriptVariable(2, n);
    }

    static Object oValue(ScriptVariable scriptVariable) {
        switch (scriptVariable == null ? 0 : scriptVariable.tok) {
            case 0x10000D: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x10000C: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Integer(scriptVariable.intValue);
            }
        }
        return scriptVariable.value;
    }

    static Object nValue(Token token) {
        int n = 0;
        switch (token == null ? 0 : token.tok) {
            case 2: {
                n = token.intValue;
                break;
            }
            case 3: {
                return token.value;
            }
            case 4: {
                if (((String)token.value).indexOf(".") >= 0) {
                    return new Float(ScriptVariable.toFloat((String)token.value));
                }
                n = (int)ScriptVariable.toFloat((String)token.value);
            }
        }
        return new Integer(n);
    }

    static boolean bValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
            case 2: {
                return token.intValue != 0;
            }
            case 3: 
            case 4: 
            case 6: {
                return ScriptVariable.fValue(token) != 0.0f;
            }
            case 0x40000007: {
                return ScriptVariable.iValue(token) != 0;
            }
            case 7: 
            case 8: {
                return Math.abs(ScriptVariable.fValue(token)) > 1.0E-4f;
            }
        }
        return false;
    }

    static int iValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 2: {
                return token.intValue;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return (int)ScriptVariable.fValue(token);
            }
            case 0x40000007: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
        }
        return 0;
    }

    static float fValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1.0f;
            }
            case 0x10000C: {
                return 0.0f;
            }
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
            case 6: {
                int n = token.intValue;
                String[] stringArray = (String[])token.value;
                if (n == Integer.MAX_VALUE) {
                    return stringArray.length;
                }
            }
            case 4: {
                return ScriptVariable.toFloat(ScriptVariable.sValue(token));
            }
            case 0x40000007: {
                return ScriptVariable.iValue(token);
            }
            case 7: {
                return ((Point3f)token.value).distance(pt0);
            }
            case 8: {
                return Measure.distanceToPlane((Point4f)token.value, pt0);
            }
        }
        return 0.0f;
    }

    static float toFloat(String string) {
        if (string.equalsIgnoreCase("true")) {
            return 1.0f;
        }
        if (string.equalsIgnoreCase("false") || string.length() == 0) {
            return 0.0f;
        }
        return Parser.parseFloatStrict(string);
    }

    static String sValue(Token token) {
        if (token == null) {
            return "";
        }
        switch (token.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + token.intValue;
            }
            case 7: {
                return Escape.escape((Point3f)token.value);
            }
            case 8: {
                return Escape.escape((Point4f)token.value);
            }
            case 0x40000007: {
                return Escape.escape(ScriptVariable.bsSelect(token), !(token.value instanceof Bond.BondSet));
            }
            case 6: {
                String[] stringArray = (String[])token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = stringArray.length - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > stringArray.length ? "" : stringArray[n - 1];
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(stringArray[n]).append("\n");
                }
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + token.value;
    }

    static String sValue(ScriptVariable scriptVariable) {
        if (scriptVariable == null) {
            return "";
        }
        switch (scriptVariable.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + scriptVariable.intValue;
            }
            case 7: {
                return Escape.escape((Point3f)scriptVariable.value);
            }
            case 8: {
                return Escape.escape((Point4f)scriptVariable.value);
            }
            case 0x40000007: {
                return Escape.escape(ScriptVariable.bsSelect(scriptVariable), !(scriptVariable.value instanceof Bond.BondSet));
            }
            case 6: {
                String[] stringArray = (String[])scriptVariable.value;
                int n = scriptVariable.intValue;
                if (n <= 0) {
                    n = stringArray.length - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > stringArray.length ? "" : stringArray[n - 1];
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(stringArray[n]).append("\n");
                }
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)scriptVariable.value;
                int n = scriptVariable.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + scriptVariable.value;
    }

    static int sizeOf(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 7: {
                return -8;
            }
            case 8: {
                return -16;
            }
            case 4: {
                return ((String)token.value).length();
            }
            case 6: {
                return token.intValue == Integer.MAX_VALUE ? ((String[])token.value).length : ScriptVariable.sizeOf(ScriptVariable.selectItem(token));
            }
            case 0x40000007: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
        }
        return 0;
    }

    static String typeOf(ScriptVariable scriptVariable) {
        switch (scriptVariable == null ? 0 : scriptVariable.tok) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "decimal";
            }
            case 7: {
                return "point";
            }
            case 8: {
                return "plane";
            }
            case 4: {
                return "string";
            }
            case 6: {
                return "array";
            }
            case 0x40000007: {
                return "bitset";
            }
        }
        return "?";
    }

    static String[] concatList(ScriptVariable scriptVariable, ScriptVariable scriptVariable2) {
        int n;
        String[] stringArray = scriptVariable.tok == 6 ? (String[])scriptVariable.value : TextFormat.split(ScriptVariable.sValue(scriptVariable), "\n");
        String[] stringArray2 = scriptVariable2.tok == 6 ? (String[])scriptVariable2.value : TextFormat.split(ScriptVariable.sValue(scriptVariable2), "\n");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        return stringArray3;
    }

    static BitSet bsSelect(Token token) {
        token = ScriptVariable.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    static BitSet bsSelect(ScriptVariable scriptVariable) {
        if (scriptVariable.index == Integer.MAX_VALUE) {
            scriptVariable = ScriptVariable.selectItem(scriptVariable);
        }
        return (BitSet)scriptVariable.value;
    }

    static BitSet bsSelect(Token token, int n) {
        token = ScriptVariable.selectItem(token);
        token = ScriptVariable.selectItem(token, 1);
        token = ScriptVariable.selectItem(token, n);
        return (BitSet)token.value;
    }

    static ScriptVariable selectItem(ScriptVariable scriptVariable) {
        if (scriptVariable.index != Integer.MAX_VALUE || scriptVariable.tok == 6 && scriptVariable.intValue == Integer.MAX_VALUE) {
            return scriptVariable;
        }
        return ScriptVariable.selectItem(scriptVariable, Integer.MIN_VALUE);
    }

    static Token selectItem(Token token) {
        return ScriptVariable.selectItem(token, Integer.MIN_VALUE);
    }

    static ScriptVariable selectItem(ScriptVariable scriptVariable, int n) {
        return (ScriptVariable)ScriptVariable.selectItem((Token)scriptVariable, n);
    }

    static Token selectItem(Token token, int n) {
        if (token.tok != 0x40000007 && token.tok != 6 && token.tok != 4) {
            return token;
        }
        BitSet bitSet = null;
        String[] stringArray = null;
        String string = null;
        int n2 = token.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = n2;
            }
            return new ScriptVariable(token.tok, n, token.value);
        }
        int n3 = 0;
        boolean bl = token instanceof ScriptVariable && ((ScriptVariable)token).index != Integer.MAX_VALUE;
        ScriptVariable scriptVariable = new ScriptVariable(token.tok, Integer.MAX_VALUE);
        switch (token.tok) {
            case 0x40000007: {
                if (token.value instanceof Bond.BondSet) {
                    scriptVariable.value = new Bond.BondSet((BitSet)token.value, ((Bond.BondSet)token.value).getAssociatedAtoms());
                    bitSet = (BitSet)scriptVariable.value;
                    n3 = BitSetUtil.cardinalityOf(bitSet);
                    break;
                }
                bitSet = BitSetUtil.copy((BitSet)token.value);
                n3 = bl ? 1 : BitSetUtil.cardinalityOf(bitSet);
                scriptVariable.value = bitSet;
                break;
            }
            case 6: {
                stringArray = (String[])token.value;
                n3 = stringArray.length;
                break;
            }
            case 4: {
                string = (String)token.value;
                n3 = string.length();
            }
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (token.tok) {
            case 0x40000007: {
                if (bl) {
                    if (n2 <= 1) break;
                    bitSet.clear();
                    break;
                }
                n3 = BitSetUtil.length(bitSet);
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (!bitSet.get(i) || ++n4 >= n2 && n4 <= n) continue;
                    bitSet.clear(i);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    scriptVariable.value = "";
                    break;
                }
                scriptVariable.value = string.substring(n2 - 1, n);
                break;
            }
            case 6: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return new ScriptVariable(4, "");
                }
                if (n == n2) {
                    return ScriptVariable.tValue(stringArray[n2 - 1]);
                }
                String[] stringArray2 = new String[n - n2 + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + n2 - 1];
                }
                scriptVariable.value = stringArray2;
            }
        }
        return scriptVariable;
    }

    static ScriptVariable tValue(String string) {
        Object object = ScriptVariable.unescapePointOrBitsetAsVariable(string);
        if (!(object instanceof String)) {
            return (ScriptVariable)object;
        }
        String string2 = (String)object;
        if (string2.toLowerCase() == "true") {
            return ScriptVariable.getBoolean(true);
        }
        if (string2.toLowerCase() == "false") {
            return ScriptVariable.getBoolean(false);
        }
        float f = Parser.parseFloatStrict(string2);
        return Float.isNaN(f) ? new ScriptVariable(4, object) : (string2.indexOf(".") < 0 ? new ScriptVariable(2, (int)f) : new ScriptVariable(3, new Float(f)));
    }

    boolean setSelectedValue(int n, ScriptVariable scriptVariable) {
        if (n == Integer.MAX_VALUE || this.tok != 4 && this.tok != 6) {
            return false;
        }
        String string = ScriptVariable.sValue(scriptVariable);
        switch (this.tok) {
            case 6: {
                String[] stringArray;
                String[] stringArray2 = (String[])this.value;
                if (n <= 0) {
                    n = stringArray2.length + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                if ((stringArray = stringArray2).length <= n) {
                    stringArray = ArrayUtil.ensureLength(stringArray2, n + 1);
                    this.value = stringArray;
                    for (int i = stringArray2.length; i <= n; ++i) {
                        stringArray[i] = "";
                    }
                }
                stringArray[n] = string;
                break;
            }
            case 4: {
                String string2 = (String)this.value;
                int n2 = string2.length();
                if (n <= 0) {
                    n = n2 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                while (n >= string2.length()) {
                    string2 = string2 + " ";
                }
                this.value = string2.substring(0, n) + string + string2.substring(n + 1);
            }
        }
        return true;
    }

    String escape() {
        switch (this.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + this.intValue;
            }
            case 0x40000007: {
                return Escape.escape((BitSet)this.value);
            }
            case 6: {
                return Escape.escape((String[])this.value);
            }
            case 7: {
                return Escape.escape((Point3f)this.value);
            }
            case 8: {
                return Escape.escape((Point4f)this.value);
            }
        }
        return Escape.escape(this.value);
    }

    static Object unescapePointOrBitsetAsVariable(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = Escape.unescapePointOrBitset(string);
        if (object instanceof Point3f) {
            return new ScriptVariable(7, object);
        }
        if (object instanceof Point4f) {
            return new ScriptVariable(8, object);
        }
        if (object instanceof BitSet) {
            return new ScriptVariable(0x40000007, object);
        }
        return string;
    }

    static ScriptVariable getBoolean(boolean bl) {
        return new ScriptVariable(bl ? vT : vF);
    }

    static Object sprintf(String string, ScriptVariable scriptVariable) {
        if (scriptVariable == null) {
            return string;
        }
        int[] nArray = (int[])(string.indexOf("d") >= 0 || string.indexOf("i") >= 0 ? new int[1] : null);
        float[] fArray = string.indexOf("f") >= 0 ? new float[1] : null;
        double[] dArray = string.indexOf("e") >= 0 ? new double[1] : null;
        boolean bl = string.indexOf("s") >= 0;
        boolean bl2 = string.indexOf("p") >= 0 && scriptVariable.tok == 7 || string.indexOf("q") >= 0 && scriptVariable.tok == 8;
        Object[] objectArray = new Object[]{nArray, fArray, dArray, null, null};
        if (scriptVariable.tok != 6) {
            return ScriptVariable.sprintf(string, scriptVariable, objectArray, nArray, fArray, dArray, bl, bl2);
        }
        String[] stringArray = (String[])scriptVariable.value;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string;
            stringArray2[i] = ScriptVariable.sprintf(string2, ScriptVariable.tValue(stringArray[i]), objectArray, nArray, fArray, dArray, bl, bl2);
        }
        return stringArray2;
    }

    private static String sprintf(String string, ScriptVariable scriptVariable, Object[] objectArray, int[] nArray, float[] fArray, double[] dArray, boolean bl, boolean bl2) {
        if (nArray != null) {
            nArray[0] = ScriptVariable.iValue(scriptVariable);
        }
        if (fArray != null) {
            fArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (dArray != null) {
            dArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (bl) {
            objectArray[3] = ScriptVariable.sValue(scriptVariable);
        }
        if (bl2) {
            objectArray[4] = scriptVariable.value;
        }
        return TextFormat.sprintf(string, objectArray);
    }

    static String sprintf(ScriptVariable[] scriptVariableArray) {
        switch (scriptVariableArray.length) {
            case 0: {
                return "";
            }
            case 1: {
                return ScriptVariable.sValue(scriptVariableArray[0]);
            }
        }
        String[] stringArray = TextFormat.split(TextFormat.simpleReplace(ScriptVariable.sValue(scriptVariableArray[0]), "%%", "\u0001"), '%');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(ScriptVariable.sprintf(TextFormat.formatCheck("%" + stringArray[i]), i < scriptVariableArray.length ? scriptVariableArray[i] : null));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "] index =" + this.index + " hashcode=" + this.hashCode();
    }
}

