/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class RepaintManager {
    private Viewer viewer;
    private int holdRepaint = 0;
    boolean repaintPending;
    private boolean repaintInterrupted = false;
    private boolean logTime;
    private ShapeRenderer[] renderers;

    RepaintManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.clear(-1);
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint() {
        if (--this.holdRepaint <= 0) {
            this.repaintDisplay();
        }
    }

    boolean refresh() {
        if (this.repaintPending) {
            return false;
        }
        if (this.holdRepaint == 0) {
            this.repaintDisplay();
        }
        return true;
    }

    synchronized void requestRepaintAndWait() {
        this.repaintDisplay();
        try {
            this.wait(1000L);
            if (this.repaintPending) {
                System.out.println("repaintManager-11.8 requestRepaintAndWait Thread " + Thread.currentThread().getName());
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void repaintDisplay() {
        this.holdRepaint = 0;
        this.repaintPending = true;
        this.repaintInterrupted = false;
        this.viewer.repaint();
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    void render(Graphics3D graphics3D, ModelSet modelSet) {
        if (!this.viewer.getRefreshing()) {
            return;
        }
        try {
            this.render1(graphics3D, modelSet);
        }
        catch (Exception exception) {
            System.out.println("rendering Exception " + exception.getMessage());
        }
    }

    private void render1(Graphics3D graphics3D, ModelSet modelSet) {
        if (modelSet == null || !this.viewer.mustRenderFlag() || this.repaintInterrupted) {
            return;
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        if (this.logTime) {
            Logger.startTimer();
        }
        try {
            graphics3D.renderBackground();
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[32];
            }
            for (int i = 0; i < 32 && graphics3D.currentlyRendering(); ++i) {
                if (this.repaintInterrupted) {
                    return;
                }
                Shape shape = modelSet.getShape(i);
                if (shape == null) continue;
                this.getRenderer(i, graphics3D).render(graphics3D, modelSet, shape);
            }
            Rectangle rectangle = this.viewer.getRubberBandSelection();
            if (rectangle != null && graphics3D.setColix(this.viewer.getColixRubberband())) {
                graphics3D.drawRect(rectangle.x, rectangle.y, 0, 0, rectangle.width, rectangle.height);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("rendering error? ");
        }
        if (this.logTime) {
            Logger.checkTimer("render time");
        }
    }

    void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            for (int i = 0; i < 32; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int n, Graphics3D graphics3D) {
        if (this.renderers[n] == null) {
            this.renderers[n] = this.allocateRenderer(n, graphics3D);
        }
        return this.renderers[n];
    }

    private ShapeRenderer allocateRenderer(int n, Graphics3D graphics3D) {
        String string = JmolConstants.getShapeClassName(n) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate renderer:" + string, exception);
            return null;
        }
    }

    String generateOutput(String string, Graphics3D graphics3D, ModelSet modelSet, String string2) {
        JmolRendererInterface jmolRendererInterface = null;
        CharSequence charSequence = null;
        boolean bl = false;
        try {
            if (string2 == null) {
                charSequence = new StringBuffer();
            } else {
                if (string2.charAt(0) == '?') {
                    string2 = this.viewer.dialogAsk("save", string2.substring(1));
                }
                if (string2 == null) {
                    return null;
                }
                charSequence = string2;
            }
            Class<?> clazz = Class.forName("org.jmol.export.Export3D");
            jmolRendererInterface = (JmolRendererInterface)clazz.newInstance();
            bl = jmolRendererInterface.initializeExporter(string, this.viewer, graphics3D, charSequence);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            Logger.error("Cannot export " + string);
            return null;
        }
        jmolRendererInterface.renderBackground();
        for (int i = 0; i < 32; ++i) {
            Shape shape = modelSet.getShape(i);
            if (shape == null) continue;
            ShapeRenderer shapeRenderer = this.getGenerator(i, graphics3D);
            shapeRenderer.setGenerator(true);
            shapeRenderer.render(jmolRendererInterface, modelSet, shape);
            shapeRenderer.setGenerator(false);
        }
        return jmolRendererInterface.finalizeOutput();
    }

    private ShapeRenderer getGenerator(int n, Graphics3D graphics3D) {
        String string = "org.jmol.export." + JmolConstants.getShapeClassName(~n) + "Generator";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            return this.getRenderer(n, graphics3D);
        }
    }
}

