/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public class ColorEncoder {
    public static final String BYELEMENT_PREFIX = "byelement";
    public static final String BYRESIDUE_PREFIX = "byresidue";
    private static final String BYELEMENT_JMOL = "byelement_jmol";
    private static final String BYELEMENT_RASMOL = "byelement_rasmol";
    private static final String BYRESIDUE_SHAPELY = "byresidue_shapely";
    private static final String BYRESIDUE_AMINO = "byresidue_amino";
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "rwb", "bwr", "low", "high", "byelement_jmol", "byelement_rasmol", "byresidue_shapely", "byresidue_amino", "colorRGB", "user", "resu"};
    public static final int ROYGB = 0;
    public static final int BGYOR = 1;
    public static final int RWB = 2;
    public static final int BWR = 3;
    public static final int LOW = 4;
    public static final int HIGH = 5;
    public static final int JMOL = 6;
    public static final int RASMOL = 7;
    public static final int SHAPELY = 8;
    public static final int AMINO = 9;
    public static final int COLOR_RGB = 10;
    public static final int USER = -11;
    public static final int RESU = -12;
    private int palette = 0;
    private static int[] userScale = new int[]{-8355712};
    private static int[] thisScale = new int[]{-8355712};
    private static String thisName = "scheme";
    private static boolean isColorIndex;
    private static Hashtable schemes;
    private static int[] rasmolScale;
    private static int[] argbsCpk;
    private static int[] argbsRoygb;
    private static int[] argbsRwb;
    private static int[] argbsShapely;
    private static int[] argbsAmino;
    private static int ihalf;
    private static final int GRAY = -8355712;

    private static final int schemeIndex(String string) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(string)) continue;
            return i < 11 ? i : -i;
        }
        return -1;
    }

    public static synchronized int[] getRasmolScale(boolean bl) {
        if (rasmolScale[0] == 0 || bl) {
            int n = JmolConstants.argbsCpkRasmol[0] | 0xFF000000;
            int n2 = rasmolScale.length;
            while (--n2 >= 0) {
                ColorEncoder.rasmolScale[n2] = n;
            }
            n2 = JmolConstants.argbsCpkRasmol.length;
            while (--n2 >= 0) {
                n = JmolConstants.argbsCpkRasmol[n2];
                ColorEncoder.rasmolScale[n >> 24] = n | 0xFF000000;
            }
        }
        return rasmolScale;
    }

    public static synchronized int makeColorScheme(String string, int[] nArray, boolean bl) {
        string = ColorEncoder.fixName(string);
        if (nArray == null) {
            schemes.remove(string);
            int n = ColorEncoder.getColorScheme(string, false, bl);
            if (bl) {
                switch (n) {
                    case 0: 
                    case 1: {
                        argbsRoygb = JmolConstants.argbsRoygbScale;
                        break;
                    }
                    case 2: 
                    case 3: {
                        argbsRwb = JmolConstants.argbsRwbScale;
                        break;
                    }
                    case 6: {
                        argbsCpk = JmolConstants.argbsCpk;
                        break;
                    }
                    case 7: {
                        ColorEncoder.getRasmolScale(true);
                        break;
                    }
                    case 9: {
                        argbsAmino = JmolConstants.argbsAmino;
                        break;
                    }
                    case 8: {
                        argbsShapely = JmolConstants.argbsShapely;
                    }
                }
            }
            return n == Integer.MAX_VALUE ? 0 : n;
        }
        thisName = string;
        thisScale = nArray;
        schemes.put(thisName, nArray);
        ColorEncoder.checkColorIndex();
        int n = ColorEncoder.getColorScheme(string, false, bl);
        if (bl) {
            switch (n) {
                case 0: 
                case 1: {
                    argbsRoygb = thisScale;
                    break;
                }
                case 2: 
                case 3: {
                    argbsRwb = thisScale;
                    break;
                }
                case 6: {
                    argbsCpk = thisScale;
                    break;
                }
                case 7: {
                    break;
                }
                case 9: {
                    argbsAmino = thisScale;
                    break;
                }
                case 8: {
                    argbsShapely = thisScale;
                }
            }
        }
        return -1;
    }

    private static void checkColorIndex() {
        isColorIndex = thisName.indexOf(BYELEMENT_PREFIX) == 0 || thisName.indexOf(BYRESIDUE_PREFIX) == 0;
    }

    private static String fixName(String string) {
        if ((string = string.toLowerCase()).equals(BYELEMENT_PREFIX)) {
            return BYELEMENT_JMOL;
        }
        if (string.equals("jmol")) {
            return BYELEMENT_JMOL;
        }
        if (string.equals("rasmol")) {
            return BYELEMENT_RASMOL;
        }
        if (string.equals(BYRESIDUE_PREFIX)) {
            return BYRESIDUE_SHAPELY;
        }
        return string;
    }

    public int setColorScheme(String string) {
        this.palette = ColorEncoder.getColorScheme(string, false);
        return this.palette;
    }

    public String getColorSchemeName() {
        return ColorEncoder.getColorSchemeName(this.palette);
    }

    public static final String getColorSchemeName(int n) {
        int n2 = Math.abs(n);
        return n == -1 ? thisName : (n2 < colorSchemes.length && n2 >= 0 ? colorSchemes[n2] : null);
    }

    public static final int getColorScheme(String string, boolean bl) {
        return ColorEncoder.getColorScheme(string, true, bl);
    }

    private static final int getColorScheme(String string, boolean bl, boolean bl2) {
        int n = Math.max((string = string.toLowerCase()).indexOf("="), string.indexOf("["));
        if (n >= 0) {
            String string2 = TextFormat.replaceAllCharacters(string.substring(0, n), " =", "");
            if (string2.length() > 0) {
                bl2 = true;
            }
            int n2 = 0;
            n = -1;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                ++n2;
            }
            if (n2 == 0) {
                return ColorEncoder.makeColorScheme(string2, null, bl2);
            }
            int[] nArray = new int[n2];
            n = -1;
            n2 = 0;
            while ((n = string.indexOf("[", n + 1)) >= 0) {
                int n3;
                int n4 = string.indexOf("]", n);
                if (n4 < 0) {
                    n4 = string.length() - 1;
                }
                nArray[n2++] = n3 = Graphics3D.getArgbFromString(string.substring(n, n4 + 1));
                if (n3 != 0) continue;
                Logger.error("error in color value: " + string.substring(n, n4 + 1));
                return 0;
            }
            if (string2.equals("user")) {
                ColorEncoder.setUserScale(nArray);
                return -11;
            }
            return ColorEncoder.makeColorScheme(string2, nArray, bl2);
        }
        string = ColorEncoder.fixName(string);
        int n5 = ColorEncoder.schemeIndex(string);
        if (schemes.containsKey(string)) {
            thisName = string;
            thisScale = (int[])schemes.get(string);
            ColorEncoder.checkColorIndex();
            return n5;
        }
        return n5 != -1 ? n5 : (bl ? 0 : Integer.MAX_VALUE);
    }

    public static final void setUserScale(int[] nArray) {
        userScale = nArray;
        ColorEncoder.makeColorScheme("user", nArray, false);
    }

    public static final String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Enumeration enumeration = schemes.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(string.length() > 0 & n++ >= 0)) continue;
            stringBuffer2.append("color \"" + string + "=" + ColorEncoder.getColorSchemeList((int[])schemes.get(string)) + "\";\n");
        }
        if (n > 0 && stringBuffer != null) {
            stringBuffer.append("\n  _setColorState\n");
        }
        return n > 0 && stringBuffer != null ? "function _setColorState() {\n" + stringBuffer2.append("}\n\n").toString() : stringBuffer2.toString();
    }

    public static String getColorSchemeList(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i == 0 ? "" : " ") + Escape.escapeColor(nArray[i]);
        }
        return string;
    }

    public static final int[] getColorSchemeArray(int n) {
        switch (n) {
            case -1: {
                return ArrayUtil.arrayCopy(thisScale, 0, -1, false);
            }
            case 0: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, -1, false);
            }
            case 1: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, -1, true);
            }
            case 4: {
                return ArrayUtil.arrayCopy(argbsRoygb, 0, ihalf, false);
            }
            case 5: {
                int[] nArray = ArrayUtil.arrayCopy(argbsRoygb, ihalf, -1, false);
                int[] nArray2 = new int[ihalf];
                int n2 = ihalf;
                while (--n2 >= 0) {
                    nArray2[n2] = nArray[n2 + n2];
                }
                return nArray2;
            }
            case 2: {
                return ArrayUtil.arrayCopy(argbsRwb, 0, -1, false);
            }
            case 3: {
                return ArrayUtil.arrayCopy(argbsRwb, 0, -1, true);
            }
            case 6: {
                return ArrayUtil.arrayCopy(argbsCpk, 0, -1, false);
            }
            case 7: {
                return ArrayUtil.arrayCopy(ColorEncoder.getRasmolScale(false), 0, -1, false);
            }
            case 8: {
                return ArrayUtil.arrayCopy(argbsShapely, 0, -1, false);
            }
            case 9: {
                return ArrayUtil.arrayCopy(argbsAmino, 0, -1, false);
            }
            case 10: {
                return new int[0];
            }
            case -11: {
                return ArrayUtil.arrayCopy(userScale, 0, -1, false);
            }
            case -12: {
                return ArrayUtil.arrayCopy(userScale, 0, -1, true);
            }
        }
        return null;
    }

    public final int getArgbFromPalette(float f, float f2, float f3) {
        return ColorEncoder.getArgbFromPalette(f, f2, f3, this.palette);
    }

    public static final int getArgbFromPalette(float f, float f2, float f3, int n) {
        if (Float.isNaN(f)) {
            return -8355712;
        }
        switch (n) {
            case -1: {
                if (isColorIndex) {
                    f2 = 0.0f;
                    f3 = thisScale.length;
                }
                return thisScale[ColorEncoder.quantize(f, f2, f3, thisScale.length)];
            }
            case 0: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(f, f2, f3, JmolConstants.argbsRoygbScale.length)];
            }
            case 1: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(-f, -f3, -f2, JmolConstants.argbsRoygbScale.length)];
            }
            case 4: {
                return JmolConstants.argbsRoygbScale[ColorEncoder.quantize(f, f2, f3, ihalf)];
            }
            case 5: {
                return JmolConstants.argbsRoygbScale[ihalf + ColorEncoder.quantize(f, f2, f3, ihalf) * 2];
            }
            case 2: {
                return JmolConstants.argbsRwbScale[ColorEncoder.quantize(f, f2, f3, JmolConstants.argbsRwbScale.length)];
            }
            case 3: {
                return JmolConstants.argbsRwbScale[ColorEncoder.quantize(-f, -f3, -f2, JmolConstants.argbsRwbScale.length)];
            }
            case -11: {
                return userScale.length == 0 ? -8355712 : userScale[ColorEncoder.quantize(f, f2, f3, userScale.length)];
            }
            case -12: {
                return userScale.length == 0 ? -8355712 : userScale[ColorEncoder.quantize(-f, -f3, -f2, userScale.length)];
            }
            case 6: {
                return argbsCpk[ColorEncoder.colorIndex((int)f, argbsCpk.length)];
            }
            case 7: {
                return ColorEncoder.getRasmolScale(false)[ColorEncoder.colorIndex((int)f, rasmolScale.length)];
            }
            case 8: {
                return JmolConstants.argbsShapely[ColorEncoder.colorIndex((int)f, JmolConstants.argbsShapely.length)];
            }
            case 9: {
                return JmolConstants.argbsAmino[ColorEncoder.colorIndex((int)f, JmolConstants.argbsAmino.length)];
            }
            case 10: {
                return (int)f;
            }
        }
        return -8355712;
    }

    public static final short getColorIndexFromPalette(float f, float f2, float f3, int n) {
        return ColorEncoder.getColorIndex(ColorEncoder.getArgbFromPalette(f, f2, f3, n));
    }

    public static final short getColorIndex(int n) {
        return Graphics3D.getColix(n);
    }

    public static final int quantize(float f, float f2, float f3, int n) {
        float f4 = f3 - f2;
        if (f4 <= 0.0f || Float.isNaN(f)) {
            return n / 2;
        }
        float f5 = f - f2;
        if (f5 <= 0.0f) {
            return 0;
        }
        float f6 = f4 / (float)n;
        int n2 = (int)(f5 / f6 + 1.0E-4f);
        if (n2 >= n) {
            n2 = n - 1;
        }
        return n2;
    }

    public static final int colorIndex(int n, int n2) {
        return n <= 0 | n >= n2 ? 0 : n;
    }

    public short getColorIndexFromPalette(float f, float f2, float f3) {
        return ColorEncoder.getColorIndexFromPalette(f, f2, f3, this.palette);
    }

    static {
        schemes = new Hashtable();
        rasmolScale = new int[JmolConstants.argbsCpk.length];
        argbsCpk = JmolConstants.argbsCpk;
        argbsRoygb = JmolConstants.argbsRoygbScale;
        argbsRwb = JmolConstants.argbsRwbScale;
        argbsShapely = JmolConstants.argbsShapely;
        argbsAmino = JmolConstants.argbsAmino;
        ihalf = JmolConstants.argbsRoygbScale.length / 3;
    }
}

